/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.generate;

import java.util.Set;

/**
 * This service retrieves information about the currently configured form
 * generation.
 */
public interface FormMappingService {

    /**
     * Gets form generation info for a specific namespace. the namespace cannot be blank.
     *
     * @param namespace the namespace.  cannot be blank.
     * @return the form generation info or null if it cannot be found
     * @throws java.lang.IllegalArgumentException if the namespace is blank
     */
    FormMappingInfo getFormInfo(String namespace);

    /**
     * Gets form generation info for all namespaces.
     * @return returns a map.  always non-null
     */
    Set<FormMappingInfo> getAllFormInfo();
}
