/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document;
import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document.PHS398ResearchPlan20;
import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document.PHS398ResearchPlan20.ResearchPlanAttachments;
import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document.PHS398ResearchPlan20.ResearchPlanAttachments.*;
import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document.PHS398ResearchPlan20.ResearchPlanAttachments.HumanSubjectSection.InclusionOfChildren;
import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document.PHS398ResearchPlan20.ResearchPlanAttachments.HumanSubjectSection.InclusionOfWomenAndMinorities;
import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document.PHS398ResearchPlan20.ResearchPlanAttachments.HumanSubjectSection.ProtectionOfHumanSubjects;
import gov.grants.apply.forms.phs398ResearchPlan20V20.PHS398ResearchPlan20Document.PHS398ResearchPlan20.ResearchPlanAttachments.OtherResearchPlanSections.*;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;


/**
 * Class for generating the XML object for grants.gov PHS398ResearchPlanV1_2.
 * Form is generated using XMLBean classes and is based on
 * PHS398ResearchPlanV1_2 schema.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
@FormGenerator("PHS398ResearchPlan_2_0V2_0Generator")
public class PHS398ResearchPlan_2_0V2_0Generator extends
		PHS398ResearchPlanBaseGenerator<PHS398ResearchPlan20Document> implements S2SFormGeneratorPdfFillable<PHS398ResearchPlan20Document> {

    @Value("http://apply.grants.gov/forms/PHS398_ResearchPlan_2_0-V2.0")
    private String namespace;

    @Value("PHS398_ResearchPlan_2_0")
    private String formName;

	@FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_ResearchPlan_2_0-V2.0.fo.xsl")
    private List<Resource> stylesheets;

	@Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_ResearchPlan_2_0-V2.0.pdf")
	private Resource pdfForm;

    @Value("195")
    private int sortIndex;

    /**
	 * 
	 * This method gives the list of attachments for PHS398ResearchPlan form
	 * 
	 * @return phsResearchPlanDocument {@link XmlObject} of type
	 *         PHS398ResearchPlan20Document.
	 */
	private PHS398ResearchPlan20Document getPHS398ResearchPlan() {
		PHS398ResearchPlan20Document phsResearchPlanDocument = PHS398ResearchPlan20Document.Factory
				.newInstance();
		PHS398ResearchPlan20 phsResearchPlan = PHS398ResearchPlan20.Factory
				.newInstance();
		phsResearchPlan.setFormVersion(FormVersion.v2_0.getVersion());
		ResearchPlanAttachments researchPlanAttachments = ResearchPlanAttachments.Factory
				.newInstance();
		getNarrativeAttachments(researchPlanAttachments);
		AttachmentGroupMin0Max100DataType attachmentGroupMin0Max100DataType = AttachmentGroupMin0Max100DataType.Factory
				.newInstance();
		attachmentGroupMin0Max100DataType
				.setAttachedFileArray(getAppendixAttachedFileDataTypes());
		researchPlanAttachments.setAppendix(attachmentGroupMin0Max100DataType);
		phsResearchPlan.setResearchPlanAttachments(researchPlanAttachments);
		phsResearchPlanDocument.setPHS398ResearchPlan20(phsResearchPlan);

		return phsResearchPlanDocument;
	}

	private void getNarrativeAttachments(ResearchPlanAttachments researchPlanAttachments) {
		final HumanSubjectSection humanSubjectSection = HumanSubjectSection.Factory.newInstance();
		final OtherResearchPlanSections otherResearchPlanSections = OtherResearchPlanSections.Factory.newInstance();

		pdDoc.getDevelopmentProposal().getNarratives().stream().forEach(narrative -> {
			final AttachedFileDataType attachedFileDataType = addAttachedFileType(narrative);
			if (attachedFileDataType != null) {
				switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
					case INTRODUCTION_TO_APPLICATION:
						IntroductionToApplication introductionToApplication = IntroductionToApplication.Factory.newInstance();
						introductionToApplication.setAttFile(attachedFileDataType);
						researchPlanAttachments.setIntroductionToApplication(introductionToApplication);
						break;
					case SPECIFIC_AIMS:
						SpecificAims specificAims = SpecificAims.Factory.newInstance();
						specificAims.setAttFile(attachedFileDataType);
						researchPlanAttachments.setSpecificAims(specificAims);
						break;
					case RESEARCH_STRATEGY:
						ResearchStrategy researchStrategy = ResearchStrategy.Factory.newInstance();
						researchStrategy.setAttFile(attachedFileDataType);
						researchPlanAttachments.setResearchStrategy(researchStrategy);
						break;
					case PROGRESS_REPORT_PUBLICATION_LIST:
						ProgressReportPublicationList progressReportPublicationList = ProgressReportPublicationList.Factory.newInstance();
						progressReportPublicationList.setAttFile(attachedFileDataType);
						researchPlanAttachments.setProgressReportPublicationList(progressReportPublicationList);
						break;
					case PROTECTION_OF_HUMAN_SUBJECTS:
						ProtectionOfHumanSubjects protectionOfHumanSubjects = ProtectionOfHumanSubjects.Factory.newInstance();
						protectionOfHumanSubjects.setAttFile(attachedFileDataType);
						humanSubjectSection.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
						break;
					case INCLUSION_OF_WOMEN_AND_MINORITIES:
						InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = InclusionOfWomenAndMinorities.Factory.newInstance();
						inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
						humanSubjectSection.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
						break;
					case INCLUSION_OF_CHILDREN:
						InclusionOfChildren inclusionOfChildren = InclusionOfChildren.Factory.newInstance();
						inclusionOfChildren.setAttFile(attachedFileDataType);
						humanSubjectSection.setInclusionOfChildren(inclusionOfChildren);
						break;
					case VERTEBRATE_ANIMALS:
						VertebrateAnimals vertebrateAnimals = VertebrateAnimals.Factory.newInstance();
						vertebrateAnimals.setAttFile(attachedFileDataType);
						otherResearchPlanSections.setVertebrateAnimals(vertebrateAnimals);
						break;
					case SELECT_AGENT_RESEARCH:
						SelectAgentResearch selectAgentResearch = SelectAgentResearch.Factory.newInstance();
						selectAgentResearch.setAttFile(attachedFileDataType);
						otherResearchPlanSections.setSelectAgentResearch(selectAgentResearch);
						break;
					case MULTIPLE_PI_LEADERSHIP_PLAN:
						MultiplePDPILeadershipPlan multiplePILeadershipPlan = MultiplePDPILeadershipPlan.Factory.newInstance();
						multiplePILeadershipPlan.setAttFile(attachedFileDataType);
						otherResearchPlanSections.setMultiplePDPILeadershipPlan(multiplePILeadershipPlan);
						break;
					case CONSORTIUM_CONTRACTUAL_ARRANGEMENTS:
						ConsortiumContractualArrangements contractualArrangements = ConsortiumContractualArrangements.Factory.newInstance();
						contractualArrangements.setAttFile(attachedFileDataType);
						otherResearchPlanSections.setConsortiumContractualArrangements(contractualArrangements);
						break;
					case LETTERS_OF_SUPPORT:
						LettersOfSupport lettersOfSupport = LettersOfSupport.Factory.newInstance();
						lettersOfSupport.setAttFile(attachedFileDataType);
						otherResearchPlanSections.setLettersOfSupport(lettersOfSupport);
						break;
					case RESOURCE_SHARING_PLANS:
						ResourceSharingPlans resourceSharingPlans = ResourceSharingPlans.Factory.newInstance();
						resourceSharingPlans.setAttFile(attachedFileDataType);
						otherResearchPlanSections.setResourceSharingPlans(resourceSharingPlans);
						break;
				}
			}
		});

		researchPlanAttachments.setHumanSubjectSection(humanSubjectSection);
		researchPlanAttachments.setOtherResearchPlanSections(otherResearchPlanSections);
	}

	/**
	 * This method creates {@link XmlObject} of type
	 * {@link PHS398ResearchPlan20Document} by populating data from the given
	 * {@link ProposalDevelopmentDocumentContract}
	 * 
	 * @param proposalDevelopmentDocument
	 *            for which the {@link XmlObject} needs to be created
	 * @return {@link XmlObject} which is generated using the given
	 *         {@link ProposalDevelopmentDocumentContract}
	 */
	@Override
	public PHS398ResearchPlan20Document getFormObject(
			ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
		this.pdDoc = proposalDevelopmentDocument;
		return getPHS398ResearchPlan();
	}

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

	@Override
	public List<Resource> getStylesheets() {
		return stylesheets;
	}

	public void setStylesheets(List<Resource> stylesheets) {
		this.stylesheets = stylesheets;
	}

	@Override
	public Resource getPdfForm() {
		return pdfForm;
	}

	public void setPdfForm(Resource pdfForm) {
		this.pdfForm = pdfForm;
	}

	@Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

	@Override
	public Attachments getMappedAttachments(PHS398ResearchPlan20Document form, List<AttachmentData> attachments) {
		final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
			final ResearchPlanAttachments researchPlanAttachments = form.getPHS398ResearchPlan20().getResearchPlanAttachments();
			if (researchPlanAttachments != null) {
				final IntroductionToApplication introductionToApplication = researchPlanAttachments.getIntroductionToApplication();

				if (introductionToApplication != null && introductionToApplication.getAttFile() != null && a.getContentId().equals(introductionToApplication.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_ResearchPlan_2_0_P1.optionalFile0", a);
				}

				final SpecificAims specificAims = researchPlanAttachments.getSpecificAims();
				if (specificAims != null && specificAims.getAttFile() != null && a.getContentId().equals(specificAims.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_ResearchPlan_2_0_P1.optionalFile1", a);
				}

				final ResearchStrategy researchStrategy = researchPlanAttachments.getResearchStrategy();
				if (researchStrategy != null && researchStrategy.getAttFile() != null && a.getContentId().equals(researchStrategy.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_ResearchPlan_2_0_P1.optionalFile2", a);
				}

				final ProgressReportPublicationList progressReportPublicationList = researchPlanAttachments.getProgressReportPublicationList();
				if (progressReportPublicationList != null && progressReportPublicationList.getAttFile() != null && a.getContentId().equals(progressReportPublicationList.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_ResearchPlan_2_0_P1.optionalFile4", a);
				}

				final HumanSubjectSection humanSubjectSection = researchPlanAttachments.getHumanSubjectSection();
				if (humanSubjectSection != null) {
					final ProtectionOfHumanSubjects protectionOfHumanSubjects = humanSubjectSection.getProtectionOfHumanSubjects();
					if (protectionOfHumanSubjects != null && protectionOfHumanSubjects.getAttFile() != null && a.getContentId().equals(protectionOfHumanSubjects.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile5", a);
					}

					final InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = humanSubjectSection.getInclusionOfWomenAndMinorities();
					if (inclusionOfWomenAndMinorities != null && inclusionOfWomenAndMinorities.getAttFile() != null && a.getContentId().equals(inclusionOfWomenAndMinorities.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile6", a);
					}

					final InclusionOfChildren inclusionOfChildren = humanSubjectSection.getInclusionOfChildren();
					if (inclusionOfChildren != null && inclusionOfChildren.getAttFile() != null && a.getContentId().equals(inclusionOfChildren.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile8", a);
					}
				}
				final OtherResearchPlanSections otherResearchPlanSections = researchPlanAttachments.getOtherResearchPlanSections();
				if (otherResearchPlanSections != null) {
					final VertebrateAnimals vertebrateAnimals = otherResearchPlanSections.getVertebrateAnimals();
					if (vertebrateAnimals != null && vertebrateAnimals.getAttFile() != null && a.getContentId().equals(vertebrateAnimals.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile9", a);
					}

					final SelectAgentResearch selectAgentResearch = otherResearchPlanSections.getSelectAgentResearch();
					if (selectAgentResearch != null && selectAgentResearch.getAttFile() != null && a.getContentId().equals(selectAgentResearch.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile10", a);
					}

					final MultiplePDPILeadershipPlan multiplePDPILeadershipPlan = otherResearchPlanSections.getMultiplePDPILeadershipPlan();
					if (multiplePDPILeadershipPlan != null && multiplePDPILeadershipPlan.getAttFile() != null && a.getContentId().equals(multiplePDPILeadershipPlan.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile11", a);
					}

					final ConsortiumContractualArrangements consortiumContractualArrangements = otherResearchPlanSections.getConsortiumContractualArrangements();
					if (consortiumContractualArrangements != null && consortiumContractualArrangements.getAttFile() != null && a.getContentId().equals(consortiumContractualArrangements.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile12", a);
					}

					final LettersOfSupport lettersOfSupport = otherResearchPlanSections.getLettersOfSupport();
					if (lettersOfSupport != null && lettersOfSupport.getAttFile() != null && a.getContentId().equals(lettersOfSupport.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile13", a);
					}

					final ResourceSharingPlans resourceSharingPlans = otherResearchPlanSections.getResourceSharingPlans();
					if (resourceSharingPlans != null && resourceSharingPlans.getAttFile() != null && a.getContentId().equals(resourceSharingPlans.getAttFile().getFileLocation().getHref())) {
						return entry("PHS398_ResearchPlan_2_0_P1.optionalFile14", a);
					}
				}

				final AttachmentGroupMin0Max100DataType appendix = researchPlanAttachments.getAppendix();
				if (appendix != null && appendix.getAttachedFileList() != null) {
					final List<AttachedFileDataType> atts = appendix.getAttachedFileList();
					for (int i = 0; i < atts.size(); i++) {
						final AttachedFileDataType att = atts.get(i);

						if (att != null && a.getContentId().equals(att.getFileLocation().getHref())){
							return entry("PHS398_ResearchPlan_2_0_P1.optionalFile15_" + i, a);
						}
					}
				}
			}

			return entry((String) null, a);
		}).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

		return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
				attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
	}

	@Override
	public DocumentFactory<PHS398ResearchPlan20Document> factory() {
		return PHS398ResearchPlan20Document.Factory;
	}
}
