/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.location;

import org.kuali.coeus.common.api.country.CountryContract;
import org.kuali.coeus.common.api.state.StateContract;

public interface S2SLocationService {

    /**
     * Finds a Country object from the country code
     *
     * @param countryCode
     *            Country name
     * @return Country object matching the code
     */
    CountryContract getCountryFromCode(String countryCode);

    /**
     * Finds a State object from the state name
     * @param countryAlternateCode country 3-character code
     * @param stateCode Code of the state (two-letter state code)
     * @return State object matching the name.
     */
    StateContract getStateFromCode(String countryAlternateCode, String stateCode);
}
