/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;


import gov.grants.apply.forms.edGEPA42720V20.EDGEPA42720Document;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * This class is used to generate XML Document object for grants.gov EDGEPA427V2.0. This form is generated using XMLBean API's
 * generated by compiling EDGEPA427V2.0 schema.
 *
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
@FormGenerator("EDGEPA427V2_0Generator")
public class EDGEPA427V2_0Generator extends S2SBaseFormGenerator<EDGEPA42720Document> implements S2SFormGeneratorPdfFillable<EDGEPA42720Document> {

    @Value("http://apply.grants.gov/forms/ED_GEPA427_2_0-V2.0")
    private String namespace;

    @Value("ED_GEPA427_2_0-V2.0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_GEPA427_2_0-V2.0.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ED_GEPA427_2_0-V2.0.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    private static final int EQUITABLE_QUESTION_ID = -10163;
    private static final int BARRIERS_QUESTION_ID = -10164;
    private static final int STEPS_QUESTION_ID = -10165;
    private static final int TIMELINE_QUESTION_ID = -10166;

    private EDGEPA42720Document getEDGEPA42720Document() {

        EDGEPA42720Document gepa427Document = EDGEPA42720Document.Factory.newInstance();
        EDGEPA42720Document.EDGEPA42720 gepa = EDGEPA42720Document.EDGEPA42720.Factory.newInstance();
        gepa.setFormVersion(FormVersion.v2_0.getVersion());

        final List<? extends AnswerHeaderContract> answers = findQuestionnaireWithAnswers(pdDoc.getDevelopmentProposal());

        for (AnswerHeaderContract answerHeader : answers) {
            QuestionnaireContract questionnaire = getQuestionAnswerService().findQuestionnaireById(answerHeader.getQuestionnaireId());
            List<? extends QuestionnaireQuestionContract> questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                Integer questionId = question.getQuestionSeqId();
                if (answer != null) {
                    switch (questionId) {
                        case BARRIERS_QUESTION_ID -> gepa.setBarriers(answer);
                        case TIMELINE_QUESTION_ID -> gepa.setTimeline(answer);
                        case EQUITABLE_QUESTION_ID -> gepa.setEnsureEquitableAccess(answer);
                        case STEPS_QUESTION_ID -> gepa.setSteps(answer);
                        default -> {
                        }
                    }
                }
            }
        }

        gepa427Document.setEDGEPA42720(gepa);
        return gepa427Document;
    }

    protected List<? extends AnswerHeaderContract> findQuestionnaireWithAnswers(DevelopmentProposalContract developmentProposal) {
        return getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(developmentProposal.getProposalNumber(),
                getNamespace(), getFormName());
    }

    /**
     * This method creates {@link XmlObject} of type {@link EDGEPA42720Document} by populating data from the given
     * {@link ProposalDevelopmentDocumentContract}
     *
     * @param proposalDevelopmentDocument for which the {@link XmlObject} needs to be created
     * @return {@link XmlObject} which is generated using the given {@link ProposalDevelopmentDocumentContract}
     */
    @Override
    public EDGEPA42720Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {

        this.pdDoc = proposalDevelopmentDocument;
        return getEDGEPA42720Document();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    @Override
    public Attachments getMappedAttachments(EDGEPA42720Document form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    protected AnswerContract getAnswer(QuestionnaireQuestionContract questionnaireQuestion, AnswerHeaderContract answerHeader) {
        final List<AnswerContract> returnAnswers = getAnswers(questionnaireQuestion, answerHeader);
        return !returnAnswers.isEmpty() ? returnAnswers.get(0) : null;
    }

    protected List<AnswerContract> getAnswers(QuestionnaireQuestionContract questionnaireQuestion, AnswerHeaderContract answerHeader) {
        return getAnswers(questionnaireQuestion.getId(), answerHeader);
    }

    protected List<AnswerContract> getAnswers(Long questonnaireQuestionId, AnswerHeaderContract answerHeader) {
        List<AnswerContract> returnAnswers = new ArrayList<>();
        if (answerHeader != null) {
            List<? extends AnswerContract> answers = answerHeader.getAnswers();
            for (AnswerContract answer : answers) {
                if (answer.getQuestionnaireQuestionsId().equals(questonnaireQuestionId)) {
                    returnAnswers.add(answer);
                }
            }
        }
        return returnAnswers;
    }

    @Override
    public DocumentFactory<EDGEPA42720Document> factory() {
        return EDGEPA42720Document.Factory;
    }
}
