/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.hash;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.springframework.stereotype.Component;

@Component("grantApplicationHashService")
public class GrantApplicationHashServiceImpl implements GrantApplicationHashService {
    @Override
    public String computeGrantFormsHash(String xml) {
        if (StringUtils.isBlank(xml)) {
            throw new IllegalArgumentException("xml is blank");
        }

        return GrantApplicationHash.computeGrantFormsHash(xml);
    }

    @Override
    public String computeAttachmentHash(byte[] attachment) {
        if (ArrayUtils.isEmpty(attachment)) {
            throw new IllegalArgumentException("attachment is null or empty");
        }

        return GrantApplicationHash.computeAttachmentHash(attachment);
    }
}
