/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.budget;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.org.OrganizationRepositoryService;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.common.api.person.KcPersonRepositoryService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapService;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMappingContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetRateAndBaseContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonSalaryService;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.common.budget.api.personnel.TbnPersonContract;
import org.kuali.coeus.common.budget.api.personnel.TbnPersonService;
import org.kuali.coeus.common.budget.api.rate.RateClassContract;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetPeriodDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCompensationDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SEquipmentDto;
import org.kuali.coeus.s2sgen.api.budget.S2SIndirectCostDetailsDto;
import org.kuali.coeus.s2sgen.api.budget.S2SIndirectCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SKeyPersonDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherDirectCostInfoDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherPersonnelDto;
import org.kuali.coeus.s2sgen.api.budget.S2SProjectIncomeDto;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetCategoryMapService;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetIndirectCostsService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2SBudgetInfoService")
public class S2SBudgetInfoServiceImpl
implements S2SBudgetInfoService,
S2SBudgetIndirectCostsService {
    private static final String CUM_OTHER_COSTS_1 = "Other 1";
    private static final String CUM_OTHER_COSTS_2 = "Other 2";
    private static final String CUM_OTHER_COSTS_3 = "Other 3";
    private static final String VALUE_UNKNOWN = "Unknown";
    private static final int MAX_KEY_PERSON_COUNT = 8;
    private static final String CATEGORY_TYPE_OTHER_DIRECT_COST = "O";
    private static final String LASALARIES = "LASALARIES";
    private static final String PERSONNEL_TYPE_GRAD = "Grad";
    private static final String PERSONNEL_TYPE_POSTDOC = "PostDoc";
    private static final String PERSONNEL_TYPE_UNDERGRAD = "UnderGrad";
    private static final String PERSONNEL_TYPE_SEC = "Sec";
    private static final String PERSONNEL_TYPE_OTHER = "Other";
    private static final String PERSONNEL_TYPE_OTHER_PROFESSIONALS = "Other Professionals";
    private static final String PERSONNEL_TYPE_ALLOCATED_ADMIN_SUPPORT = "Allocated Admin Support";
    private static final String ROLE_GRADUATE_STUDENTS = "Graduate Students";
    private static final String ROLE_POST_DOCTORAL_ASSOCIATES = "Post Doctoral Associates";
    private static final String ROLE_GRADUATE_UNDERGRADUATE_STUDENTS = "Undergraduate Students";
    private static final String ROLE_GRADUATE_SECRETARIAL_OR_CLERICAL = "Secretarial / Clerical";
    private static final String ROLE_GRADUATE_OTHER = "Other";
    private static final String ROLE_GRADUATE_OTHER_PROFESSIONALS = "Other Professionals";
    private static final String ROLE_GRADUATE_ALLOCATED_ADMIN_SUPPORT = "Allocated Admin Support";
    private static final String TARGET_CATEGORY_CODE_01 = "01";
    private static final String DESCRIPTION_LA = "LA ";
    private static final String KEYPERSON_CO_PD_PI = "CO-PD/PI";
    private static final String NID_PD_PI = "PD/PI";
    private static final String NID_CO_PD_PI = "CO-INVESTIGATOR";
    private static final String KEYPERSON_OTHER = "Other (Specify)";
    private static final String SPONSOR = "S2S";
    private static final String PRINCIPAL_INVESTIGATOR_ROLE = "PD/PI";
    private static final BigDecimal POINT_ZERO_ONE = new ScaleTwoDecimal(0.01).bigDecimalValue();
    private static final Logger LOGGER = LogManager.getLogger(S2SBudgetInfoServiceImpl.class);
    @Autowired
    @Qualifier(value="budgetCategoryMapService")
    private BudgetCategoryMapService budgetCategoryMapService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="budgetPersonSalaryService")
    private BudgetPersonSalaryService budgetPersonSalaryService;
    @Autowired
    @Qualifier(value="organizationRepositoryService")
    private OrganizationRepositoryService organizationRepositoryService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="kcPersonRepositoryService")
    private KcPersonRepositoryService kcPersonRepositoryService;
    @Autowired
    @Qualifier(value="tbnPersonService")
    private TbnPersonService tbnPersonService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    private S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="s2SProposalPersonService")
    private S2SProposalPersonService s2SProposalPersonService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    private S2SCommonBudgetService s2SCommonBudgetService;
    @Autowired
    @Qualifier(value="modularBudgetService")
    private ModularBudgetService modularBudgetService;
    @Autowired
    @Qualifier(value="s2SBudgetCategoryMapService")
    private S2SBudgetCategoryMapService s2SBudgetCategoryMapService;

    public S2SBudgetDto getBudgetInfo(ProposalDevelopmentDocumentContract pdDoc) {
        HashMap<String, S2SOtherCostDto> cumulativeOtherCostsGrouping = new HashMap<String, S2SOtherCostDto>();
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(pdDoc.getDevelopmentProposal());
        S2SBudgetDto budgetSummaryInfo = new S2SBudgetDto();
        if (budget == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ICDB: budgetSummaryInfo is null");
            }
            return budgetSummaryInfo;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ICDB: calling getBudgetPeriods");
        }
        List<S2SBudgetPeriodDto> budgetPeriodInfos = this.getBudgetPeriods(pdDoc);
        budgetSummaryInfo.setBudgetPeriods(budgetPeriodInfos);
        budgetSummaryInfo.setCumTotalCosts(budget.getTotalCost());
        budgetSummaryInfo.setCumTotalIndirectCosts(budget.getTotalIndirectCost());
        budgetSummaryInfo.setCumTotalDirectCosts(budget.getTotalDirectCost());
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            budgetSummaryInfo.setCumTotalCostSharing(budget.getCostSharingAmount());
        }
        ScaleTwoDecimal totalDirectCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal lineItemCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal lineItemCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fringeCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fringeCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal budgetDetailsCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal budgetDetailsCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal budgetDetailsFringeCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal budgetDetailsFringeCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totPersFunds = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totPersNonFunds = ScaleTwoDecimal.ZERO;
        String budgetCategoryTypePersonnel = this.s2SConfigurationService.getValueAsString("s2sBudgetBudgetCategoryTypePersonnel");
        String rateTypeSupportStaffSalaries = this.s2SConfigurationService.getValueAsString("s2sBudgetRateTypeSupportStaffSalaries");
        String rateTypeAdministrativeSalaries = this.s2SConfigurationService.getValueAsString("s2sBudgetRateTypeAdministrativeSalaries");
        for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                totalDirectCostSharing = (ScaleTwoDecimal)totalDirectCostSharing.add((AbstractDecimal)lineItem.getCostSharingAmount());
                if (lineItem.getBudgetCategory().getBudgetCategoryType().getCode().equals(budgetCategoryTypePersonnel)) {
                    lineItemCost = (ScaleTwoDecimal)lineItemCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    if (this.canBudgetLineItemCostSharingInclude((BudgetContract)budget, lineItem)) {
                        lineItemCostSharingAmount = (ScaleTwoDecimal)lineItemCostSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    }
                }
                for (BudgetLineItemCalculatedAmountContract lineItemCalAmt : lineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (this.canBudgetLineItemCostSharingInclude((BudgetContract)budget, lineItem)) {
                        if (lineItemCalAmt.getRateClass().getRateClassType().getCode().equals(RateClassType.OVERHEAD.getRateClassType())) {
                            totalIndirectCostSharing = (ScaleTwoDecimal)totalIndirectCostSharing.add((AbstractDecimal)lineItemCalAmt.getCalculatedCostSharing());
                        } else {
                            totalDirectCostSharing = (ScaleTwoDecimal)totalDirectCostSharing.add((AbstractDecimal)lineItemCalAmt.getCalculatedCostSharing());
                        }
                    }
                    if ((lineItemCalAmt.getRateClass().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassCodeEmployeeBenefits")) && !lineItemCalAmt.getRateTypeCode().equals(rateTypeSupportStaffSalaries) || lineItemCalAmt.getRateClass().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassCodeVacation")) && !lineItemCalAmt.getRateTypeCode().equals(rateTypeAdministrativeSalaries)) && lineItem.getBudgetCategory().getBudgetCategoryType().getCode().equals(budgetCategoryTypePersonnel)) {
                        fringeCost = (ScaleTwoDecimal)fringeCost.add((AbstractDecimal)lineItemCalAmt.getCalculatedCost());
                        if (this.canBudgetLineItemCostSharingInclude((BudgetContract)budget, lineItem)) {
                            fringeCostSharingAmount = (ScaleTwoDecimal)fringeCostSharingAmount.add((AbstractDecimal)lineItemCalAmt.getCalculatedCostSharing());
                        }
                    }
                    if (lineItemCalAmt.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeLabAllocationSalaries"))) {
                        budgetDetailsCost = (ScaleTwoDecimal)budgetDetailsCost.add((AbstractDecimal)lineItemCalAmt.getCalculatedCost());
                        if (this.canBudgetLineItemCostSharingInclude((BudgetContract)budget, lineItem)) {
                            budgetDetailsCostSharingAmount = (ScaleTwoDecimal)budgetDetailsCostSharingAmount.add((AbstractDecimal)lineItemCalAmt.getCalculatedCostSharing());
                        }
                    }
                    if ((!lineItemCalAmt.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeEmployeeBenefits")) || !lineItemCalAmt.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!lineItemCalAmt.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeVacation")) || !lineItemCalAmt.getRateTypeCode().equals(rateTypeAdministrativeSalaries))) continue;
                    budgetDetailsFringeCost = (ScaleTwoDecimal)budgetDetailsFringeCost.add((AbstractDecimal)lineItemCalAmt.getCalculatedCost());
                    if (!this.canBudgetLineItemCostSharingInclude((BudgetContract)budget, lineItem)) continue;
                    budgetDetailsFringeCostSharingAmount = (ScaleTwoDecimal)budgetDetailsFringeCostSharingAmount.add((AbstractDecimal)lineItemCalAmt.getCalculatedCostSharing());
                }
            }
        }
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            budgetSummaryInfo.setCumTotalDirectCostSharing(totalDirectCostSharing);
            budgetSummaryInfo.setCumTotalIndirectCostSharing(totalIndirectCostSharing);
        }
        totPersFunds = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)totPersFunds.add((AbstractDecimal)lineItemCost)).add((AbstractDecimal)fringeCost)).add((AbstractDecimal)budgetDetailsCost)).add((AbstractDecimal)budgetDetailsFringeCost);
        totPersNonFunds = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)totPersNonFunds.add((AbstractDecimal)lineItemCostSharingAmount)).add((AbstractDecimal)fringeCostSharingAmount)).add((AbstractDecimal)budgetDetailsCostSharingAmount)).add((AbstractDecimal)budgetDetailsFringeCostSharingAmount);
        budgetSummaryInfo.setCumTotalNonFundsForPersonnel(totPersNonFunds);
        budgetSummaryInfo.setCumTotalFundsForPersonnel(totPersFunds);
        ScaleTwoDecimal cumAlterations = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumConsultants = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumMaterials = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPubs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumSubAward = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumComputer = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumEquipRental = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumAll = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumOtherType1 = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumOtherType2 = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumOtherType3 = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartStipends = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartSubsistence = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartTuition = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartOther = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartTravel = ScaleTwoDecimal.ZERO;
        int cumParticipantCount = 0;
        ScaleTwoDecimal cumAlterationsCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumConsultantsCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumMaterialsCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPubsCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumSubAwardCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumComputerCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumEquipRentalCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumAllCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumOtherType1CostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumOtherType2CostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumOtherType3CostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartStipendsCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartSubsistenceCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartTuitionCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartOtherCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumPartTravelCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal participantTotalCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDomesticTravel = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalForeignTravel = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDomesticTravelNonFund = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalForeignTravelNonFund = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumTotalEquipFund = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal cumTotalEquipNonFund = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totCountOtherPersonnel = ScaleTwoDecimal.ZERO;
        for (S2SBudgetPeriodDto budgetPeriodInfo : budgetPeriodInfos) {
            List cvOtherDirectCost = budgetPeriodInfo.getOtherDirectCosts();
            S2SOtherDirectCostInfoDto otherDirectCostInfo = (S2SOtherDirectCostInfoDto)cvOtherDirectCost.get(0);
            cumAlterations = (ScaleTwoDecimal)cumAlterations.add((AbstractDecimal)otherDirectCostInfo.getAlterations());
            cumConsultants = (ScaleTwoDecimal)cumConsultants.add((AbstractDecimal)otherDirectCostInfo.getConsultants());
            cumMaterials = (ScaleTwoDecimal)cumMaterials.add((AbstractDecimal)otherDirectCostInfo.getMaterials());
            cumPubs = (ScaleTwoDecimal)cumPubs.add((AbstractDecimal)otherDirectCostInfo.getPublications());
            cumSubAward = (ScaleTwoDecimal)cumSubAward.add((AbstractDecimal)otherDirectCostInfo.getSubAwards());
            cumComputer = (ScaleTwoDecimal)cumComputer.add((AbstractDecimal)otherDirectCostInfo.getComputer());
            cumEquipRental = (ScaleTwoDecimal)cumEquipRental.add((AbstractDecimal)otherDirectCostInfo.getEquipRental());
            cumAll = (ScaleTwoDecimal)cumAll.add((AbstractDecimal)otherDirectCostInfo.getTotalOtherDirect());
            cumPartStipends = (ScaleTwoDecimal)cumPartStipends.add((AbstractDecimal)(otherDirectCostInfo.getPartStipends() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartStipends()));
            cumPartTravel = (ScaleTwoDecimal)cumPartTravel.add((AbstractDecimal)(otherDirectCostInfo.getPartTravel() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartTravel()));
            cumPartSubsistence = (ScaleTwoDecimal)cumPartSubsistence.add((AbstractDecimal)(otherDirectCostInfo.getPartSubsistence() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartSubsistence()));
            cumPartTuition = (ScaleTwoDecimal)cumPartTuition.add((AbstractDecimal)(otherDirectCostInfo.getPartTuition() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartTuition()));
            cumPartOther = (ScaleTwoDecimal)cumPartOther.add((AbstractDecimal)(otherDirectCostInfo.getPartOther() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartOther()));
            cumParticipantCount += otherDirectCostInfo.getParticipantTotalCount();
            if (budget.getSubmitCostSharingFlag().booleanValue()) {
                cumAlterationsCostSharing = (ScaleTwoDecimal)cumAlterationsCostSharing.add((AbstractDecimal)otherDirectCostInfo.getAlterationsCostSharing());
                cumConsultantsCostSharing = (ScaleTwoDecimal)cumConsultantsCostSharing.add((AbstractDecimal)otherDirectCostInfo.getConsultantsCostSharing());
                cumMaterialsCostSharing = (ScaleTwoDecimal)cumMaterialsCostSharing.add((AbstractDecimal)otherDirectCostInfo.getMaterialsCostSharing());
                cumPubsCostSharing = (ScaleTwoDecimal)cumPubsCostSharing.add((AbstractDecimal)otherDirectCostInfo.getPublicationsCostSharing());
                cumSubAwardCostSharing = (ScaleTwoDecimal)cumSubAwardCostSharing.add((AbstractDecimal)otherDirectCostInfo.getSubAwardsCostSharing());
                cumComputerCostSharing = (ScaleTwoDecimal)cumComputerCostSharing.add((AbstractDecimal)otherDirectCostInfo.getComputerCostSharing());
                cumEquipRentalCostSharing = (ScaleTwoDecimal)cumEquipRentalCostSharing.add((AbstractDecimal)otherDirectCostInfo.getEquipRentalCostSharing());
                cumAllCostSharing = (ScaleTwoDecimal)cumAllCostSharing.add((AbstractDecimal)otherDirectCostInfo.getTotalOtherDirectCostSharing());
                cumPartStipendsCostSharing = (ScaleTwoDecimal)cumPartStipendsCostSharing.add((AbstractDecimal)(otherDirectCostInfo.getPartStipendsCostSharing() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartStipendsCostSharing()));
                cumPartTravelCostSharing = (ScaleTwoDecimal)cumPartTravelCostSharing.add((AbstractDecimal)(otherDirectCostInfo.getPartTravelCostSharing() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartTravelCostSharing()));
                cumPartSubsistenceCostSharing = (ScaleTwoDecimal)cumPartSubsistenceCostSharing.add((AbstractDecimal)(otherDirectCostInfo.getPartSubsistenceCostSharing() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartSubsistenceCostSharing()));
                cumPartTuitionCostSharing = (ScaleTwoDecimal)cumPartTuitionCostSharing.add((AbstractDecimal)(otherDirectCostInfo.getPartTuitionCostSharing() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartTuitionCostSharing()));
                cumPartOtherCostSharing = (ScaleTwoDecimal)cumPartOtherCostSharing.add((AbstractDecimal)(otherDirectCostInfo.getPartOtherCostSharing() == null ? ScaleTwoDecimal.ZERO : otherDirectCostInfo.getPartOtherCostSharing()));
            } else {
                cumAlterationsCostSharing = (ScaleTwoDecimal)cumAlterationsCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumConsultantsCostSharing = (ScaleTwoDecimal)cumConsultantsCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumMaterialsCostSharing = (ScaleTwoDecimal)cumMaterialsCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumPubsCostSharing = (ScaleTwoDecimal)cumPubsCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumSubAwardCostSharing = (ScaleTwoDecimal)cumSubAwardCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumComputerCostSharing = (ScaleTwoDecimal)cumComputerCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumEquipRentalCostSharing = (ScaleTwoDecimal)cumEquipRentalCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumAllCostSharing = (ScaleTwoDecimal)cumAllCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumPartStipendsCostSharing = (ScaleTwoDecimal)cumPartStipendsCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumPartTravelCostSharing = (ScaleTwoDecimal)cumPartTravelCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumPartSubsistenceCostSharing = (ScaleTwoDecimal)cumPartSubsistenceCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumPartTuitionCostSharing = (ScaleTwoDecimal)cumPartTuitionCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
                cumPartOtherCostSharing = (ScaleTwoDecimal)cumPartOtherCostSharing.add((AbstractDecimal)ScaleTwoDecimal.ZERO);
            }
            totalDomesticTravel = (ScaleTwoDecimal)totalDomesticTravel.add((AbstractDecimal)budgetPeriodInfo.getDomesticTravelCost());
            totalForeignTravel = (ScaleTwoDecimal)totalForeignTravel.add((AbstractDecimal)budgetPeriodInfo.getForeignTravelCost());
            totalDomesticTravelNonFund = (ScaleTwoDecimal)totalDomesticTravelNonFund.add((AbstractDecimal)budgetPeriodInfo.getDomesticTravelCostSharing());
            totalForeignTravelNonFund = (ScaleTwoDecimal)totalForeignTravelNonFund.add((AbstractDecimal)budgetPeriodInfo.getForeignTravelCostSharing());
            totCountOtherPersonnel = (ScaleTwoDecimal)totCountOtherPersonnel.add((AbstractDecimal)budgetPeriodInfo.getOtherPersonnelTotalNumber());
            for (S2SEquipmentDto equipmentInfo : budgetPeriodInfo.getEquipment()) {
                cumTotalEquipFund = (ScaleTwoDecimal)cumTotalEquipFund.add((AbstractDecimal)equipmentInfo.getTotalFund());
                cumTotalEquipNonFund = (ScaleTwoDecimal)cumTotalEquipNonFund.add((AbstractDecimal)equipmentInfo.getTotalNonFund());
            }
            for (int i = 0; i < otherDirectCostInfo.getOtherCosts().size(); ++i) {
                S2SOtherCostDto cumulativeCost;
                S2SOtherCostDto oc = (S2SOtherCostDto)otherDirectCostInfo.getOtherCosts().get(i);
                String key = oc.getDescription();
                if (cumulativeOtherCostsGrouping.get(key) == null) {
                    cumulativeCost = new S2SOtherCostDto();
                    cumulativeCost.setDescription(key);
                    cumulativeCost.setCost(oc.getCost());
                    cumulativeCost.setCostSharing(oc.getCostSharing());
                    cumulativeOtherCostsGrouping.put(key, cumulativeCost);
                    continue;
                }
                cumulativeCost = (S2SOtherCostDto)cumulativeOtherCostsGrouping.get(key);
                cumulativeCost.setCost((ScaleTwoDecimal)cumulativeCost.getCost().add((AbstractDecimal)oc.getCost()));
                cumulativeCost.setCostSharing((ScaleTwoDecimal)cumulativeCost.getCostSharing().add((AbstractDecimal)oc.getCostSharing()));
                cumulativeOtherCostsGrouping.put(key, cumulativeCost);
            }
        }
        budgetSummaryInfo.setCumDomesticTravelNonFund(totalDomesticTravelNonFund);
        budgetSummaryInfo.setCumForeignTravelNonFund(totalForeignTravelNonFund);
        budgetSummaryInfo.setCumTravelNonFund((ScaleTwoDecimal)totalDomesticTravelNonFund.add((AbstractDecimal)totalForeignTravelNonFund));
        budgetSummaryInfo.setCumDomesticTravel(totalDomesticTravel);
        budgetSummaryInfo.setCumForeignTravel(totalForeignTravel);
        budgetSummaryInfo.setCumTravel((ScaleTwoDecimal)totalDomesticTravel.add((AbstractDecimal)totalForeignTravel));
        budgetSummaryInfo.setPartOtherCost(cumPartOther);
        budgetSummaryInfo.setPartStipendCost(cumPartStipends);
        budgetSummaryInfo.setPartTravelCost(cumPartTravel);
        budgetSummaryInfo.setPartSubsistence(cumPartSubsistence);
        budgetSummaryInfo.setPartTuition(cumPartTuition);
        budgetSummaryInfo.setParticipantCount(cumParticipantCount);
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            budgetSummaryInfo.setPartOtherCostSharing(cumPartOtherCostSharing);
            budgetSummaryInfo.setPartStipendCostSharing(cumPartStipendsCostSharing);
            budgetSummaryInfo.setPartTravelCostSharing(cumPartTravelCostSharing);
            budgetSummaryInfo.setPartSubsistenceCostSharing(cumPartSubsistenceCostSharing);
            budgetSummaryInfo.setPartTuitionCostSharing(cumPartTuitionCostSharing);
        }
        S2SOtherDirectCostInfoDto summaryOtherDirectCostInfo = new S2SOtherDirectCostInfoDto();
        summaryOtherDirectCostInfo.setAlterations(cumAlterations);
        summaryOtherDirectCostInfo.setComputer(cumComputer);
        summaryOtherDirectCostInfo.setConsultants(cumConsultants);
        summaryOtherDirectCostInfo.setMaterials(cumMaterials);
        summaryOtherDirectCostInfo.setPublications(cumPubs);
        summaryOtherDirectCostInfo.setSubAwards(cumSubAward);
        summaryOtherDirectCostInfo.setEquipRental(cumEquipRental);
        summaryOtherDirectCostInfo.setTotalOtherDirect(cumAll);
        summaryOtherDirectCostInfo.setPartStipends(cumPartStipends);
        summaryOtherDirectCostInfo.setPartTravel(cumPartTravel);
        summaryOtherDirectCostInfo.setPartSubsistence(cumPartSubsistence);
        summaryOtherDirectCostInfo.setPartTuition(cumPartTuition);
        summaryOtherDirectCostInfo.setPartOther(cumPartOther);
        summaryOtherDirectCostInfo.setParticipantTotal((ScaleTwoDecimal)cumPartStipends.add((AbstractDecimal)((ScaleTwoDecimal)cumPartTravel.add((AbstractDecimal)((ScaleTwoDecimal)cumPartOther.add((AbstractDecimal)((ScaleTwoDecimal)cumPartSubsistence.add((AbstractDecimal)cumPartTravel))))))));
        summaryOtherDirectCostInfo.setParticipantTotalCount(cumParticipantCount);
        summaryOtherDirectCostInfo.setAlterationsCostSharing(cumAlterationsCostSharing);
        summaryOtherDirectCostInfo.setComputerCostSharing(cumComputerCostSharing);
        summaryOtherDirectCostInfo.setConsultantsCostSharing(cumConsultantsCostSharing);
        summaryOtherDirectCostInfo.setMaterialsCostSharing(cumMaterialsCostSharing);
        summaryOtherDirectCostInfo.setPublicationsCostSharing(cumPubsCostSharing);
        summaryOtherDirectCostInfo.setSubAwardsCostSharing(cumSubAwardCostSharing);
        summaryOtherDirectCostInfo.setEquipRentalCostSharing(cumEquipRentalCostSharing);
        summaryOtherDirectCostInfo.setTotalOtherDirectCostSharing(cumAllCostSharing);
        summaryOtherDirectCostInfo.setPartStipendsCostSharing(cumPartStipendsCostSharing);
        summaryOtherDirectCostInfo.setPartTravelCostSharing(cumPartTravelCostSharing);
        summaryOtherDirectCostInfo.setPartTuitionCostSharing(cumPartTuitionCostSharing);
        summaryOtherDirectCostInfo.setPartSubsistenceCostSharing(cumPartSubsistenceCostSharing);
        summaryOtherDirectCostInfo.setPartOtherCostSharing(cumPartOtherCostSharing);
        participantTotalCostSharing = (ScaleTwoDecimal)participantTotalCostSharing.add((AbstractDecimal)cumPartStipendsCostSharing);
        participantTotalCostSharing = (ScaleTwoDecimal)participantTotalCostSharing.add((AbstractDecimal)cumPartTravelCostSharing);
        participantTotalCostSharing = (ScaleTwoDecimal)participantTotalCostSharing.add((AbstractDecimal)cumPartOtherCostSharing);
        participantTotalCostSharing = (ScaleTwoDecimal)participantTotalCostSharing.add((AbstractDecimal)cumPartTuitionCostSharing);
        participantTotalCostSharing = (ScaleTwoDecimal)participantTotalCostSharing.add((AbstractDecimal)cumPartSubsistenceCostSharing);
        summaryOtherDirectCostInfo.setParticipantTotalCostSharing(participantTotalCostSharing);
        ArrayList<S2SOtherCostDto> otherCosts = new ArrayList<S2SOtherCostDto>();
        S2SOtherCostDto otherDirectCost = (S2SOtherCostDto)cumulativeOtherCostsGrouping.get("Other Direct Costs");
        S2SOtherCostDto humanFetalTissueCosts = (S2SOtherCostDto)cumulativeOtherCostsGrouping.get("Human Fetal Tissue Costs");
        S2SOtherCostDto dataManagementAndSharingCosts = (S2SOtherCostDto)cumulativeOtherCostsGrouping.get("Data Management and Sharing Costs");
        S2SOtherCostDto allOtherCosts = (S2SOtherCostDto)cumulativeOtherCostsGrouping.get("All Other Costs");
        if (otherDirectCost != null && otherDirectCost.getCost().isNonZero()) {
            otherCosts.add((S2SOtherCostDto)cumulativeOtherCostsGrouping.get("Other Direct Costs"));
        }
        if (humanFetalTissueCosts != null && humanFetalTissueCosts.getCost().isNonZero()) {
            otherCosts.add((S2SOtherCostDto)cumulativeOtherCostsGrouping.get("Human Fetal Tissue Costs"));
        }
        if (dataManagementAndSharingCosts != null && dataManagementAndSharingCosts.getCost().isNonZero()) {
            otherCosts.add((S2SOtherCostDto)cumulativeOtherCostsGrouping.get("Data Management and Sharing Costs"));
        }
        if (allOtherCosts != null && allOtherCosts.getCost().isNonZero()) {
            otherCosts.add((S2SOtherCostDto)cumulativeOtherCostsGrouping.get("All Other Costs"));
        }
        summaryOtherDirectCostInfo.setOtherCosts(otherCosts);
        ArrayList<S2SOtherDirectCostInfoDto> cvCumOtherDirectCost = new ArrayList<S2SOtherDirectCostInfoDto>();
        cvCumOtherDirectCost.add(summaryOtherDirectCostInfo);
        budgetSummaryInfo.setOtherDirectCosts(cvCumOtherDirectCost);
        budgetSummaryInfo.setCumEquipmentFunds(cumTotalEquipFund);
        budgetSummaryInfo.setCumEquipmentNonFunds(cumTotalEquipNonFund);
        budgetSummaryInfo.setCumFee(ScaleTwoDecimal.ZERO);
        ScaleTwoDecimal totSrFunds = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totSrNonFunds = ScaleTwoDecimal.ZERO;
        for (S2SBudgetPeriodDto budgetPeriodInfo : budgetPeriodInfos) {
            totSrFunds = (ScaleTwoDecimal)totSrFunds.add((AbstractDecimal)budgetPeriodInfo.getTotalFundsKeyPersons());
            totSrNonFunds = (ScaleTwoDecimal)totSrNonFunds.add((AbstractDecimal)budgetPeriodInfo.getTotalNonFundsKeyPersons());
        }
        budgetSummaryInfo.setCumTotalFundsForSrPersonnel(totSrFunds);
        budgetSummaryInfo.setCumTotalNonFundsForSrPersonnel(totSrNonFunds);
        budgetSummaryInfo.setCumTotalFundsForOtherPersonnel((ScaleTwoDecimal)totPersFunds.subtract((AbstractDecimal)totSrFunds));
        budgetSummaryInfo.setCumTotalNonFundsForOtherPersonnel((ScaleTwoDecimal)totPersNonFunds.subtract((AbstractDecimal)totSrNonFunds));
        budgetSummaryInfo.setCumNumOtherPersonnel(totCountOtherPersonnel);
        budgetSummaryInfo.setCumProjectIncome(budgetPeriodInfos.stream().map(S2SBudgetPeriodDto::getTotalProjectIncome).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add));
        return budgetSummaryInfo;
    }

    private List<S2SBudgetPeriodDto> getBudgetPeriods(ProposalDevelopmentDocumentContract pdDoc) {
        ArrayList<S2SBudgetPeriodDto> budgetPeriods = new ArrayList<S2SBudgetPeriodDto>();
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(pdDoc.getDevelopmentProposal());
        if (budget == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ICDB: budget is null ");
            }
            return budgetPeriods;
        }
        if (LOGGER.isDebugEnabled()) {
            List bp = budget.getBudgetPeriods();
            String count = bp == null ? "null" : String.valueOf(bp.size());
            LOGGER.debug("ICDB: Processing " + count + " budget periods. budgetId = " + budget.getBudgetId());
        }
        for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
            S2SBudgetPeriodDto bpData = new S2SBudgetPeriodDto();
            ScaleTwoDecimal totalCostSharing = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalDirectCostSharing = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalIndirectCostSharing = ScaleTwoDecimal.ZERO;
            bpData.setLineItemCount(budgetPeriod.getBudgetLineItems().size());
            if (budget.getSubmitCostSharingFlag().booleanValue()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                        totalCostSharing = (ScaleTwoDecimal)totalCostSharing.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    }
                    for (BudgetLineItemCalculatedAmountContract lineItemCalculatedAmt : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        if (!lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                        if (lineItemCalculatedAmt.getRateClass().getRateClassType().getCode().equals(RateClassType.OVERHEAD.getRateClassType())) {
                            totalIndirectCostSharing = (ScaleTwoDecimal)totalIndirectCostSharing.add((AbstractDecimal)lineItemCalculatedAmt.getCalculatedCostSharing());
                            continue;
                        }
                        totalDirectCostSharing = (ScaleTwoDecimal)totalDirectCostSharing.add((AbstractDecimal)lineItemCalculatedAmt.getCalculatedCostSharing());
                    }
                }
                totalDirectCostSharing = (ScaleTwoDecimal)totalDirectCostSharing.add((AbstractDecimal)totalCostSharing);
            }
            bpData.setBudgetPeriod(budgetPeriod.getBudgetPeriod().intValue());
            bpData.setStartDate(new Date(budgetPeriod.getStartDate().getTime()));
            bpData.setEndDate(new Date(budgetPeriod.getEndDate().getTime()));
            bpData.setTotalCosts(budgetPeriod.getTotalCost());
            bpData.setDirectCostsTotal(budgetPeriod.getTotalDirectCost());
            bpData.setTotalIndirectCost(budgetPeriod.getTotalIndirectCost());
            bpData.setCostSharingAmount(budgetPeriod.getCostSharingAmount());
            if (budget.getSubmitCostSharingFlag().booleanValue()) {
                bpData.setTotalDirectCostSharing(totalDirectCostSharing);
                bpData.setTotalIndirectCostSharing(totalIndirectCostSharing);
            }
            bpData.setCognizantFedAgency(this.getCognizantFedAgency(pdDoc.getDevelopmentProposal()));
            List modularAmounts = this.modularBudgetService.getModularBudgetAmounts((BudgetContract)budget);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ICDB: Calling getIndirectCosts. budgetId = " + budget.getBudgetId() + ", budgetPeriodId = " + budgetPeriod.getBudgetPeriodId() + ", modularAmounts = " + String.valueOf(modularAmounts));
            }
            bpData.setIndirectCosts(this.getIndirectCosts((BudgetContract)budget, budgetPeriod, modularAmounts));
            bpData.setEquipment(this.getEquipment(budgetPeriod, (BudgetContract)budget));
            bpData.setOtherDirectCosts(this.getOtherDirectCosts(budgetPeriod, (BudgetContract)budget));
            if (bpData.getOtherDirectCosts().size() > 0) {
                S2SOtherDirectCostInfoDto otherCostInfo = (S2SOtherDirectCostInfoDto)bpData.getOtherDirectCosts().get(0);
                bpData.setDomesticTravelCost(otherCostInfo.getDomTravel());
                bpData.setForeignTravelCost(otherCostInfo.getForeignTravel());
                bpData.setTotalTravelCost(otherCostInfo.getTotTravel());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    bpData.setDomesticTravelCostSharing(otherCostInfo.getDomTravelCostSharing());
                    bpData.setForeignTravelCostSharing(otherCostInfo.getForeignTravelCostSharing());
                    bpData.setTotalTravelCostSharing(otherCostInfo.getTotTravelCostSharing());
                }
                bpData.setPartOtherCost(otherCostInfo.getPartOther());
                bpData.setPartStipendCost(otherCostInfo.getPartStipends());
                bpData.setPartTravelCost(otherCostInfo.getPartTravel());
                bpData.setPartSubsistence(otherCostInfo.getPartSubsistence());
                bpData.setPartTuition(otherCostInfo.getPartTuition());
                bpData.setParticipantCount(otherCostInfo.getParticipantTotalCount());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    bpData.setPartOtherCostSharing(otherCostInfo.getPartOtherCostSharing());
                    bpData.setPartStipendCostSharing(otherCostInfo.getPartStipendsCostSharing());
                    bpData.setPartTravelCostSharing(otherCostInfo.getPartTravelCostSharing());
                    bpData.setPartTuitionCostSharing(otherCostInfo.getPartTuitionCostSharing());
                    bpData.setPartSubsistenceCostSharing(otherCostInfo.getPartSubsistenceCostSharing());
                }
            }
            List<S2SKeyPersonDto> keyPersons = this.getKeyPersons(budgetPeriod, pdDoc, (BudgetContract)budget);
            List<S2SKeyPersonDto> nKeyPersons = this.getNKeyPersons(keyPersons, 8);
            List extraPersons = keyPersons.stream().filter(person -> this.hasPersonnelBudget(budgetPeriod, (S2SKeyPersonDto)person)).filter(seniorKp -> !nKeyPersons.contains(seniorKp)).collect(Collectors.toList());
            bpData.setKeyPersons(nKeyPersons);
            bpData.setExtraKeyPersons(extraPersons);
            ScaleTwoDecimal totalKeyPersonSum = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalKeyPersonSumCostSharing = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalAttKeyPersonSum = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalAttKeyPersonSumCostSharing = ScaleTwoDecimal.ZERO;
            for (S2SKeyPersonDto keyPerson : nKeyPersons) {
                totalKeyPersonSum = (ScaleTwoDecimal)totalKeyPersonSum.add((AbstractDecimal)keyPerson.getCompensation().getFundsRequested());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                totalKeyPersonSumCostSharing = (ScaleTwoDecimal)totalKeyPersonSumCostSharing.add((AbstractDecimal)keyPerson.getCompensation().getNonFundsRequested());
            }
            for (S2SKeyPersonDto keyPerson : extraPersons) {
                totalAttKeyPersonSum = (ScaleTwoDecimal)totalAttKeyPersonSum.add((AbstractDecimal)keyPerson.getCompensation().getFundsRequested());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                totalAttKeyPersonSumCostSharing = (ScaleTwoDecimal)totalAttKeyPersonSumCostSharing.add((AbstractDecimal)keyPerson.getCompensation().getNonFundsRequested());
            }
            bpData.setTotalFundsKeyPersons((ScaleTwoDecimal)totalKeyPersonSum.add((AbstractDecimal)totalAttKeyPersonSum));
            bpData.setTotalFundsAttachedKeyPersons(totalAttKeyPersonSum);
            bpData.setTotalNonFundsKeyPersons((ScaleTwoDecimal)totalKeyPersonSumCostSharing.add((AbstractDecimal)totalAttKeyPersonSumCostSharing));
            bpData.setTotalNonFundsAttachedKeyPersons(totalAttKeyPersonSumCostSharing);
            List<S2SOtherPersonnelDto> otherPersonnel = this.getOtherPersonnel(budgetPeriod, keyPersons);
            bpData.setOtherPersonnel(otherPersonnel);
            ScaleTwoDecimal otherPersonnelCount = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal otherPersonnelTotalFunds = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal otherPersonnelTotalNonFunds = ScaleTwoDecimal.ZERO;
            for (S2SOtherPersonnelDto otherPersonnelInfo : otherPersonnel) {
                otherPersonnelCount = (ScaleTwoDecimal)otherPersonnelCount.add((AbstractDecimal)new ScaleTwoDecimal(otherPersonnelInfo.getNumberPersonnel()));
                otherPersonnelTotalFunds = (ScaleTwoDecimal)otherPersonnelTotalFunds.add((AbstractDecimal)otherPersonnelInfo.getCompensation().getFundsRequested());
                otherPersonnelTotalNonFunds = (ScaleTwoDecimal)otherPersonnelTotalNonFunds.add((AbstractDecimal)otherPersonnelInfo.getCompensation().getNonFundsRequested());
            }
            bpData.setTotalOtherPersonnelFunds(otherPersonnelTotalFunds);
            bpData.setOtherPersonnelTotalNumber(otherPersonnelCount);
            bpData.setTotalCompensation((ScaleTwoDecimal)((ScaleTwoDecimal)otherPersonnelTotalFunds.add((AbstractDecimal)totalKeyPersonSum)).add((AbstractDecimal)totalAttKeyPersonSum));
            bpData.setTotalOtherPersonnelNonFunds(otherPersonnelTotalNonFunds);
            bpData.setTotalCompensationCostSharing((ScaleTwoDecimal)((ScaleTwoDecimal)otherPersonnelTotalNonFunds.add((AbstractDecimal)totalKeyPersonSumCostSharing)).add((AbstractDecimal)totalAttKeyPersonSumCostSharing));
            bpData.setProjectIncomes(this.getProjectIncomes(budget, budgetPeriod.getBudgetPeriod()));
            bpData.setTotalProjectIncome(bpData.getProjectIncomes().stream().map(S2SProjectIncomeDto::getProjectIncome).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add));
            bpData.setProjectIncomesSummary(bpData.getProjectIncomes().stream().map(S2SProjectIncomeDto::getDescription).collect(Collectors.joining(";")));
            budgetPeriods.add(bpData);
        }
        return budgetPeriods;
    }

    protected String getCognizantFedAgency(DevelopmentProposalContract developmentProposal) {
        StringBuilder fedAgency = new StringBuilder();
        ProposalSiteContract applicantOrganization = developmentProposal.getApplicantOrganization();
        if (applicantOrganization != null && applicantOrganization.getOrganization() != null && applicantOrganization.getOrganization().getCognizantAuditor() != null) {
            fedAgency.append(this.organizationRepositoryService.getCognizantFedAgency(applicantOrganization.getOrganization()));
        }
        if (fedAgency.toString().length() == 0) {
            fedAgency.append(VALUE_UNKNOWN);
        }
        return fedAgency.toString();
    }

    private List<S2SProjectIncomeDto> getProjectIncomes(ProposalDevelopmentBudgetExtContract budget, int periodNumber) {
        return budget.getBudgetProjectIncomes().stream().filter(projectIncome -> projectIncome.getBudgetPeriodNumber() == periodNumber).map(projectIncome -> {
            S2SProjectIncomeDto incomeDto = new S2SProjectIncomeDto();
            incomeDto.setPeriodNumber(Integer.valueOf(periodNumber));
            incomeDto.setDescription(projectIncome.getDescription());
            incomeDto.setProjectIncome(projectIncome.getProjectIncome());
            return incomeDto;
        }).collect(Collectors.toList());
    }

    @Override
    public S2SIndirectCostDto getIndirectCosts(BudgetContract budget, BudgetPeriodContract budgetPeriod, List<? extends BudgetModularContract> modularAmounts) {
        ArrayList<Object> indirectCostDetailList = new ArrayList<S2SIndirectCostDetailsDto>();
        ScaleTwoDecimal baseCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal baseCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal appliedRate = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCosts = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCostSharing = ScaleTwoDecimal.ZERO;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ICDB: In getIndirectCosts()");
        }
        String description = "";
        boolean firstLoop = true;
        if (budget.getModularBudgetFlag().booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ICDB: Processing modular budget...");
            }
            BudgetModularContract modularBudget = this.modularBudgetService.getModularBudgetForPeriod(modularAmounts, budgetPeriod);
            for (BudgetModularIdcContract budgetModularIdc : modularBudget.getBudgetModularIdcs()) {
                if (firstLoop) {
                    appliedRate = (ScaleTwoDecimal)appliedRate.add((AbstractDecimal)budgetModularIdc.getIdcRate());
                    description = budgetModularIdc.getDescription();
                    firstLoop = false;
                }
                baseCost = (ScaleTwoDecimal)baseCost.add((AbstractDecimal)budgetModularIdc.getIdcBase());
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)budgetModularIdc.getFundsRequested());
            }
            S2SIndirectCostDetailsDto indirectCostDetails = new S2SIndirectCostDetailsDto();
            indirectCostDetails.setBase(baseCost);
            indirectCostDetails.setBaseCostSharing(baseCostSharing);
            indirectCostDetails.setCostSharing(calculatedCostSharing);
            indirectCostDetails.setCostType(description);
            indirectCostDetails.setFunds(calculatedCost);
            indirectCostDetails.setRate(appliedRate);
            indirectCostDetailList.add(indirectCostDetails);
            totalIndirectCosts = (ScaleTwoDecimal)totalIndirectCosts.add((AbstractDecimal)calculatedCost);
            totalIndirectCostSharing = (ScaleTwoDecimal)totalIndirectCostSharing.add((AbstractDecimal)calculatedCostSharing);
        } else {
            HashMap<CallSite, S2SIndirectCostDetailsDto> costDetailsMap = new HashMap<CallSite, S2SIndirectCostDetailsDto>();
            if (LOGGER.isDebugEnabled()) {
                int size = budgetPeriod.getBudgetLineItems() == null ? 0 : budgetPeriod.getBudgetLineItems().size();
                LOGGER.debug("ICDB: Processing " + size + " Line Items");
            }
            for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                if (LOGGER.isDebugEnabled()) {
                    int size = lineItem.getBudgetRateAndBaseList() == null ? 0 : lineItem.getBudgetRateAndBaseList().size();
                    LOGGER.debug("ICDB: Processing " + size + "Rate and Bases for Period = " + budgetPeriod.getBudgetPeriod());
                }
                for (BudgetRateAndBaseContract rateBase : lineItem.getBudgetRateAndBaseList()) {
                    S2SIndirectCostDetailsDto indirectCostDetails;
                    RateClassContract rateClass = rateBase.getRateClass();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("ICDB: Rate Class = " + rateClass.toString());
                    }
                    if (!rateClass.getRateClassType().getCode().equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("ICDB: Processing OVERHEAD rate class. Rate Class = " + String.valueOf(rateClass));
                    }
                    String rateClassCode = rateClass.getCode();
                    String rateTypeCode = rateBase.getRateTypeCode();
                    appliedRate = rateBase.getAppliedRate();
                    String key = rateClassCode + "-" + rateTypeCode + "-" + String.valueOf(appliedRate);
                    boolean applyRateFlag = this.getApplyRateFlagForRateBase(rateBase, lineItem.getBudgetLineItemCalculatedAmounts());
                    if (costDetailsMap.get(key) == null) {
                        indirectCostDetails = new S2SIndirectCostDetailsDto();
                        indirectCostDetails.setBase(rateBase.getBaseCost() == null ? ScaleTwoDecimal.ZERO : (applyRateFlag ? rateBase.getBaseCost() : ScaleTwoDecimal.ZERO));
                        indirectCostDetails.setBaseCostSharing(rateBase.getBaseCostSharing() == null ? ScaleTwoDecimal.ZERO : rateBase.getBaseCostSharing());
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            indirectCostDetails.setCostSharing(rateBase.getCalculatedCostSharing() == null ? ScaleTwoDecimal.ZERO : rateBase.getCalculatedCostSharing());
                        }
                        indirectCostDetails.setCostType(rateClass.getDescription());
                        indirectCostDetails.setFunds(rateBase.getCalculatedCost() == null ? ScaleTwoDecimal.ZERO : rateBase.getCalculatedCost());
                        indirectCostDetails.setRate(appliedRate);
                    } else {
                        indirectCostDetails = (S2SIndirectCostDetailsDto)costDetailsMap.get(key);
                        baseCost = (ScaleTwoDecimal)indirectCostDetails.getBase().add((AbstractDecimal)(rateBase.getBaseCost() == null ? ScaleTwoDecimal.ZERO : (applyRateFlag ? rateBase.getBaseCost() : ScaleTwoDecimal.ZERO)));
                        baseCostSharing = (ScaleTwoDecimal)indirectCostDetails.getBaseCostSharing().add((AbstractDecimal)(rateBase.getBaseCostSharing() == null ? ScaleTwoDecimal.ZERO : rateBase.getBaseCostSharing()));
                        calculatedCost = (ScaleTwoDecimal)indirectCostDetails.getFunds().add((AbstractDecimal)(rateBase.getCalculatedCost() == null ? ScaleTwoDecimal.ZERO : rateBase.getCalculatedCost()));
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            calculatedCostSharing = (ScaleTwoDecimal)indirectCostDetails.getCostSharing().add((AbstractDecimal)(rateBase.getCalculatedCostSharing() == null ? ScaleTwoDecimal.ZERO : rateBase.getCalculatedCostSharing()));
                        } else if (!lineItem.getSubmitCostSharingFlag().booleanValue() && budget.getSubmitCostSharingFlag().booleanValue()) {
                            calculatedCostSharing = indirectCostDetails.getCostSharing();
                        }
                        indirectCostDetails.setBase(baseCost);
                        indirectCostDetails.setBaseCostSharing(baseCostSharing);
                        indirectCostDetails.setCostSharing(calculatedCostSharing);
                        indirectCostDetails.setFunds(calculatedCost);
                    }
                    costDetailsMap.put((CallSite)((Object)key), indirectCostDetails);
                    indirectCostDetailList = new ArrayList(costDetailsMap.values());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("ICDB: Updated Details List = " + String.valueOf(indirectCostDetailList));
                    }
                    totalIndirectCosts = (ScaleTwoDecimal)totalIndirectCosts.add((AbstractDecimal)(rateBase.getCalculatedCost() == null ? ScaleTwoDecimal.ZERO : rateBase.getCalculatedCost()));
                    if (!this.canBudgetLineItemCostSharingInclude(budget, lineItem)) continue;
                    totalIndirectCostSharing = (ScaleTwoDecimal)totalIndirectCostSharing.add((AbstractDecimal)(rateBase.getCalculatedCostSharing() == null ? ScaleTwoDecimal.ZERO : rateBase.getCalculatedCostSharing()));
                }
            }
        }
        S2SIndirectCostDto indirectCostInfo = new S2SIndirectCostDto();
        indirectCostInfo.setIndirectCostDetails(indirectCostDetailList);
        indirectCostInfo.setTotalIndirectCosts(totalIndirectCosts);
        indirectCostInfo.setTotalIndirectCostSharing(totalIndirectCostSharing);
        return indirectCostInfo;
    }

    protected List<S2SEquipmentDto> getEquipment(BudgetPeriodContract budgetPeriod, BudgetContract budget) {
        ArrayList<S2SCostDto> cvExtraEquipment = new ArrayList<S2SCostDto>();
        List<? extends BudgetCategoryMapContract> budgetCategoryMapList = this.s2SBudgetCategoryMapService.getBudgetCategoryMapList(new ArrayList<String>(), new ArrayList<String>());
        ScaleTwoDecimal totalEquipFund = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalExtraEquipFund = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalEquipNonFund = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalExtraEquipNonFund = ScaleTwoDecimal.ZERO;
        HashMap<CallSite, S2SCostDto> costInfoMap = new HashMap<CallSite, S2SCostDto>();
        ArrayList<S2SCostDto> costInfos = new ArrayList<S2SCostDto>();
        for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetCategoryMapContract budgetCategoryMapContract : budgetCategoryMapList) {
                S2SCostDto equipCostInfo = new S2SCostDto();
                for (BudgetCategoryMappingContract budgetCategoryMapping : budgetCategoryMapContract.getBudgetCategoryMappings()) {
                    String key;
                    if (!lineItem.getBudgetCategory().getCode().equals(budgetCategoryMapping.getBudgetCategoryCode()) || !budgetCategoryMapping.getTargetCategoryCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetTargetCategoryCodeEquipmentCost")) || !budgetCategoryMapping.getMappingName().equals(SPONSOR)) continue;
                    equipCostInfo.setCategory(budgetCategoryMapContract.getDescription());
                    equipCostInfo.setCategoryType(budgetCategoryMapContract.getCategoryType());
                    if (lineItem.getLineItemDescription() != null) {
                        equipCostInfo.setDescription(lineItem.getLineItemDescription());
                    } else {
                        equipCostInfo.setDescription(lineItem.getCostElementBO().getDescription());
                    }
                    totalEquipFund = (ScaleTwoDecimal)totalEquipFund.add((AbstractDecimal)lineItem.getLineItemCost());
                    if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                        totalEquipNonFund = (ScaleTwoDecimal)totalEquipNonFund.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    }
                    if (costInfoMap.get(key = budgetCategoryMapContract.getCategoryType() + "-" + lineItem.getLineItemDescription()) == null) {
                        equipCostInfo = new S2SCostDto();
                        equipCostInfo.setCategory(budgetCategoryMapContract.getDescription());
                        equipCostInfo.setCategoryType(budgetCategoryMapContract.getCategoryType());
                        if (lineItem.getLineItemDescription() != null) {
                            equipCostInfo.setDescription(lineItem.getLineItemDescription());
                        } else {
                            equipCostInfo.setDescription(lineItem.getCostElementBO().getDescription());
                        }
                        equipCostInfo.setCost(lineItem.getLineItemCost());
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            equipCostInfo.setCostSharing(lineItem.getCostSharingAmount());
                        }
                        costInfos.add(equipCostInfo);
                    } else {
                        equipCostInfo = (S2SCostDto)costInfoMap.get(key);
                        equipCostInfo.setCost((ScaleTwoDecimal)equipCostInfo.getCost().add((AbstractDecimal)lineItem.getLineItemCost()));
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            equipCostInfo.setCostSharing((ScaleTwoDecimal)equipCostInfo.getCostSharing().add((AbstractDecimal)lineItem.getCostSharingAmount()));
                        }
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)lineItem.getLineItemDescription())) continue;
                    costInfoMap.put((CallSite)((Object)key), equipCostInfo);
                }
            }
        }
        S2SEquipmentDto equipmentInfo = new S2SEquipmentDto();
        if (costInfos.size() > 10) {
            for (int j = costInfos.size() - 1; j > 9; --j) {
                cvExtraEquipment.add((S2SCostDto)costInfos.get(j));
                S2SCostDto extraCostInfo = (S2SCostDto)costInfos.get(j);
                totalExtraEquipFund = (ScaleTwoDecimal)totalExtraEquipFund.add((AbstractDecimal)extraCostInfo.getCost());
                totalExtraEquipNonFund = (ScaleTwoDecimal)totalExtraEquipNonFund.add((AbstractDecimal)extraCostInfo.getCostSharing());
                costInfos.remove(j);
            }
            Collections.reverse(cvExtraEquipment);
            equipmentInfo.setExtraEquipmentList(cvExtraEquipment);
            equipmentInfo.setTotalExtraNonFund(totalExtraEquipNonFund);
        }
        equipmentInfo.setTotalExtraFund(totalExtraEquipFund);
        equipmentInfo.setEquipmentList(costInfos);
        equipmentInfo.setTotalFund(totalEquipFund);
        equipmentInfo.setTotalNonFund(totalEquipNonFund);
        ArrayList<S2SEquipmentDto> equipmentInfos = new ArrayList<S2SEquipmentDto>();
        equipmentInfos.add(equipmentInfo);
        return equipmentInfos;
    }

    /*
     * WARNING - void declaration
     */
    protected List<S2SOtherDirectCostInfoDto> getOtherDirectCosts(BudgetPeriodContract budgetPeriod, BudgetContract budget) {
        void var12_31;
        S2SOtherDirectCostInfoDto otherDirectCostInfo = new S2SOtherDirectCostInfoDto();
        ArrayList<S2SCostDto> costInfoList = new ArrayList<S2SCostDto>();
        ArrayList<String> filterTargetCategoryCodes = new ArrayList<String>();
        filterTargetCategoryCodes.add(this.s2SConfigurationService.getValueAsString("s2sBudgetTargetCategoryCodeEquipmentCost"));
        ArrayList<String> filterCategoryTypes = new ArrayList<String>();
        filterCategoryTypes.add(this.s2SConfigurationService.getValueAsString("s2sBudgetFilterCategoryTypePersonnel"));
        List<? extends BudgetCategoryMapContract> budgetCategoryMapList = this.s2SBudgetCategoryMapService.getBudgetCategoryMapList(filterTargetCategoryCodes, filterCategoryTypes);
        for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
            void var12_12;
            Object budgetCategoryMapping22;
            for (BudgetCategoryMapContract budgetCategoryMapContract : budgetCategoryMapList) {
                boolean recordAdded = false;
                for (Object budgetCategoryMapping22 : budgetCategoryMapContract.getBudgetCategoryMappings()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(budgetCategoryMapping22.getBudgetCategoryCode())) continue;
                    S2SCostDto costInfo = new S2SCostDto();
                    costInfo.setCost(lineItem.getLineItemCost());
                    if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                        costInfo.setCostSharing(lineItem.getCostSharingAmount());
                    }
                    costInfo.setCategory(budgetCategoryMapContract.getDescription());
                    costInfo.setCategoryType(budgetCategoryMapContract.getCategoryType());
                    if (lineItem.getQuantity() != null) {
                        costInfo.setQuantity(lineItem.getQuantity().intValue());
                    }
                    costInfoList.add(costInfo);
                    recordAdded = true;
                    break;
                }
                if (!recordAdded) continue;
                break;
            }
            S2SCostDto lineItemcostInfo = new S2SCostDto();
            lineItemcostInfo.setCategory("Other Direct Costs");
            lineItemcostInfo.setCategoryType(CATEGORY_TYPE_OTHER_DIRECT_COST);
            lineItemcostInfo.setQuantity(1);
            ScaleTwoDecimal scaleTwoDecimal = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalCostSharing = ScaleTwoDecimal.ZERO;
            budgetCategoryMapping22 = lineItem.getBudgetLineItemCalculatedAmounts().iterator();
            while (budgetCategoryMapping22.hasNext()) {
                BudgetLineItemCalculatedAmountContract lineItemCalculatedAmt = (BudgetLineItemCalculatedAmountContract)budgetCategoryMapping22.next();
                if (!lineItemCalculatedAmt.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeSalariesMs"))) continue;
                ScaleTwoDecimal scaleTwoDecimal2 = (ScaleTwoDecimal)var12_12.add((AbstractDecimal)lineItemCalculatedAmt.getCalculatedCost());
                if (!this.canBudgetLineItemCostSharingInclude(budget, lineItem)) continue;
                totalCostSharing = (ScaleTwoDecimal)totalCostSharing.add((AbstractDecimal)lineItemCalculatedAmt.getCalculatedCostSharing());
            }
            lineItemcostInfo.setCost((ScaleTwoDecimal)var12_12);
            if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                lineItemcostInfo.setCostSharing(totalCostSharing);
            }
            String description = DESCRIPTION_LA + String.valueOf(var12_12) + ";";
            lineItemcostInfo.setDescription(description);
            costInfoList.add(lineItemcostInfo);
        }
        ScaleTwoDecimal totalOtherDirect = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTravelCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalParticipantCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal scaleTwoDecimal = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTravelCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalParticipantCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal materialCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal materialCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal consultantCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal consultantCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal publicationCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal publicationCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal computerCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal computerCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal alterationsCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal alterationsCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal subContractCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal subContractCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal equipmentRentalCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal equipmentRentalCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal domesticTravelCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal domesticTravelCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal foreignTravelCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal foreignTravelCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partStipendsCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partStipendsCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partTravelCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partTravelCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partTuitionCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partTuitionCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partSubsistenceCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partSubsistenceCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partOtherCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal partOtherCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal otherDirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal otherDirectCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal otherCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal otherCostSharing = ScaleTwoDecimal.ZERO;
        Optional<Object> otherDirectHumanFetalTissueCost = Optional.empty();
        Optional<Object> otherDirectHumanFetalTissueCostSharing = Optional.empty();
        Optional<Object> otherDataManagementAndSharingCosts = Optional.empty();
        Optional<Object> otherDataManagementAndSharingCostsSharing = Optional.empty();
        for (S2SCostDto costInfo : costInfoList) {
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetMaterialsAndSuppliesCategory"))) {
                materialCost = (ScaleTwoDecimal)materialCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                materialCostSharing = (ScaleTwoDecimal)materialCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetConsultantCostsCategory"))) {
                consultantCost = (ScaleTwoDecimal)consultantCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                consultantCostSharing = (ScaleTwoDecimal)consultantCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetPublicationCostsCategory"))) {
                publicationCost = (ScaleTwoDecimal)publicationCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                publicationCostSharing = (ScaleTwoDecimal)publicationCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetComputerServicesCategory"))) {
                computerCost = (ScaleTwoDecimal)computerCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                computerCostSharing = (ScaleTwoDecimal)computerCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetAlterationsCategory"))) {
                alterationsCost = (ScaleTwoDecimal)alterationsCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                alterationsCostSharing = (ScaleTwoDecimal)alterationsCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetSubcontractCategory"))) {
                subContractCost = (ScaleTwoDecimal)subContractCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                subContractCostSharing = (ScaleTwoDecimal)subContractCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetEquipmentRentalCategory"))) {
                equipmentRentalCost = (ScaleTwoDecimal)equipmentRentalCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                equipmentRentalCostSharing = (ScaleTwoDecimal)equipmentRentalCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetDomesticTravelCategory"))) {
                domesticTravelCost = (ScaleTwoDecimal)domesticTravelCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                domesticTravelCostSharing = (ScaleTwoDecimal)domesticTravelCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetForeignTravelCategory"))) {
                foreignTravelCost = (ScaleTwoDecimal)foreignTravelCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                foreignTravelCostSharing = (ScaleTwoDecimal)foreignTravelCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetParticipantStipendsCategory"))) {
                partStipendsCost = (ScaleTwoDecimal)partStipendsCost.add((AbstractDecimal)costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partStipendsCostSharing = (ScaleTwoDecimal)partStipendsCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                    totalParticipantCostSharing = (ScaleTwoDecimal)totalParticipantCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                }
                totalParticipantCost = (ScaleTwoDecimal)totalParticipantCost.add((AbstractDecimal)costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetParticipantTravelCategory"))) {
                partTravelCost = (ScaleTwoDecimal)partTravelCost.add((AbstractDecimal)costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partTravelCostSharing = (ScaleTwoDecimal)partTravelCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                    totalParticipantCostSharing = (ScaleTwoDecimal)totalParticipantCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                }
                totalParticipantCost = (ScaleTwoDecimal)totalParticipantCost.add((AbstractDecimal)costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetParticipantTutionCategory"))) {
                partTuitionCost = (ScaleTwoDecimal)partTuitionCost.add((AbstractDecimal)costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partTuitionCostSharing = (ScaleTwoDecimal)partTuitionCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                    totalParticipantCostSharing = (ScaleTwoDecimal)totalParticipantCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                }
                totalParticipantCost = (ScaleTwoDecimal)totalParticipantCost.add((AbstractDecimal)costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetParticipantSubsistenceCategory"))) {
                partSubsistenceCost = (ScaleTwoDecimal)partSubsistenceCost.add((AbstractDecimal)costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partSubsistenceCostSharing = (ScaleTwoDecimal)partSubsistenceCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                    totalParticipantCostSharing = (ScaleTwoDecimal)totalParticipantCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                }
                totalParticipantCost = (ScaleTwoDecimal)totalParticipantCost.add((AbstractDecimal)costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetParticipantOtherCategory"))) {
                partOtherCost = (ScaleTwoDecimal)partOtherCost.add((AbstractDecimal)costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partOtherCostSharing = (ScaleTwoDecimal)partOtherCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                    totalParticipantCostSharing = (ScaleTwoDecimal)totalParticipantCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                }
                totalParticipantCost = (ScaleTwoDecimal)totalParticipantCost.add((AbstractDecimal)costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetOtherDirectCostsCategory"))) {
                otherDirectCost = (ScaleTwoDecimal)otherDirectCost.add((AbstractDecimal)costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                otherDirectCostSharing = (ScaleTwoDecimal)otherDirectCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetOtherDirectHumanFetalTissueCostsCategory"))) {
                otherDirectHumanFetalTissueCost = otherDirectHumanFetalTissueCost.map(v -> (ScaleTwoDecimal)v.add((AbstractDecimal)costInfo.getCost())).or(() -> Optional.of(costInfo.getCost()));
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                otherDirectHumanFetalTissueCostSharing = otherDirectHumanFetalTissueCostSharing.map(v -> (ScaleTwoDecimal)v.add((AbstractDecimal)costInfo.getCostSharing())).or(() -> Optional.of(costInfo.getCostSharing()));
                continue;
            }
            if (costInfo.getCategory().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetOtherDirectDataManagementAndSharingCosts"))) {
                otherDataManagementAndSharingCosts = otherDataManagementAndSharingCosts.map(v -> (ScaleTwoDecimal)v.add((AbstractDecimal)costInfo.getCost())).or(() -> Optional.of(costInfo.getCost()));
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                otherDataManagementAndSharingCostsSharing = otherDataManagementAndSharingCostsSharing.map(v -> (ScaleTwoDecimal)v.add((AbstractDecimal)costInfo.getCostSharing())).or(() -> Optional.of(costInfo.getCostSharing()));
                continue;
            }
            otherCost = (ScaleTwoDecimal)otherCost.add((AbstractDecimal)costInfo.getCost());
            if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
            otherCostSharing = (ScaleTwoDecimal)otherCostSharing.add((AbstractDecimal)costInfo.getCostSharing());
        }
        otherDirectCostInfo.setMaterials(materialCost);
        otherDirectCostInfo.setMaterialsCostSharing(materialCostSharing);
        otherDirectCostInfo.setConsultants(consultantCost);
        otherDirectCostInfo.setConsultantsCostSharing(consultantCostSharing);
        otherDirectCostInfo.setPublications(publicationCost);
        otherDirectCostInfo.setPublicationsCostSharing(publicationCostSharing);
        otherDirectCostInfo.setComputer(computerCost);
        otherDirectCostInfo.setComputerCostSharing(computerCostSharing);
        otherDirectCostInfo.setAlterations(alterationsCost);
        otherDirectCostInfo.setAlterationsCostSharing(alterationsCostSharing);
        otherDirectCostInfo.setSubAwards(subContractCost);
        otherDirectCostInfo.setSubAwardsCostSharing(subContractCostSharing);
        otherDirectCostInfo.setEquipRental(equipmentRentalCost);
        otherDirectCostInfo.setEquipRentalCostSharing(equipmentRentalCostSharing);
        otherDirectCostInfo.setDomTravel(domesticTravelCost);
        otherDirectCostInfo.setDomTravelCostSharing(domesticTravelCostSharing);
        otherDirectCostInfo.setForeignTravel(foreignTravelCost);
        otherDirectCostInfo.setForeignTravelCostSharing(foreignTravelCostSharing);
        otherDirectCostInfo.setPartStipends(partStipendsCost);
        otherDirectCostInfo.setPartStipendsCostSharing(partStipendsCostSharing);
        otherDirectCostInfo.setPartTravel(partTravelCost);
        otherDirectCostInfo.setPartTravelCostSharing(partTravelCostSharing);
        otherDirectCostInfo.setPartTuition(partTuitionCost);
        otherDirectCostInfo.setPartTuitionCostSharing(partTuitionCostSharing);
        otherDirectCostInfo.setPartSubsistence(partSubsistenceCost);
        otherDirectCostInfo.setPartSubsistenceCostSharing(partSubsistenceCostSharing);
        otherDirectCostInfo.setPartOther(partOtherCost);
        otherDirectCostInfo.setPartOtherCostSharing(partOtherCostSharing);
        otherDirectCostInfo.setParticipantTotal(totalParticipantCost);
        otherDirectCostInfo.setParticipantTotalCostSharing(totalParticipantCostSharing);
        otherDirectCostInfo.setParticipantTotalCount(budgetPeriod.getNumberOfParticipants() == null ? 0 : budgetPeriod.getNumberOfParticipants());
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)materialCost);
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)consultantCost);
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)publicationCost);
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)computerCost);
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)alterationsCost);
        if (otherDirectHumanFetalTissueCost.isPresent()) {
            totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)((ScaleTwoDecimal)otherDirectHumanFetalTissueCost.get()));
        }
        if (otherDataManagementAndSharingCosts.isPresent()) {
            totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)((ScaleTwoDecimal)otherDataManagementAndSharingCosts.get()));
        }
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)subContractCost);
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)equipmentRentalCost);
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)otherDirectCost);
        totalOtherDirect = (ScaleTwoDecimal)totalOtherDirect.add((AbstractDecimal)otherCost);
        totalTravelCost = (ScaleTwoDecimal)totalTravelCost.add((AbstractDecimal)domesticTravelCost);
        totalTravelCost = (ScaleTwoDecimal)totalTravelCost.add((AbstractDecimal)foreignTravelCost);
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            void var12_26;
            ScaleTwoDecimal scaleTwoDecimal7 = (ScaleTwoDecimal)scaleTwoDecimal.add((AbstractDecimal)materialCostSharing);
            scaleTwoDecimal7 = (ScaleTwoDecimal)scaleTwoDecimal7.add((AbstractDecimal)consultantCostSharing);
            scaleTwoDecimal7 = (ScaleTwoDecimal)scaleTwoDecimal7.add((AbstractDecimal)publicationCostSharing);
            scaleTwoDecimal7 = (ScaleTwoDecimal)scaleTwoDecimal7.add((AbstractDecimal)computerCostSharing);
            scaleTwoDecimal7 = (ScaleTwoDecimal)scaleTwoDecimal7.add((AbstractDecimal)alterationsCostSharing);
            if (otherDirectHumanFetalTissueCostSharing.isPresent()) {
                ScaleTwoDecimal scaleTwoDecimal8 = (ScaleTwoDecimal)scaleTwoDecimal7.add((AbstractDecimal)((ScaleTwoDecimal)otherDirectHumanFetalTissueCostSharing.get()));
            }
            if (otherDataManagementAndSharingCostsSharing.isPresent()) {
                void var12_24;
                ScaleTwoDecimal scaleTwoDecimal9 = (ScaleTwoDecimal)var12_24.add((AbstractDecimal)((ScaleTwoDecimal)otherDataManagementAndSharingCostsSharing.get()));
            }
            ScaleTwoDecimal scaleTwoDecimal13 = (ScaleTwoDecimal)var12_26.add((AbstractDecimal)subContractCostSharing);
            scaleTwoDecimal13 = (ScaleTwoDecimal)scaleTwoDecimal13.add((AbstractDecimal)equipmentRentalCostSharing);
            scaleTwoDecimal13 = (ScaleTwoDecimal)scaleTwoDecimal13.add((AbstractDecimal)otherDirectCostSharing);
            scaleTwoDecimal13 = (ScaleTwoDecimal)scaleTwoDecimal13.add((AbstractDecimal)otherCostSharing);
            totalTravelCostSharing = (ScaleTwoDecimal)totalTravelCostSharing.add((AbstractDecimal)domesticTravelCostSharing);
            totalTravelCostSharing = (ScaleTwoDecimal)totalTravelCostSharing.add((AbstractDecimal)foreignTravelCostSharing);
        }
        otherDirectCostInfo.setTotalOtherDirect(totalOtherDirect);
        otherDirectCostInfo.setTotalOtherDirectCostSharing((ScaleTwoDecimal)var12_31);
        otherDirectCostInfo.setTotTravel(totalTravelCost);
        otherDirectCostInfo.setTotTravelCostSharing(totalTravelCostSharing);
        ArrayList<S2SOtherCostDto> otherCostDetails = new ArrayList<S2SOtherCostDto>();
        S2SOtherCostDto hmOtherDirectCostDetails = new S2SOtherCostDto();
        hmOtherDirectCostDetails.setCost(otherDirectCost);
        hmOtherDirectCostDetails.setDescription("Other Direct Costs");
        hmOtherDirectCostDetails.setCostSharing(otherDirectCostSharing);
        otherCostDetails.add(hmOtherDirectCostDetails);
        if (otherDirectHumanFetalTissueCost.isPresent()) {
            S2SOtherCostDto hftOtherDirectCostDetails = new S2SOtherCostDto();
            hftOtherDirectCostDetails.setCost((ScaleTwoDecimal)otherDirectHumanFetalTissueCost.get());
            hftOtherDirectCostDetails.setDescription("Human Fetal Tissue Costs");
            hftOtherDirectCostDetails.setCostSharing((ScaleTwoDecimal)otherDirectHumanFetalTissueCostSharing.orElse(ScaleTwoDecimal.ZERO));
            otherCostDetails.add(hftOtherDirectCostDetails);
        }
        if (otherDataManagementAndSharingCosts.isPresent()) {
            S2SOtherCostDto dmsOtherDirectionCostDetails = new S2SOtherCostDto();
            dmsOtherDirectionCostDetails.setCost((ScaleTwoDecimal)otherDataManagementAndSharingCosts.get());
            dmsOtherDirectionCostDetails.setDescription("Data Management and Sharing Costs");
            dmsOtherDirectionCostDetails.setCostSharing((ScaleTwoDecimal)otherDataManagementAndSharingCostsSharing.orElse(ScaleTwoDecimal.ZERO));
            otherCostDetails.add(dmsOtherDirectionCostDetails);
        }
        S2SOtherCostDto hmOtherCostDetails = new S2SOtherCostDto();
        hmOtherCostDetails.setCost(otherCost);
        hmOtherCostDetails.setDescription("All Other Costs");
        hmOtherCostDetails.setCostSharing(otherCostSharing);
        otherCostDetails.add(hmOtherCostDetails);
        otherDirectCostInfo.setOtherCosts(otherCostDetails);
        ArrayList<S2SOtherDirectCostInfoDto> otherDirectCosts = new ArrayList<S2SOtherDirectCostInfoDto>();
        otherDirectCosts.add(otherDirectCostInfo);
        return otherDirectCosts;
    }

    protected List<S2SKeyPersonDto> getKeyPersons(BudgetPeriodContract budgetPeriod, ProposalDevelopmentDocumentContract pdDoc, BudgetContract budget) {
        ArrayList<S2SKeyPersonDto> keyPersons = new ArrayList<S2SKeyPersonDto>();
        S2SKeyPersonDto keyPerson = new S2SKeyPersonDto();
        ProposalPersonContract principalInvestigator = this.s2SProposalPersonService.getPrincipalInvestigator(pdDoc);
        if (principalInvestigator != null) {
            keyPerson.setPersonId(principalInvestigator.getPersonId());
            keyPerson.setRolodexId(principalInvestigator.getRolodexId());
            keyPerson.setFirstName(principalInvestigator.getFirstName() == null ? VALUE_UNKNOWN : principalInvestigator.getFirstName());
            keyPerson.setLastName(principalInvestigator.getLastName() == null ? VALUE_UNKNOWN : principalInvestigator.getLastName());
            keyPerson.setMiddleName(principalInvestigator.getMiddleName());
            keyPerson.setRole("PD/PI");
            this.addUniqueKeyPerson(keyPersons, keyPerson);
        }
        List seniorBudgetCategories = this.budgetCategoryMapService.findCatMappingByTargetAndMappingName(TARGET_CATEGORY_CODE_01, SPONSOR);
        for (ProposalPersonContract coInvestigator : this.s2SProposalPersonService.getCoInvestigators(pdDoc)) {
            boolean isEmployeeMpi;
            keyPerson = new S2SKeyPersonDto();
            keyPerson.setPersonId(coInvestigator.getPersonId());
            keyPerson.setRolodexId(coInvestigator.getRolodexId());
            keyPerson.setFirstName(coInvestigator.getFirstName() == null ? VALUE_UNKNOWN : coInvestigator.getFirstName());
            keyPerson.setLastName(coInvestigator.getLastName() == null ? VALUE_UNKNOWN : coInvestigator.getLastName());
            keyPerson.setMiddleName(coInvestigator.getMiddleName());
            if (this.sponsorHierarchyService.isSponsorNihMultiplePi(pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                if (coInvestigator.isMultiplePi()) {
                    keyPerson.setRole("PD/PI");
                } else {
                    keyPerson.setRole(NID_CO_PD_PI);
                }
            } else {
                keyPerson.setRole(KEYPERSON_CO_PD_PI);
            }
            boolean bl = isEmployeeMpi = keyPerson.getRole().equals("PD/PI") && keyPerson.getPersonId() != null;
            if (!isEmployeeMpi && !this.hasSeniorPersonnelBudget(budgetPeriod, keyPerson, seniorBudgetCategories)) continue;
            this.addUniqueKeyPerson(keyPersons, keyPerson);
        }
        for (ProposalPersonContract propPerson : this.s2SProposalPersonService.getKeyPersons(pdDoc)) {
            keyPerson = new S2SKeyPersonDto();
            keyPerson.setPersonId(propPerson.getPersonId());
            keyPerson.setRolodexId(propPerson.getRolodexId());
            keyPerson.setFirstName(propPerson.getFirstName() == null ? VALUE_UNKNOWN : propPerson.getFirstName());
            keyPerson.setLastName(propPerson.getLastName() == null ? VALUE_UNKNOWN : propPerson.getLastName());
            keyPerson.setMiddleName(propPerson.getMiddleName());
            keyPerson.setRole(this.getBudgetPersonRoleOther());
            keyPerson.setKeyPersonRole(propPerson.getProjectRole());
            if (!this.hasSeniorPersonnelBudget(budgetPeriod, keyPerson, seniorBudgetCategories)) continue;
            this.addUniqueKeyPerson(keyPersons, keyPerson);
        }
        for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetailsContract budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                if (!this.isSeniorLineItem(seniorBudgetCategories, lineItem.getBudgetCategory().getCode())) continue;
                if (budgetPersonnelDetails.getBudgetPerson().getNonEmployeeFlag().booleanValue()) {
                    String l;
                    String middleName;
                    TbnPersonContract tbnPerson;
                    if (budgetPersonnelDetails.getBudgetPerson().getRolodexId() != null) {
                        RolodexContract rolodexPerson = this.rolodexService.getRolodex(budgetPersonnelDetails.getBudgetPerson().getRolodexId());
                        keyPerson = new S2SKeyPersonDto();
                        keyPerson.setRolodexId(rolodexPerson.getRolodexId());
                        keyPerson.setFirstName(rolodexPerson.getFirstName() == null ? VALUE_UNKNOWN : rolodexPerson.getFirstName());
                        keyPerson.setLastName(rolodexPerson.getLastName() == null ? VALUE_UNKNOWN : rolodexPerson.getLastName());
                        keyPerson.setMiddleName(rolodexPerson.getMiddleName());
                        keyPerson.setRole(StringUtils.isNotBlank((CharSequence)rolodexPerson.getTitle()) ? rolodexPerson.getTitle() : this.getBudgetPersonRoleOther());
                        this.addUniqueKeyPerson(keyPersons, keyPerson);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)budgetPersonnelDetails.getBudgetPerson().getTbnId()) || (tbnPerson = this.tbnPersonService.getTbnPerson(budgetPersonnelDetails.getBudgetPerson().getTbnId())) == null) continue;
                    keyPerson = new S2SKeyPersonDto();
                    keyPerson.setTbn(true);
                    keyPerson.setTbnName(budgetPersonnelDetails.getBudgetPerson().getPersonName());
                    List tbnNames = Stream.of(budgetPersonnelDetails.getBudgetPerson().getPersonName().split(" ")).filter(Objects::nonNull).map(s -> s.replace("-", "")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                    String firstName = tbnNames.size() >= 1 ? (String)tbnNames.get(0) : VALUE_UNKNOWN;
                    String string = middleName = tbnNames.size() >= 3 ? (String)tbnNames.get(1) : " ";
                    String lastName = tbnNames.size() == 2 ? (StringUtils.isNotBlank((CharSequence)(l = (String)tbnNames.get(1))) ? l : VALUE_UNKNOWN) : (tbnNames.size() >= 3 ? (StringUtils.isNotBlank((CharSequence)(l = String.join((CharSequence)" ", tbnNames.subList(2, tbnNames.size())))) ? l : VALUE_UNKNOWN) : VALUE_UNKNOWN);
                    keyPerson.setPersonId(tbnPerson.getId());
                    keyPerson.setFirstName(firstName);
                    keyPerson.setMiddleName(middleName);
                    keyPerson.setLastName(lastName);
                    keyPerson.setRole(tbnPerson.getPersonName());
                    this.addUniqueKeyPerson(keyPersons, keyPerson);
                    continue;
                }
                KcPersonContract kcPerson = this.kcPersonRepositoryService.findKcPersonByPersonId(budgetPersonnelDetails.getBudgetPerson().getPersonId());
                if (kcPerson == null) continue;
                keyPerson = new S2SKeyPersonDto();
                keyPerson.setPersonId(kcPerson.getPersonId());
                keyPerson.setFirstName(kcPerson.getFirstName() == null ? VALUE_UNKNOWN : kcPerson.getFirstName());
                keyPerson.setLastName(kcPerson.getLastName() == null ? VALUE_UNKNOWN : kcPerson.getLastName());
                keyPerson.setMiddleName(kcPerson.getMiddleName());
                keyPerson.setRole(this.getBudgetPersonRoleOther());
                this.addUniqueKeyPerson(keyPersons, keyPerson);
            }
        }
        for (S2SKeyPersonDto keyPersonInfo : keyPersons) {
            this.setCompensation(keyPersonInfo, budgetPeriod, budget);
        }
        return keyPersons;
    }

    private Boolean hasPersonnelBudget(BudgetPeriodContract budgetPeriod, S2SKeyPersonDto keyPerson) {
        return budgetPeriod.getBudgetLineItems().stream().anyMatch(lineItem -> lineItem.getBudgetPersonnelDetailsList().stream().anyMatch(personnelDetails -> this.isSamePerson(keyPerson, (BudgetPersonnelDetailsContract)personnelDetails)));
    }

    private boolean hasSeniorPersonnelBudget(BudgetPeriodContract budgetPeriod, S2SKeyPersonDto keyPerson, List<? extends BudgetCategoryMappingContract> budgetCategoryList) {
        return budgetPeriod.getBudgetLineItems().stream().anyMatch(lineItem -> lineItem.getBudgetPersonnelDetailsList().stream().anyMatch(personnelDetails -> this.isSamePerson(keyPerson, (BudgetPersonnelDetailsContract)personnelDetails) && this.isSeniorLineItem(budgetCategoryList, lineItem.getBudgetCategory().getCode())));
    }

    private boolean canBudgetLineItemCostSharingInclude(BudgetContract budget, BudgetLineItemContract lineItem) {
        return budget.getSubmitCostSharingFlag() != false && lineItem.getSubmitCostSharingFlag() != false;
    }

    private boolean isSamePerson(S2SKeyPersonDto keyPerson, BudgetPersonnelDetailsContract budgetPersonnelDetails) {
        return budgetPersonnelDetails.getPersonId().equals(keyPerson.getPersonId()) || keyPerson.getRolodexId() != null && budgetPersonnelDetails.getPersonId().equals(keyPerson.getRolodexId().toString());
    }

    private String getBudgetPersonRoleOther() {
        return KEYPERSON_OTHER;
    }

    private boolean isSeniorLineItem(List<? extends BudgetCategoryMappingContract> budgetCategoryList, String budgetCategoryCode) {
        boolean isSeniorLineItem = false;
        for (BudgetCategoryMappingContract budgetCategoryMappingContract : budgetCategoryList) {
            if (!budgetCategoryMappingContract.getBudgetCategoryCode().equals(budgetCategoryCode)) continue;
            isSeniorLineItem = true;
        }
        return isSeniorLineItem;
    }

    protected List<S2SKeyPersonDto> getNKeyPersons(List<S2SKeyPersonDto> keyPersons, int n) {
        return keyPersons.stream().limit(n).collect(Collectors.toList());
    }

    protected List<S2SOtherPersonnelDto> getOtherPersonnel(BudgetPeriodContract budgetPeriod, List<S2SKeyPersonDto> keyPersons) {
        ArrayList<S2SOtherPersonnelDto> cvOtherPersonnel = new ArrayList<S2SOtherPersonnelDto>();
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, this.s2SConfigurationService.getValueAsString("s2sBudgetCategory01Graduates"), PERSONNEL_TYPE_GRAD, ROLE_GRADUATE_STUDENTS, keyPersons));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, this.s2SConfigurationService.getValueAsString("s2sBudgetCategory01Postdocs"), PERSONNEL_TYPE_POSTDOC, ROLE_POST_DOCTORAL_ASSOCIATES, keyPersons));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, this.s2SConfigurationService.getValueAsString("s2sBudgetCategory01Undergrads"), PERSONNEL_TYPE_UNDERGRAD, ROLE_GRADUATE_UNDERGRADUATE_STUDENTS, keyPersons));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, this.s2SConfigurationService.getValueAsString("s2sBudgetCategory01Secretarial"), PERSONNEL_TYPE_SEC, ROLE_GRADUATE_SECRETARIAL_OR_CLERICAL, keyPersons));
        S2SOtherPersonnelDto other = this.getOtherPersonnelDetails(budgetPeriod, this.s2SConfigurationService.getValueAsString("s2sBudgetCategory01Other"), "Other", "Other", keyPersons);
        S2SOtherPersonnelDto otherProfessional = this.getOtherPersonnelDetails(budgetPeriod, this.s2SConfigurationService.getValueAsString("s2sBudgetCategory01OtherProfs"), "Other Professionals", "Other Professionals", keyPersons);
        S2SOtherPersonnelDto allocatedAdminSupport = this.getOtherPersonnelDetails(budgetPeriod, LASALARIES, "Allocated Admin Support", "Allocated Admin Support", keyPersons);
        if (other.getNumberPersonnel() > 0) {
            cvOtherPersonnel.add(other);
        }
        if (otherProfessional.getNumberPersonnel() > 0) {
            cvOtherPersonnel.add(otherProfessional);
        }
        if (allocatedAdminSupport.getNumberPersonnel() > 0) {
            cvOtherPersonnel.add(allocatedAdminSupport);
        }
        return cvOtherPersonnel;
    }

    protected S2SOtherPersonnelDto getOtherPersonnelDetails(BudgetPeriodContract budgetPeriod, String category, String personnelType, String role, List<S2SKeyPersonDto> keyPersons) {
        S2SOtherPersonnelDto otherPersonnelInfo = new S2SOtherPersonnelDto();
        int count = 0;
        ScaleTwoDecimal salaryRequested = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal salaryCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal lineItemCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal lineItemCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal mrLaCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal mrLaCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fringeCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fringeCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal mrLaFringeCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal mrLaFringeCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal budgetLineItemFringeCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal budgetLineItemFringeCostSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdSalary = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdFringe = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdSalaryCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdFringeCostSharing = ScaleTwoDecimal.ZERO;
        BigDecimal academicMonths = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal summerMonths = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal calendarMonths = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal cycleMonths = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        String rateTypeSupportStaffSalaries = this.s2SConfigurationService.getValueAsString("s2sBudgetRateTypeSupportStaffSalaries");
        String rateClassCodeEmployeeBenefits = this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassCodeEmployeeBenefits");
        String rateClassCodeVacation = this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassCodeVacation");
        String rateTypeAdministrativeSalaries = this.s2SConfigurationService.getValueAsString("s2sBudgetRateTypeAdministrativeSalaries");
        HashSet<CallSite> personJobCodes = new HashSet<CallSite>();
        if (category.equalsIgnoreCase(LASALARIES)) {
            for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetLineItemCalculatedAmountContract lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (lineItemCalculatedAmount.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeLabAllocationSalaries"))) {
                        mrLaCost = (ScaleTwoDecimal)mrLaCost.add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCost());
                        if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                            mrLaCostSharingAmount = (ScaleTwoDecimal)mrLaCostSharingAmount.add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCostSharing());
                        }
                    }
                    if ((!lineItemCalculatedAmount.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeEmployeeBenefits")) || !lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!lineItemCalculatedAmount.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeVacation")) || !lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeAdministrativeSalaries))) continue;
                    mrLaFringeCost = (ScaleTwoDecimal)mrLaFringeCost.add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCost());
                    if (!lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    mrLaFringeCostSharingAmount = (ScaleTwoDecimal)mrLaFringeCostSharingAmount.add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCostSharing());
                }
            }
        } else {
            for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                List budgetCategoryList = this.budgetCategoryMapService.findCatMappingByTargetAndMappingName(category, SPONSOR);
                for (BudgetCategoryMappingContract categoryMapping : budgetCategoryList) {
                    if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategory().getCode())) continue;
                    List lineItemPersonDetails = lineItem.getBudgetPersonnelDetailsList();
                    if (!lineItemPersonDetails.isEmpty()) {
                        for (BudgetPersonnelDetailsContract personDetails : lineItemPersonDetails) {
                            String key;
                            if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategory().getCode()) || !keyPersons.stream().noneMatch(keyPersonDto -> this.isSamePerson((S2SKeyPersonDto)keyPersonDto, personDetails))) continue;
                            salaryRequested = (ScaleTwoDecimal)salaryRequested.add((AbstractDecimal)personDetails.getSalaryRequested());
                            if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                                salaryCostSharing = (ScaleTwoDecimal)salaryCostSharing.add((AbstractDecimal)personDetails.getCostSharingAmount());
                            }
                            BigDecimal numberOfMonths = this.s2SDateTimeService.getNumberOfMonths(personDetails.getStartDate(), personDetails.getEndDate()).bigDecimalValue();
                            if (personDetails.getPeriodTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetPeriodTypeAcademicMonths"))) {
                                academicMonths = this.getPersonEffortMonths(academicMonths, numberOfMonths, personDetails);
                            } else if (personDetails.getPeriodTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetPeriodTypeSummerMonths"))) {
                                summerMonths = this.getPersonEffortMonths(summerMonths, numberOfMonths, personDetails);
                            } else if (personDetails.getPeriodTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetPeriodTypeCalendarMonths"))) {
                                calendarMonths = this.getPersonEffortMonths(calendarMonths, numberOfMonths, personDetails);
                            } else if (personDetails.getPeriodTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetPeriodTypeCycleMonths"))) {
                                cycleMonths = cycleMonths.add(personDetails.getPercentEffort().bigDecimalValue().multiply(numberOfMonths).multiply(POINT_ZERO_ONE));
                            }
                            if (this.isTbn(personDetails.getBudgetPerson())) {
                                key = personDetails.getPersonId() + "$tbn$" + personDetails.getBudgetPerson().getPersonName() + personDetails.getJobCode();
                                if (personDetails.getBudgetPerson().getHierarchyProposalNumber() != null) {
                                    key = (String)key + "$pd$" + personDetails.getBudgetPerson().getHierarchyProposalNumber();
                                }
                            } else {
                                key = personDetails.getPersonId() + personDetails.getJobCode();
                            }
                            personJobCodes.add((CallSite)((Object)key));
                            for (BudgetPersonnelCalculatedAmountContract personCalculatedAmount : personDetails.getBudgetPersonnelCalculatedAmounts()) {
                                if ((!personCalculatedAmount.getRateClass().getCode().equals(rateClassCodeEmployeeBenefits) || personCalculatedAmount.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!personCalculatedAmount.getRateClass().getCode().equals(rateClassCodeVacation) || personCalculatedAmount.getRateTypeCode().equals(rateTypeAdministrativeSalaries))) continue;
                                fringeCost = (ScaleTwoDecimal)fringeCost.add((AbstractDecimal)personCalculatedAmount.getCalculatedCost());
                                if (!lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                                fringeCostSharingAmount = (ScaleTwoDecimal)fringeCostSharingAmount.add((AbstractDecimal)personCalculatedAmount.getCalculatedCostSharing());
                            }
                        }
                        continue;
                    }
                    lineItemCost = (ScaleTwoDecimal)lineItemCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                        lineItemCostSharingAmount = (ScaleTwoDecimal)lineItemCostSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    }
                    count = lineItem.getQuantity();
                    for (BudgetLineItemCalculatedAmountContract lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        if (lineItemCalculatedAmount.getRateClass().getRateClassType().getCode().equalsIgnoreCase("E")) {
                            fringeCost = (ScaleTwoDecimal)fringeCost.add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCost());
                        }
                        if ((!lineItemCalculatedAmount.getRateClass().getCode().equals(rateClassCodeEmployeeBenefits) || lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!lineItemCalculatedAmount.getRateClass().getCode().equals(rateClassCodeVacation) || lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeAdministrativeSalaries)) || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                        fringeCostSharingAmount = (ScaleTwoDecimal)fringeCostSharingAmount.add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
        }
        bdSalary = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)bdSalary.add((AbstractDecimal)salaryRequested)).add((AbstractDecimal)lineItemCost)).add((AbstractDecimal)mrLaCost);
        bdSalaryCostSharing = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)bdSalaryCostSharing.add((AbstractDecimal)salaryCostSharing)).add((AbstractDecimal)lineItemCostSharingAmount)).add((AbstractDecimal)mrLaCostSharingAmount);
        bdFringe = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)bdFringe.add((AbstractDecimal)fringeCost)).add((AbstractDecimal)budgetLineItemFringeCost)).add((AbstractDecimal)mrLaFringeCost);
        bdFringeCostSharing = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)bdFringeCostSharing.add((AbstractDecimal)fringeCostSharingAmount)).add((AbstractDecimal)budgetLineItemFringeCostSharingAmount)).add((AbstractDecimal)mrLaFringeCostSharingAmount);
        ScaleTwoDecimal bdNonFunds = (ScaleTwoDecimal)bdSalaryCostSharing.add((AbstractDecimal)bdFringeCostSharing);
        ScaleTwoDecimal bdFunds = (ScaleTwoDecimal)bdSalary.add((AbstractDecimal)bdFringe);
        otherPersonnelInfo.setNumberPersonnel(personJobCodes.isEmpty() ? count : personJobCodes.size());
        otherPersonnelInfo.setPersonnelType(personnelType);
        otherPersonnelInfo.setRole(role);
        S2SCompensationDto compensationInfo = otherPersonnelInfo.getCompensation();
        compensationInfo.setBaseSalary(ScaleTwoDecimal.ZERO);
        compensationInfo.setFringe(bdFringe);
        compensationInfo.setFundsRequested(bdFunds);
        compensationInfo.setRequestedSalary(bdSalary);
        compensationInfo.setSummerMonths(new ScaleTwoDecimal(summerMonths));
        compensationInfo.setAcademicMonths(new ScaleTwoDecimal(academicMonths));
        compensationInfo.setCalendarMonths(new ScaleTwoDecimal(calendarMonths));
        compensationInfo.setFringeCostSharing(bdFringeCostSharing);
        compensationInfo.setNonFundsRequested(bdNonFunds);
        compensationInfo.setCostSharingAmount(bdSalaryCostSharing);
        otherPersonnelInfo.setCompensation(compensationInfo);
        return otherPersonnelInfo;
    }

    protected boolean getApplyRateFlagForRateBase(BudgetRateAndBaseContract rateBase, List<? extends BudgetLineItemCalculatedAmountContract> budgetLineItemCalculatedAmounts) {
        for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmountContract : budgetLineItemCalculatedAmounts) {
            if (!budgetLineItemCalculatedAmountContract.getBudgetLineItemId().equals(rateBase.getBudgetLineItemId()) || !rateBase.getRateClassCode().equals(budgetLineItemCalculatedAmountContract.getRateClass().getCode())) continue;
            return budgetLineItemCalculatedAmountContract.getApplyRateFlag();
        }
        return true;
    }

    protected void setCompensation(S2SKeyPersonDto keyPerson, BudgetPeriodContract budgetPeriod, BudgetContract budget) {
        S2SCompensationDto compensationInfo = keyPerson.getCompensation();
        BigDecimal summerMonths = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal academicMonths = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal calendarMonths = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        ScaleTwoDecimal totalSal = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal baseAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalSalCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fringeCostSharing = ScaleTwoDecimal.ZERO;
        String budgetCatagoryCodePersonnel = this.s2SConfigurationService.getValueAsString("s2sBudgetCategoryCodePersonnel");
        for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetailsContract personDetails : lineItem.getBudgetPersonnelDetailsList()) {
                ScaleTwoDecimal baseSalaryByPeriod;
                if (!this.keyPersonEqualsBudgetPerson(keyPerson, personDetails)) continue;
                BigDecimal numberOfMonths = this.s2SDateTimeService.getNumberOfMonths(personDetails.getStartDate(), personDetails.getEndDate()).bigDecimalValue();
                if (personDetails.getPeriodTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetPeriodTypeAcademicMonths"))) {
                    academicMonths = this.getPersonEffortMonths(academicMonths, numberOfMonths, personDetails);
                } else if (personDetails.getPeriodTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetPeriodTypeSummerMonths"))) {
                    summerMonths = this.getPersonEffortMonths(summerMonths, numberOfMonths, personDetails);
                } else if (StringUtils.isNotBlank((CharSequence)personDetails.getBudgetPerson().getTbnId())) {
                    if (lineItem.getBudgetCategory().getCode().equals(budgetCatagoryCodePersonnel)) {
                        calendarMonths = this.getPersonEffortMonths(calendarMonths, numberOfMonths, personDetails);
                    }
                } else {
                    calendarMonths = this.getPersonEffortMonths(calendarMonths, numberOfMonths, personDetails);
                }
                if (StringUtils.isNotBlank((CharSequence)personDetails.getBudgetPerson().getTbnId())) {
                    if (lineItem.getBudgetCategory().getCode().equals(budgetCatagoryCodePersonnel)) {
                        totalSal = (ScaleTwoDecimal)totalSal.add((AbstractDecimal)personDetails.getSalaryRequested());
                    }
                } else {
                    totalSal = (ScaleTwoDecimal)totalSal.add((AbstractDecimal)personDetails.getSalaryRequested());
                }
                if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                    if (StringUtils.isNotBlank((CharSequence)personDetails.getBudgetPerson().getTbnId())) {
                        if (lineItem.getBudgetCategory().getCode().equals(budgetCatagoryCodePersonnel)) {
                            totalSalCostSharing = (ScaleTwoDecimal)totalSalCostSharing.add((AbstractDecimal)personDetails.getCostSharingAmount());
                        }
                    } else {
                        totalSalCostSharing = (ScaleTwoDecimal)totalSalCostSharing.add((AbstractDecimal)personDetails.getCostSharingAmount());
                    }
                }
                for (BudgetPersonnelCalculatedAmountContract personCalculatedAmt : personDetails.getBudgetPersonnelCalculatedAmounts()) {
                    if ((!personCalculatedAmt.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeEmployeeBenefits")) || personCalculatedAmt.getRateTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateTypeSupportStaffSalaries"))) && (!personCalculatedAmt.getRateClass().getRateClassType().getCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateClassTypeVacation")) || personCalculatedAmt.getRateTypeCode().equals(this.s2SConfigurationService.getValueAsString("s2sBudgetRateTypeAdministrativeSalaries")))) continue;
                    if (StringUtils.isNotBlank((CharSequence)personDetails.getBudgetPerson().getTbnId())) {
                        if (lineItem.getBudgetCategory().getCode().equals(budgetCatagoryCodePersonnel)) {
                            fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)personCalculatedAmt.getCalculatedCost());
                        }
                    } else {
                        fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)personCalculatedAmt.getCalculatedCost());
                    }
                    if (!this.canBudgetLineItemCostSharingInclude(budget, lineItem)) continue;
                    if (StringUtils.isNotBlank((CharSequence)personDetails.getBudgetPerson().getTbnId())) {
                        if (!lineItem.getBudgetCategory().getCode().equals(budgetCatagoryCodePersonnel)) continue;
                        fringeCostSharing = (ScaleTwoDecimal)fringeCostSharing.add((AbstractDecimal)personCalculatedAmt.getCalculatedCostSharing());
                        continue;
                    }
                    fringeCostSharing = (ScaleTwoDecimal)fringeCostSharing.add((AbstractDecimal)personCalculatedAmt.getCalculatedCostSharing());
                }
                BudgetPersonContract budgetPerson = personDetails.getBudgetPerson();
                if (budgetPerson == null || (baseSalaryByPeriod = this.getBaseSalaryByPeriod(budget.getBudgetId(), budgetPeriod.getBudgetPeriod(), keyPerson)) == null) continue;
                baseAmount = baseSalaryByPeriod;
            }
        }
        compensationInfo.setAcademicMonths(new ScaleTwoDecimal(academicMonths));
        compensationInfo.setCalendarMonths(new ScaleTwoDecimal(calendarMonths));
        compensationInfo.setSummerMonths(new ScaleTwoDecimal(summerMonths));
        compensationInfo.setRequestedSalary(totalSal);
        compensationInfo.setBaseSalary(baseAmount);
        compensationInfo.setCostSharingAmount(totalSalCostSharing);
        compensationInfo.setFringe(fringe);
        compensationInfo.setFundsRequested((ScaleTwoDecimal)totalSal.add((AbstractDecimal)fringe));
        compensationInfo.setFringeCostSharing(fringeCostSharing);
        compensationInfo.setNonFundsRequested((ScaleTwoDecimal)totalSalCostSharing.add((AbstractDecimal)fringeCostSharing));
    }

    private ScaleTwoDecimal getBaseSalaryByPeriod(Long budgetId, int budgetPeriod, S2SKeyPersonDto person) {
        return this.budgetPersonSalaryService.findBaseSalaryForFirstPeriod(budgetId, person.getPersonId() != null ? person.getPersonId() : person.getRolodexId().toString(), Integer.valueOf(budgetPeriod));
    }

    private boolean keyPersonEqualsBudgetPerson(S2SKeyPersonDto keyPersonInfo, BudgetPersonnelDetailsContract budgetPersonnelDetails) {
        boolean equal = false;
        if (keyPersonInfo != null && budgetPersonnelDetails != null) {
            String budgetPersonId = budgetPersonnelDetails.getPersonId();
            if (keyPersonInfo.getPersonId() != null && keyPersonInfo.getPersonId().equals(budgetPersonId) && !keyPersonInfo.isTbn() || keyPersonInfo.getRolodexId() != null && keyPersonInfo.getRolodexId().toString().equals(budgetPersonId) || keyPersonInfo.getPersonId() != null && keyPersonInfo.getPersonId().equals(budgetPersonId) && keyPersonInfo.isTbn() && keyPersonInfo.getTbnName() != null && keyPersonInfo.getTbnName().equals(budgetPersonnelDetails.getBudgetPerson().getPersonName())) {
                equal = true;
            }
        }
        return equal;
    }

    private void addUniqueKeyPerson(List<S2SKeyPersonDto> keyPersons, S2SKeyPersonDto keyPerson) {
        if (keyPersons.stream().noneMatch(p -> this.matches((S2SKeyPersonDto)p, keyPerson))) {
            keyPersons.add(keyPerson);
        }
    }

    private boolean matches(S2SKeyPersonDto keyPerson1, S2SKeyPersonDto keyPerson2) {
        boolean personIdMatches = StringUtils.isNotBlank((CharSequence)keyPerson1.getPersonId()) && keyPerson1.getPersonId().equals(keyPerson2.getPersonId()) && !keyPerson1.isTbn() && keyPerson1.isTbn() == keyPerson2.isTbn();
        boolean tbnIdMatches = StringUtils.isNotBlank((CharSequence)keyPerson1.getPersonId()) && keyPerson1.getPersonId().equals(keyPerson2.getPersonId()) && StringUtils.isNotBlank((CharSequence)keyPerson1.getTbnName()) && keyPerson1.getTbnName().equals(keyPerson2.getTbnName()) && keyPerson1.isTbn() && keyPerson1.isTbn() == keyPerson2.isTbn();
        boolean rolodexIdMatches = keyPerson1.getRolodexId() != null && keyPerson1.getRolodexId().equals(keyPerson2.getRolodexId());
        return personIdMatches || rolodexIdMatches || tbnIdMatches;
    }

    private boolean isTbn(BudgetPersonContract person) {
        return StringUtils.isNotBlank((CharSequence)person.getTbnId());
    }

    private BigDecimal getPersonEffortMonths(BigDecimal effortMonths, BigDecimal numberOfMonths, BudgetPersonnelDetailsContract personDetails) {
        effortMonths = effortMonths.add(personDetails.getPercentEffort().bigDecimalValue().multiply(numberOfMonths).multiply(POINT_ZERO_ONE));
        return effortMonths;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }

    public OrganizationRepositoryService getOrganizationRepositoryService() {
        return this.organizationRepositoryService;
    }

    public void setOrganizationRepositoryService(OrganizationRepositoryService organizationRepositoryService) {
        this.organizationRepositoryService = organizationRepositoryService;
    }

    public ModularBudgetService getModularBudgetService() {
        return this.modularBudgetService;
    }

    public void setModularBudgetService(ModularBudgetService modularBudgetService) {
        this.modularBudgetService = modularBudgetService;
    }

    public BudgetCategoryMapService getBudgetCategoryMapService() {
        return this.budgetCategoryMapService;
    }

    public void setBudgetCategoryMapService(BudgetCategoryMapService budgetCategoryMapService) {
        this.budgetCategoryMapService = budgetCategoryMapService;
    }

    public BudgetPersonSalaryService getBudgetPersonSalaryService() {
        return this.budgetPersonSalaryService;
    }

    public void setBudgetPersonSalaryService(BudgetPersonSalaryService budgetPersonSalaryService) {
        this.budgetPersonSalaryService = budgetPersonSalaryService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public KcPersonRepositoryService getKcPersonRepositoryService() {
        return this.kcPersonRepositoryService;
    }

    public void setKcPersonRepositoryService(KcPersonRepositoryService kcPersonRepositoryService) {
        this.kcPersonRepositoryService = kcPersonRepositoryService;
    }

    public TbnPersonService getTbnPersonService() {
        return this.tbnPersonService;
    }

    public void setTbnPersonService(TbnPersonService tbnPersonService) {
        this.tbnPersonService = tbnPersonService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public S2SProposalPersonService getS2SProposalPersonService() {
        return this.s2SProposalPersonService;
    }

    public void setS2SProposalPersonService(S2SProposalPersonService s2SProposalPersonService) {
        this.s2SProposalPersonService = s2SProposalPersonService;
    }

    public S2SBudgetCategoryMapService getS2SBudgetCategoryMapService() {
        return this.s2SBudgetCategoryMapService;
    }

    public void setS2SBudgetCategoryMapService(S2SBudgetCategoryMapService s2SBudgetCategoryMapService) {
        this.s2SBudgetCategoryMapService = s2SBudgetCategoryMapService;
    }
}

