/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.s2sgen.api.generate.FormMappingInfo;
import org.kuali.coeus.s2sgen.api.generate.FormMappingService;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorRetrievalService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="formMappingService")
public class FormMappingServiceImpl
implements FormMappingService,
InitializingBean {
    private Map<String, FormMappingInfo> namespaceToInfo;
    @Autowired
    @Qualifier(value="s2SFormGeneratorRetrievalService")
    private S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService;

    public FormMappingInfo getFormInfo(String namespace) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        return this.namespaceToInfo.get(namespace);
    }

    public Set<FormMappingInfo> getAllFormInfo() {
        return new HashSet<FormMappingInfo>(this.namespaceToInfo.values());
    }

    public S2SFormGeneratorRetrievalService getS2SFormGeneratorRetrievalService() {
        return this.s2SFormGeneratorRetrievalService;
    }

    public void setS2SFormGeneratorRetrievalService(S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService) {
        this.s2SFormGeneratorRetrievalService = s2SFormGeneratorRetrievalService;
    }

    public void afterPropertiesSet() {
        this.namespaceToInfo = this.getS2SFormGeneratorRetrievalService().getS2SGenerators().stream().map(s2sGenerator -> CollectionUtils.entry(s2sGenerator.getNamespace(), new FormMappingInfo(s2sGenerator.getNamespace(), s2sGenerator.getFormName()))).collect(CollectionUtils.entriesToMap());
    }
}

