/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.sys.api.model.Cfda;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class CommonSF424BaseGenerator<T extends XmlObject>
extends S2SBaseFormGenerator<T> {
    protected static final Integer PROPOSAL_YNQ_QUESTION_129 = 129;
    protected static final Integer PROPOSAL_YNQ_QUESTION_130 = 130;
    protected static final Integer PROPOSAL_YNQ_QUESTION_131 = 131;
    private static final String YNQ_NOT_REVIEWED = "X";
    protected static final String YNQ_REVIEW_DATE = "reviewDate";
    protected static final String YNQ_STATE_REVIEW_DATA = "stateReviewData";
    protected static final String YNQ_STATE_NOT_SELECTED = "Not Selected";
    protected static final String YNQ_STATE_NOT_COVERED = "Not Covered";
    protected static final String YNQ_ANSWER = "answer";
    protected static final String SPONSOR_GROUPS = "Sponsor Groups";
    protected static final int SPONSOR_NAME_MAX_LENGTH = 60;
    protected static final String SPONSOR_NIH = "NIH";
    protected static final int FED_AWARD_ID_MAX_LENGTH = 25;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    private S2SCommonBudgetService s2SCommonBudgetService;

    protected Map<String, String> getEOStateReview(ProposalDevelopmentDocumentContract pdDoc) {
        HashMap<String, String> stateReview = new HashMap<String, String>();
        List answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(pdDoc.getDevelopmentProposal().getProposalNumber());
        answerHeaders.forEach(answerHeader -> {
            for (AnswerContract answers : answerHeader.getAnswers()) {
                Integer questionSeqId = this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId();
                if (questionSeqId != null && questionSeqId.equals(PROPOSAL_YNQ_QUESTION_129)) {
                    stateReview.putIfAbsent(YNQ_ANSWER, answers.getAnswer());
                }
                if (questionSeqId != null && questionSeqId.equals(PROPOSAL_YNQ_QUESTION_130)) {
                    stateReview.putIfAbsent(YNQ_REVIEW_DATE, answers.getAnswer());
                }
                if (questionSeqId == null || !questionSeqId.equals(PROPOSAL_YNQ_QUESTION_131)) continue;
                stateReview.putIfAbsent(YNQ_STATE_REVIEW_DATA, answers.getAnswer());
            }
        });
        if (stateReview.size() == 0) {
            stateReview.put(YNQ_ANSWER, YNQ_NOT_REVIEWED);
            stateReview.put(YNQ_REVIEW_DATE, null);
        }
        return stateReview;
    }

    protected boolean isSponsorInHierarchy(DevelopmentProposalContract sponsorable, String sponsorHierarchy, String level1) {
        return this.getSponsorHierarchyService().isSponsorInHierarchy(sponsorable.getSponsor().getSponsorCode(), sponsorHierarchy, 1, level1);
    }

    protected String getEmployerId() {
        String employerId = "";
        ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        boolean isNih = this.isSponsorInHierarchy(this.pdDoc.getDevelopmentProposal(), SPONSOR_GROUPS, SPONSOR_NIH);
        if (applicantOrganization != null) {
            employerId = applicantOrganization.getOrganization().getPhsAccount() != null && isNih ? applicantOrganization.getOrganization().getPhsAccount() : applicantOrganization.getOrganization().getFederalEmployerId();
        }
        return employerId;
    }

    protected String getFirstCfdaNumber() {
        return this.pdDoc.getDevelopmentProposal().getProposalCfdas().stream().map(Cfda::getCfdaNumber).findFirst().orElse(null);
    }

    protected String getFederalAgencyName() {
        return Optional.ofNullable(this.pdDoc.getDevelopmentProposal()).map(DevelopmentProposalContract::getSponsor).map(SponsorContract::getSponsorName).map(sponsorName -> StringUtils.substring((String)sponsorName, (int)0, (int)60)).orElse("");
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }
}

