/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.edGEPA42720V20.EDGEPA42720Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="EDGEPA427V2_0Generator")
public class EDGEPA427V2_0Generator
extends S2SBaseFormGenerator<EDGEPA42720Document>
implements S2SFormGeneratorPdfFillable<EDGEPA42720Document> {
    @Value(value="http://apply.grants.gov/forms/ED_GEPA427_2_0-V2.0")
    private String namespace;
    @Value(value="ED_GEPA427_2_0-V2.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_GEPA427_2_0-V2.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ED_GEPA427_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    private static final int EQUITABLE_QUESTION_ID = -10163;
    private static final int BARRIERS_QUESTION_ID = -10164;
    private static final int STEPS_QUESTION_ID = -10165;
    private static final int TIMELINE_QUESTION_ID = -10166;

    private EDGEPA42720Document getEDGEPA42720Document() {
        EDGEPA42720Document gepa427Document = (EDGEPA42720Document)EDGEPA42720Document.Factory.newInstance();
        EDGEPA42720Document.EDGEPA42720 gepa = (EDGEPA42720Document.EDGEPA42720)EDGEPA42720Document.EDGEPA42720.Factory.newInstance();
        gepa.setFormVersion(FormVersion.v2_0.getVersion());
        List<? extends AnswerHeaderContract> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        for (AnswerHeaderContract answerHeaderContract : answers) {
            QuestionnaireContract questionnaire = this.getQuestionAnswerService().findQuestionnaireById(answerHeaderContract.getQuestionnaireId());
            List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeaderContract);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                Integer questionId = question.getQuestionSeqId();
                if (answer == null) continue;
                switch (questionId) {
                    case -10164: {
                        gepa.setBarriers(answer);
                        break;
                    }
                    case -10166: {
                        gepa.setTimeline(answer);
                        break;
                    }
                    case -10163: {
                        gepa.setEnsureEquitableAccess(answer);
                        break;
                    }
                    case -10165: {
                        gepa.setSteps(answer);
                        break;
                    }
                }
            }
        }
        gepa427Document.setEDGEPA42720(gepa);
        return gepa427Document;
    }

    protected List<? extends AnswerHeaderContract> findQuestionnaireWithAnswers(DevelopmentProposalContract developmentProposal) {
        return this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(developmentProposal.getProposalNumber(), this.getNamespace(), this.getFormName());
    }

    @Override
    public EDGEPA42720Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getEDGEPA42720Document();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(EDGEPA42720Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    protected AnswerContract getAnswer(QuestionnaireQuestionContract questionnaireQuestion, AnswerHeaderContract answerHeader) {
        List<AnswerContract> returnAnswers = this.getAnswers(questionnaireQuestion, answerHeader);
        return !returnAnswers.isEmpty() ? returnAnswers.get(0) : null;
    }

    protected List<AnswerContract> getAnswers(QuestionnaireQuestionContract questionnaireQuestion, AnswerHeaderContract answerHeader) {
        return this.getAnswers(questionnaireQuestion.getId(), answerHeader);
    }

    protected List<AnswerContract> getAnswers(Long questonnaireQuestionId, AnswerHeaderContract answerHeader) {
        ArrayList<AnswerContract> returnAnswers = new ArrayList<AnswerContract>();
        if (answerHeader != null) {
            List answers = answerHeader.getAnswers();
            for (AnswerContract answer : answers) {
                if (!answer.getQuestionnaireQuestionsId().equals(questonnaireQuestionId)) continue;
                returnAnswers.add(answer);
            }
        }
        return returnAnswers;
    }

    @Override
    public DocumentFactory<EDGEPA42720Document> factory() {
        return EDGEPA42720Document.Factory;
    }
}

