/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phsFellowshipSupplemental80V80.DegreeTypeDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental80V80.FieldOfTrainingDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental80V80.NonUSCitizenDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental80V80.PHSFellowshipSupplemental80Document;
import gov.grants.apply.forms.phsFellowshipSupplementalV10.CitizenshipDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398FellowshipSupplementalBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398FellowshipSupplementalV8_0Generator")
public class PHS398FellowshipSupplementalV8_0Generator
extends PHS398FellowshipSupplementalBaseGenerator<PHSFellowshipSupplemental80Document>
implements S2SFormGeneratorPdfFillable<PHSFellowshipSupplemental80Document> {
    private static final Logger LOG = LogManager.getLogger(PHS398FellowshipSupplementalV8_0Generator.class);
    private static final char DATE_SEPARATOR = '/';
    private static final int DEGREE_TYPE_SOUGHT = 99;
    private static final int OTHER_DBOTH = 100;
    private static final String LETTER_COLLAB_CONTRIB_CONSULT = "157";
    private static final String PHS_FELLOW_INSTITUTION_CANDIDATE_CONTRIB = "-7";
    private static final String PHS_FELLOW_AUTH_KEY_BIO_CHEM_RESOURCES = "160";
    private static final int ARE_VERTEBRATE_ANIMALS_EUTHANISED = 146;
    private static final String INTRODUCTION_TO_APPLICATION = "97";
    private static final String PROGRESS_REPORT_PUBLICATION_LIST = "103";
    private static final String RESPONSIBLE_CONDUCT_OF_RESEARCH = "90";
    private static final String CONCURRENT_SUPPORT = "91";
    private static final String VERTEBRATE_ANIMALS = "108";
    private static final String SELECT_AGENT_RESEARCH = "109";
    private static final String RESOURCE_SHARING_PLANS = "110";
    private static final String RESEARCH_OTHER_PLANS = "191";
    private static final int CONSISTENT_AVMA_GUIDELINES = 147;
    private static final int NO_AVMA_METHOD_SCIENTIFIC_JUSTIFICATION = 148;
    private static final int FIELD_OF_TRAINING = 200;
    private static final String FELLOWSHIP_CANDIDATE_AND_GOALS = "200";
    private static final String FELLOWSHIP_RES_TRAINING_PLAN_TRAINING_ACTIVITIES = "201";
    private static final String FELLOWSHIP_RES_TRAINING_PLAN_RESEARCH_PROJECT_AIMS = "202";
    private static final String FELLOWSHIP_RES_TRAINING_PLAN_RESEARCH_PROJECT_STRATEGY = "203";
    private static final String FELLOWSHIP_COMMITMENT_SECTION_SPONSORS_COMMITMENT = "204";
    private static final String TEMPORARY_VISA_ALSO_APPLIED_FOR_PERMANENT_RESIDENT_STATUS = "Temporary Visa also applied for permanent resident status";
    private static final ScaleTwoDecimal POINT_ZERO_ONE = new ScaleTwoDecimal(0.01);
    @Value(value="http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_8_0-V8.0")
    private String namespace;
    @Value(value="PHS_Fellowship_Supplemental_8_0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS_FellowshipSupplemental-V8.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS_Fellowship_Supplemental_8_0-V8.0.pdf")
    private Resource pdfForm;
    @Value(value="211")
    private int sortIndex;

    protected PHSFellowshipSupplemental80Document getPhsFellowshipSupplemental80() {
        PHSFellowshipSupplemental80Document phsFellowshipSupplementalDocument = (PHSFellowshipSupplemental80Document)PHSFellowshipSupplemental80Document.Factory.newInstance();
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80 phsFellowshipSupplemental = phsFellowshipSupplementalDocument.addNewPHSFellowshipSupplemental80();
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan researchTrainingPlan = phsFellowshipSupplemental.addNewResearchTrainingPlan();
        this.setNarrativeDataForResearchTrainingPlan(phsFellowshipSupplemental, researchTrainingPlan);
        this.setOtherResearchTrainingPlanVertebrate(phsFellowshipSupplemental);
        phsFellowshipSupplemental.setFormVersion(FormVersion.v8_0.getVersion());
        AttachmentGroupMin0Max100DataType appendix = this.getAppendix();
        if (appendix != null) {
            phsFellowshipSupplemental.setAppendix(appendix);
        }
        this.setQuestionnaireData(phsFellowshipSupplemental);
        return phsFellowshipSupplementalDocument;
    }

    private void setOtherResearchTrainingPlanVertebrate(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80 phsFellowshipSupplemental) {
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan otherResearchTrainingPlan = phsFellowshipSupplemental.getOtherResearchTrainingPlan();
        if (otherResearchTrainingPlan == null) {
            otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
        }
        List<AnswerHeaderContract> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        for (AnswerHeaderContract answerHeader : answers) {
            QuestionnaireContract questionnaire = this.questionAnswerService.findQuestionnaireById(answerHeader.getQuestionnaireId());
            List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                Integer questionId = question.getQuestionSeqId();
                if (answer == null) continue;
                switch (questionId) {
                    case 146: {
                        otherResearchTrainingPlan.setAreAnimalsEuthanized(this.getYesNoEnum(answer));
                        break;
                    }
                    case 147: {
                        otherResearchTrainingPlan.setAVMAConsistentIndicator(this.getYesNoEnum(answer));
                        break;
                    }
                    case 148: {
                        otherResearchTrainingPlan.setEuthanasiaMethodDescription(answer);
                    }
                }
            }
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            String code = narrative.getNarrativeType().getCode();
            if (code == null) continue;
            if (code.equalsIgnoreCase(VERTEBRATE_ANIMALS)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.VertebrateAnimals)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.VertebrateAnimals.Factory.newInstance();
                vertebrateAnimals.setAttFile(attachedFileDataType);
                if (otherResearchTrainingPlan == null) {
                    otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
                }
                otherResearchTrainingPlan.setVertebrateAnimals(vertebrateAnimals);
                continue;
            }
            if (code.equalsIgnoreCase(SELECT_AGENT_RESEARCH)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.SelectAgentResearch selectAgentResearch = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.SelectAgentResearch)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.SelectAgentResearch.Factory.newInstance();
                selectAgentResearch.setAttFile(attachedFileDataType);
                if (otherResearchTrainingPlan == null) {
                    otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
                }
                otherResearchTrainingPlan.setSelectAgentResearch(selectAgentResearch);
                continue;
            }
            if (code.equalsIgnoreCase(RESOURCE_SHARING_PLANS)) {
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.ResourceSharingPlan)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.ResourceSharingPlan.Factory.newInstance();
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                resourceSharingPlan.setAttFile(attachedFileDataType);
                if (otherResearchTrainingPlan == null) {
                    otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
                }
                otherResearchTrainingPlan.setResourceSharingPlan(resourceSharingPlan);
                continue;
            }
            if (code.equalsIgnoreCase(RESEARCH_OTHER_PLANS)) {
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.OtherPlans otherPlans = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.OtherPlans)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.OtherPlans.Factory.newInstance();
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                otherPlans.setAttFile(attachedFileDataType);
                if (otherResearchTrainingPlan == null) {
                    otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
                }
                otherResearchTrainingPlan.setOtherPlans(otherPlans);
                continue;
            }
            if (!code.equalsIgnoreCase(PHS_FELLOW_AUTH_KEY_BIO_CHEM_RESOURCES)) continue;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources.Factory.newInstance();
            attachedFileDataType = this.addAttachedFileType(narrative);
            if (attachedFileDataType == null) continue;
            keyBiologicalAndOrChemicalResources.setAttFile(attachedFileDataType);
            if (otherResearchTrainingPlan == null) {
                otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
            }
            otherResearchTrainingPlan.setKeyBiologicalAndOrChemicalResources(keyBiologicalAndOrChemicalResources);
        }
    }

    private void setQuestionnaireData(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80 phsFellowshipSupplemental) {
        Object questionId;
        HashMap<Integer, String> hmBudgetQuestions = new HashMap<Integer, String>();
        List<AnswerHeaderContract> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan otherResearchTrainingPlan = phsFellowshipSupplemental.getOtherResearchTrainingPlan();
        if (otherResearchTrainingPlan == null) {
            otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
        }
        this.setHumanSubjectInvolvedAndVertebrateAnimalUsed(otherResearchTrainingPlan);
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation additionalInfoType = phsFellowshipSupplemental.addNewAdditionalInformation();
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.GraduateDegreeSought graduateDegreeSought = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.GraduateDegreeSought)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.GraduateDegreeSought.Factory.newInstance();
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.StemCells stemCellstype = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.StemCells)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.StemCells.Factory.newInstance();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvKirsch = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        for (AnswerHeaderContract answerHeader : answers) {
            QuestionnaireContract questionnaire = this.questionAnswerService.findQuestionnaireById(answerHeader.getQuestionnaireId());
            List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            block40: for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                Integer questionNumber = questionnaireQuestion.getQuestionNumber();
                Integer parentQuestionNumber = questionnaireQuestion.getParentQuestionNumber();
                questionId = question.getQuestionSeqId();
                if (answer != null) {
                    switch ((Integer)questionId) {
                        case 5: {
                            stemCellstype.setIsHumanStemCellsInvolved(this.getYesNoEnum(answer));
                            break;
                        }
                        case 6: {
                            stemCellstype.setStemCellsIndicator(answer.equals(YnqConstant.NO.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                            break;
                        }
                        case 7: {
                            List<AnswerContract> answerList = this.getAnswers(questionnaireQuestion, answerHeader);
                            for (AnswerContract questionnaireAnswerBO : answerList) {
                                String questionnaireSubAnswer = questionnaireAnswerBO.getAnswer();
                                if (questionnaireSubAnswer == null) continue;
                                stemCellstype.addCellLines(questionnaireAnswerBO.getAnswer());
                            }
                            continue block40;
                        }
                        case 99: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.Enum.forString(answer));
                            break;
                        }
                        case 35: {
                            graduateDegreeSought.setDegreeDate(answer.substring(0, 2) + "/" + answer.substring(6, 10));
                            break;
                        }
                        case 16: {
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 18: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.DDOT_OTHER_DOCTOR_OF_MEDICAL_DENTISTRY);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 19: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.VDOT_OTHER_DOCTOR_OF_VETERINARY_MEDICINE);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 21: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.MDOT_OTHER_DOCTOR_OF_MEDICINE);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 100: {
                            if (!((Object)((Object)graduateDegreeSought.getDegreeType())).equals((Object)DegreeTypeDataType.OTH_OTHER)) continue block40;
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 17: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.DOTH_OTHER_DOCTORATE);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 23: 
                        case 200: {
                            if (answer.toUpperCase().equals("SUB CATEGORY NOT FOUND")) continue block40;
                            FieldOfTrainingDataType.Enum fieldOfTraining = FieldOfTrainingDataType.Enum.forString(answer);
                            additionalInfoType.setFieldOfTraining(fieldOfTraining);
                            break;
                        }
                        case 24: {
                            additionalInfoType.setCurrentPriorNRSASupportIndicator(this.getYesNoEnum(answer));
                            break;
                        }
                        case 27: 
                        case 32: 
                        case 33: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: {
                            if ((Integer)questionId == 43) {
                                if (!answer.equals("N")) continue block40;
                                answer = "Unknown";
                                questionId = 44;
                            }
                            if ((Integer)questionId == 49) {
                                if (!answer.equals("N")) continue block40;
                                answer = "Unknown";
                                questionId = 45;
                            }
                            if ((Integer)questionId == 46) {
                                if (!answer.equals("N")) continue block40;
                                answer = "Unknown";
                                questionId = 27;
                            }
                            PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean cbKirschstein = new PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean();
                            cbKirschstein.setAnswer(answer);
                            cbKirschstein.setQuestionId((Integer)questionId);
                            cbKirschstein.setQuestionNumber(questionNumber);
                            cbKirschstein.setParentQuestionNumber(parentQuestionNumber);
                            cvKirsch.add(cbKirschstein);
                            break;
                        }
                        case 28: {
                            additionalInfoType.setChangeOfInstitution(this.getYesNoEnum(answer));
                            break;
                        }
                        case 29: {
                            additionalInfoType.setFormerInstitution(answer);
                            break;
                        }
                        case 36: {
                            hmBudgetQuestions.put(36, answer);
                            break;
                        }
                        case 37: {
                            hmBudgetQuestions.put(37, answer);
                            break;
                        }
                        case 41: {
                            hmBudgetQuestions.put(41, answer);
                            break;
                        }
                        case 38: {
                            hmBudgetQuestions.put(38, answer);
                            break;
                        }
                        case 51: {
                            hmBudgetQuestions.put(51, answer);
                            break;
                        }
                        case 40: {
                            hmBudgetQuestions.put(40, answer);
                            break;
                        }
                        case 50: {
                            hmBudgetQuestions.put(50, answer);
                            break;
                        }
                        case 48: {
                            hmBudgetQuestions.put(48, answer);
                            break;
                        }
                        case 47: {
                            hmBudgetQuestions.put(47, answer);
                            break;
                        }
                    }
                    continue;
                }
                if (answer != null) continue;
                switch ((Integer)questionId) {
                    case 200: {
                        additionalInfoType.setFieldOfTraining(null);
                        break;
                    }
                    case 5: {
                        stemCellstype.setIsHumanStemCellsInvolved(null);
                        break;
                    }
                    case 24: {
                        additionalInfoType.setCurrentPriorNRSASupportIndicator(null);
                        break;
                    }
                }
            }
        }
        if (stemCellstype != null) {
            additionalInfoType.setStemCells(stemCellstype);
        }
        if (graduateDegreeSought.getDegreeType() != null) {
            additionalInfoType.setGraduateDegreeSought(graduateDegreeSought);
        }
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvType = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvStart = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvEnd = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvLevel = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvGrant = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean2 = null;
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean3 = null;
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean4 = null;
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean5 = null;
        if (additionalInfoType.getCurrentPriorNRSASupportIndicator() != null) {
            if (((Object)((Object)additionalInfoType.getCurrentPriorNRSASupportIndicator())).equals((Object)YesNoDataType.Y_YES)) {
                cvKirsch.sort(BY_QUESTION_NUMBER);
                questionId = cvKirsch.iterator();
                while (questionId.hasNext()) {
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean aCvKirsch;
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean = aCvKirsch = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)questionId.next();
                    switch (kbBean.getQuestionId()) {
                        case 32: {
                            cvLevel.add(kbBean);
                            break;
                        }
                        case 33: {
                            cvType.add(kbBean);
                            break;
                        }
                        case 44: {
                            cvStart.add(kbBean);
                            break;
                        }
                        case 45: {
                            cvEnd.add(kbBean);
                            break;
                        }
                        case 27: {
                            cvGrant.add(kbBean);
                        }
                    }
                }
            }
            ArrayList<PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport> currentPriorNRSASupportList = new ArrayList<PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport>();
            int numberRepeats = cvLevel.size();
            if (numberRepeats > 0) {
                for (int j = 0; j < numberRepeats; ++j) {
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean1 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvLevel.get(j);
                    if (cvType.size() - 1 >= j) {
                        kbBean2 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvType.get(j);
                    }
                    if (cvStart.size() - 1 >= j) {
                        kbBean3 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvStart.get(j);
                    }
                    if (cvEnd.size() - 1 >= j) {
                        kbBean4 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvEnd.get(j);
                    }
                    if (cvGrant.size() - 1 >= j) {
                        kbBean5 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvGrant.get(j);
                    }
                    PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport nrsaSupportType = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport.Factory.newInstance();
                    if (kbBean1 != null) {
                        nrsaSupportType.setLevel(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum.forString(kbBean1.getAnswer()));
                    }
                    if (kbBean2 != null) {
                        nrsaSupportType.setType(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum.forString(kbBean2.getAnswer()));
                    }
                    if (kbBean3 != null && !kbBean3.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setStartDate(this.s2SDateTimeService.convertDateStringToCalendar(kbBean3.getAnswer()));
                    }
                    if (kbBean4 != null && !kbBean4.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setEndDate(this.s2SDateTimeService.convertDateStringToCalendar(kbBean4.getAnswer()));
                    }
                    if (kbBean5 != null) {
                        nrsaSupportType.setGrantNumber(kbBean5.getAnswer());
                    }
                    currentPriorNRSASupportList.add(nrsaSupportType);
                }
            }
            additionalInfoType.setCurrentPriorNRSASupportArray(currentPriorNRSASupportList.toArray(new PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.CurrentPriorNRSASupport[0]));
        }
        phsFellowshipSupplemental.setBudget(this.createBudgetElements(hmBudgetQuestions));
        this.setAdditionalInformation(additionalInfoType);
    }

    protected PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget createBudgetElements(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget budget = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.Factory.newInstance();
        budget.setTuitionAndFeesRequested(YesNoDataType.N_NO);
        budget.setChildcareCostsRequested(YesNoDataType.N_NO);
        this.getInstitutionalBaseSalary(budget, budgetMap);
        this.getFederalStipendRequested(budget);
        this.getSupplementationFromOtherSources(budget, budgetMap);
        this.setTuitionRequestedYears(budget);
        this.setChildcareRequestedYears(budget);
        return budget;
    }

    protected void setTuitionRequestedYears(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget budget) {
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget == null) {
            return;
        }
        ScaleTwoDecimal tuitionTotal = ScaleTwoDecimal.ZERO;
        for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
            ScaleTwoDecimal tuition = ScaleTwoDecimal.ZERO;
            for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("TUITION_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                tuition = (ScaleTwoDecimal)tuition.add((AbstractDecimal)budgetLineItem.getLineItemCost());
            }
            tuitionTotal = (ScaleTwoDecimal)tuitionTotal.add((AbstractDecimal)tuition);
            switch (budgetPeriod.getBudgetPeriod()) {
                case 1: {
                    budget.setTuitionRequestedYear1(tuition.bigDecimalValue());
                    break;
                }
                case 2: {
                    budget.setTuitionRequestedYear2(tuition.bigDecimalValue());
                    break;
                }
                case 3: {
                    budget.setTuitionRequestedYear3(tuition.bigDecimalValue());
                    break;
                }
                case 4: {
                    budget.setTuitionRequestedYear4(tuition.bigDecimalValue());
                    break;
                }
                case 5: {
                    budget.setTuitionRequestedYear5(tuition.bigDecimalValue());
                    break;
                }
                case 6: {
                    budget.setTuitionRequestedYear6(tuition.bigDecimalValue());
                    break;
                }
            }
        }
        budget.setTuitionRequestedTotal(tuitionTotal.bigDecimalValue());
        if (!tuitionTotal.equals((Object)ScaleTwoDecimal.ZERO)) {
            budget.setTuitionAndFeesRequested(YesNoDataType.Y_YES);
        }
    }

    protected void setChildcareRequestedYears(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget budget) {
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget == null) {
            return;
        }
        ScaleTwoDecimal childcareTotal = ScaleTwoDecimal.ZERO;
        for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
            ScaleTwoDecimal childcare = ScaleTwoDecimal.ZERO;
            for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("CHILDCARE_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                childcare = (ScaleTwoDecimal)childcare.add((AbstractDecimal)budgetLineItem.getLineItemCost());
            }
            childcareTotal = (ScaleTwoDecimal)childcareTotal.add((AbstractDecimal)childcare);
            switch (budgetPeriod.getBudgetPeriod()) {
                case 1: {
                    budget.setChildcareRequestedYear1(childcare.bigDecimalValue());
                    break;
                }
                case 2: {
                    budget.setChildcareRequestedYear2(childcare.bigDecimalValue());
                    break;
                }
                case 3: {
                    budget.setChildcareRequestedYear3(childcare.bigDecimalValue());
                    break;
                }
                case 4: {
                    budget.setChildcareRequestedYear4(childcare.bigDecimalValue());
                    break;
                }
                case 5: {
                    budget.setChildcareRequestedYear5(childcare.bigDecimalValue());
                    break;
                }
                case 6: {
                    budget.setChildcareRequestedYear6(childcare.bigDecimalValue());
                    break;
                }
            }
        }
        budget.setChildcareRequestedTotal(childcareTotal.bigDecimalValue());
        if (!childcareTotal.equals((Object)ScaleTwoDecimal.ZERO)) {
            budget.setChildcareCostsRequested(YesNoDataType.Y_YES);
        }
    }

    protected void getSupplementationFromOtherSources(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget budget, Map<Integer, String> hmBudgetQuestions) {
        if (!hmBudgetQuestions.isEmpty() && hmBudgetQuestions.get(37) != null && hmBudgetQuestions.get(37).toUpperCase().equals("Y")) {
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.SupplementationFromOtherSources supplementationFromOtherSources = budget.addNewSupplementationFromOtherSources();
            if (hmBudgetQuestions.get(41) != null) {
                supplementationFromOtherSources.setSource(hmBudgetQuestions.get(41));
                supplementationFromOtherSources.setAmount(new BigDecimal(hmBudgetQuestions.get(38)));
                try {
                    supplementationFromOtherSources.setNumberOfMonths(new BigDecimal(hmBudgetQuestions.get(51)));
                }
                catch (NumberFormatException ex) {
                    LOG.error((Object)ex);
                }
                supplementationFromOtherSources.setType(hmBudgetQuestions.get(40));
            }
        }
    }

    protected void getFederalStipendRequested(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget budget) {
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.FederalStipendRequested federalStipendRequested = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.FederalStipendRequested)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.FederalStipendRequested.Factory.newInstance();
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget != null) {
            ScaleTwoDecimal sumOfLineItemCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal numberOfMonths = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!this.getCostElementsByParam("STIPEND_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                    sumOfLineItemCost = (ScaleTwoDecimal)sumOfLineItemCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)budgetLineItem.getBudgetPersonnelDetailsList())) {
                        for (BudgetPersonnelDetailsContract details : budgetLineItem.getBudgetPersonnelDetailsList()) {
                            ScaleTwoDecimal detailsNumberOfMonths = details.getPercentEffort() != null ? (ScaleTwoDecimal)this.getNumberOfMonths(details.getStartDate(), details.getEndDate()).multiply((AbstractDecimal)((ScaleTwoDecimal)details.getPercentEffort().multiply((AbstractDecimal)POINT_ZERO_ONE))) : this.getNumberOfMonths(details.getStartDate(), details.getEndDate());
                            numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)detailsNumberOfMonths);
                        }
                        continue;
                    }
                    numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)this.getNumberOfMonths(budgetLineItem.getStartDate(), budgetLineItem.getEndDate()));
                }
            }
            federalStipendRequested.setAmount(sumOfLineItemCost.bigDecimalValue());
            federalStipendRequested.setNumberOfMonths(numberOfMonths.bigDecimalValue());
            budget.setFederalStipendRequested(federalStipendRequested);
        }
    }

    protected void getInstitutionalBaseSalary(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget budget, Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.InstitutionalBaseSalary institutionalBaseSalary = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.InstitutionalBaseSalary)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.InstitutionalBaseSalary.Factory.newInstance();
        if (budgetMap.get(36) != null && budgetMap.get(36).equals(YnqConstant.YES.code())) {
            if (budgetMap.get(47) != null) {
                institutionalBaseSalary.setAmount(new BigDecimal(budgetMap.get(47)));
            }
            if (budgetMap.get(48) != null) {
                institutionalBaseSalary.setAcademicPeriod(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Budget.InstitutionalBaseSalary.AcademicPeriod.Enum.forString(budgetMap.get(48)));
            }
            if (budgetMap.get(50) != null) {
                institutionalBaseSalary.setNumberOfMonths(new BigDecimal(budgetMap.get(50)));
            }
            budget.setInstitutionalBaseSalary(institutionalBaseSalary);
        }
    }

    protected void setNarrativeDataForResearchTrainingPlan(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80 phsFellowshipSupplemental, PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan researchTrainingPlan) {
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection commitmentSection = phsFellowshipSupplemental.addNewCommitmentSection();
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection candidateSection = phsFellowshipSupplemental.addNewCandidateSection();
        PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Introduction introduction = phsFellowshipSupplemental.addNewIntroduction();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            String code = narrative.getNarrativeType().getCode();
            if (code == null) continue;
            if (code.equalsIgnoreCase(INTRODUCTION_TO_APPLICATION)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Introduction.IntroductionToApplication introductionToApplication = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Introduction.IntroductionToApplication)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Introduction.IntroductionToApplication.Factory.newInstance();
                introductionToApplication.setAttFile(attachedFileDataType);
                introduction.setIntroductionToApplication(introductionToApplication);
                continue;
            }
            if (code.equalsIgnoreCase(FELLOWSHIP_CANDIDATE_AND_GOALS)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection.Goals goals = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection.Goals)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection.Goals.Factory.newInstance();
                goals.setAttFile(attachedFileDataType);
                candidateSection.setGoals(goals);
                continue;
            }
            if (code.equalsIgnoreCase(FELLOWSHIP_RES_TRAINING_PLAN_TRAINING_ACTIVITIES)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingActivities trainingActivities = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingActivities)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingActivities.Factory.newInstance();
                trainingActivities.setAttFile(attachedFileDataType);
                researchTrainingPlan.setTrainingActivities(trainingActivities);
                continue;
            }
            if (code.equalsIgnoreCase(FELLOWSHIP_RES_TRAINING_PLAN_RESEARCH_PROJECT_AIMS)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectAims researchProjectAims = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectAims)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectAims.Factory.newInstance();
                researchProjectAims.setAttFile(attachedFileDataType);
                researchTrainingPlan.setResearchProjectAims(researchProjectAims);
                continue;
            }
            if (code.equalsIgnoreCase(FELLOWSHIP_RES_TRAINING_PLAN_RESEARCH_PROJECT_STRATEGY)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectStrategy researchProjectStrategy = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectStrategy)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectStrategy.Factory.newInstance();
                researchProjectStrategy.setAttFile(attachedFileDataType);
                researchTrainingPlan.setResearchProjectStrategy(researchProjectStrategy);
                continue;
            }
            if (code.equalsIgnoreCase(PROGRESS_REPORT_PUBLICATION_LIST)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ProgressReportPublicationList)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ProgressReportPublicationList.Factory.newInstance();
                progressReportPublicationList.setAttFile(attachedFileDataType);
                researchTrainingPlan.setProgressReportPublicationList(progressReportPublicationList);
                continue;
            }
            if (code.equalsIgnoreCase(RESPONSIBLE_CONDUCT_OF_RESEARCH)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch responsibleConductOfResearch = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch.Factory.newInstance();
                responsibleConductOfResearch.setAttFile(attachedFileDataType);
                researchTrainingPlan.setTrainingInResponsibleConductOfResearch(responsibleConductOfResearch);
                continue;
            }
            if (code.equalsIgnoreCase(FELLOWSHIP_COMMITMENT_SECTION_SPONSORS_COMMITMENT)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.SponsorsCommitment sponsorsCommitment = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.SponsorsCommitment)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.SponsorsCommitment.Factory.newInstance();
                sponsorsCommitment.setAttFile(attachedFileDataType);
                commitmentSection.setSponsorsCommitment(sponsorsCommitment);
                continue;
            }
            if (code.equalsIgnoreCase(LETTER_COLLAB_CONTRIB_CONSULT)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.LettersOfSupport lettersOfSupport = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.LettersOfSupport)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.LettersOfSupport.Factory.newInstance();
                lettersOfSupport.setAttFile(attachedFileDataType);
                commitmentSection.setLettersOfSupport(lettersOfSupport);
                continue;
            }
            if (!code.equalsIgnoreCase(PHS_FELLOW_INSTITUTION_CANDIDATE_CONTRIB) || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.CandidateContribution candidateContribution = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.CandidateContribution)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.CandidateContribution.Factory.newInstance();
            candidateContribution.setAttFile(attachedFileDataType);
            commitmentSection.setCandidateContribution(candidateContribution);
        }
        this.setMandatoryAttachmentsOnResearchTrainingPlan(researchTrainingPlan);
        this.setMandatoryAttachmentsOnCandidateSection(candidateSection);
    }

    private void setMandatoryAttachmentsOnCandidateSection(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection candidateSection) {
        if (candidateSection.getGoals() == null) {
            candidateSection.setGoals((PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection.Goals)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection.Goals.Factory.newInstance());
        }
    }

    private void setMandatoryAttachmentsOnResearchTrainingPlan(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan researchTrainingPlan) {
        if (researchTrainingPlan.getTrainingActivities() == null) {
            researchTrainingPlan.setTrainingActivities((PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingActivities)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingActivities.Factory.newInstance());
        }
        if (researchTrainingPlan.getResearchProjectAims() == null) {
            researchTrainingPlan.setResearchProjectAims((PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectAims)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectAims.Factory.newInstance());
        }
        if (researchTrainingPlan.getResearchProjectStrategy() == null) {
            researchTrainingPlan.setResearchProjectStrategy((PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectStrategy)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectStrategy.Factory.newInstance());
        }
        if (researchTrainingPlan.getTrainingInResponsibleConductOfResearch() == null) {
            researchTrainingPlan.setTrainingInResponsibleConductOfResearch((PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch.Factory.newInstance());
        }
    }

    protected void setHumanSubjectInvolvedAndVertebrateAnimalUsed(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.N_NO);
        for (ProposalSpecialReviewContract propSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (!"2".equals(propSpecialReview.getSpecialReviewType().getCode())) continue;
            researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.Y_YES);
        }
    }

    private void setAdditionalInformation(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation additionalInformation) {
        this.setCitizenshipAndAlternatePhoneNumber(additionalInformation);
        this.setAdditionalInformationConcurrentSupport(additionalInformation);
    }

    private void setCitizenshipAndAlternatePhoneNumber(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation additionalInformation) {
        ProposalPersonContract principalInvestigator = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            CitizenshipType citizenShip;
            if (!proposalPerson.isPrincipalInvestigator() || (citizenShip = this.s2SProposalPersonService.getCitizenship(proposalPerson)) == null || !StringUtils.isNotBlank((CharSequence)citizenShip.getCitizenShip())) continue;
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA.toString())) {
                additionalInformation.setUSCitizen(YesNoDataType.N_NO);
                additionalInformation.setNonUSCitizen(NonUSCitizenDataType.WITH_A_TEMPORARY_U_S_VISA);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S.toString())) {
                additionalInformation.setUSCitizen(YesNoDataType.N_NO);
                additionalInformation.setNonUSCitizen(NonUSCitizenDataType.WITH_A_PERMANENT_U_S_RESIDENT_VISA);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL.toString())) {
                additionalInformation.setUSCitizen(YesNoDataType.Y_YES);
                continue;
            }
            if (!citizenShip.getCitizenShip().trim().equals(TEMPORARY_VISA_ALSO_APPLIED_FOR_PERMANENT_RESIDENT_STATUS)) continue;
            additionalInformation.setUSCitizen(YesNoDataType.N_NO);
            additionalInformation.setNonUSCitizen(NonUSCitizenDataType.WITH_A_TEMPORARY_U_S_VISA);
            additionalInformation.setPermanentResidentByAwardIndicator(YesNoDataType.Y_YES);
        }
        if (additionalInformation.getUSCitizen() == null && additionalInformation.getNonUSCitizen() == null) {
            additionalInformation.setUSCitizen(YesNoDataType.N_NO);
            additionalInformation.setNonUSCitizen(null);
        }
        if (principalInvestigator != null && StringUtils.isNotEmpty((CharSequence)principalInvestigator.getMobilePhoneNumber())) {
            additionalInformation.setAlernatePhoneNumber(principalInvestigator.getMobilePhoneNumber());
        }
    }

    private void setAdditionalInformationConcurrentSupport(PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation additionalInformation) {
        additionalInformation.setConcurrentSupport(YesNoDataType.N_NO);
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            String code = narrative.getNarrativeType().getCode();
            if (code == null || !code.equalsIgnoreCase(CONCURRENT_SUPPORT) || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription = (PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.ConcurrentSupportDescription)PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.ConcurrentSupportDescription.Factory.newInstance();
            concurrentSupportDescription.setAttFile(attachedFileDataType);
            additionalInformation.setConcurrentSupport(YesNoDataType.Y_YES);
            additionalInformation.setConcurrentSupportDescription(concurrentSupportDescription);
        }
    }

    @Override
    public PHSFellowshipSupplemental80Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPhsFellowshipSupplemental80();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHSFellowshipSupplemental80Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation additionalInformation;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection candidateSection;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CandidateSection.Goals goals;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Introduction introduction;
            PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.Introduction.IntroductionToApplication introductionToApplication;
            if (form.getPHSFellowshipSupplemental80().getIntroduction() != null && (introductionToApplication = (introduction = form.getPHSFellowshipSupplemental80().getIntroduction()).getIntroductionToApplication()) != null && introductionToApplication.getAttFile() != null && a.getContentId().equals(introductionToApplication.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.optionalFile0", a);
            }
            if (form.getPHSFellowshipSupplemental80().getCandidateSection() != null && (goals = (candidateSection = form.getPHSFellowshipSupplemental80().getCandidateSection()).getGoals()) != null && goals.getAttFile() != null && a.getContentId().equals(goals.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.mandatoryFile0", a);
            }
            if (form.getPHSFellowshipSupplemental80().getResearchTrainingPlan() != null) {
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan researchTrainingPlan = form.getPHSFellowshipSupplemental80().getResearchTrainingPlan();
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingActivities trainingActivities = researchTrainingPlan.getTrainingActivities();
                if (trainingActivities != null && trainingActivities.getAttFile() != null && a.getContentId().equals(trainingActivities.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.mandatoryFile1", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectAims researchProjectAims = researchTrainingPlan.getResearchProjectAims();
                if (researchProjectAims != null && researchProjectAims.getAttFile() != null && a.getContentId().equals(researchProjectAims.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.mandatoryFile2", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ResearchProjectStrategy researchProjectStrategy = researchTrainingPlan.getResearchProjectStrategy();
                if (researchProjectStrategy != null && researchProjectStrategy.getAttFile() != null && a.getContentId().equals(researchProjectStrategy.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.mandatoryFile3", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = researchTrainingPlan.getProgressReportPublicationList();
                if (progressReportPublicationList != null && progressReportPublicationList.getAttFile() != null && a.getContentId().equals(progressReportPublicationList.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.optionalFile1", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch trainingInResponsibleConductOfResearch = researchTrainingPlan.getTrainingInResponsibleConductOfResearch();
                if (trainingInResponsibleConductOfResearch != null && trainingInResponsibleConductOfResearch.getAttFile() != null && a.getContentId().equals(trainingInResponsibleConductOfResearch.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.mandatoryFile4", a);
                }
            }
            if (form.getPHSFellowshipSupplemental80().getCommitmentSection() != null) {
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection commitmentSection = form.getPHSFellowshipSupplemental80().getCommitmentSection();
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.SponsorsCommitment sponsorsCommitment = commitmentSection.getSponsorsCommitment();
                if (sponsorsCommitment != null && sponsorsCommitment.getAttFile() != null && a.getContentId().equals(sponsorsCommitment.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.optionalFile2", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.LettersOfSupport lettersOfSupport = commitmentSection.getLettersOfSupport();
                if (lettersOfSupport != null && lettersOfSupport.getAttFile() != null && a.getContentId().equals(lettersOfSupport.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.optionalFile3", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.CommitmentSection.CandidateContribution candidateContribution = commitmentSection.getCandidateContribution();
                if (candidateContribution != null && candidateContribution.getAttFile() != null && a.getContentId().equals(candidateContribution.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.optionalFile4", a);
                }
            }
            if (form.getPHSFellowshipSupplemental80().getOtherResearchTrainingPlan() != null) {
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan otherResearchTrainingPlan = form.getPHSFellowshipSupplemental80().getOtherResearchTrainingPlan();
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = otherResearchTrainingPlan.getVertebrateAnimals();
                if (vertebrateAnimals != null && vertebrateAnimals.getAttFile() != null && a.getContentId().equals(vertebrateAnimals.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P1.optionalFile5", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.SelectAgentResearch selectAgentResearch = otherResearchTrainingPlan.getSelectAgentResearch();
                if (selectAgentResearch != null && selectAgentResearch.getAttFile() != null && a.getContentId().equals(selectAgentResearch.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P2.optionalFile0", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = otherResearchTrainingPlan.getResourceSharingPlan();
                if (resourceSharingPlan != null && resourceSharingPlan.getAttFile() != null && a.getContentId().equals(resourceSharingPlan.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P2.optionalFile1", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.OtherPlans otherPlans = otherResearchTrainingPlan.getOtherPlans();
                if (otherPlans != null && otherPlans.getAttFile() != null && a.getContentId().equals(otherPlans.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P2.optionalFile2", a);
                }
                PHSFellowshipSupplemental80Document.PHSFellowshipSupplemental80.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = otherResearchTrainingPlan.getKeyBiologicalAndOrChemicalResources();
                if (keyBiologicalAndOrChemicalResources != null && keyBiologicalAndOrChemicalResources.getAttFile() != null && a.getContentId().equals(keyBiologicalAndOrChemicalResources.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P2.optionalFile3", a);
                }
            }
            if (form.getPHSFellowshipSupplemental80().getAdditionalInformation() != null && (concurrentSupportDescription = (additionalInformation = form.getPHSFellowshipSupplemental80().getAdditionalInformation()).getConcurrentSupportDescription()) != null && concurrentSupportDescription.getAttFile() != null && a.getContentId().equals(concurrentSupportDescription.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P2.optionalFile4", a);
            }
            if (form.getPHSFellowshipSupplemental80().getAppendix() != null && form.getPHSFellowshipSupplemental80().getAppendix().getAttachedFileList() != null) {
                List<AttachedFileDataType> atts = form.getPHSFellowshipSupplemental80().getAppendix().getAttachedFileList();
                for (int i = 0; i < atts.size(); ++i) {
                    AttachedFileDataType att = atts.get(i);
                    if (att == null || !a.getContentId().equals(att.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_8_0_P2.optionalFile_5" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHSFellowshipSupplemental80Document> factory() {
        return PHSFellowshipSupplemental80Document.Factory;
    }
}

