/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.performanceSite13V13.PerformanceSite13Document;
import gov.grants.apply.forms.performanceSite13V13.SiteLocationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationYnqContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.CongressionalDistrictContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PerformanceSiteBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PerformanceSiteV1_3Generator")
public class PerformanceSiteV1_3Generator
extends PerformanceSiteBaseGenerator<PerformanceSite13Document> {
    private static final String QUESTION_ID_FOR_INDIVIDUAL_YNQ = "30";
    private static final int PERFORMING_ORG_LOCATION_TYPE_CODE = 2;
    private static final int OTHER_ORG_LOCATION_TYPE_CODE = 3;
    private static final int PERFORMANCE_SITE_LOCATION_TYPE_CODE = 4;
    @Value(value="http://apply.grants.gov/forms/PerformanceSite_1_3-V1.3")
    private String namespace;
    @Value(value="PerformanceSite_1_3")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PerformanceSite-V1.3.xsl")
    private List<Resource> stylesheets;
    @Value(value="130")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private PerformanceSite13Document getPerformanceSite() {
        PerformanceSite13Document performanceSite13Document = (PerformanceSite13Document)PerformanceSite13Document.Factory.newInstance();
        PerformanceSite13Document.PerformanceSite13 performanceSite13 = (PerformanceSite13Document.PerformanceSite13)PerformanceSite13Document.PerformanceSite13.Factory.newInstance();
        performanceSite13.setFormVersion(FormVersion.v1_3.getVersion());
        this.setOtherSites(performanceSite13);
        AttachedFileDataType attachedFile = this.getAttachment();
        if (attachedFile != null) {
            performanceSite13.setAttachedFile(attachedFile);
        }
        performanceSite13Document.setPerformanceSite13(performanceSite13);
        return performanceSite13Document;
    }

    private void setSiteLocationDataType(SiteLocationDataType siteLocationDataType, OrganizationContract organization) {
        if (organization.getOrganizationYnqs() != null && !organization.getOrganizationYnqs().isEmpty()) {
            for (OrganizationYnqContract organizationYnq : organization.getOrganizationYnqs()) {
                if (!organizationYnq.getQuestionId().equals(QUESTION_ID_FOR_INDIVIDUAL_YNQ)) continue;
                YesNoDataType.Enum answer = organizationYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                siteLocationDataType.setIndividual(answer);
            }
        }
    }

    private void setOtherSites(PerformanceSite13Document.PerformanceSite13 performanceSite) {
        List proposalSites = this.pdDoc.getDevelopmentProposal().getProposalSites();
        if (proposalSites != null) {
            OrganizationContract organization = null;
            SiteLocationDataType siteLocationDataType = null;
            for (ProposalSiteContract proposalSite : proposalSites) {
                String congressionalDistrict;
                organization = proposalSite.getOrganization();
                switch (proposalSite.getLocationTypeCode()) {
                    case 2: {
                        siteLocationDataType = performanceSite.addNewPrimarySite();
                        this.setSiteLocationDataType(siteLocationDataType, organization);
                        siteLocationDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
                        break;
                    }
                    case 3: 
                    case 4: {
                        siteLocationDataType = performanceSite.addNewOtherSite();
                        siteLocationDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
                    }
                }
                if (siteLocationDataType == null) continue;
                siteLocationDataType.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
                if (organization != null && organization.getDunsNumber() != null) {
                    siteLocationDataType.setDUNSNumber(organization.getDunsNumber());
                }
                if ((congressionalDistrict = this.getCongressionalDistrict(proposalSite)) == null) continue;
                siteLocationDataType.setCongressionalDistrictProgramProject(congressionalDistrict);
            }
        }
    }

    private String getCongressionalDistrict(ProposalSiteContract proposalSite) {
        String congDistrictProject = null;
        for (CongressionalDistrictContract congDistrict : proposalSite.getCongressionalDistricts()) {
            congDistrictProject = congDistrict.getCongressionalDistrict();
            if (congDistrictProject == null || congDistrictProject.length() <= 6) continue;
            congDistrictProject = congDistrictProject.substring(0, 6);
        }
        return congDistrictProject;
    }

    protected AttachedFileDataType getAttachment() {
        return this.getAttachedFileDataType("40");
    }

    @Override
    public PerformanceSite13Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPerformanceSite();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PerformanceSite13Document> factory() {
        return PerformanceSite13Document.Factory;
    }
}

