/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrFedNonFedBudgetV11.RRFedNonFedBudgetDocument;
import gov.grants.apply.forms.rrFedNonFedSubawardBudgetV12.RRFedNonFedSubawardBudgetDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="RRFedNonFedSubAwardBudgetV1_2Generator")
public class RRFedNonFedSubAwardBudgetV1_2Generator
extends S2SAdobeFormAttachmentBaseGenerator<RRFedNonFedSubawardBudgetDocument>
implements S2SFormGeneratorPdfFillable<RRFedNonFedSubawardBudgetDocument> {
    @Value(value="http://apply.grants.gov/forms/RR_FedNonFed_SubawardBudget-V1.2")
    private String namespace;
    @Value(value="RR_FedNonFed_SubawardBudget-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_FedNonFedSubawardBudget-V1.2.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_FedNonFed_SubawardBudget-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="172")
    private int sortIndex;
    private static final String RR_FED_NON_FED_BUDGET_11_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_FedNonFedBudget-V1.1";
    private static final String LOCAL_FED_NON_FED_NAME = "RR_FedNonFedBudget";

    private RRFedNonFedSubawardBudgetDocument getRRFedNonFedSubawardBudgetDocument() {
        RRFedNonFedSubawardBudgetDocument rrSubawardBudgetDocument = (RRFedNonFedSubawardBudgetDocument)RRFedNonFedSubawardBudgetDocument.Factory.newInstance();
        RRFedNonFedSubawardBudgetDocument.RRFedNonFedSubawardBudget rrSubawardBudget = (RRFedNonFedSubawardBudgetDocument.RRFedNonFedSubawardBudget)RRFedNonFedSubawardBudgetDocument.RRFedNonFedSubawardBudget.Factory.newInstance();
        RRFedNonFedSubawardBudgetDocument.RRFedNonFedSubawardBudget.BudgetAttachments budgetAttachments = (RRFedNonFedSubawardBudgetDocument.RRFedNonFedSubawardBudget.BudgetAttachments)RRFedNonFedSubawardBudgetDocument.RRFedNonFedSubawardBudget.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, RR_FED_NON_FED_BUDGET_11_NAMESPACE_URI, false);
        RRFedNonFedBudgetDocument.RRFedNonFedBudget[] budgetList = new RRFedNonFedBudgetDocument.RRFedNonFedBudget[budgetSubAwardsList.size()];
        rrSubawardBudget.setFormVersion(FormVersion.v1_2.getVersion());
        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRFedNonFedBudgetDocument.RRFedNonFedBudget rrBudget = this.getRRFedNonFedBudget(budgetSubAwards).getRRFedNonFedBudget();
            switch (attCount) {
                case 1: {
                    rrSubawardBudget.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList[0] = rrBudget;
                    break;
                }
                case 2: {
                    rrSubawardBudget.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList[1] = rrBudget;
                    break;
                }
                case 3: {
                    rrSubawardBudget.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList[2] = rrBudget;
                    break;
                }
                case 4: {
                    rrSubawardBudget.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList[3] = rrBudget;
                    break;
                }
                case 5: {
                    rrSubawardBudget.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList[4] = rrBudget;
                    break;
                }
                case 6: {
                    rrSubawardBudget.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList[5] = rrBudget;
                    break;
                }
                case 7: {
                    rrSubawardBudget.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList[6] = rrBudget;
                    break;
                }
                case 8: {
                    rrSubawardBudget.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList[7] = rrBudget;
                    break;
                }
                case 9: {
                    rrSubawardBudget.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList[8] = rrBudget;
                    break;
                }
                case 10: {
                    rrSubawardBudget.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList[9] = rrBudget;
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attCount;
        }
        budgetAttachments.setRRFedNonFedBudgetArray(budgetList);
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRFedNonFedSubawardBudget(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRFedNonFedBudgetDocument getRRFedNonFedBudget(BudgetSubAwardsContract budgetSubAwards) {
        Document subAwdFormsDoc;
        RRFedNonFedBudgetDocument rrBudget = (RRFedNonFedBudgetDocument)RRFedNonFedBudgetDocument.Factory.newInstance();
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        try {
            subAwdFormsDoc = this.stringToDom(subAwdXML);
        }
        catch (S2SException e1) {
            return rrBudget;
        }
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_FED_NON_FED_BUDGET_11_NAMESPACE_URI, LOCAL_FED_NON_FED_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        try {
            byte[] subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
            ByteArrayInputStream bgtIS = new ByteArrayInputStream(subAwdNodeBytes);
            rrBudget = (RRFedNonFedBudgetDocument)RRFedNonFedBudgetDocument.Factory.parse((InputStream)bgtIS);
        }
        catch (IOException | XmlException | S2SException e) {
            return rrBudget;
        }
        return rrBudget;
    }

    @Override
    public RRFedNonFedSubawardBudgetDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRFedNonFedSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRFedNonFedSubawardBudgetDocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRFedNonFedSubawardBudgetDocument> factory() {
        return RRFedNonFedSubawardBudgetDocument.Factory;
    }
}

