/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrKeyPerson30V30.PersonProfileDataType;
import gov.grants.apply.forms.rrKeyPerson30V30.ProjectRoleDataType;
import gov.grants.apply.forms.rrKeyPerson30V30.RRKeyPerson30Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.ProposalPersonComparator;
import org.kuali.coeus.s2sgen.impl.generate.support.RRKeyPersonBase;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRKeyPersonV3_0Generator")
public class RRKeyPersonV3_0Generator
extends RRKeyPersonBase<RRKeyPerson30Document>
implements S2SFormGeneratorPdfFillable<RRKeyPerson30Document> {
    private static final int DEPARTMENT_DIVISION_CHARACTER_LIMIT = 100;
    RolodexContract rolodex;
    @Value(value="http://apply.grants.gov/forms/RR_KeyPerson_3_0-V3.0")
    private String namespace;
    @Value(value="RR_KeyPerson_3_0-V3.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_KeyPerson_3_0-V3.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_KeyPerson_3_0-V3.0.pdf")
    private Resource pdfForm;
    @Value(value="150")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private RRKeyPerson30Document getRRKeyPerson() {
        RRKeyPerson30Document rrKeyPersonDocument = (RRKeyPerson30Document)RRKeyPerson30Document.Factory.newInstance();
        RRKeyPerson30Document.RRKeyPerson30 rrKeyPerson = (RRKeyPerson30Document.RRKeyPerson30)RRKeyPerson30Document.RRKeyPerson30.Factory.newInstance();
        rrKeyPerson.setFormVersion(FormVersion.v3_0.getVersion());
        rrKeyPerson.setPDPI(this.getPersonProfilePI());
        rrKeyPerson.setKeyPersonArray(this.getPersonProfileKeyPerson());
        this.saveKeyPersonAttachmentsToProposal();
        if (this.extraPersons.size() > 0) {
            RRKeyPerson30Document.RRKeyPerson30.BioSketchsAttached bioSketchAttached = (RRKeyPerson30Document.RRKeyPerson30.BioSketchsAttached)RRKeyPerson30Document.RRKeyPerson30.BioSketchsAttached.Factory.newInstance();
            List narratives = this.pdDoc.getDevelopmentProposal().getNarratives();
            narratives.addAll(this.getAddedNarratives());
            for (NarrativeContract narrative : narratives) {
                if (narrative.getNarrativeType().getCode() == null) continue;
                switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                    case 16: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        bioSketchAttached.setBioSketchAttached(attachedFileDataType);
                        break;
                    }
                    case 17: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        RRKeyPerson30Document.RRKeyPerson30.SupportsAttached supportsAttached = (RRKeyPerson30Document.RRKeyPerson30.SupportsAttached)RRKeyPerson30Document.RRKeyPerson30.SupportsAttached.Factory.newInstance();
                        supportsAttached.setSupportAttached(attachedFileDataType);
                        rrKeyPerson.setSupportsAttached(supportsAttached);
                        break;
                    }
                    case 18: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        RRKeyPerson30Document.RRKeyPerson30.AdditionalProfilesAttached additionalProfilesAttached = (RRKeyPerson30Document.RRKeyPerson30.AdditionalProfilesAttached)RRKeyPerson30Document.RRKeyPerson30.AdditionalProfilesAttached.Factory.newInstance();
                        additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
                        rrKeyPerson.setAdditionalProfilesAttached(additionalProfilesAttached);
                    }
                }
            }
            rrKeyPerson.setBioSketchsAttached(bioSketchAttached);
        }
        rrKeyPersonDocument.setRRKeyPerson30(rrKeyPerson);
        return rrKeyPersonDocument;
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType personProfileDataType = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
        PersonProfileDataType.Profile profile = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            if (PI.getPersonId() != null) {
                this.pIPersonOrRolodexId = PI.getPersonId();
                this.rolodex = null;
            } else if (PI.getRolodexId() != null) {
                this.pIPersonOrRolodexId = PI.getRolodexId().toString();
                this.rolodex = this.rolodexService.getRolodex(Integer.valueOf(this.pIPersonOrRolodexId));
            }
            profile.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            if (PI.getDirectoryTitle() != null) {
                if (PI.getDirectoryTitle().length() > 45) {
                    profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
                } else {
                    profile.setTitle(PI.getDirectoryTitle());
                }
            }
            profile.setAddress(this.globLibV20Generator.getAddressDataTypeV3((Addressable)PI));
            profile.setPhone(PI.getOfficePhone());
            if (StringUtils.isNotEmpty((CharSequence)PI.getFaxNumber())) {
                profile.setFax(PI.getFaxNumber());
            }
            profile.setEmail(PI.getEmailAddress());
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                profile.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
            }
            this.setDepartmentNameToProfile(profile, PI);
            this.setDivisionNameToProfile(profile, PI);
            if (PI.getEraCommonsUserName() != null) {
                profile.setCredential(PI.getEraCommonsUserName());
            } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + PI.getFullName(), "grantsGov.Opportunity", new String[0]));
            }
            profile.setProjectRole(ProjectRoleDataType.PD_PI);
            PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = (PersonProfileDataType.Profile.BioSketchsAttached)PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
            AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "1");
            personBioSketch.setBioSketchAttached(bioSketchAttachment);
            profile.setBioSketchsAttached(personBioSketch);
            AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "2");
            if (supportAttachment != null) {
                PersonProfileDataType.Profile.SupportsAttached supportsAttached = (PersonProfileDataType.Profile.SupportsAttached)PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                supportsAttached.setSupportAttached(supportAttachment);
                profile.setSupportsAttached(supportsAttached);
            }
            personProfileDataType.setProfile(profile);
        }
        return personProfileDataType;
    }

    private void setDepartmentNameToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract keyPerson) {
        if (keyPerson.getHomeUnit() != null && keyPerson.getPerson() != null && keyPerson.getPerson().getUnit() != null) {
            String departmentName = keyPerson.getPerson().getUnit().getUnitName();
            profile.setDepartment(StringUtils.substring((String)departmentName, (int)0, (int)100));
        } else if (keyPerson.getRolodexId() != null && keyPerson.getDirectoryDepartment() != null) {
            profile.setDepartment(StringUtils.substring((String)keyPerson.getDirectoryDepartment(), (int)0, (int)100));
        } else {
            DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
            profile.setDepartment(StringUtils.substring((String)developmentProposal.getOwnedByUnit().getUnitName(), (int)0, (int)100));
        }
    }

    private void setDivisionNameToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract keyPerson) {
        String divisionName = this.getS2sDivisionService().getDivision(keyPerson);
        if (divisionName != null) {
            profile.setDivision(divisionName);
        }
    }

    private PersonProfileDataType[] getPersonProfileKeyPerson() {
        ArrayList<PersonProfileDataType> personProfileDataTypeList = new ArrayList<PersonProfileDataType>();
        List keyPersons = this.pdDoc.getDevelopmentProposal().getProposalPersons();
        keyPersons.sort(new ProposalPersonComparator());
        List<ProposalPersonContract> nKeyPersons = this.s2SProposalPersonService.getNKeyPersons(keyPersons, 8);
        this.extraPersons = keyPersons.stream().filter(kp -> !nKeyPersons.contains(kp)).collect(Collectors.toList());
        if (nKeyPersons.size() > 0) {
            for (ProposalPersonContract keyPerson : nKeyPersons) {
                if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
                if (keyPerson.getPersonId() != null) {
                    this.pIPersonOrRolodexId = keyPerson.getPersonId();
                    this.rolodex = null;
                } else if (keyPerson.getRolodexId() != null) {
                    this.pIPersonOrRolodexId = keyPerson.getRolodexId().toString();
                    this.rolodex = this.rolodexService.getRolodex(Integer.valueOf(this.pIPersonOrRolodexId));
                }
                PersonProfileDataType.Profile profileKeyPerson = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
                profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                if (keyPerson.getDirectoryTitle() != null) {
                    profileKeyPerson.setTitle(keyPerson.getDirectoryTitle());
                }
                profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataTypeV3((Addressable)keyPerson));
                profileKeyPerson.setPhone(keyPerson.getOfficePhone());
                if (StringUtils.isNotEmpty((CharSequence)keyPerson.getFaxNumber())) {
                    profileKeyPerson.setFax(keyPerson.getFaxNumber());
                }
                profileKeyPerson.setEmail(keyPerson.getEmailAddress());
                if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                    profileKeyPerson.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
                }
                this.setDepartmentNameToProfile(profileKeyPerson, keyPerson);
                this.setDivisionNameToProfile(profileKeyPerson, keyPerson);
                if (keyPerson.getEraCommonsUserName() != null) {
                    profileKeyPerson.setCredential(keyPerson.getEraCommonsUserName());
                } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode()) && keyPerson.isMultiplePi()) {
                    this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + keyPerson.getFullName(), "grantsGov.Opportunity", new String[0]));
                }
                if (keyPerson.isMultiplePi() || keyPerson.isCoInvestigator()) {
                    if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                        if (keyPerson.isMultiplePi()) {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                        } else {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                        }
                    } else {
                        profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                    }
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
                    PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = (PersonProfileDataType.Profile.OtherProjectRoleCategory)PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
                    String otherRole = keyPerson.getProjectRole() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
                    otherProjectRole.setStringValue(otherRole);
                    profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
                }
                PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = (PersonProfileDataType.Profile.BioSketchsAttached)PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
                AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "1");
                personBioSketch.setBioSketchAttached(bioSketchAttachment);
                profileKeyPerson.setBioSketchsAttached(personBioSketch);
                AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "2");
                if (supportAttachment != null) {
                    PersonProfileDataType.Profile.SupportsAttached supportsAttached = (PersonProfileDataType.Profile.SupportsAttached)PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                    supportsAttached.setSupportAttached(supportAttachment);
                    profileKeyPerson.setSupportsAttached(supportsAttached);
                }
                PersonProfileDataType personProfileDataTypeKeyperson = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
                personProfileDataTypeKeyperson.setProfile(profileKeyPerson);
                personProfileDataTypeList.add(personProfileDataTypeKeyperson);
            }
        }
        return personProfileDataTypeList.toArray(new PersonProfileDataType[0]);
    }

    @Override
    public RRKeyPerson30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRKeyPerson();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRKeyPerson30Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            List<PersonProfileDataType> keyPersons;
            RRKeyPerson30Document.RRKeyPerson30.AdditionalProfilesAttached additionalProfilesAttached = form.getRRKeyPerson30().getAdditionalProfilesAttached();
            if (additionalProfilesAttached != null && additionalProfilesAttached.getAdditionalProfileAttached() != null && a.getContentId().equals(additionalProfilesAttached.getAdditionalProfileAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_KeyPerson_3_0_P1.footer.optionalFile4", a);
            }
            RRKeyPerson30Document.RRKeyPerson30.BioSketchsAttached bioSketchsAttached = form.getRRKeyPerson30().getBioSketchsAttached();
            if (bioSketchsAttached != null && bioSketchsAttached.getBioSketchAttached() != null && a.getContentId().equals(bioSketchsAttached.getBioSketchAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_KeyPerson_3_0_P1.footer.optionalFile5", a);
            }
            RRKeyPerson30Document.RRKeyPerson30.SupportsAttached supportsAttached = form.getRRKeyPerson30().getSupportsAttached();
            if (supportsAttached != null && supportsAttached.getSupportAttached() != null && a.getContentId().equals(supportsAttached.getSupportAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_KeyPerson_3_0_P1.footer.optionalFile6", a);
            }
            PersonProfileDataType pdpi = form.getRRKeyPerson30().getPDPI();
            if (pdpi != null && pdpi.getProfile() != null) {
                PersonProfileDataType.Profile.BioSketchsAttached pdpiBioSketchsAttached = pdpi.getProfile().getBioSketchsAttached();
                if (pdpiBioSketchsAttached != null && pdpiBioSketchsAttached.getBioSketchAttached() != null && a.getContentId().equals(pdpiBioSketchsAttached.getBioSketchAttached().getFileLocation().getHref())) {
                    return CollectionUtils.entry("RR_KeyPerson_3_0_P1.PDPI.mandatoryFile0", a);
                }
                PersonProfileDataType.Profile.SupportsAttached pdpiSupportsAttached = pdpi.getProfile().getSupportsAttached();
                if (pdpiSupportsAttached != null && pdpiSupportsAttached.getSupportAttached() != null && a.getContentId().equals(pdpiSupportsAttached.getSupportAttached().getFileLocation().getHref())) {
                    return CollectionUtils.entry("RR_KeyPerson_3_0_P1.PDPI.optionalFile0", a);
                }
            }
            if ((keyPersons = form.getRRKeyPerson30().getKeyPersonList()) != null) {
                for (int i = 0; i < keyPersons.size(); ++i) {
                    PersonProfileDataType keyPerson = keyPersons.get(i);
                    if (keyPerson == null || keyPerson.getProfile() == null) continue;
                    PersonProfileDataType.Profile.BioSketchsAttached keyPersonBioSketchsAttached = keyPerson.getProfile().getBioSketchsAttached();
                    if (keyPersonBioSketchsAttached != null && keyPersonBioSketchsAttached.getBioSketchAttached() != null && a.getContentId().equals(keyPersonBioSketchsAttached.getBioSketchAttached().getFileLocation().getHref())) {
                        return CollectionUtils.entry("RR_KeyPerson_3_0_P1.KeyPerson.mandatoryFile" + i, a);
                    }
                    PersonProfileDataType.Profile.SupportsAttached keyPersonSupportsAttached = keyPerson.getProfile().getSupportsAttached();
                    if (keyPersonSupportsAttached == null || keyPersonSupportsAttached.getSupportAttached() == null || !a.getContentId().equals(keyPersonSupportsAttached.getSupportAttached().getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("RR_KeyPerson_3_0_P1.KeyPerson.optionalFile" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RRKeyPerson30Document> factory() {
        return RRKeyPerson30Document.Factory;
    }
}

