/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sf424AV10.BudgetCategoriesDocument;
import gov.grants.apply.forms.sf424AV10.BudgetFirstQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetFirstYearAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetForecastedCashNeedsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetFourthQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetInformationDocument;
import gov.grants.apply.forms.sf424AV10.BudgetInformationType;
import gov.grants.apply.forms.sf424AV10.BudgetSecondQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.BudgetSummaryDocument;
import gov.grants.apply.forms.sf424AV10.BudgetThirdQuarterAmountsDocument;
import gov.grants.apply.forms.sf424AV10.CategorySetDocument;
import gov.grants.apply.forms.sf424AV10.CategoryTotalsDocument;
import gov.grants.apply.forms.sf424AV10.FederalFundsNeededDocument;
import gov.grants.apply.forms.sf424AV10.FundsLineItemDocument;
import gov.grants.apply.forms.sf424AV10.FundsTotalsDocument;
import gov.grants.apply.forms.sf424AV10.NonFederalResourcesDocument;
import gov.grants.apply.forms.sf424AV10.OtherInformationDocument;
import gov.grants.apply.forms.sf424AV10.ResourceLineItemDocument;
import gov.grants.apply.forms.sf424AV10.ResourceTotalsDocument;
import gov.grants.apply.forms.sf424AV10.SummaryLineItemDocument;
import gov.grants.apply.forms.sf424AV10.SummaryTotalsDocument;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMappingContract;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetRateAndBaseContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.BudgetPeriodNum;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetCategoryMapService;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.SF424BaseGenerator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.Cfda;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SF424AV1_0Generator")
public class SF424AV1_0Generator
extends SF424BaseGenerator<BudgetInformationDocument>
implements S2SFormGeneratorPdfFillable<BudgetInformationDocument> {
    private static final int MAX_LENGTH = 50;
    private static final String RATE_TYPE = "Type=";
    private static final String IDC_BASE = " Base=";
    private static final String IDC_EXP = " IDCExp=";
    private static final String ELLIPSES = "...";
    private static final int MIN_DISPLAY_CHARS = 4;
    private BudgetContract budget = null;
    @Value(value="http://apply.grants.gov/forms/SF424A-V1.0")
    private String namespace;
    @Value(value="SF424A-V1.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SF424A-V1.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/SF424A-V1.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SBudgetCategoryMapService")
    protected S2SBudgetCategoryMapService s2SBudgetCategoryMapService;
    @Autowired
    @Qualifier(value="s2SBudgetInfoService")
    protected S2SBudgetInfoService s2sBudgetInfoService;

    private BudgetInformationDocument getSF424A() {
        BudgetInformationDocument budgetInformationDocument = (BudgetInformationDocument)BudgetInformationDocument.Factory.newInstance();
        this.budget = this.getS2SCommonBudgetService().getBudget(this.pdDoc.getDevelopmentProposal());
        BudgetInformationType SF424A = (BudgetInformationType)BudgetInformationType.Factory.newInstance();
        SF424A.setCoreSchemaVersion("1.0");
        SF424A.setFormVersionIdentifier(FormVersion.v1_0.getVersion());
        SF424A.setProgramType("Non-Construction");
        if (this.budget != null) {
            BudgetSummaryDocument.BudgetSummary budgetSummary = this.getBudgetSummary();
            BudgetCategoriesDocument.BudgetCategories budgetCategories = this.getBudgetCategories();
            NonFederalResourcesDocument.NonFederalResources nonFederalResources = this.getNonFederalResources();
            BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds budgetForecastedCashNeeds = this.getBudgetForecastedCashNeeds();
            FederalFundsNeededDocument.FederalFundsNeeded federalFundsNeeded = this.getFederalFundsNeeded();
            SF424A.setBudgetSummary(budgetSummary);
            SF424A.setBudgetCategories(budgetCategories);
            SF424A.setNonFederalResources(nonFederalResources);
            SF424A.setBudgetForecastedCashNeeds(budgetForecastedCashNeeds);
            SF424A.setFederalFundsNeeded(federalFundsNeeded);
            SF424A.setOtherInformation(this.getOtherInformation());
        }
        budgetInformationDocument.setBudgetInformation(SF424A);
        return budgetInformationDocument;
    }

    protected OtherInformationDocument.OtherInformation getOtherInformation() {
        OtherInformationDocument.OtherInformation otherInformation = (OtherInformationDocument.OtherInformation)OtherInformationDocument.OtherInformation.Factory.newInstance();
        otherInformation.setOtherIndirectChargesExplanation(this.getFormattedIndirectChargeExplanation());
        return otherInformation;
    }

    private String getFormattedIndirectChargeExplanation() {
        ScaleTwoDecimal indirectCostBase = this.getIndirectBaseCost();
        int totalLength = RATE_TYPE.length() + this.budget.getRateClass().getDescription().length() + IDC_BASE.length() + indirectCostBase.toString().length() + IDC_EXP.length() + this.budget.getTotalIndirectCost().toString().length();
        Object rateClass = this.budget.getRateClass().getDescription();
        if (totalLength > 50) {
            int overflowLength;
            int rateClassLength = this.budget.getRateClass().getDescription().length();
            int availableLength = rateClassLength - (overflowLength = totalLength - 50);
            rateClass = availableLength <= 0 ? "" : (availableLength <= 4 + ELLIPSES.length() ? this.budget.getRateClass().getDescription().substring(0, availableLength) : this.budget.getRateClass().getDescription().substring(0, availableLength - ELLIPSES.length()) + ELLIPSES);
        }
        Object rateSection = ((String)rateClass).isBlank() ? "" : RATE_TYPE + (String)rateClass;
        String explanation = (String)rateSection + IDC_BASE + String.valueOf(indirectCostBase) + IDC_EXP + String.valueOf(this.budget.getTotalIndirectCost());
        return explanation.length() > 50 ? explanation.substring(0, 50) : explanation;
    }

    protected ScaleTwoDecimal getIndirectBaseCost() {
        ScaleTwoDecimal indirectCostBase = ScaleTwoDecimal.ZERO;
        for (BudgetPeriodContract period : this.budget.getBudgetPeriods()) {
            for (BudgetLineItemContract lineItem : period.getBudgetLineItems()) {
                for (BudgetRateAndBaseContract rateAndBase : lineItem.getBudgetRateAndBaseList()) {
                    if (!rateAndBase.getRateClass().getRateClassType().getCode().equalsIgnoreCase(RateClassType.OVERHEAD.getRateClassType())) continue;
                    indirectCostBase = (ScaleTwoDecimal)indirectCostBase.add((AbstractDecimal)rateAndBase.getBaseCost());
                }
            }
        }
        return indirectCostBase;
    }

    private BudgetCategoriesDocument.BudgetCategories getBudgetCategories() {
        ScaleTwoDecimal constructionCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal contractualCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal equipmentCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal personnelCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal suppliesCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal otherCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal travelCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal programIncome = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal laSalaries = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal labAllocation = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal constructionCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal contractualCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal equipmentCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal personnelCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal suppliesCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal otherCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal travelCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCostCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal laSalariesCostShare = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal labAllocationCostShare = ScaleTwoDecimal.ZERO;
        BudgetCategoriesDocument.BudgetCategories budgetCategories = (BudgetCategoriesDocument.BudgetCategories)BudgetCategoriesDocument.BudgetCategories.Factory.newInstance();
        CategoryTotalsDocument.CategoryTotals categoryTotals = (CategoryTotalsDocument.CategoryTotals)CategoryTotalsDocument.CategoryTotals.Factory.newInstance();
        if (this.budget == null) {
            return budgetCategories;
        }
        boolean separateFedNonFed = this.getS2SConfigurationService().getValuesFromCommaSeparatedParam("s2sBudgetSF424A_SectionB_Separate_Fed_NonFed_Sponsors").contains(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode());
        CategorySetDocument.CategorySet[] categorySetArray = separateFedNonFed ? new CategorySetDocument.CategorySet[2] : new CategorySetDocument.CategorySet[1];
        CategorySetDocument.CategorySet categorySet = (CategorySetDocument.CategorySet)CategorySetDocument.CategorySet.Factory.newInstance();
        CategorySetDocument.CategorySet categorySetCostShare = (CategorySetDocument.CategorySet)CategorySetDocument.CategorySet.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionType() != null) {
            String opportunityTitle = StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle(), (int)0, (int)120);
            categorySet.setActivityTitle(opportunityTitle);
            categorySetCostShare.setActivityTitle(opportunityTitle);
        }
        List<? extends BudgetCategoryMapContract> budgetCategoryMapList = this.s2SBudgetCategoryMapService.getBudgetCategoryMapList(new ArrayList<String>(), new ArrayList<String>());
        for (BudgetPeriodContract budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetCategoryMapContract budgetCategoryMapContract : budgetCategoryMapList) {
                    for (BudgetCategoryMappingContract budgetCategoryMapping : budgetCategoryMapContract.getBudgetCategoryMappings()) {
                        if (!budgetLineItem.getBudgetCategory().getCode().equals(budgetCategoryMapping.getBudgetCategoryCode())) continue;
                        if (budgetCategoryMapContract.getTargetCategoryCode().equals("40")) {
                            constructionCost = (ScaleTwoDecimal)constructionCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                            if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                            constructionCostCostShare = (ScaleTwoDecimal)constructionCostCostShare.add((AbstractDecimal)budgetLineItem.getCostSharingAmount());
                            continue;
                        }
                        if (budgetCategoryMapContract.getTargetCategoryCode().equals("04")) {
                            contractualCost = (ScaleTwoDecimal)contractualCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                            if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                            contractualCostCostShare = (ScaleTwoDecimal)contractualCostCostShare.add((AbstractDecimal)budgetLineItem.getCostSharingAmount());
                            continue;
                        }
                        if (budgetCategoryMapContract.getTargetCategoryCode().equals("42")) {
                            equipmentCost = (ScaleTwoDecimal)equipmentCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                            if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                            equipmentCostCostShare = (ScaleTwoDecimal)equipmentCostCostShare.add((AbstractDecimal)budgetLineItem.getCostSharingAmount());
                            continue;
                        }
                        if (budgetCategoryMapContract.getCategoryType().equals("P")) {
                            personnelCost = (ScaleTwoDecimal)personnelCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                            if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                            personnelCostCostShare = (ScaleTwoDecimal)personnelCostCostShare.add((AbstractDecimal)budgetLineItem.getCostSharingAmount());
                            continue;
                        }
                        if (budgetCategoryMapContract.getTargetCategoryCode().equals("43")) {
                            suppliesCost = (ScaleTwoDecimal)suppliesCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                            if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                            suppliesCostCostShare = (ScaleTwoDecimal)suppliesCostCostShare.add((AbstractDecimal)budgetLineItem.getCostSharingAmount());
                            continue;
                        }
                        if (budgetCategoryMapContract.getTargetCategoryCode().equals("73") || budgetCategoryMapContract.getTargetCategoryCode().equals("74")) {
                            travelCost = (ScaleTwoDecimal)travelCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                            if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                            travelCostCostShare = (ScaleTwoDecimal)travelCostCostShare.add((AbstractDecimal)budgetLineItem.getCostSharingAmount());
                            continue;
                        }
                        otherCost = (ScaleTwoDecimal)otherCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                        if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                        otherCostCostShare = (ScaleTwoDecimal)otherCostCostShare.add((AbstractDecimal)budgetLineItem.getCostSharingAmount());
                    }
                }
                for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmountContract : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (budgetLineItemCalculatedAmountContract.getRateClass().getRateClassType().getCode().equals("E") || budgetLineItemCalculatedAmountContract.getRateClass().getRateClassType().getCode().equals("V")) {
                        calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)budgetLineItemCalculatedAmountContract.getCalculatedCost());
                        if (budgetLineItem.getSubmitCostSharingFlag().booleanValue()) {
                            calculatedCostCostShare = (ScaleTwoDecimal)calculatedCostCostShare.add((AbstractDecimal)budgetLineItemCalculatedAmountContract.getCalculatedCostSharing());
                        }
                    }
                    if (budgetLineItemCalculatedAmountContract.getRateClass().getRateClassType().getCode().equals("Y")) {
                        laSalaries = (ScaleTwoDecimal)laSalaries.add((AbstractDecimal)budgetLineItemCalculatedAmountContract.getCalculatedCost());
                        if (budgetLineItem.getSubmitCostSharingFlag().booleanValue()) {
                            laSalariesCostShare = (ScaleTwoDecimal)laSalariesCostShare.add((AbstractDecimal)budgetLineItemCalculatedAmountContract.getCalculatedCostSharing());
                        }
                    }
                    if (!budgetLineItemCalculatedAmountContract.getRateClass().getRateClassType().getCode().equals("L")) continue;
                    labAllocation = (ScaleTwoDecimal)labAllocation.add((AbstractDecimal)budgetLineItemCalculatedAmountContract.getCalculatedCost());
                    if (!budgetLineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    labAllocationCostShare = (ScaleTwoDecimal)labAllocationCostShare.add((AbstractDecimal)budgetLineItemCalculatedAmountContract.getCalculatedCostSharing());
                }
            }
        }
        for (BudgetProjectIncomeContract budgetProjectIncome : this.budget.getBudgetProjectIncomes()) {
            programIncome = (ScaleTwoDecimal)programIncome.add((AbstractDecimal)new ScaleTwoDecimal(budgetProjectIncome.getProjectIncome().bigDecimalValue()));
        }
        BigDecimal otherCostWithLA = labAllocation.bigDecimalValue().add(otherCost.bigDecimalValue());
        BigDecimal otherCostWithLACostShare = labAllocationCostShare.bigDecimalValue().add(otherCostCostShare.bigDecimalValue());
        BigDecimal salariesWithLA = laSalaries.bigDecimalValue().add(personnelCost.bigDecimalValue());
        BigDecimal salariesWithLACostShare = laSalariesCostShare.bigDecimalValue().add(personnelCostCostShare.bigDecimalValue());
        S2SBudgetDto budgetSummarydto = this.s2sBudgetInfoService.getBudgetInfo(this.pdDoc);
        categorySet.setBudgetConstructionRequestedAmount(constructionCost.bigDecimalValue());
        categorySetCostShare.setBudgetConstructionRequestedAmount(constructionCostCostShare.bigDecimalValue());
        categoryTotals.setBudgetConstructionRequestedAmount(categorySet.getBudgetConstructionRequestedAmount().add(categorySetCostShare.getBudgetConstructionRequestedAmount()));
        categorySet.setBudgetContractualRequestedAmount(contractualCost.bigDecimalValue());
        categorySetCostShare.setBudgetContractualRequestedAmount(contractualCostCostShare.bigDecimalValue());
        categoryTotals.setBudgetContractualRequestedAmount(categorySet.getBudgetContractualRequestedAmount().add(categorySetCostShare.getBudgetContractualRequestedAmount()));
        categorySet.setBudgetEquipmentRequestedAmount(equipmentCost.bigDecimalValue());
        categorySetCostShare.setBudgetEquipmentRequestedAmount(equipmentCostCostShare.bigDecimalValue());
        categoryTotals.setBudgetEquipmentRequestedAmount(categorySet.getBudgetEquipmentRequestedAmount().add(categorySetCostShare.getBudgetEquipmentRequestedAmount()));
        categorySet.setBudgetFringeBenefitsRequestedAmount(calculatedCost.bigDecimalValue());
        categorySetCostShare.setBudgetFringeBenefitsRequestedAmount(calculatedCostCostShare.bigDecimalValue());
        categoryTotals.setBudgetFringeBenefitsRequestedAmount(categorySet.getBudgetFringeBenefitsRequestedAmount().add(categorySetCostShare.getBudgetFringeBenefitsRequestedAmount()));
        categorySet.setBudgetIndirectChargesAmount(budgetSummarydto.getCumTotalIndirectCosts().bigDecimalValue());
        categorySetCostShare.setBudgetIndirectChargesAmount(budgetSummarydto.getCumTotalIndirectCostSharing().bigDecimalValue());
        categoryTotals.setBudgetIndirectChargesAmount(categorySet.getBudgetIndirectChargesAmount().add(categorySetCostShare.getBudgetIndirectChargesAmount()));
        categorySet.setBudgetOtherRequestedAmount(otherCostWithLA);
        categorySetCostShare.setBudgetOtherRequestedAmount(otherCostWithLACostShare);
        categoryTotals.setBudgetOtherRequestedAmount(categorySet.getBudgetOtherRequestedAmount().add(categorySetCostShare.getBudgetOtherRequestedAmount()));
        categorySet.setBudgetPersonnelRequestedAmount(salariesWithLA);
        categorySetCostShare.setBudgetPersonnelRequestedAmount(salariesWithLACostShare);
        categoryTotals.setBudgetPersonnelRequestedAmount(categorySet.getBudgetPersonnelRequestedAmount().add(categorySetCostShare.getBudgetPersonnelRequestedAmount()));
        categorySet.setBudgetSuppliesRequestedAmount(suppliesCost.bigDecimalValue());
        categorySetCostShare.setBudgetSuppliesRequestedAmount(suppliesCostCostShare.bigDecimalValue());
        categoryTotals.setBudgetSuppliesRequestedAmount(categorySet.getBudgetSuppliesRequestedAmount().add(categorySetCostShare.getBudgetSuppliesRequestedAmount()));
        categorySetCostShare.setBudgetTotalAmount(constructionCostCostShare.bigDecimalValue().add(contractualCostCostShare.bigDecimalValue()).add(equipmentCostCostShare.bigDecimalValue()).add(personnelCostCostShare.bigDecimalValue()).add(suppliesCostCostShare.bigDecimalValue()).add(travelCostCostShare.bigDecimalValue()).add(otherCostCostShare.bigDecimalValue().add(calculatedCostCostShare.bigDecimalValue()).add(laSalariesCostShare.bigDecimalValue().add(labAllocationCostShare.bigDecimalValue()))).add(categorySetCostShare.getBudgetIndirectChargesAmount()));
        categorySet.setBudgetTotalAmount(constructionCost.bigDecimalValue().add(contractualCost.bigDecimalValue().add(equipmentCost.bigDecimalValue().add(personnelCost.bigDecimalValue().add(suppliesCost.bigDecimalValue().add(travelCost.bigDecimalValue()).add(otherCost.bigDecimalValue().add(calculatedCost.bigDecimalValue().add(laSalaries.bigDecimalValue().add(labAllocation.bigDecimalValue())))))))).add(categorySet.getBudgetIndirectChargesAmount()));
        categoryTotals.setBudgetTotalAmount(categorySet.getBudgetTotalAmount().add(categorySetCostShare.getBudgetTotalAmount()));
        categorySet.setBudgetTotalDirectChargesAmount(constructionCost.bigDecimalValue().add(contractualCost.bigDecimalValue().add(equipmentCost.bigDecimalValue().add(personnelCost.bigDecimalValue().add(suppliesCost.bigDecimalValue().add(travelCost.bigDecimalValue()).add(otherCost.bigDecimalValue().add(calculatedCost.bigDecimalValue().add(laSalaries.bigDecimalValue().add(labAllocation.bigDecimalValue())))))))));
        categorySetCostShare.setBudgetTotalDirectChargesAmount(constructionCostCostShare.bigDecimalValue().add(contractualCostCostShare.bigDecimalValue()).add(equipmentCostCostShare.bigDecimalValue()).add(personnelCostCostShare.bigDecimalValue()).add(suppliesCostCostShare.bigDecimalValue()).add(travelCostCostShare.bigDecimalValue()).add(otherCostCostShare.bigDecimalValue().add(calculatedCostCostShare.bigDecimalValue()).add(laSalariesCostShare.bigDecimalValue().add(labAllocationCostShare.bigDecimalValue()))));
        categoryTotals.setBudgetTotalDirectChargesAmount(categorySet.getBudgetTotalDirectChargesAmount().add(categorySetCostShare.getBudgetTotalDirectChargesAmount()));
        categorySet.setBudgetTravelRequestedAmount(travelCost.bigDecimalValue());
        categorySetCostShare.setBudgetTravelRequestedAmount(travelCostCostShare.bigDecimalValue());
        categoryTotals.setBudgetTravelRequestedAmount(categorySet.getBudgetTravelRequestedAmount().add(categorySetCostShare.getBudgetTravelRequestedAmount()));
        categorySet.setProgramIncomeAmount(programIncome.bigDecimalValue());
        categorySetCostShare.setProgramIncomeAmount(BigDecimal.ZERO);
        categoryTotals.setProgramIncomeAmount(categorySet.getProgramIncomeAmount().add(categorySetCostShare.getProgramIncomeAmount()));
        if (separateFedNonFed) {
            categorySetArray[0] = categorySet;
            categorySetArray[1] = categorySetCostShare;
        } else {
            categorySet.setBudgetConstructionRequestedAmount(categorySet.getBudgetConstructionRequestedAmount().add(categorySetCostShare.getBudgetConstructionRequestedAmount()));
            categorySet.setBudgetContractualRequestedAmount(categorySet.getBudgetContractualRequestedAmount().add(categorySetCostShare.getBudgetContractualRequestedAmount()));
            categorySet.setBudgetEquipmentRequestedAmount(categorySet.getBudgetEquipmentRequestedAmount().add(categorySetCostShare.getBudgetEquipmentRequestedAmount()));
            categorySet.setBudgetFringeBenefitsRequestedAmount(categorySet.getBudgetFringeBenefitsRequestedAmount().add(categorySetCostShare.getBudgetFringeBenefitsRequestedAmount()));
            categorySet.setBudgetIndirectChargesAmount(categorySet.getBudgetIndirectChargesAmount().add(categorySetCostShare.getBudgetIndirectChargesAmount()));
            categorySet.setBudgetOtherRequestedAmount(categorySet.getBudgetOtherRequestedAmount().add(categorySetCostShare.getBudgetOtherRequestedAmount()));
            categorySet.setBudgetPersonnelRequestedAmount(categorySet.getBudgetPersonnelRequestedAmount().add(categorySetCostShare.getBudgetPersonnelRequestedAmount()));
            categorySet.setBudgetSuppliesRequestedAmount(categorySet.getBudgetSuppliesRequestedAmount().add(categorySetCostShare.getBudgetSuppliesRequestedAmount()));
            categorySet.setBudgetTotalAmount(categorySet.getBudgetTotalAmount().add(categorySetCostShare.getBudgetTotalAmount()));
            categorySet.setBudgetTotalDirectChargesAmount(categorySet.getBudgetTotalDirectChargesAmount().add(categorySetCostShare.getBudgetTotalDirectChargesAmount()));
            categorySet.setBudgetTravelRequestedAmount(categorySet.getBudgetTravelRequestedAmount().add(categorySetCostShare.getBudgetTravelRequestedAmount()));
            categorySet.setProgramIncomeAmount(categorySet.getProgramIncomeAmount().add(categorySetCostShare.getProgramIncomeAmount()));
            categorySetArray[0] = categorySet;
        }
        budgetCategories.setCategorySetArray(categorySetArray);
        budgetCategories.setCategoryTotals(categoryTotals);
        return budgetCategories;
    }

    private BudgetSummaryDocument.BudgetSummary getBudgetSummary() {
        BudgetSummaryDocument.BudgetSummary budgetSummary = (BudgetSummaryDocument.BudgetSummary)BudgetSummaryDocument.BudgetSummary.Factory.newInstance();
        SummaryLineItemDocument.SummaryLineItem[] summaryLineItemArray = new SummaryLineItemDocument.SummaryLineItem[1];
        SummaryLineItemDocument.SummaryLineItem summaryLineItem = (SummaryLineItemDocument.SummaryLineItem)SummaryLineItemDocument.SummaryLineItem.Factory.newInstance();
        boolean hasBudgetLineItem = false;
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionType() != null) {
            String opportunityTitle = StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle(), (int)0, (int)120);
            summaryLineItem.setActivityTitle(opportunityTitle);
            this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sOpportunityCfdas().stream().map(Cfda::getCfdaNumber).findFirst().ifPresent(summaryLineItem::setCFDANumber);
        }
        if (this.budget != null) {
            ScaleTwoDecimal fedNonFedCost = this.budget.getTotalCost();
            ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : this.budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!this.budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetLineItemCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && this.budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = this.budget.getCostSharingAmount();
            }
            fedNonFedCost = (ScaleTwoDecimal)fedNonFedCost.add((AbstractDecimal)costSharingAmount);
            summaryLineItem.setBudgetFederalNewOrRevisedAmount(this.budget.getTotalCost().bigDecimalValue());
            summaryLineItem.setBudgetNonFederalNewOrRevisedAmount(costSharingAmount.bigDecimalValue());
            summaryLineItem.setBudgetTotalNewOrRevisedAmount(fedNonFedCost.bigDecimalValue());
            summaryLineItemArray[0] = summaryLineItem;
            budgetSummary.setSummaryLineItemArray(summaryLineItemArray);
            SummaryTotalsDocument.SummaryTotals summaryTotals = (SummaryTotalsDocument.SummaryTotals)SummaryTotalsDocument.SummaryTotals.Factory.newInstance();
            summaryTotals.setBudgetFederalNewOrRevisedAmount(this.budget.getTotalCost().bigDecimalValue());
            summaryTotals.setBudgetNonFederalNewOrRevisedAmount(costSharingAmount.bigDecimalValue());
            summaryTotals.setBudgetTotalNewOrRevisedAmount(fedNonFedCost.bigDecimalValue());
            budgetSummary.setSummaryTotals(summaryTotals);
        }
        return budgetSummary;
    }

    private NonFederalResourcesDocument.NonFederalResources getNonFederalResources() {
        NonFederalResourcesDocument.NonFederalResources nonFederalResources = (NonFederalResourcesDocument.NonFederalResources)NonFederalResourcesDocument.NonFederalResources.Factory.newInstance();
        ResourceLineItemDocument.ResourceLineItem[] resourceLineItemArray = new ResourceLineItemDocument.ResourceLineItem[1];
        ResourceLineItemDocument.ResourceLineItem resourceLineItem = (ResourceLineItemDocument.ResourceLineItem)ResourceLineItemDocument.ResourceLineItem.Factory.newInstance();
        boolean hasBudegetLineItem = false;
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionType() != null) {
            String opportunityTitle = StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle(), (int)0, (int)120);
            resourceLineItem.setActivityTitle(opportunityTitle);
        }
        if (this.budget != null) {
            ScaleTwoDecimal fedNonFedCost = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : this.budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudegetLineItem = true;
                    if (!this.budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    fedNonFedCost = (ScaleTwoDecimal)fedNonFedCost.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        fedNonFedCost = (ScaleTwoDecimal)fedNonFedCost.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudegetLineItem && this.budget.getSubmitCostSharingFlag().booleanValue()) {
                fedNonFedCost = (ScaleTwoDecimal)fedNonFedCost.add((AbstractDecimal)this.budget.getCostSharingAmount());
            }
            resourceLineItem.setBudgetApplicantContributionAmount(fedNonFedCost.bigDecimalValue());
            resourceLineItem.setBudgetTotalContributionAmount(fedNonFedCost.bigDecimalValue());
            resourceLineItemArray[0] = resourceLineItem;
            nonFederalResources.setResourceLineItemArray(resourceLineItemArray);
            ResourceTotalsDocument.ResourceTotals resourceTotals = (ResourceTotalsDocument.ResourceTotals)ResourceTotalsDocument.ResourceTotals.Factory.newInstance();
            resourceTotals.setBudgetApplicantContributionAmount(fedNonFedCost.bigDecimalValue());
            resourceTotals.setBudgetTotalContributionAmount(fedNonFedCost.bigDecimalValue());
            nonFederalResources.setResourceTotals(resourceTotals);
        }
        return nonFederalResources;
    }

    private BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds getBudgetForecastedCashNeeds() {
        ScaleTwoDecimal totalFedCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal costSharing = ScaleTwoDecimal.ZERO;
        BigDecimal totalEstimation = ScaleTwoDecimal.ZERO.bigDecimalValue();
        BigDecimal costShareEstimation = ScaleTwoDecimal.ZERO.bigDecimalValue();
        BigDecimal totalFedEstimation = ScaleTwoDecimal.ZERO.bigDecimalValue();
        BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds budgetForecastedCashNeeds = (BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds)BudgetForecastedCashNeedsDocument.BudgetForecastedCashNeeds.Factory.newInstance();
        if (this.budget != null) {
            BudgetFirstYearAmountsDocument.BudgetFirstYearAmounts budgetFirstYearAmounts = (BudgetFirstYearAmountsDocument.BudgetFirstYearAmounts)BudgetFirstYearAmountsDocument.BudgetFirstYearAmounts.Factory.newInstance();
            BudgetFirstQuarterAmountsDocument.BudgetFirstQuarterAmounts budgetFirstQuarterAmounts = (BudgetFirstQuarterAmountsDocument.BudgetFirstQuarterAmounts)BudgetFirstQuarterAmountsDocument.BudgetFirstQuarterAmounts.Factory.newInstance();
            BudgetSecondQuarterAmountsDocument.BudgetSecondQuarterAmounts budgetSecondQuarterAmounts = (BudgetSecondQuarterAmountsDocument.BudgetSecondQuarterAmounts)BudgetSecondQuarterAmountsDocument.BudgetSecondQuarterAmounts.Factory.newInstance();
            BudgetThirdQuarterAmountsDocument.BudgetThirdQuarterAmounts budgetThirdQuarterAmounts = (BudgetThirdQuarterAmountsDocument.BudgetThirdQuarterAmounts)BudgetThirdQuarterAmountsDocument.BudgetThirdQuarterAmounts.Factory.newInstance();
            BudgetFourthQuarterAmountsDocument.BudgetFourthQuarterAmounts budgetFourthQuarterAmounts = (BudgetFourthQuarterAmountsDocument.BudgetFourthQuarterAmounts)BudgetFourthQuarterAmountsDocument.BudgetFourthQuarterAmounts.Factory.newInstance();
            for (BudgetPeriodContract budgetPeriod : this.budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!this.budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue() || budgetPeriod.getBudgetPeriod().intValue() != BudgetPeriodNum.P1.getNum()) continue;
                    costSharing = (ScaleTwoDecimal)costSharing.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        costSharing = (ScaleTwoDecimal)costSharing.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
                if (budgetPeriod.getBudgetPeriod().intValue() != BudgetPeriodNum.P1.getNum()) continue;
                totalFedCost = budgetPeriod.getTotalCost();
                totalFedEstimation = totalFedCost.bigDecimalValue().divide(new ScaleTwoDecimal(4).bigDecimalValue(), RoundingMode.HALF_UP);
                costShareEstimation = costSharing.bigDecimalValue().divide(new ScaleTwoDecimal(4).bigDecimalValue(), RoundingMode.HALF_UP);
                totalEstimation = totalFedEstimation.add(costShareEstimation);
            }
            budgetFirstYearAmounts.setBudgetFederalForecastedAmount(totalFedCost.bigDecimalValue());
            budgetFirstYearAmounts.setBudgetNonFederalForecastedAmount(costSharing.bigDecimalValue());
            budgetFirstYearAmounts.setBudgetTotalForecastedAmount(((ScaleTwoDecimal)costSharing.add((AbstractDecimal)totalFedCost)).bigDecimalValue());
            budgetForecastedCashNeeds.setBudgetFirstYearAmounts(budgetFirstYearAmounts);
            budgetFirstQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation);
            budgetFirstQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation);
            budgetFirstQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation);
            budgetForecastedCashNeeds.setBudgetFirstQuarterAmounts(budgetFirstQuarterAmounts);
            budgetSecondQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation);
            budgetSecondQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation);
            budgetSecondQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation);
            budgetForecastedCashNeeds.setBudgetSecondQuarterAmounts(budgetSecondQuarterAmounts);
            budgetThirdQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation);
            budgetThirdQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation);
            budgetThirdQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation);
            budgetForecastedCashNeeds.setBudgetThirdQuarterAmounts(budgetThirdQuarterAmounts);
            budgetFourthQuarterAmounts.setBudgetFederalForecastedAmount(totalFedEstimation);
            budgetFourthQuarterAmounts.setBudgetNonFederalForecastedAmount(costShareEstimation);
            budgetFourthQuarterAmounts.setBudgetTotalForecastedAmount(totalEstimation);
            budgetForecastedCashNeeds.setBudgetFourthQuarterAmounts(budgetFourthQuarterAmounts);
        }
        return budgetForecastedCashNeeds;
    }

    private FederalFundsNeededDocument.FederalFundsNeeded getFederalFundsNeeded() {
        ScaleTwoDecimal firstYearNetCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal secondYearNetCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal thirdYearNetCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal fourthYearNetCost = ScaleTwoDecimal.ZERO;
        FederalFundsNeededDocument.FederalFundsNeeded federalFundsNeeded = (FederalFundsNeededDocument.FederalFundsNeeded)FederalFundsNeededDocument.FederalFundsNeeded.Factory.newInstance();
        if (this.budget == null) {
            return federalFundsNeeded;
        }
        FundsTotalsDocument.FundsTotals fundsTotals = (FundsTotalsDocument.FundsTotals)FundsTotalsDocument.FundsTotals.Factory.newInstance();
        FundsLineItemDocument.FundsLineItem[] fundsLineItemArray = new FundsLineItemDocument.FundsLineItem[1];
        FundsLineItemDocument.FundsLineItem fundsLineItem = (FundsLineItemDocument.FundsLineItem)FundsLineItemDocument.FundsLineItem.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionType() != null) {
            String opportunityTitle = StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle(), (int)0, (int)120);
            fundsLineItem.setActivityTitle(opportunityTitle);
        }
        for (BudgetPeriodContract budgetPeriod : this.budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod().intValue() == BudgetPeriodNum.P2.getNum()) {
                firstYearNetCost = (ScaleTwoDecimal)firstYearNetCost.add((AbstractDecimal)budgetPeriod.getTotalCost());
            }
            if (budgetPeriod.getBudgetPeriod().intValue() == BudgetPeriodNum.P3.getNum()) {
                secondYearNetCost = (ScaleTwoDecimal)secondYearNetCost.add((AbstractDecimal)budgetPeriod.getTotalCost());
            }
            if (budgetPeriod.getBudgetPeriod().intValue() == BudgetPeriodNum.P4.getNum()) {
                thirdYearNetCost = (ScaleTwoDecimal)thirdYearNetCost.add((AbstractDecimal)budgetPeriod.getTotalCost());
            }
            if (budgetPeriod.getBudgetPeriod().intValue() != BudgetPeriodNum.P5.getNum()) continue;
            fourthYearNetCost = (ScaleTwoDecimal)fourthYearNetCost.add((AbstractDecimal)budgetPeriod.getTotalCost());
        }
        fundsLineItem.setBudgetFirstYearAmount(firstYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetFirstYearAmount(firstYearNetCost.bigDecimalValue());
        fundsLineItem.setBudgetSecondYearAmount(secondYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetSecondYearAmount(secondYearNetCost.bigDecimalValue());
        fundsLineItem.setBudgetThirdYearAmount(thirdYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetThirdYearAmount(thirdYearNetCost.bigDecimalValue());
        fundsLineItem.setBudgetFourthYearAmount(fourthYearNetCost.bigDecimalValue());
        fundsTotals.setBudgetFourthYearAmount(fourthYearNetCost.bigDecimalValue());
        fundsLineItemArray[0] = fundsLineItem;
        federalFundsNeeded.setFundsLineItemArray(fundsLineItemArray);
        federalFundsNeeded.setFundsTotals(fundsTotals);
        return federalFundsNeeded;
    }

    @Override
    public BudgetInformationDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getSF424A();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public S2SBudgetCategoryMapService getS2SBudgetCategoryMapService() {
        return this.s2SBudgetCategoryMapService;
    }

    public void setS2SBudgetCategoryMapService(S2SBudgetCategoryMapService s2SBudgetCategoryMapService) {
        this.s2SBudgetCategoryMapService = s2SBudgetCategoryMapService;
    }

    public S2SBudgetInfoService getS2sBudgetInfoService() {
        return this.s2sBudgetInfoService;
    }

    public void setS2sBudgetInfoService(S2SBudgetInfoService s2sBudgetInfoService) {
        this.s2sBudgetInfoService = s2sBudgetInfoService;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(BudgetInformationDocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<BudgetInformationDocument> factory() {
        return BudgetInformationDocument.Factory;
    }
}

