/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sflllV11.AwardeeDataType;
import gov.grants.apply.forms.sflllV11.LobbyingActivitiesDisclosureDocument;
import gov.grants.apply.forms.sflllV11.ReportDataType;
import gov.grants.apply.forms.sflllV11.ReportEntityDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.SFLLLBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SFLLLV1_1Generator")
public class SFLLLV1_1Generator
extends SFLLLBaseGenerator<LobbyingActivitiesDisclosureDocument> {
    private DepartmentalPersonDto aorInfo;
    @Value(value="http://apply.grants.gov/forms/SFLLL-V1.1")
    private String namespace;
    @Value(value="SFLLL-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SFLLL-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="1000")
    private int sortIndex;

    private LobbyingActivitiesDisclosureDocument getLobbyingActivitiesDisclosure() {
        LobbyingActivitiesDisclosureDocument lobbyinADDocument = (LobbyingActivitiesDisclosureDocument)LobbyingActivitiesDisclosureDocument.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure lobbyingDisclosure = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.Factory.newInstance();
        lobbyingDisclosure.setFormVersion(FormVersion.v1_1.getVersion());
        lobbyingDisclosure.setFederalActionType(LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalActionType.GRANT);
        lobbyingDisclosure.setFederalActionStatus(LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalActionStatus.BID_OFFER);
        lobbyingDisclosure.setReportType(ReportDataType.INITIAL_FILING);
        lobbyingDisclosure.setReportEntity(this.getReportEntity());
        lobbyingDisclosure.setFederalAgencyDepartment("");
        SponsorContract sponsor = this.pdDoc.getDevelopmentProposal().getSponsor();
        if (sponsor != null) {
            if (sponsor.getSponsorName() != null) {
                if (sponsor.getSponsorName().length() > 40) {
                    lobbyingDisclosure.setFederalAgencyDepartment(sponsor.getSponsorName().substring(0, 40));
                } else {
                    lobbyingDisclosure.setFederalAgencyDepartment(sponsor.getSponsorName());
                }
            }
        } else {
            SponsorContract primeSponsor;
            String primeSponsorCode = this.pdDoc.getDevelopmentProposal().getPrimeSponsor().getSponsorCode();
            if (primeSponsorCode != null && (primeSponsor = this.pdDoc.getDevelopmentProposal().getPrimeSponsor()).getSponsorName() != null) {
                if (primeSponsor.getSponsorName().length() > 40) {
                    lobbyingDisclosure.setFederalAgencyDepartment(primeSponsor.getSponsorName().substring(0, 40));
                } else {
                    lobbyingDisclosure.setFederalAgencyDepartment(primeSponsor.getSponsorName());
                }
            }
        }
        lobbyingDisclosure.setFederalProgramName(this.getFedProgramName());
        lobbyingDisclosure.setLobbyingRegistrant(this.getLobbyingRegistrant());
        lobbyingDisclosure.setIndividualsPerformingServices(this.getIndividualsPerformingServices());
        lobbyingDisclosure.setSignatureBlock(this.getSignatureBlock());
        lobbyinADDocument.setLobbyingActivitiesDisclosure(lobbyingDisclosure);
        return lobbyinADDocument;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock getSignatureBlock() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock signatureBlock = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock.Factory.newInstance();
        signatureBlock.setName(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            signatureBlock.setTitle(StringUtils.substring((String)this.aorInfo.getPrimaryTitle(), (int)0, (int)45));
        }
        signatureBlock.setSignature(this.aorInfo.getFullName());
        signatureBlock.setSignedDate(this.aorInfo.getSubmittedDate());
        return signatureBlock;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant getLobbyingRegistrant() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant lobbyingRegistrant = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant.Factory.newInstance();
        lobbyingRegistrant.setOrganizationName("N/A");
        return lobbyingRegistrant;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices getIndividualsPerformingServices() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices individualServices = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual individual = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual.Factory.newInstance();
        HumanNameDataType humanName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
        humanName.setFirstName("N/A");
        humanName.setLastName("N/A");
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual[] individualArray = new LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual[1];
        individual.setName(humanName);
        individualArray[0] = individual;
        individualServices.setIndividualArray(individualArray);
        return individualServices;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName getFedProgramName() {
        String cfdaNumber;
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName federalProgramName = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            federalProgramName.setFederalProgramDescription(announcementTitle);
        }
        if ((cfdaNumber = this.getFirstCfdaNumber()) != null) {
            federalProgramName.setCFDANumber(cfdaNumber);
        }
        return federalProgramName;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity getReportEntity() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity reportEntity = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Factory.newInstance();
        reportEntity.setReportEntityType(ReportEntityDataType.PRIME);
        reportEntity.setReportEntityIsPrime(YesNoDataType.Y_YES);
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Prime prime = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Prime)LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Prime.Factory.newInstance();
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        OrganizationContract organization = proposalSite.getOrganization();
        if (organization != null) {
            if (proposalSite.getLocationName() != null) {
                prime.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            }
            if (organization.getCongressionalDistrict() != null) {
                if (organization.getCongressionalDistrict().length() > 6) {
                    prime.setCongressionalDistrict(organization.getCongressionalDistrict().substring(0, 6));
                } else {
                    prime.setCongressionalDistrict(organization.getCongressionalDistrict());
                }
            }
        }
        prime.setReportEntityType(ReportEntityDataType.PRIME);
        AwardeeDataType.Address address = (AwardeeDataType.Address)AwardeeDataType.Address.Factory.newInstance();
        if (proposalSite != null) {
            if (proposalSite.getAddressLine1() != null) {
                if (proposalSite.getAddressLine1().length() > 55) {
                    address.setStreet1(proposalSite.getAddressLine1().substring(0, 55));
                } else {
                    address.setStreet1(proposalSite.getAddressLine1());
                }
            }
            if (proposalSite.getAddressLine2() != null) {
                if (proposalSite.getAddressLine2().length() > 55) {
                    address.setStreet2(proposalSite.getAddressLine2().substring(0, 55));
                } else {
                    address.setStreet2(proposalSite.getAddressLine2());
                }
            }
            if (proposalSite.getCity() != null) {
                if (proposalSite.getCity().length() > 35) {
                    address.setCity(proposalSite.getCity().substring(0, 35));
                } else {
                    address.setCity(proposalSite.getCity());
                }
            }
            this.globLibV20Generator.getStateCodeDataType(proposalSite.getCountryCode(), proposalSite.getState()).ifPresent(address::setState);
            address.setZipPostalCode(proposalSite.getPostalCode());
        }
        prime.setAddress(address);
        reportEntity.setPrime(prime);
        return reportEntity;
    }

    @Override
    public LobbyingActivitiesDisclosureDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        return this.getLobbyingActivitiesDisclosure();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<LobbyingActivitiesDisclosureDocument> factory() {
        return LobbyingActivitiesDisclosureDocument.Factory;
    }
}

