/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.hash;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.DigesterOutputStream;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.util.XPathExecutor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class GrantApplicationHash {
    private static final Logger LOG = LogManager.getLogger((String)GrantApplicationHash.class.getName());
    private static final String FORMS_XPATH = "//*[local-name(.) = 'Forms' and namespace-uri(.) = 'http://apply.grants.gov/system/MetaGrantApplication']";
    private static MessageDigest MESSAGE_DIGESTER = null;

    private GrantApplicationHash() {
        throw new UnsupportedOperationException("do not call");
    }

    static String computeGrantFormsHash(String xml) throws S2SException {
        try {
            XPathExecutor xpath = new XPathExecutor(xml);
            return GrantApplicationHash._hash(xpath);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new S2SException(e.getMessage(), e);
        }
    }

    static String computeAttachmentHash(byte[] attachment) {
        byte[] rawDigest = MESSAGE_DIGESTER.digest(attachment);
        return Base64.encode((byte[])rawDigest);
    }

    private static String _hash(XPathExecutor xpath) throws XMLSignatureException, InvalidCanonicalizerException, CanonicalizationException {
        String string;
        block8: {
            Node formsNode = xpath.getNode(FORMS_XPATH);
            DigesterOutputStream digester = GrantApplicationHash._createDigesterOutputStream(xpath.getDoc());
            try {
                Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
                canonicalizer.canonicalizeSubtree(formsNode, (OutputStream)digester);
                byte[] hash = digester.getDigestValue();
                string = Base64.encode((byte[])hash);
                if (digester == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (digester != null) {
                        try {
                            digester.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            digester.close();
        }
        return string;
    }

    private static DigesterOutputStream _createDigesterOutputStream(Document doc) throws XMLSignatureException {
        DigesterOutputStream stream = null;
        if (doc != null) {
            stream = new DigesterOutputStream(MessageDigestAlgorithm.getInstance((Document)doc, (String)"http://www.w3.org/2000/09/xmldsig#sha1"));
        }
        return stream;
    }

    static {
        Init.init();
        try {
            MESSAGE_DIGESTER = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception ex) {
            LOG.error("Unable to get instance of java.security.MessageDigester", (Throwable)ex);
        }
    }
}

