/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * This abstract class has methods that are common to all the versions of RRPerformanceSite form.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
public abstract class RRPerformanceSiteBaseGenerator<T extends XmlObject> extends S2SBaseFormGenerator<T> implements S2SFormGeneratorPdfFillable<T> {

    public static final int PERFORMANCE_SITES_ATTACHMENT = 40;
    protected static final int PERFORMING_ORG_LOCATION_TYPE_CODE = 2;
    protected static final int OTHER_ORG_LOCATION_TYPE_CODE = 3;
    protected static final int PERFORMANCE_SITE_LOCATION_TYPE_CODE = 4;

    @Autowired
    @Qualifier("rolodexService")
    protected RolodexService rolodexService;

    public RolodexService getRolodexService() {
        return rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }
}
