/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.ed524Budget13V13.ApprovingFederalAgencyDataType;
import gov.grants.apply.forms.ed524Budget13V13.ED524Budget13Document;
import gov.grants.apply.forms.ed524Budget13V13.ED524Budget13Document.ED524Budget13.IndirectCost;
import gov.grants.apply.forms.ed524Budget13V13.ED524Budget13Document.ED524Budget13.IndirectCost.IndirectCostRateAgreementApproved;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationIndirectcostContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.BudgetPeriodNum;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@FormGenerator("ED524BudgetV1_3Generator")
public class ED524BudgetV1_3Generator extends ED524BudgetBaseGenerator<ED524Budget13Document> implements S2SFormGeneratorPdfFillable<ED524Budget13Document> {
    public static final String DEFAULT = "D";
    public static final String ON_CAMPUS = "N";
    public static final int QUESTION_ID = -10120;
    public static final String OVERHEAD = "O";

    @Value("http://apply.grants.gov/forms/ED_524_Budget_1_3-V1.3")
    private String namespace;

    @Value("ED_524_Budget_1_3-V1.3")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_524_Budget_1_3-V1.3.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ED_524_Budget_1_3-V1.3.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    protected ED524Budget13Document getED524Budget() {

        ED524Budget13Document ed524BudgetDocument = ED524Budget13Document.Factory.newInstance();
        ED524Budget13Document.ED524Budget13 ed524Budget = ED524Budget13Document.ED524Budget13.Factory.newInstance();

        ed524Budget.setFormVersion(FormVersion.v1_3.getVersion());
        if (pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            ed524Budget.setLEGALNAME(StringUtils.substring(pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), 0, ORGANIZATON_NAME_MAX_LENGTH));
        }
        else {
            ed524Budget.setLEGALNAME(DEFAULT_LEGAL_NAME);
        }

        ScaleTwoDecimal totalCategoryCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalPersonnel = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalPersonnelCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalFringe = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalFringeCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTravel = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTravelCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalEquip = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalEquipCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalSupplies = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalSuppliesCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalContractual = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalContractualCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalConstruction = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalConstructionCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalOther = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalOtherCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTraining = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalTrainingCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalCostAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalCostSharingAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDirectCostAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDirectCostAllYrsCS = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCostAllYrs = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCostAllYrsCS = ScaleTwoDecimal.ZERO;


        ProposalDevelopmentBudgetExtContract budget = s2SCommonBudgetService.getBudget(pdDoc.getDevelopmentProposal());

        if (budget == null) {
            return ed524BudgetDocument;
        }

        for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P1.getNum())) {
                getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFirstYearAmount(totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFirstYearAmount(totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFirstYearAmount(totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFirstYearAmount(totalIndirectCost.bigDecimalValue());

                totalCostAllYrs = totalCostAllYrs.add(totalCost);
                totalCostSharingAllYrs = totalCostSharingAllYrs.add(totalCostSharing);
                totalDirectCostAllYrs = totalDirectCostAllYrs.add(totalDirectCost);
                totalIndirectCostAllYrs = totalIndirectCostAllYrs.add(totalIndirectCost);

                // Total Indirect Cost Sharing
                getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFirstYearAmount(indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = totalIndirectCostAllYrsCS.add(indirectCS);

                // Supplies
                getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFirstYearAmount(supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFirstYearAmount(supplyCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(supplyCostCS);
                totalSupplies = totalSupplies.add(supplyCost);
                totalSuppliesCS = totalSuppliesCS.add(supplyCostCS);

                // Construction
                // Set to zero as it set hard coded as 0 in the procedure
                ed524Budget.setBudgetFederalConstructionFirstYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFirstYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());


                // Other
                getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFirstYearAmount(otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFirstYearAmount(otherCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(otherCostCS);
                totalOther = totalOther.add(otherCost);
                totalOtherCS = totalOtherCS.add(otherCostCS);

                // Equipment
                getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFirstYearAmount(equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFirstYearAmount(equipmentCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(equipmentCostCS);
                totalEquip = totalEquip.add(equipmentCost);
                totalEquipCS = totalEquipCS.add(equipmentCostCS);

                // Contractual
                getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFirstYearAmount(contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFirstYearAmount(contractualCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(contractualCostCS);
                totalContractual = totalContractual.add(contractualCost);
                totalContractualCS = totalContractualCS.add(contractualCostCS);

                // Travel
                getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFirstYearAmount(travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFirstYearAmount(travelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(travelCostCS);
                totalTravel = totalTravel.add(travelCost);
                totalTravelCS = totalTravelCS.add(travelCostCS);

                // Training
                getTrainingCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTrainingFirstYearAmount(trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFirstYearAmount(trainingCostCS.bigDecimalValue());

                totalTraining = totalTraining.add(trainingCost);
                totalTrainingCS = totalTrainingCS.add(trainingCostCS);

                // Fringe
                ed524Budget.setBudgetFederalFringeFirstYearAmount(categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFirstYearAmount(categoryCostCSFringe.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(categoryCostCSFringe);
                totalFringe = totalFringe.add(categoryCostFringe);
                totalFringeCS = totalFringeCS.add(categoryCostCSFringe);

                // Personnel
                getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFirstYearAmount(personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFirstYearAmount(personnelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(personnelCostCS);
                totalPersonnel = totalPersonnel.add(personnelCost);
                totalPersonnelCS = totalPersonnelCS.add(personnelCostCS);

                ed524Budget.setBudgetNonFederalDirectFirstYearAmount(totalCategoryCS.bigDecimalValue());

            }
            else if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P2.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSecondYearAmount(totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSecondYearAmount(totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectSecondYearAmount(totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectSecondYearAmount(totalIndirectCost.bigDecimalValue());

                totalCostAllYrs = totalCostAllYrs.add(totalCost);
                totalCostSharingAllYrs = totalCostSharingAllYrs.add(totalCostSharing);
                totalDirectCostAllYrs = totalDirectCostAllYrs.add(totalDirectCost);
                totalIndirectCostAllYrs = totalIndirectCostAllYrs.add(totalIndirectCost);

                // Total Indirect Cost Sharing
                getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectSecondYearAmount(indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = totalIndirectCostAllYrsCS.add(indirectCS);

                // Supplies
                getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesSecondYearAmount(supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesSecondYearAmount(supplyCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(supplyCostCS);
                totalSupplies = totalSupplies.add(supplyCost);
                totalSuppliesCS = totalSuppliesCS.add(supplyCostCS);

                // Construction
                // Set to zero as it set hard coded as 0 in the procedure
                ed524Budget.setBudgetFederalConstructionSecondYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionSecondYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());


                // Other
                getOtherCosts(budgetPeriod);
                if (otherCost.longValue() < 0) {
                    ed524Budget.setBudgetFederalOtherSecondYearAmount(BigDecimal.ZERO);
                }
                else {
                    ed524Budget.setBudgetFederalOtherSecondYearAmount(otherCost.bigDecimalValue());
                }

                ed524Budget.setBudgetNonFederalOtherSecondYearAmount(otherCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(otherCostCS);
                totalOther = totalOther.add(otherCost);
                totalOtherCS = totalOtherCS.add(otherCostCS);

                // Equipment
                getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentSecondYearAmount(equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentSecondYearAmount(equipmentCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(equipmentCostCS);
                totalEquip = totalEquip.add(equipmentCost);
                totalEquipCS = totalEquipCS.add(equipmentCostCS);

                // Contractual
                getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualSecondYearAmount(contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualSecondYearAmount(contractualCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(contractualCostCS);
                totalContractual = totalContractual.add(contractualCost);
                totalContractualCS = totalContractualCS.add(contractualCostCS);

                // Travel
                getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelSecondYearAmount(travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelSecondYearAmount(travelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(travelCostCS);
                totalTravel = totalTravel.add(travelCost);
                totalTravelCS = totalTravelCS.add(travelCostCS);

                // Training
                ed524Budget.setBudgetFederalTrainingSecondYearAmount(trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingSecondYearAmount(trainingCostCS.bigDecimalValue());

                totalTraining = totalTraining.add(trainingCost);
                totalTrainingCS = totalTrainingCS.add(trainingCostCS);

                // Fringe
                ed524Budget.setBudgetFederalFringeSecondYearAmount(categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeSecondYearAmount(categoryCostCSFringe.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(categoryCostCSFringe);
                totalFringe = totalFringe.add(categoryCostFringe);
                totalFringeCS = totalFringeCS.add(categoryCostCSFringe);

                // Personnel
                getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelSecondYearAmount(personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelSecondYearAmount(personnelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(personnelCostCS);
                totalPersonnel = totalPersonnel.add(personnelCost);
                totalPersonnelCS = totalPersonnelCS.add(personnelCostCS);

                ed524Budget.setBudgetNonFederalDirectSecondYearAmount(totalCategoryCS.bigDecimalValue());
            }
            else if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P3.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalThirdYearAmount(totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalThirdYearAmount(totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectThirdYearAmount(totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectThirdYearAmount(totalIndirectCost.bigDecimalValue());

                totalCostAllYrs = totalCostAllYrs.add(totalCost);
                totalCostSharingAllYrs = totalCostSharingAllYrs.add(totalCostSharing);
                totalDirectCostAllYrs = totalDirectCostAllYrs.add(totalDirectCost);
                totalIndirectCostAllYrs = totalIndirectCostAllYrs.add(totalIndirectCost);

                // Total Indirect Cost Sharing
                getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectThirdYearAmount(indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = totalIndirectCostAllYrsCS.add(indirectCS);

                // Supplies
                getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesThirdYearAmount(supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesThirdYearAmount(supplyCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(supplyCostCS);
                totalSupplies = totalSupplies.add(supplyCost);
                totalSuppliesCS = totalSuppliesCS.add(supplyCostCS);

                // Construction
                // Set to zero as it set hard coded as 0 in the procedure
                ed524Budget.setBudgetFederalConstructionThirdYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionThirdYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());


                // Other
                getOtherCosts(budgetPeriod);
                if (otherCost.longValue() < 0) {
                    ed524Budget.setBudgetFederalOtherThirdYearAmount(BigDecimal.ZERO);
                }
                else {
                    ed524Budget.setBudgetFederalOtherThirdYearAmount(otherCost.bigDecimalValue());
                }
                ed524Budget.setBudgetNonFederalOtherThirdYearAmount(otherCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(otherCostCS);
                totalOther = totalOther.add(otherCost);
                totalOtherCS = totalOtherCS.add(otherCostCS);

                // Equipment
                getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentThirdYearAmount(equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentThirdYearAmount(equipmentCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(equipmentCostCS);
                totalEquip = totalEquip.add(equipmentCost);
                totalEquipCS = totalEquipCS.add(equipmentCostCS);

                // Contractual
                getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualThirdYearAmount(contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualThirdYearAmount(contractualCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(contractualCostCS);
                totalContractual = totalContractual.add(contractualCost);
                totalContractualCS = totalContractualCS.add(contractualCostCS);

                // Travel
                getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelThirdYearAmount(travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelThirdYearAmount(travelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(travelCostCS);
                totalTravel = totalTravel.add(travelCost);
                totalTravelCS = totalTravelCS.add(travelCostCS);

                // Training
                ed524Budget.setBudgetFederalTrainingThirdYearAmount(trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingThirdYearAmount(trainingCostCS.bigDecimalValue());

                totalTraining = totalTraining.add(trainingCost);
                totalTrainingCS = totalTrainingCS.add(trainingCostCS);

                // Fringe
                ed524Budget.setBudgetFederalFringeThirdYearAmount(categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeThirdYearAmount(categoryCostCSFringe.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(categoryCostCSFringe);
                totalFringe = totalFringe.add(categoryCostFringe);
                totalFringeCS = totalFringeCS.add(categoryCostCSFringe);

                // Personnel
                getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelThirdYearAmount(personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelThirdYearAmount(personnelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(personnelCostCS);
                totalPersonnel = totalPersonnel.add(personnelCost);
                totalPersonnelCS = totalPersonnelCS.add(personnelCostCS);

                ed524Budget.setBudgetNonFederalDirectThirdYearAmount(totalCategoryCS.bigDecimalValue());
            }
            else if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P4.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFourthYearAmount(totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFourthYearAmount(totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFourthYearAmount(totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFourthYearAmount(totalIndirectCost.bigDecimalValue());

                totalCostAllYrs = totalCostAllYrs.add(totalCost);
                totalCostSharingAllYrs = totalCostSharingAllYrs.add(totalCostSharing);
                totalDirectCostAllYrs = totalDirectCostAllYrs.add(totalDirectCost);
                totalIndirectCostAllYrs = totalIndirectCostAllYrs.add(totalIndirectCost);

                // Total Indirect Cost Sharing
                getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFourthYearAmount(indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = totalIndirectCostAllYrsCS.add(indirectCS);

                // Supplies
                getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFourthYearAmount(supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFourthYearAmount(supplyCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(supplyCostCS);
                totalSupplies = totalSupplies.add(supplyCost);
                totalSuppliesCS = totalSuppliesCS.add(supplyCostCS);

                // Construction
                // Set to zero as it set hard coded as 0 in the procedure
                ed524Budget.setBudgetFederalConstructionFourthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFourthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());


                // Other
                getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFourthYearAmount(otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFourthYearAmount(otherCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(otherCostCS);
                totalOther = totalOther.add(otherCost);
                totalOtherCS = totalOtherCS.add(otherCostCS);

                // Equipment
                getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFourthYearAmount(equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFourthYearAmount(equipmentCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(equipmentCostCS);
                totalEquip = totalEquip.add(equipmentCost);
                totalEquipCS = totalEquipCS.add(equipmentCostCS);

                // Contractual
                getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFourthYearAmount(contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFourthYearAmount(contractualCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(contractualCostCS);
                totalContractual = totalContractual.add(contractualCost);
                totalContractualCS = totalContractualCS.add(contractualCostCS);

                // Travel
                getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFourthYearAmount(travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFourthYearAmount(travelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(travelCostCS);
                totalTravel = totalTravel.add(travelCost);
                totalTravelCS = totalTravelCS.add(travelCostCS);

                // Training
                ed524Budget.setBudgetFederalTrainingFourthYearAmount(trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFourthYearAmount(trainingCostCS.bigDecimalValue());

                totalTraining = totalTraining.add(trainingCost);
                totalTrainingCS = totalTrainingCS.add(trainingCostCS);

                // Fringe
                ed524Budget.setBudgetFederalFringeFourthYearAmount(categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFourthYearAmount(categoryCostCSFringe.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(categoryCostCSFringe);
                totalFringe = totalFringe.add(categoryCostFringe);
                totalFringeCS = totalFringeCS.add(categoryCostCSFringe);

                // Personnel
                getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFourthYearAmount(personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFourthYearAmount(personnelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(personnelCostCS);
                totalPersonnel = totalPersonnel.add(personnelCost);
                totalPersonnelCS = totalPersonnelCS.add(personnelCostCS);

                ed524Budget.setBudgetNonFederalDirectFourthYearAmount(totalCategoryCS.bigDecimalValue());
            }
            else if (budgetPeriod.getBudgetPeriod().equals(BudgetPeriodNum.P5.getNum())) {
                totalCategoryCS = ScaleTwoDecimal.ZERO;
                getTotalCosts(budgetPeriod);
                ed524Budget.setBudgetFederalFifthYearAmount(totalCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFifthYearAmount(totalCostSharing.bigDecimalValue());
                ed524Budget.setBudgetFederalDirectFifthYearAmount(totalDirectCost.bigDecimalValue());
                ed524Budget.setBudgetFederalIndirectFifthYearAmount(totalIndirectCost.bigDecimalValue());

                totalCostAllYrs = totalCostAllYrs.add(totalCost);
                totalCostSharingAllYrs = totalCostSharingAllYrs.add(totalCostSharing);
                totalDirectCostAllYrs = totalDirectCostAllYrs.add(totalDirectCost);
                totalIndirectCostAllYrs = totalIndirectCostAllYrs.add(totalIndirectCost);

                // Total Indirect Cost Sharing
                getIndirectCosts(budgetPeriod);
                ed524Budget.setBudgetNonFederalIndirectFifthYearAmount(indirectCS.bigDecimalValue());
                totalIndirectCostAllYrsCS = totalIndirectCostAllYrsCS.add(indirectCS);

                // Supplies
                getSuppliesCosts(budgetPeriod);
                ed524Budget.setBudgetFederalSuppliesFifthYearAmount(supplyCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalSuppliesFifthYearAmount(supplyCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(supplyCostCS);
                totalSupplies = totalSupplies.add(supplyCost);
                totalSuppliesCS = totalSuppliesCS.add(supplyCostCS);

                // Construction
                // Set to zero as it set hard coded as 0 in the procedure

                ed524Budget.setBudgetFederalConstructionFifthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());
                ed524Budget.setBudgetNonFederalConstructionFifthYearAmount(ScaleTwoDecimal.ZERO.bigDecimalValue());


                // Other
                getOtherCosts(budgetPeriod);
                ed524Budget.setBudgetFederalOtherFifthYearAmount(otherCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalOtherFifthYearAmount(otherCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(otherCostCS);
                totalOther = totalOther.add(otherCost);
                totalOtherCS = totalOtherCS.add(otherCostCS);

                // Equipment
                getEquipmentCosts(budgetPeriod);
                ed524Budget.setBudgetFederalEquipmentFifthYearAmount(equipmentCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalEquipmentFifthYearAmount(equipmentCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(equipmentCostCS);
                totalEquip = totalEquip.add(equipmentCost);
                totalEquipCS = totalEquipCS.add(equipmentCostCS);

                // Contractual
                getContractualCosts(budgetPeriod);
                ed524Budget.setBudgetFederalContractualFifthYearAmount(contractualCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalContractualFifthYearAmount(contractualCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(contractualCostCS);
                totalContractual = totalContractual.add(contractualCost);
                totalContractualCS = totalContractualCS.add(contractualCostCS);

                // Travel
                getTravelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalTravelFifthYearAmount(travelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTravelFifthYearAmount(travelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(travelCostCS);
                totalTravel = totalTravel.add(travelCost);
                totalTravelCS = totalTravelCS.add(travelCostCS);

                // Training
                ed524Budget.setBudgetFederalTrainingFifthYearAmount(trainingCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalTrainingFifthYearAmount(trainingCostCS.bigDecimalValue());

                totalTraining = totalTraining.add(trainingCost);
                totalTrainingCS = totalTrainingCS.add(trainingCostCS);

                // Fringe
                ed524Budget.setBudgetFederalFringeFifthYearAmount(categoryCostFringe.bigDecimalValue());
                ed524Budget.setBudgetNonFederalFringeFifthYearAmount(categoryCostCSFringe.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(categoryCostCSFringe);
                totalFringe = totalFringe.add(categoryCostFringe);
                totalFringeCS = totalFringeCS.add(categoryCostCSFringe);

                // Personnel
                getPersonnelCosts(budgetPeriod);
                ed524Budget.setBudgetFederalPersonnelFifthYearAmount(personnelCost.bigDecimalValue());
                ed524Budget.setBudgetNonFederalPersonnelFifthYearAmount(personnelCostCS.bigDecimalValue());

                totalCategoryCS = totalCategoryCS.add(personnelCostCS);
                totalPersonnel = totalPersonnel.add(personnelCost);
                totalPersonnelCS = totalPersonnelCS.add(personnelCostCS);

                ed524Budget.setBudgetNonFederalDirectFifthYearAmount(totalCategoryCS.bigDecimalValue());
            }
        }// end of main for loop
        ed524Budget.setBudgetFederalPersonnelTotalAmount(totalPersonnel.bigDecimalValue());
        ed524Budget.setBudgetNonFederalPersonnelTotalAmount(totalPersonnelCS.bigDecimalValue());
        ed524Budget.setBudgetFederalFringeTotalAmount(totalFringe.bigDecimalValue());
        ed524Budget.setBudgetNonFederalFringeTotalAmount(totalFringeCS.bigDecimalValue());
        ed524Budget.setBudgetFederalTravelTotalAmount(totalTravel.bigDecimalValue());

        ed524Budget.setBudgetNonFederalTravelTotalAmount(totalTravelCS.bigDecimalValue());
        ed524Budget.setBudgetFederalEquipmentTotalAmount(totalEquip.bigDecimalValue());
        ed524Budget.setBudgetNonFederalEquipmentTotalAmount(totalEquipCS.bigDecimalValue());
        ed524Budget.setBudgetFederalContractualTotalAmount(totalContractual.bigDecimalValue());

        ed524Budget.setBudgetNonFederalContractualTotalAmount(totalContractualCS.bigDecimalValue());
        ed524Budget.setBudgetFederalSuppliesTotalAmount(totalSupplies.bigDecimalValue());
        ed524Budget.setBudgetNonFederalSuppliesTotalAmount(totalSuppliesCS.bigDecimalValue());
        ed524Budget.setBudgetFederalConstructionTotalAmount(totalConstruction.bigDecimalValue());

        ed524Budget.setBudgetNonFederalConstructionTotalAmount(totalConstructionCS.bigDecimalValue());
        ed524Budget.setBudgetFederalTrainingTotalAmount(totalTraining.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTrainingTotalAmount(totalTrainingCS.bigDecimalValue());
        if (totalOther.longValue() < 0) {
            ed524Budget.setBudgetFederalOtherTotalAmount(BigDecimal.ZERO);
        }
        else {
            ed524Budget.setBudgetFederalOtherTotalAmount(totalOther.bigDecimalValue());
        }
        ed524Budget.setBudgetNonFederalOtherTotalAmount(totalOtherCS.bigDecimalValue());

        totalDirectCostAllYrsCS = totalPersonnelCS.add(totalFringeCS).add(totalTravelCS).add(totalEquipCS).add(totalContractualCS)
                .add(totalConstructionCS).add(totalSuppliesCS).add(totalOtherCS);
        ed524Budget.setBudgetNonFederalDirectTotalAmount(totalDirectCostAllYrsCS.bigDecimalValue());
        ed524Budget.setBudgetNonFederalIndirectTotalAmount(totalIndirectCostAllYrsCS.bigDecimalValue());
        ed524Budget.setBudgetFederalIndirectTotalAmount(totalIndirectCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetFederalTotalAmount(totalCostAllYrs.bigDecimalValue());

        ed524Budget.setBudgetFederalDirectTotalAmount(totalDirectCostAllYrs.bigDecimalValue());
        ed524Budget.setBudgetNonFederalTotalAmount(totalCostSharingAllYrs.bigDecimalValue());

        ed524Budget.setIndirectCost(populateIndirectCost(budget));
        ed524BudgetDocument.setED524Budget13(ed524Budget);
        return ed524BudgetDocument;
    }

    private IndirectCost populateIndirectCost(ProposalDevelopmentBudgetExtContract budget) {
        IndirectCost indirectCost = IndirectCost.Factory.newInstance();
        IndirectCostRateAgreementApproved indirectCostRateAgreementApproved = IndirectCostRateAgreementApproved.Factory.newInstance();
        indirectCost.setIsIndirectCostRateAgreementApproved(YesNoDataType.Y_YES);

        indirectCost.setIndirectCostRateAgreementApproved(indirectCostRateAgreementApproved);
        indirectCost.getIndirectCostRateAgreementApproved().setIndirectCostRatePercentage(getIndirectCostRate(budget));
        String agencyName = getAgencyName();

        if (agencyName.equals(APPROVING_FEDERAL_AGENCY_ED)) {
            indirectCost.getIndirectCostRateAgreementApproved().setApprovingFederalAgency(ApprovingFederalAgencyDataType.ED);
        }
        else {
            indirectCost.getIndirectCostRateAgreementApproved().setApprovingFederalAgency(ApprovingFederalAgencyDataType.OTHER);
            indirectCost.getIndirectCostRateAgreementApproved().setOtherApprovingFederalAgency(agencyName);
        }
        populateFromOrganizationIdc(indirectCost);
        return indirectCost;
    }

    protected BigDecimal getIndirectCostRate(ProposalDevelopmentBudgetExtContract budget) {

        return BigDecimal.valueOf(budget.getBudgetRates().stream().filter(rate ->
                rate.getRateClass().getRateClassType().getCode().equalsIgnoreCase(OVERHEAD) &&
                        rate.getRateType().getRateTypeCode().equalsIgnoreCase(budget.getOhRateTypeCode()) &&
                        rate.getRateClass().getCode().equalsIgnoreCase(budget.getRateClass().getCode()) &&
                        rate.getOnOffCampusFlag().compareTo(getOnOfCampusFlag(budget.getOnOffCampusFlag())) == 0).
                findFirst().get().getInstituteRate().doubleValue());
    }

    protected boolean getOnOfCampusFlag(String onOffCampusFlag) {
        return (onOffCampusFlag.equalsIgnoreCase(DEFAULT) || onOffCampusFlag.equalsIgnoreCase(ON_CAMPUS)) ? Boolean.TRUE : Boolean.FALSE;
    }

    private void populateFromOrganizationIdc(IndirectCost indirectCost) {
        final List<? extends AnswerContract> questionnaireAnswers = getPropDevQuestionAnswerService().getQuestionnaireAnswers(pdDoc.getDevelopmentProposal().getProposalNumber(),
                getNamespace(), getFormName());
        String answer;
        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionSeqId();
            if (QUESTION_ID == questionId) {
                if (YnqConstant.YES.code().equals(answer)) {
                    final List<? extends OrganizationIndirectcostContract> organizationIdcs = pdDoc.getDevelopmentProposal().getApplicantOrganization().
                                                                                                getOrganization().getOrganizationIdcs();
                    if (!organizationIdcs.isEmpty()) {
                        OrganizationIndirectcostContract idc = organizationIdcs.get(organizationIdcs.size() - 1);

                        final Date endDate = idc.getEndDate();
                        indirectCost.getIndirectCostRateAgreementApproved().setIndirectCostRateAgreementToDate(s2SDateTimeService.convertDateToCalendar(endDate));
                        final Date startDate = idc.getStartDate();
                        indirectCost.getIndirectCostRateAgreementApproved().setIndirectCostRateAgreementFromDate(s2SDateTimeService.convertDateToCalendar(startDate));

                        indirectCost.setRestrictedPercentage(idc.getApplicableIndirectcostRate().bigDecimalValue());
                        if ("I".equalsIgnoreCase(idc.getRestrictedRatePolicy())) {
                            indirectCost.setRestrictedIndirectCostRate(IndirectCost.RestrictedIndirectCostRate.IS_INCLUDED_IN_YOUR_APPROVED_INDIRECT_COST_RATE_AGREEMENT);
                        } else if ("C".equalsIgnoreCase(idc.getRestrictedRatePolicy())) {
                            indirectCost.setRestrictedIndirectCostRate(IndirectCost.RestrictedIndirectCostRate.COMPLIES_WITH_34_CFR_76_564_C_2);
                        }
                    }
                }
            }
        }
    }

    @Override
    public ED524Budget13Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {

        this.pdDoc = proposalDevelopmentDocument;
        return getED524Budget();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(ED524Budget13Document form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<ED524Budget13Document> factory() {
        return ED524Budget13Document.Factory;
    }
}
