/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398ResearchTrainingProgramPlan50V50.PHS398ResearchTrainingProgramPlan50Document;
import gov.grants.apply.forms.phs398ResearchTrainingProgramPlan50V50.PHS398ResearchTrainingProgramPlan50Document.PHS398ResearchTrainingProgramPlan50;
import gov.grants.apply.forms.phs398ResearchTrainingProgramPlan50V50.PHS398ResearchTrainingProgramPlan50Document.PHS398ResearchTrainingProgramPlan50.ResearchTrainingProgramPlanAttachments;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

@FormGenerator("PHS398ResTrainProgPlanV5_0Generator")
public class PHS398ResTrainProgPlanV5_0Generator extends S2SBaseFormGenerator<PHS398ResearchTrainingProgramPlan50Document> implements S2SFormGeneratorPdfFillable<PHS398ResearchTrainingProgramPlan50Document> {
    private static final int PHS_RES_TRAINING_PLAN_INTRODUCTION_112 = 112;
    private static final int PHS_RES_TRAINING_PLAN_METHODS_ENHANCE_REPRO_151 = 151;
    private static final int PHS_RES_TRAINING_PLAN_PROGRAM_PLAN_114 = 114;
    private static final int PHS_RES_TRAINING_PLAN_RESP_CONDUCT_SEARCH_116 = 116;
    private static final int PHS_RES_TRAINING_PLAN_PROGRESS_REPORT_117 = 117;
    private static final int PHS_RES_TRAINING_PLAN_SELECT_AGENT_SEARCH_120 = 120;
    private static final int PHS_RES_TRAINING_PLAN_VERT_ANIMALS_119 = 119;
    private static final int PHS_RES_TRAINING_PLAN_PI_LEADERSHIP_PLAN_121 = 121;
    private static final int PHS_RES_TRAINING_PLAN_CONS_CONTRACTUAL_122 = 122;
    private static final int PHS_RES_TRAINING_PLAN_FAC_BIOSKETCHES_123 = 123;
    private static final int PHS_RES_TRAINING_PLAN_DATA_TABLES_124 = 124;
    private static final int PHS_RES_TRAINING_PLAN_SUPPORT_LETTERS_125 = 125;
    private static final int PHS_RES_TRAINING_PLAN_APPENDIX_126 = 126;

    private static final int PHS_RES_TRAINING_PLAN_OTHER_PLANS = 193;

    @Value("http://apply.grants.gov/forms/PHS398_ResearchTrainingProgramPlan_5_0-V5.0")
    private String namespace;

    @Value("PHS398_ResearchTrainingProgramPlan_5_0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_ResearchTrainProPlan-V5.0.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_ResearchTrainingProgramPlan_5_0-V5.0.pdf")
    private Resource pdfForm;

    @Value("187")
    private int sortIndex;

    private PHS398ResearchTrainingProgramPlan50 getPHS398ResearchTrainingProgramPlan(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        DevelopmentProposalContract developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        PHS398ResearchTrainingProgramPlan50 phs398ResTrainProgPlan = PHS398ResearchTrainingProgramPlan50.Factory.newInstance();

        ResearchTrainingProgramPlanAttachments researchTrainingProgramPlanAttachments = ResearchTrainingProgramPlanAttachments.Factory.newInstance();

        phs398ResTrainProgPlan.setFormVersion(FormVersion.v5_0.getVersion());
        List<AttachedFileDataType> attachedFileDataTypes = new ArrayList<>();

        AttachedFileDataType attachedFileDataType;
        for (NarrativeContract narrative : developmentProposal.getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                    case (PHS_RES_TRAINING_PLAN_INTRODUCTION_112):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.IntroductionToApplication introductionToApplication = researchTrainingProgramPlanAttachments.addNewIntroductionToApplication();
                            introductionToApplication.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_METHODS_ENHANCE_REPRO_151):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.MethodsForEnhancingReproducibility reproducibility = researchTrainingProgramPlanAttachments.addNewMethodsForEnhancingReproducibility();
                            reproducibility.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_PROGRAM_PLAN_114):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.ProgramPlan programPlan = researchTrainingProgramPlanAttachments.addNewProgramPlan();
                            programPlan.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_RESP_CONDUCT_SEARCH_116):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.ResponsibleConductOfResearch responsibleConductOfResearch = researchTrainingProgramPlanAttachments.addNewResponsibleConductOfResearch();
                            responsibleConductOfResearch.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_PROGRESS_REPORT_117):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.ProgressReport progressReport = researchTrainingProgramPlanAttachments.addNewProgressReport();
                            progressReport.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_SELECT_AGENT_SEARCH_120):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.SelectAgentResearch selectAgentResearch = researchTrainingProgramPlanAttachments.addNewSelectAgentResearch();
                            selectAgentResearch.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_VERT_ANIMALS_119):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.VertebrateAnimals vertebrateAnimals = researchTrainingProgramPlanAttachments.addNewVertebrateAnimals();
                            vertebrateAnimals.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_PI_LEADERSHIP_PLAN_121):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.MultiplePDPILeadershipPlan multiplePDPILeadershipPlan = researchTrainingProgramPlanAttachments.addNewMultiplePDPILeadershipPlan();
                            multiplePDPILeadershipPlan.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_CONS_CONTRACTUAL_122):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.ConsortiumContractualArrangements consortiumContractualArrangements = researchTrainingProgramPlanAttachments.addNewConsortiumContractualArrangements();
                            consortiumContractualArrangements.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_FAC_BIOSKETCHES_123):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.ParticipatingFacultyBiosketches participatingFacultyBiosketches = researchTrainingProgramPlanAttachments.addNewParticipatingFacultyBiosketches();
                            participatingFacultyBiosketches.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_DATA_TABLES_124):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.DataTables dataTables = researchTrainingProgramPlanAttachments.addNewDataTables();
                            dataTables.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_SUPPORT_LETTERS_125):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.LettersOfSupport lettersOfSupport = researchTrainingProgramPlanAttachments.addNewLettersOfSupport();
                            lettersOfSupport.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_OTHER_PLANS):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResearchTrainingProgramPlanAttachments.OtherPlans otherPlans = researchTrainingProgramPlanAttachments.addNewOtherPlans();
                            otherPlans.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_APPENDIX_126):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            attachedFileDataTypes.add(attachedFileDataType);
                        }
                        break;
                }
            }
        }
        if (!attachedFileDataTypes.isEmpty()) {
            AttachmentGroupMin0Max100DataType attachmentGroup = researchTrainingProgramPlanAttachments.addNewAppendix();
            attachmentGroup.setAttachedFileArray(attachedFileDataTypes.toArray(new AttachedFileDataType[0]));
        }

        if (researchTrainingProgramPlanAttachments != null) {
            phs398ResTrainProgPlan.setResearchTrainingProgramPlanAttachments(researchTrainingProgramPlanAttachments);
            setMandatoryAttachments(researchTrainingProgramPlanAttachments);
        }

        return phs398ResTrainProgPlan;
    }

    /**
     * This set any mandatory attachments that aren't set to blank objects so that validation errors can be more user friendly.
     */
    private void setMandatoryAttachments(ResearchTrainingProgramPlanAttachments researchTrainingProgramPlanAttachments) {
        if (researchTrainingProgramPlanAttachments.getProgramPlan() == null) {
            researchTrainingProgramPlanAttachments.setProgramPlan(ResearchTrainingProgramPlanAttachments.ProgramPlan.Factory.newInstance());
        }
    }

    @Override
    public PHS398ResearchTrainingProgramPlan50Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        PHS398ResearchTrainingProgramPlan50 phs398ResearchTrainingProgramPlan = getPHS398ResearchTrainingProgramPlan(proposalDevelopmentDocument);
        PHS398ResearchTrainingProgramPlan50Document pHS398ResearchTrainingProgramPlan50Document = PHS398ResearchTrainingProgramPlan50Document.Factory.newInstance();
        pHS398ResearchTrainingProgramPlan50Document.setPHS398ResearchTrainingProgramPlan50(phs398ResearchTrainingProgramPlan);
        return pHS398ResearchTrainingProgramPlan50Document;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(PHS398ResearchTrainingProgramPlan50Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            final ResearchTrainingProgramPlanAttachments researchTrainingProgramPlanAttachments = form.getPHS398ResearchTrainingProgramPlan50().getResearchTrainingProgramPlanAttachments();
            if (researchTrainingProgramPlanAttachments != null) {
                final ResearchTrainingProgramPlanAttachments.IntroductionToApplication introductionToApplication = researchTrainingProgramPlanAttachments.getIntroductionToApplication();
                if (introductionToApplication != null && introductionToApplication.getAttFile() != null && a.getContentId().equals(introductionToApplication.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile0", a);
                }

                final ResearchTrainingProgramPlanAttachments.ProgramPlan programPlan = researchTrainingProgramPlanAttachments.getProgramPlan();
                if (programPlan != null && programPlan.getAttFile() != null && a.getContentId().equals(programPlan.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.mandatoryFile0", a);
                }

                final ResearchTrainingProgramPlanAttachments.ResponsibleConductOfResearch responsibleConductOfResearch = researchTrainingProgramPlanAttachments.getResponsibleConductOfResearch();
                if (responsibleConductOfResearch != null && responsibleConductOfResearch.getAttFile() != null && a.getContentId().equals(responsibleConductOfResearch.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile1", a);
                }

                final ResearchTrainingProgramPlanAttachments.MethodsForEnhancingReproducibility methodsForEnhancingReproducibility = researchTrainingProgramPlanAttachments.getMethodsForEnhancingReproducibility();
                if (methodsForEnhancingReproducibility != null && methodsForEnhancingReproducibility.getAttFile() != null && a.getContentId().equals(methodsForEnhancingReproducibility.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile2", a);
                }

                final ResearchTrainingProgramPlanAttachments.MultiplePDPILeadershipPlan multiplePDPILeadershipPlan = researchTrainingProgramPlanAttachments.getMultiplePDPILeadershipPlan();
                if (multiplePDPILeadershipPlan != null && multiplePDPILeadershipPlan.getAttFile() != null && a.getContentId().equals(multiplePDPILeadershipPlan.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile3", a);
                }

                final ResearchTrainingProgramPlanAttachments.ProgressReport progressReport = researchTrainingProgramPlanAttachments.getProgressReport();
                if (progressReport != null && progressReport.getAttFile() != null && a.getContentId().equals(progressReport.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile4", a);
                }

                final ResearchTrainingProgramPlanAttachments.ParticipatingFacultyBiosketches participatingFacultyBiosketches = researchTrainingProgramPlanAttachments.getParticipatingFacultyBiosketches();
                if (participatingFacultyBiosketches != null && participatingFacultyBiosketches.getAttFile() != null && a.getContentId().equals(participatingFacultyBiosketches.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile5", a);
                }

                final ResearchTrainingProgramPlanAttachments.LettersOfSupport lettersOfSupport = researchTrainingProgramPlanAttachments.getLettersOfSupport();
                if (lettersOfSupport != null && lettersOfSupport.getAttFile() != null && a.getContentId().equals(lettersOfSupport.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile6", a);
                }

                final ResearchTrainingProgramPlanAttachments.DataTables dataTables = researchTrainingProgramPlanAttachments.getDataTables();
                if (dataTables != null && dataTables.getAttFile() != null && a.getContentId().equals(dataTables.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile7", a);
                }

                final ResearchTrainingProgramPlanAttachments.VertebrateAnimals vertebrateAnimals = researchTrainingProgramPlanAttachments.getVertebrateAnimals();
                if (vertebrateAnimals != null && vertebrateAnimals.getAttFile() != null && a.getContentId().equals(vertebrateAnimals.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile8", a);
                }

                final ResearchTrainingProgramPlanAttachments.SelectAgentResearch selectAgentResearch = researchTrainingProgramPlanAttachments.getSelectAgentResearch();
                if (selectAgentResearch != null && selectAgentResearch.getAttFile() != null && a.getContentId().equals(selectAgentResearch.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile9", a);
                }

                final ResearchTrainingProgramPlanAttachments.ConsortiumContractualArrangements consortiumContractualArrangements = researchTrainingProgramPlanAttachments.getConsortiumContractualArrangements();
                if (consortiumContractualArrangements != null && consortiumContractualArrangements.getAttFile() != null && a.getContentId().equals(consortiumContractualArrangements.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile10", a);
                }

                final ResearchTrainingProgramPlanAttachments.OtherPlans otherPlans = researchTrainingProgramPlanAttachments.getOtherPlans();
                if (otherPlans != null && otherPlans.getAttFile() != null && a.getContentId().equals(otherPlans.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile11", a);
                }

                final AttachmentGroupMin0Max100DataType appendix = researchTrainingProgramPlanAttachments.getAppendix();
                if (appendix != null && appendix.getAttachedFileList() != null) {
                    final List<AttachedFileDataType> atts = appendix.getAttachedFileList();
                    for (int i = 0; i < atts.size(); i++) {
                        final AttachedFileDataType att = atts.get(i);

                        if (att != null && a.getContentId().equals(att.getFileLocation().getHref())) {
                            return entry("PHS398_ResearchTrainingProgramPlan_5_0_P1.optionalFile_12_" + i, a);
                        }
                    }
                }
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHS398ResearchTrainingProgramPlan50Document> factory() {
        return PHS398ResearchTrainingProgramPlan50Document.Factory;
    }
}
