/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.ProtectionMonitoringPlans.DataSafetyMonitoringPlan;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.ProtectionMonitoringPlans.IRBPlan;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.ProtectionMonitoringPlans.ProtectionOfHumanSubjects;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.ProtectionMonitoringPlans.StudyTeamStructure;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.ProtocolSynopsis.DisseminationPlan;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.ProtocolSynopsis.InvestigationalAvailability;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.ProtocolSynopsis.StatisticalDesignPower;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.StudyPopulationCharacteristics;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.StudyPopulationCharacteristics.InclusionOfIndividualsAcrossLifespan;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.StudyPopulationCharacteristics.InclusionOfWomenAndMinorities;
import gov.grants.apply.forms.humanSubjectStudy20V20.HumanSubjectStudy20Document.HumanSubjectStudy20.StudyPopulationCharacteristics.RecruitmentAndRetentionPlan;
import gov.grants.apply.forms.phsHumanSubjectsAndClinicalTrialsInfo20V20.PHSHumanSubjectsAndClinicalTrialsInfo20Document;
import gov.grants.apply.forms.phsHumanSubjectsAndClinicalTrialsInfo20V20.PHSHumanSubjectsAndClinicalTrialsInfo20Document.PHSHumanSubjectsAndClinicalTrialsInfo20;
import gov.grants.apply.forms.phsHumanSubjectsAndClinicalTrialsInfo20V20.PHSHumanSubjectsAndClinicalTrialsInfo20Document.PHSHumanSubjectsAndClinicalTrialsInfo20.ExemptionNumbers;
import gov.grants.apply.forms.phsHumanSubjectsAndClinicalTrialsInfo20V20.PHSHumanSubjectsAndClinicalTrialsInfo20Document.PHSHumanSubjectsAndClinicalTrialsInfo20.Explanation;
import gov.grants.apply.forms.phsHumanSubjectsAndClinicalTrialsInfo20V20.PHSHumanSubjectsAndClinicalTrialsInfo20Document.PHSHumanSubjectsAndClinicalTrialsInfo20.OtherRequestedInformation;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.globalV10.HashValueDocument;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.*;
import org.kuali.coeus.sys.api.model.KcFile;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

@FormGenerator("PHSHumanSubjectsAndClinicalTrialsInfo_2_0V2_0Generator")
public class PHSHumanSubjectsAndClinicalTrialsInfo_2_0V2_0Generator extends S2SBaseFormGenerator<PHSHumanSubjectsAndClinicalTrialsInfo20Document> implements S2SFormGeneratorPdfFillable<PHSHumanSubjectsAndClinicalTrialsInfo20Document>, InitializingBean {

    private static final String APPROVAL_TYPE_EXCEMPT = "4";
    private static final String HUMAN_SUBJECT = "1";
    private static final String OTHER_REQUESTED_INFO_NARRATIVE_TYPE_CODE = "-4";
    private static final String EXPLANATION_NARRATIVE_TYPE_CODE = "-3";
    private static final int INVOLVE_HUMAN_QUESTION_SEQ_ID = -10130;
    private static final String FILES = "files";
    private static final String CONTENT = "content";
    private static final String Y = "Y";
    private static final String INVALID_HUMAN_STUDIES_ATTACHMENT = "Invalid Human Studies Attachment";

    @Value("http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0")
    private String namespace;

    @Value("PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHSHumanSubjectsAndClinicalTrialsInfo-V2.0.xsl")
    private Resource page1;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection1-V2.0-modified.xsl")
    private Resource page2;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection2-V2.0-modified.xsl")
    private Resource page3;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ClinicalTrialInclusionEnrollmentReport-V2.0-modified.xsl")
    private Resource page4;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection3-V2.0-modified.xsl")
    private Resource page5;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection4-V2.0-modified.xsl")
    private Resource page6;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection5-V2.0-modified.xsl")
    private Resource page7;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHSHumanSubjectsAndClinicalTrialsDelayedOnsetStudy-V2.0.xsl")
    private Resource page8;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0.pdf")
    private Resource pdfForm;

    @Value("197")
    private int sortIndex;

    private List<Resource> stylesheets;

    @Override
    public String getNamespace() {
        return namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    @Override
    public PHSHumanSubjectsAndClinicalTrialsInfo20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {

        this.pdDoc = proposalDevelopmentDocument;

        final PHSHumanSubjectsAndClinicalTrialsInfo20Document document = PHSHumanSubjectsAndClinicalTrialsInfo20Document.Factory.newInstance();
        final PHSHumanSubjectsAndClinicalTrialsInfo20 info = PHSHumanSubjectsAndClinicalTrialsInfo20.Factory.newInstance();
        info.setFormVersion(FormVersion.v2_0.getVersion());

        if (pdDoc.getDevelopmentProposal().getPropSpecialReviews().isEmpty()) {
            info.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        }

        final List<PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy> delayedOnsetStudiesList = new ArrayList<>();
        final List<HumanSubjectStudy20Document.HumanSubjectStudy20> humanSubjectsStudyList = new ArrayList<>();

        final List<ProposalSpecialReviewContract> humanSpecialreviews = pdDoc.getDevelopmentProposal().getPropSpecialReviews().stream()
                .filter(Objects::nonNull)
                .filter(specialReview -> Objects.nonNull(specialReview.getSpecialReviewType()))
                .filter(specialReview -> HUMAN_SUBJECT.equals(specialReview.getSpecialReviewType().getCode()))
                .collect(Collectors.toList());

        if (CollectionUtils.isNotEmpty(humanSpecialreviews)) {
            info.setHumanSubjectsIndicator(YesNoDataType.Y_YES);

            final AttachedFileDataType attachment = getAttachedFileDataType(OTHER_REQUESTED_INFO_NARRATIVE_TYPE_CODE);
            if (attachment != null) {
                final OtherRequestedInformation otherInfo = OtherRequestedInformation.Factory.newInstance();
                otherInfo.setAttFile(attachment);
                info.setOtherRequestedInformation(otherInfo);
            }

            humanSpecialreviews.forEach(humanSpecialreview -> setDelayedOnsetAndHumanSubjectStudy(delayedOnsetStudiesList, humanSubjectsStudyList, humanSpecialreview));
        } else {
            info.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        }

        final Set<Integer> exemptionNumbers = humanSpecialreviews.stream()
                .filter(specialReview -> Objects.nonNull(specialReview.getApprovalType()))
                .filter(specialReview -> APPROVAL_TYPE_EXCEMPT.equalsIgnoreCase(specialReview.getApprovalType().getCode()))
                .filter(specialReview -> Objects.nonNull(specialReview.getSpecialReviewExemptions()))
                .flatMap(specialReview -> specialReview.getSpecialReviewExemptions().stream())
                .filter(Objects::nonNull)
                .map(e -> e.getExemptionType().getCode())
                .map(Integer::parseInt)
                .filter(c -> c > 0 && c < 9)
                .collect(Collectors.toSet());

        if (CollectionUtils.isNotEmpty(exemptionNumbers)) {
            info.setExemptFedReg(YesNoDataType.Y_YES);

            final ExemptionNumbers en = ExemptionNumbers.Factory.newInstance();
            en.setExemptionNumberArray(exemptionNumbers.stream()
                    .map(ExemptionNumbers.ExemptionNumber.Enum::forInt)
                    .toArray(ExemptionNumbers.ExemptionNumber.Enum[]::new));

            info.setExemptionNumbers(en);
        } else {
            info.setExemptFedReg(YesNoDataType.N_NO);
        }

        final List<? extends AnswerHeaderContract> answerHeaders = getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(pdDoc.getDevelopmentProposal().getProposalNumber());
        final String involveHumanSpecimens = getAnswer(INVOLVE_HUMAN_QUESTION_SEQ_ID, answerHeaders);

        if (StringUtils.isNotBlank(involveHumanSpecimens)) {
            if (Y.equals(involveHumanSpecimens)) {
                info.setInvolveHumanSpecimens(YesNoDataType.Y_YES);
                final AttachedFileDataType attachment = getAttachedFileDataType(EXPLANATION_NARRATIVE_TYPE_CODE);
                final Explanation explanation = Explanation.Factory.newInstance();
                if (attachment != null) {
                    explanation.setAttFile(attachment);
                    info.setExplanation(explanation);
                }
            } else {
                info.setInvolveHumanSpecimens(YesNoDataType.N_NO);
            }
        }

        consolidateAllDelayedOnsetAndHumanSubjectStudies(info, delayedOnsetStudiesList, humanSubjectsStudyList);
        document.setPHSHumanSubjectsAndClinicalTrialsInfo20(info);
        return document;
    }

    private void setDelayedOnsetAndHumanSubjectStudy(List<PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy> delayedOnsetStudiesList,
                                                     List<HumanSubjectStudy20Document.HumanSubjectStudy20> humanSubjectsStudyList,
                                                     ProposalSpecialReviewContract sr) {
        if (sr.getSpecialReviewAttachment() != null && sr.getSpecialReviewAttachment().getData() != null) {
            if (!sr.getSpecialReviewAttachment().isAttachmentDelayedOnset()) {
                try {
                    final Map<String, Object> fileData = sr.getSpecialReviewAttachment().getSpecialReviewAttachmentXmlFileData();
                    if (fileData != null) {
                        setHumanSubjectStudy(humanSubjectsStudyList, fileData);
                    } else {
                        getAuditErrors().add(new AuditError(AuditError.NO_FIELD_ERROR_KEY, INVALID_HUMAN_STUDIES_ATTACHMENT, AuditError.GG_LINK));
                    }
                } catch (S2SException e) {
                    getAuditErrors().add(new AuditError(AuditError.NO_FIELD_ERROR_KEY, INVALID_HUMAN_STUDIES_ATTACHMENT, AuditError.GG_LINK));
                } catch (XmlException e) {
                    throw new RuntimeException(e);
                }
            } else {
                PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy study = getDelayedOnsetStudy(sr);
                delayedOnsetStudiesList.add(study);
            }
        }
    }

    private void consolidateAllDelayedOnsetAndHumanSubjectStudies(PHSHumanSubjectsAndClinicalTrialsInfo20 info,
                                                                  List<PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy> delayedOnsetStudiesList,
                                                                  List<HumanSubjectStudy20Document.HumanSubjectStudy20> humanSubjectsStudyList) {

        if (!delayedOnsetStudiesList.isEmpty()) {
            PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy[] delayedOnsetStudiesArray =
                    delayedOnsetStudiesList.toArray(new PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy[0]);
            info.setDelayedOnsetStudyArray(delayedOnsetStudiesArray);
        }

        if (!humanSubjectsStudyList.isEmpty()) {
            HumanSubjectStudy20Document.HumanSubjectStudy20[] humanSubjectsStudyArray =
                    humanSubjectsStudyList.toArray(new HumanSubjectStudy20Document.HumanSubjectStudy20[0]);
            PHSHumanSubjectsAndClinicalTrialsInfo20.HumanSubjectStudyAttachment humanSubjectStudyAttachment = PHSHumanSubjectsAndClinicalTrialsInfo20.HumanSubjectStudyAttachment.Factory.newInstance();
            humanSubjectStudyAttachment.setHumanSubjectStudy20Array(humanSubjectsStudyArray);
            info.setHumanSubjectStudyAttachment(humanSubjectStudyAttachment);
        }
    }

    @SuppressWarnings("unchecked")
    private void setHumanSubjectStudy(List<HumanSubjectStudy20Document.HumanSubjectStudy20> humanSubjectsStudyList, Map<String, Object> fileData) throws XmlException {
        final String xmlContent = (String) fileData.get(CONTENT);
        final List<KcFile> files = (List<KcFile>) fileData.get(FILES);

        try {
            final String grantWrapperNS = "declare namespace grantwrapper='http://apply.grants.gov/system/MetaGrantApplicationWrapper';";
            final String grantNS = "declare namespace grant='http://apply.grants.gov/system/MetaGrantApplication';";
            final XmlObject xmlObject = XmlObject.Factory.parse(xmlContent);
            final XmlObject[] forms = xmlObject.selectPath(grantWrapperNS + grantNS + "$this/grantwrapper:GrantApplicationWrapper/grant:GrantApplication/grant:Forms");
            if (forms.length > 0) {
                final HumanSubjectStudy20Document study20Document = HumanSubjectStudy20Document.Factory.parse(forms[0].xmlText(new XmlOptions().setSavePrettyPrint()));
                final HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy = study20Document.getHumanSubjectStudy20();
                setInclOfIndividualAcrossLifespanAttachment(files, currentStudy);
                setInclOfWomenAttachment(files, currentStudy);
                setDataMentoringPlanAttachment(files, currentStudy);
                setDisseminationPlanAttachment(files, currentStudy);
                setInvestigationalAvailabilityAttachment(files, currentStudy);
                setIrbPlanAttachment(files, currentStudy);
                setOtherAttachments(files, currentStudy);
                setRRPlanAttachment(files, currentStudy);
                setStudyTimelineAttachment(files, currentStudy);
                setProtectionOfHumanSubjectsAttachment(files, currentStudy);
                setStudyTimelineAttachment(files, currentStudy);
                setStatDesignPowerAttachment(files, currentStudy);
                setStudyTeamStructureAttachment(files, currentStudy);
                humanSubjectsStudyList.add(currentStudy);
            } else {
                throw new XmlException("Unable to find study");
            }
        } catch (XmlException e) {
            getAuditErrors().add(new AuditError(AuditError.NO_FIELD_ERROR_KEY, INVALID_HUMAN_STUDIES_ATTACHMENT, AuditError.GG_LINK));
        }
    }

    private void setInclOfIndividualAcrossLifespanAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getStudyPopulationCharacteristics() != null) {
            final InclusionOfIndividualsAcrossLifespan inclusionOfIndividualsAcrossLifespan = currentStudy.getStudyPopulationCharacteristics().getInclusionOfIndividualsAcrossLifespan();
            if (inclusionOfIndividualsAcrossLifespan != null && inclusionOfIndividualsAcrossLifespan.getAttFile() != null) {
                final String fileName = inclusionOfIndividualsAcrossLifespan.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> inclusionOfIndividualsAcrossLifespan.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setInclOfWomenAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getStudyPopulationCharacteristics() != null) {
            final InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = currentStudy.getStudyPopulationCharacteristics().getInclusionOfWomenAndMinorities();
            if (inclusionOfWomenAndMinorities != null && inclusionOfWomenAndMinorities.getAttFile() != null) {
                final String fileName = inclusionOfWomenAndMinorities.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> inclusionOfWomenAndMinorities.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setRRPlanAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getStudyPopulationCharacteristics() != null) {
            final RecruitmentAndRetentionPlan recruitmentAndRetentionPlan = currentStudy.getStudyPopulationCharacteristics().getRecruitmentAndRetentionPlan();
            if (recruitmentAndRetentionPlan != null && recruitmentAndRetentionPlan.getAttFile() != null) {
                final String fileName = recruitmentAndRetentionPlan.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> recruitmentAndRetentionPlan.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setStudyTimelineAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getStudyPopulationCharacteristics() != null) {
            final StudyPopulationCharacteristics.StudyTimeline studyTimeline = currentStudy.getStudyPopulationCharacteristics().getStudyTimeline();
            if (studyTimeline != null && studyTimeline.getAttFile() != null) {
                final String fileName = studyTimeline.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> studyTimeline.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setProtectionOfHumanSubjectsAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getProtectionMonitoringPlans() != null) {
            final ProtectionOfHumanSubjects protectionOfHumanSubjects = currentStudy.getProtectionMonitoringPlans().getProtectionOfHumanSubjects();
            if (protectionOfHumanSubjects != null && protectionOfHumanSubjects.getAttFile() != null) {
                final String fileName = protectionOfHumanSubjects.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> protectionOfHumanSubjects.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setIrbPlanAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getProtectionMonitoringPlans() != null) {
            final IRBPlan irbPlan = currentStudy.getProtectionMonitoringPlans().getIRBPlan();
            if (irbPlan != null && irbPlan.getAttFile() != null) {
                final String fileName = irbPlan.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> irbPlan.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setDataMentoringPlanAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getProtectionMonitoringPlans() != null) {
            final DataSafetyMonitoringPlan dataSafetyMonitoringPlan = currentStudy.getProtectionMonitoringPlans().getDataSafetyMonitoringPlan();
            if (dataSafetyMonitoringPlan != null && dataSafetyMonitoringPlan.getAttFile() != null) {
                final String fileName = dataSafetyMonitoringPlan.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> dataSafetyMonitoringPlan.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setStudyTeamStructureAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getProtectionMonitoringPlans() != null) {
            final StudyTeamStructure studyTeamStructure = currentStudy.getProtectionMonitoringPlans().getStudyTeamStructure();
            if (studyTeamStructure != null && studyTeamStructure.getAttFile() != null) {
                final String fileName = studyTeamStructure.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> studyTeamStructure.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setStatDesignPowerAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getProtocolSynopsis() != null) {
            final StatisticalDesignPower statisticalDesignPower = currentStudy.getProtocolSynopsis().getStatisticalDesignPower();
            if (statisticalDesignPower != null && statisticalDesignPower.getAttFile() != null) {
                final String fileName = statisticalDesignPower.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> statisticalDesignPower.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setInvestigationalAvailabilityAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getProtocolSynopsis() != null) {
            final InvestigationalAvailability investigationalAvailability = currentStudy.getProtocolSynopsis().getInvestigationalAvailability();
            if (investigationalAvailability != null && investigationalAvailability.getAttFile() != null) {
                final String fileName = investigationalAvailability.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> investigationalAvailability.setAttFile(addAttachedFileType(fileContent)));

            }
        }
    }

    private void setDisseminationPlanAttachment(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        if (currentStudy.getProtocolSynopsis() != null) {
            final DisseminationPlan disseminationPlan = currentStudy.getProtocolSynopsis().getDisseminationPlan();
            if (disseminationPlan != null && disseminationPlan.getAttFile() != null) {
                final String fileName = disseminationPlan.getAttFile().getFileName();
                findFile(files, fileName).ifPresent(fileContent -> disseminationPlan.setAttFile(addAttachedFileType(fileContent)));
            }
        }
    }

    private void setOtherAttachments(List<KcFile> files, HumanSubjectStudy20Document.HumanSubjectStudy20 currentStudy) {
        final AttachmentGroupMin0Max100DataType otherClinicalTrialAttachment = currentStudy.getOtherClinicalTrialAttachment();
        if (otherClinicalTrialAttachment != null && otherClinicalTrialAttachment.getAttachedFileArray() != null) {
            final AttachmentGroupMin0Max100DataType newOtherClinicalTrialAttachment = AttachmentGroupMin0Max100DataType.Factory.newInstance();
            newOtherClinicalTrialAttachment.setAttachedFileArray(Stream.of(otherClinicalTrialAttachment.getAttachedFileArray())
                    .map(att -> {
                        final String fileName = att.getFileName();
                        final Optional<KcFile> fileContent = findFile(files, fileName);
                        return fileContent.map(this::addAttachedFileType).orElse(null);
                    })
                    .filter(Objects::nonNull)
                    .toArray(AttachedFileDataType[]::new));
            currentStudy.setOtherClinicalTrialAttachment(newOtherClinicalTrialAttachment);
        }
    }

    private Optional<KcFile> findFile(List<KcFile> files, String fileName) {
        return files.stream().filter(a -> a.getName().equals(fileName)).findFirst();
    }

    private PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy getDelayedOnsetStudy(ProposalSpecialReviewContract sr) {
        PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy study = PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy.Factory.newInstance();
        study.setAnticipatedClinicalTrial(sr.getSpecialReviewAttachment().getClinicalTrial() ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
        study.setStudyTitle(sr.getSpecialReviewAttachment().getStudyTitle());
        PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy.Justification justification = PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy.Justification.Factory.newInstance();
        justification.setAttFile(addAttachedFileType(sr.getSpecialReviewAttachment()));
        study.setJustification(justification);
        return study;
    }

    protected AttachedFileDataType addAttachedFileType(KcFile data) {
        if (data != null && data.getData() != null && data.getData().length > 0 ){
            final String fileName = createUniqueFileName(data.getName(), getAttachments());

            final AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            fileLocation.setHref(fileName);

            AttachedFileDataType attachedFileDataType = AttachedFileDataType.Factory.newInstance();
            attachedFileDataType.setFileLocation(fileLocation);
            attachedFileDataType.setFileName(fileName);
            attachedFileDataType.setMimeType(data.getType());
            final HashValueDocument.HashValue hashValue = getHashValue(data.getData());
            attachedFileDataType.setHashValue(hashValue);
            
            addAttachment(new AttachmentData(data.getFileDataId(), fileName, fileName, data.getData(), data.getType(), hashValue.getHashAlgorithm(), hashValue.getStringValue(), data.getUploadUser(), data.getUploadTimestamp()));
            return attachedFileDataType;
        }
        return null;
    }

    String createUniqueFileName(String fileName, List<AttachmentData> currentAttachments) {
        final List<String> matchingNames = currentAttachments.stream()
                .map(AttachmentData::getFileName)
                .filter(f -> f.endsWith(fileName))
                .collect(Collectors.toList());

        if (matchingNames.isEmpty()) {
            return createUniqueFileName(1, fileName);
        } else {
            for (int i = 0; i < matchingNames.size(); i++) {
                final String newFileName = createUniqueFileName(i + 1, fileName);
                if (!matchingNames.contains(newFileName)) {
                    return newFileName;
                }
            }
            return createUniqueFileName(matchingNames.size() + 1, fileName);
        }
    }

    private String createUniqueFileName(int num, String fileName) {
        return "HS-" + num + "-" + fileName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public Resource getPage1() {
        return page1;
    }

    public void setPage1(Resource page1) {
        this.page1 = page1;
    }

    public Resource getPage2() {
        return page2;
    }

    public void setPage2(Resource page2) {
        this.page2 = page2;
    }

    public Resource getPage3() {
        return page3;
    }

    public void setPage3(Resource page3) {
        this.page3 = page3;
    }

    public Resource getPage4() {
        return page4;
    }

    public void setPage4(Resource page4) {
        this.page4 = page4;
    }

    public Resource getPage5() {
        return page5;
    }

    public void setPage5(Resource page5) {
        this.page5 = page5;
    }

    public Resource getPage6() {
        return page6;
    }

    public void setPage6(Resource page6) {
        this.page6 = page6;
    }

    public Resource getPage7() {
        return page7;
    }

    public void setPage7(Resource page7) {
        this.page7 = page7;
    }

    public Resource getPage8() {
        return page8;
    }

    public void setPage8(Resource page8) {
        this.page8 = page8;
    }

    @Override
    public void afterPropertiesSet() {
        stylesheets = new ArrayList<>();
        stylesheets.add(page1);
        stylesheets.add(page2);
        stylesheets.add(page3);
        stylesheets.add(page4);
        stylesheets.add(page5);
        stylesheets.add(page6);
        stylesheets.add(page7);
        stylesheets.add(page8);
    }

    @Override
    public Attachments getMappedAttachments(PHSHumanSubjectsAndClinicalTrialsInfo20Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            final Explanation explanation = form.getPHSHumanSubjectsAndClinicalTrialsInfo20().getExplanation();
            if (explanation != null && explanation.getAttFile() != null && a.getContentId().equals(explanation.getAttFile().getFileLocation().getHref())) {
                return entry("PHSHumanSubjectsAndClinicalTrialsInfo_2_0_P1.optionalFile0", a);
            }

            final OtherRequestedInformation otherRequestedInformation = form.getPHSHumanSubjectsAndClinicalTrialsInfo20().getOtherRequestedInformation();
            if (otherRequestedInformation != null && otherRequestedInformation.getAttFile() != null && a.getContentId().equals(otherRequestedInformation.getAttFile().getFileLocation().getHref())) {
                return entry("PHSHumanSubjectsAndClinicalTrialsInfo_2_0_P1.optionalFile1", a);
            }

            final List<PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy> delayedOnsetStudies = form.getPHSHumanSubjectsAndClinicalTrialsInfo20().getDelayedOnsetStudyList();
            if (delayedOnsetStudies != null) {
                for (int i = 0; i < delayedOnsetStudies.size(); i++) {
                    final PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy delayedOnsetStudy = delayedOnsetStudies.get(i);
                    final PHSHumanSubjectsAndClinicalTrialsInfo20.DelayedOnsetStudy.Justification justification = delayedOnsetStudy.getJustification();
                    if (justification != null && justification.getAttFile() != null && a.getContentId().equals(justification.getAttFile().getFileLocation().getHref())){
                        return entry("PHSHumanSubjectsAndClinicalTrialsInfo_2_0_P1.DelayedOnsetStudy.optionalFile3_" + i, a);
                    }
                }
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHSHumanSubjectsAndClinicalTrialsInfo20Document> factory() {
        return PHSHumanSubjectsAndClinicalTrialsInfo20Document.Factory;
    }
}
