/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.print;


import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;

public class GenericPrintable implements S2SPrintable {

	private String name;
	private String xml;
	private Map<String, byte[]> attachments;
	private List<Resource> xslTemplates;

	@Override
	public Map<String, byte[]> getAttachments() {
		return attachments;
	}

	public void setAttachments(Map<String, byte[]> attachments) {
		this.attachments = attachments;
	}

	@Override
	public List<Resource> getXslTemplates() {
		return xslTemplates;
	}

	public void setXslTemplates(List<Resource> xslTemplates) {
		this.xslTemplates = xslTemplates;
	}

	@Override
	public String getXml() {
		return xml;
	}

	public void setXml(String xml) {
		this.xml = xml;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
