<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
                xmlns:ED_524_Budget_1_5="http://apply.grants.gov/forms/ED_524_Budget_1_5-V1.5" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="8.5in" page-width="11in" margin-left="0.5in" margin-right="0.5in">
                <fo:region-body margin-top="0.5in" margin-bottom="0.5in" font-family="Helvetica,Times,Courier" font-size="12pt" />
                <fo:region-after extent=".5in" />
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="ED_524_Budget_1_5:ED_524_Budget_1_5">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set" />
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <fo:static-content flow-name="xsl-region-after">
                    <fo:block>
                        <fo:inline font-size="6px" font-weight="bold">ED 524</fo:inline>
                    </fo:block>
                </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <fo:block font-size="7.5pt">
                        <fo:table padding="1pt" width="100%" space-before.optimum="1pt">
                            <fo:table-column column-width="90pt" />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="7" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">U.S. DEPARTMENT OF EDUCATION</fo:inline>
                                        </fo:block>
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">BUDGET INFORMATION</fo:inline>
                                        </fo:block>
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">NON-CONSTRUCTION PROGRAMS</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="10pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>OMB Number: 1894-0008</fo:block>
                                        <fo:block>Expiration Date: 08/31/2026</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="5" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>* Name of Institution/Organization<fo:block space-before.optimum="1pt" space-after.optimum="2pt" keep-together="always">
                                            <fo:block>&#160;&#160;&#160;&#160; <xsl:for-each select="ED_524_Budget_1_5:LEGAL_NAME">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                            </fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="4" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Applicants requesting funding for only one year should complete the column under</fo:block>
                                        <fo:block>"Project Year 1."&#160; Applicants requesting funding for multi-year grants should complete all</fo:block>
                                        <fo:block>applicable columns.&#160; Please read all instructions before completing form.</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-after-width="2pt" border-before-width="2pt" number-columns-spanned="9" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">SECTION A - BUDGET SUMMARY</fo:inline>
                                        </fo:block>
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">U.S. DEPARTMENT OF EDUCATION FUNDS</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="60pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Budget</fo:block>
                                        <fo:block>Categories</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 1<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (a)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 2<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (b)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 3<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (c)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 4<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (d)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 5<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (e)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 6<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (f)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 7<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (g)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell  width="160pt" text-align="center" padding-start="2pt" padding-end="2pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Total<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (h)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 1. Personnel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block></fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalPersonnelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 2. Fringe Benefits</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFringeTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 3. Travel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTravelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 4. Equipment</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalEquipmentTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 5. Supplies</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSuppliesTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 6. Contractual</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalContractualTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 7. Construction</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalConstructionTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 8. Other</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalOtherTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 9. Total Direct Costs</fo:block>
                                        <fo:block>&#160; (lines 1-8)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectSixthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectSeventhYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalDirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 10. Indirect Costs</fo:block>
                                        <fo:block font-size="6pt">&#160; *Enter Rate Applied:
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectRateApplied">
                                                <xsl:value-of select="format-number(., '#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalIndirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 11. Training Stipends</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTrainingTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 12. Total Costs</fo:block>
                                        <fo:block>&#160; (lines 9-11)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSixthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalSeventhYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="2pt" padding-after="2pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetFederalTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>

                        <!-- new section of ED 524=============-->

                        <fo:table padding="1pt" width="100%" space-after.optimum="1pt" border-style="solid" border-width="1pt" border-color="black">
                            <fo:table-column column-width="20pt" />
                            <fo:table-column column-width="240pt" />
                            <fo:table-column/>
                            <fo:table-column />

                            <fo:table-body>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell number-columns-spanned="4" padding-before="3pt" padding-after="1pt" padding-start="3pt" padding-end="3pt" text-align="start">
                                        <fo:block>
                                            <fo:inline font-weight="bold">*Indirect Cost Information</fo:inline>
                                            <fo:inline font-weight="bold" font-style="italic">&#160;(To Be Completed by Your Business Office):</fo:inline>
                                            <fo:inline>&#160;&#160;If you are requesting reimbursement for indirect costs on line 10, please answer the following questions:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>(1)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>Do you have an Indirect Cost Rate Agreement approved by the Federal government?&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IsIndirectCostRateAgreementApproved='Y: Yes'"> <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                    &#160;Yes&#160;&#160;<fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;No</xsl:when>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IsIndirectCostRateAgreementApproved='N: No'"> <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;Yes&#160;&#160;<fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>&#160;No</xsl:when>

                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>&#160;Yes&#160;&#160;<fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                    &#160;No
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>(2)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>If yes, please provide the following information and provide a copy of your Indirect Cost Rate Agreement:</fo:block></fo:table-cell>
                                </fo:table-row>

                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt"  padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>&#160;&#160;&#160;&#160;Indirect Cost Rate Agreement:&#160;&#160;
                                            <xsl:value-of select="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:IndirectCostRateAgreement/ED_524_Budget_1_5:AttachedFile/att:FileName"/>
                                            &#160;&#160;
                                            <xsl:value-of select="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:IndirectCostRateAgreement/ED_524_Budget_1_5:AttachedFile/att:MimeType"/></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt"  padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>&#160;&#160;&#160;&#160;Period Covered by the Indirect Cost Rate Agreement:&#160;&#160;From:&#160;&#160;
                                            <xsl:call-template name="formatDate">
                                                <xsl:with-param name="value" select="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:IndirectCostRateAgreementFromDate"/>
                                            </xsl:call-template>&#160;&#160;
                                            &#160;
                                            To:&#160;&#160;
                                            <xsl:call-template name="formatDate">
                                                <xsl:with-param name="value" select="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:IndirectCostRateAgreementToDate"/>
                                            </xsl:call-template>&#160;&#160;&#160;
                                            (mm/dd/yyyy)					</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">	<fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>&#160;&#160;&#160;&#160;Approving Federal agency:&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:ApprovingFederalAgency='ED'">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>&#160;ED&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:ApprovingFederalAgency='Other'">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>&#160;Other (please specify):&#160;&#160;
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block><xsl:value-of select="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:OtherApprovingFederalAgency"/></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">

                                        <fo:block>&#160;&#160;&#160;&#160;The approved Indirect Cost Rate is
                                            <xsl:for-each select="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:IndirectCostRatePercentage">
                                                <xsl:value-of select="format-number(., '#,##0.00')" />
                                            </xsl:for-each>

                                            %.&#160;&#160;The approved Indirect Cost Rate Base&#160;&#160;
                                            <xsl:value-of select="format-number(ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:IndirectCostRateAgreementApproved/ED_524_Budget_1_5:IndirectCostRateBase, '$#,##0.00')" />
                                            <fo:inline font-size="6pt">
                                                (e.g., Modified Total Direct Costs, Salaries and Wages, or Salaries, Wages
                                                and Fringe Benefits see 34 CFR § 75.564(b))
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>(3)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>
                                            If this is your first Federal grant, and you do not have an approved indirect cost rate agreement, are not a State or Local government that receives more than $35 million in direct Federal
                                            funding, and are not funded under a training rate program or a restricted rate program, do you want to use the de minimis rate of 15% MTDC?
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>
                                            &#160;&#160;&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:DeMinimisRate='Y: Yes'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>
                                            &#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:DeMinimisRate='N: No'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>
                                            &#160;If yes, you must comply with the requirements of 2 CFR § 200.414(f).
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>(4)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>
                                            If you do not have an approved indirect cost rate agreement, do you want to use the temporary rate of 10% of budgeted salaries and wages?
                                        </fo:block>
                                        <fo:block>
                                            &#160;&#160;&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:TemporaryRate='Y: Yes'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>
                                            &#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:TemporaryRate='N: No'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>
                                            &#160;If yes, you must submit a proposed indirect cost rate agreement within 90 days after the date your grant is awarded, as required by 34 CFR § 75.560.
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>(5)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>For Restricted Rate Programs (check one) -- Are you using a restricted indirect cost rate that:</fo:block>
                                        <fo:block>
                                            &#160;&#160;&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:RestrictedIndirectCostRate='Is included in your approved Indirect Cost Rate Agreement?'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>
                                            &#160;Is included in your approved Indirect Cost Rate Agreement?   Or,&#160;&#160;<xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:RestrictedIndirectCostRate='Complies with 34 CFR 76.564(c)(2)?'"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline></xsl:when><xsl:otherwise><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline></xsl:otherwise>
                                            </xsl:choose>
                                            &#160;Complies with 34 CFR 76.564(c)(2)?&#160;&#160;
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>
                                            &#160;&#160;&#160;&#160;The Restricted Indirect Cost Rate is&#160;
                                            <xsl:for-each select="ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:RestrictedPercentage">
                                                <xsl:value-of select="format-number(., '#,##0.00')" />
                                            </xsl:for-each>
                                            &#160;%.&#160;&#160;The approved Indirect Cost Rate Base&#160;&#160;
                                            <xsl:value-of select="format-number(ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:RestrictedIndirectBase, '$#,##0.00')" />
                                            <fo:inline font-size="6pt">
                                                &#160;&#160;(e.g., Modified Total Direct Costs, Salaries and Wages, or Salaries, Wages and Fringe Benefits see 34 CFR § 75.564)
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row space-before.optimum="0pt">
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-after="1pt" text-align="start">
                                        <fo:block>(6)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3" padding-start="3pt" padding-end="3pt" padding-after="3pt" text-align="start">
                                        <fo:block>For Training Rate Programs (check one) -- Are you using a rate that:</fo:block>
                                        <fo:block>
                                            &#160;&#160;&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="starts-with(ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:TrainingIndirectCostRate, 'Is based on the training rate of 8 percent of MTDC')">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            &#160;Is based on the training rate of 8 percent of MTDC (See 34 CFR §75.562(c)(4))? Or,&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="starts-with(ED_524_Budget_1_5:IndirectCost/ED_524_Budget_1_5:TrainingIndirectCostRate, 'Is included in your approved Indirect Cost Rate Agreement, because it is lower than the training rate of 8 percent of MTDC')">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            &#160;Is included in your approved Indirect Cost Rate Agreement, because it is lower than the
                                        </fo:block>
                                        <fo:block margin-left="312pt" text-align="start">
                                            &#160;training rate of 8 percent of MTDC (See 34 CFR §75.562(c)(4))?&#160;&#160;
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>


                        <!-- end new section ===================-->
                        <fo:table padding="1pt" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                            <fo:table-column column-width="90pt" />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="5" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>* Name of Institution/Organization<fo:block space-before.optimum="1pt" space-after.optimum="2pt" keep-together="always">
                                            <fo:block>&#160;&#160;&#160;&#160; <xsl:for-each select="ED_524_Budget_1_5:LEGAL_NAME">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                            </fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Applicants requesting funding for only one year should complete the column under
                                            "Project Year 1."&#160; Applicants requesting funding for multi-year grants should complete all
                                            applicable columns.&#160; Please read all instructions before completing form.</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-after-width="2pt" border-before-width="2pt" number-columns-spanned="9" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">SECTION B - BUDGET SUMMARY</fo:inline>
                                            <fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:block>
                                                    <fo:inline font-size="10pt" font-weight="bold">NON-FEDERAL FUNDS</fo:inline>
                                                </fo:block>
                                            </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="60pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Budget Categories</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 1<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>(a)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 2<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>(b)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 3<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (c)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 4<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (d)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 5<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (e)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 6<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (f)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 7<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (g)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Total<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (h)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 1. Personnel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalPersonnelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 2. Fringe Benefits</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFringeTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 3. Travel</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTravelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 4. Equipment</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalEquipmentTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 5. Supplies</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSuppliesTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 6. Contractual</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalContractualTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 7. Construction</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalConstructionTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 8. Other</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalOtherTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 9. Total Direct Costs</fo:block>
                                        <fo:block>&#160; (lines 1-8)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectSixthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectSeventhYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalDirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 10. Indirect Costs</fo:block>
                                        <fo:block font-size="6pt">&#160; *Enter Rate Applied:
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectRateApplied">
                                                <xsl:value-of select="format-number(., '#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalIndirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 11. Training Stipends</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTrainingTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 12. Total Costs</fo:block>
                                        <fo:block>&#160; (lines 9-11)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSixthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalSeventhYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:BudgetNonFederalTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" number-columns-spanned="9" text-align="center" width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:block>
                                                <fo:leader leader-pattern="space" />
                                            </fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">SECTION C - BUDGET NARRATIVE (see instructions)</fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space" />
                                            </fo:block>
                                            <fo:block>
                                                <xsl:text>&#xA;</xsl:text>
                                            </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>

                        <fo:block break-after="page">
                            <fo:leader leader-pattern="space" />
                        </fo:block>

                        <!-- end new section ===================-->
                        <fo:table padding="1pt" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                            <fo:table-column column-width="110pt" />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="5" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>* Name of Institution/Organization<fo:block space-before.optimum="1pt" space-after.optimum="2pt" keep-together="always">
                                            <fo:block>&#160;&#160;&#160;&#160; <xsl:for-each select="ED_524_Budget_1_5:LEGAL_NAME">
                                                <xsl:apply-templates />
                                            </xsl:for-each>
                                            </fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Applicants requesting funding for only one year should complete the column under
                                            "Project Year 1."&#160; Applicants requesting funding for multi-year grants should complete all
                                            applicable columns.&#160; Please read all instructions before completing form.</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-before-width="2pt" display-align="before" number-columns-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-after-width="2pt" border-before-width="2pt" number-columns-spanned="9" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="12pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:inline font-size="10pt" font-weight="bold">IF APPLICABLE: SECTION D - LIMITATION ON ADMINISTRATIVE EXPENSES</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-after-width="2pt" border-before-width="2pt" number-columns-spanned="9" padding-start="15pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block padding-top="3pt" padding-bottom="3pt">
                                            <fo:inline>(1)&#160; List administrative cost cap (x%):&#160;</fo:inline>
                                            <xsl:for-each select="ED_524_Budget_1_5:AdminCostCap/ED_524_Budget_1_5:AdministrativeCostCapRate">
                                                <xsl:value-of select="format-number(., '#,##0.00')" />
                                                &#160;%
                                            </xsl:for-each>
                                        </fo:block>
                                        <fo:block padding-bottom="3pt">
                                            <fo:inline>(2)&#160; What does your administrative cost cap apply to?&#160;&#160;&#160;%</fo:inline>
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:AdminCostCap/ED_524_Budget_1_5:AdministrativeCostCapApplication='(a) indirect and direct costs'">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            &#160;(a) indirect and direct costs or,&#160;&#160;
                                            <xsl:choose>
                                                <xsl:when test="ED_524_Budget_1_5:AdminCostCap/ED_524_Budget_1_5:AdministrativeCostCapApplication='(b) only direct costs'">
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            &#160;(b) only direct costs
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="80pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Budget Categories</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 1<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>(a)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 2<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>(b)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 3<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (c)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 4<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (d)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 5<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (e)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 6<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (f)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Project Year 7<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (g)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>Total<fo:block space-before.optimum="1pt" space-after.optimum="2pt">
                                            <fo:block>
                                                (h)</fo:block>
                                        </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 1. Personnel</fo:block>
                                        <fo:block>&#160;&#160;&#160;&#160;&#160; Administrative</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePersonnelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 2. Fringe Benefits</fo:block>
                                        <fo:block>&#160;&#160;&#160;&#160;&#160; Administrative</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFringeTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="5pt" padding-after="5pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 3. Travel Administrative</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTravelTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 4. Contractual</fo:block>
                                        <fo:block>&#160;&#160;&#160;&#160;&#160; Administrative</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseContractualTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 5. Construction</fo:block>
                                        <fo:block>&#160;&#160;&#160;&#160;&#160; Administrative</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseConstructionTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="5pt" padding-after="5pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 6. Other Administrative</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseOtherTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 7. Total Direct Administrative</fo:block>
                                        <fo:block>&#160; Costs (lines 1-6)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectSixthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectSeventhYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseDirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="5pt" padding-after="5pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 8. Indirect Costs</fo:block>
                                        <fo:block font-size="6pt">&#160; *Enter Rate Applied:
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectRateApplied">
                                                <xsl:value-of select="format-number(., '#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectFirstYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectSecondYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectThirdYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectFourthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectFifthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectSixthYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="right" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectSeventhYearAmount">
                                                <xsl:value-of select="format-number(., '$#,##0.00')" />
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseIndirectTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 9. Total Administrative</fo:block>
                                        <fo:block>&#160;&#160;&#160;&#160;&#160; Costs</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseSixthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseSeventhYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpenseTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell width="130pt" padding-start="3pt" padding-end="3pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>&#160; 10. Total Percentage of</fo:block>
                                        <fo:block>&#160;&#160;&#160;&#160;&#160;&#160;&#160; Administrative Costs</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentFirstYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentSecondYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentThirdYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentFourthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentFifthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentSixthYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentSeventhYearAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block>
                                            <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                                                <fo:table-column />
                                                <fo:table-column />
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block/>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" text-align="right" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                                            <fo:block>
                                                                <xsl:for-each select="ED_524_Budget_1_5:LimitAdminExpensePercentTotalAmount">
                                                                    <xsl:value-of select="format-number(., '$#,##0.00')" />
                                                                </xsl:for-each>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-before-width="2pt" number-columns-spanned="9" text-align="center" width="130pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="24pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>

                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <!-- ============================================= -->
    <!-- FORMAT DATE                                   -->
    <!-- Writes XSD:date style text into to mm-dd-yyyy -->
    <!-- ============================================= -->
    <xsl:template name="formatDate">
        <xsl:param name="value"/>
        <xsl:if test="$value != ''">
            <xsl:value-of select="format-number(substring($value,6,2), '00')"/>
            <xsl:text>/</xsl:text>
            <xsl:value-of select="format-number(substring($value,9,2), '00')"/>
            <xsl:text>/</xsl:text>
            <xsl:value-of select="format-number(substring($value,1,4), '0000')"/>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>

