<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 sp2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:PHS398_TrainingBudget_2_0="http://apply.grants.gov/forms/PHS398_TrainingBudget_2_0-V2.0"
                xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
                xmlns:header="http://apply.grants.gov/system/Header-V1.0"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="'PDF'"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.25in"
                                   margin-right="0.25in">
                <fo:region-body margin-top="0.5in" margin-bottom="0.5in"/>
                <fo:region-after extent="0.3in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="PHS398_TrainingBudget_2_0:PHS398_TrainingBudget_2_0">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <fo:static-content flow-name="xsl-region-after">
                    <fo:table width="100%"
                              space-before.optimum="0pt"
                              space-after.optimum="0pt"
                              table-layout="fixed">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell hyphenate="true" language="en"
                                               padding-start="0pt"
                                               padding-end="0pt"
                                               padding-before="1pt"
                                               padding-after="1pt"
                                               display-align="before"
                                               text-align="left"
                                               border-style="solid"
                                               border-width="0pt"
                                               border-color="white">
                                    <!-- check for the Tracking Number element. If it is not present then don't display the label -->
                                    <fo:block>
                                        <xsl:if test="/*/*/footer:Grants_govTrackingNumber != ''">
                                            <fo:inline font-size="8px">Tracking Number:
                                                <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                                            </fo:inline>
                                        </xsl:if>
                                    </fo:block>


                                </fo:table-cell>
                                <fo:table-cell hyphenate="true" language="en" line-height="10pt"
                                               padding-start="0pt"
                                               padding-end="0pt"
                                               padding-before="1pt"
                                               padding-after="1pt"
                                               display-align="before"
                                               text-align="right"
                                               border-style="solid"
                                               border-width="0pt"
                                               border-color="white">
                                    <fo:block>
                                        <xsl:if test="/*/*/header:OpportunityID != ''">
                                            <fo:inline font-size="8px">Funding Opportunity Number:
                                                <xsl:value-of select="/*/*/header:OpportunityID"/>
                                            </fo:inline>
                                        </xsl:if>
                                        <xsl:if test="/*/*/footer:ReceivedDateTime != ''">
                                            <fo:inline font-size="8px">. Received Date:
                                                <xsl:value-of select="/*/*/footer:ReceivedDateTime"/>
                                            </fo:inline>
                                        </xsl:if>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:static-content>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <fo:inline-container>
                            <fo:block>
                                <xsl:text>&#x2029;</xsl:text>
                            </fo:block>
                        </fo:inline-container>
                        <xsl:for-each select="PHS398_TrainingBudget_2_0:BudgetYear">
                            <fo:table font-family="arialuni" line-height="11px" padding="0" table-layout="fixed"
                                      width="100%" border-spacing="0pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body margin="0" padding="0" start-indent="0pt">

                                    <xsl:choose>
                                        <xsl:when test="position()='1'">

                                            <fo:table-row margin="0">
                                                <fo:table-cell margin="0" padding="0" padding-bottom="0"
                                                               display-align="center">
                                                    <fo:block text-align="right">
                                                        <fo:inline font-size="6px">
                                                            <xsl:text>OMB Number: 0925-0001</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                    <fo:block text-align="right">
                                                        <fo:inline font-size="6px">
                                                            <xsl:text>Expiration Date: 01/31/2026</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </xsl:when>
                                    </xsl:choose>

                                    <fo:table-row margin="0">
                                        <fo:table-cell margin="0" padding="0" padding-top="0" text-align="center"
                                                       display-align="after">
                                            <fo:block>
                                                <fo:inline font-family="arialuni" font-size="12px" font-weight="bold">
                                                    <xsl:text>PHS 398 TRAINING BUDGET, Period </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="arialuni" font-size="12px" font-weight="bold">
                                                    <xsl:value-of select="position()"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row margin="0">
                                        <fo:table-cell padding-left="25pt" padding-right="25pt" padding="1px"
                                                       display-align="center">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:table font-family="arialuni" font-size="9px" line-height="11px"
                                                          table-layout="fixed" width="100%" border-spacing="0pt">
                                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                                    <fo:table-body margin="0" padding="0" start-indent="0pt">
                                                        <fo:table-row margin="0">
                                                            <fo:table-cell padding="1px" display-align="center">
                                                                <fo:block>

                                                                    <fo:inline font-family="arialuni" font-size="9px">
                                                                        <xsl:text>UEI: </xsl:text>
                                                                    </fo:inline>

                                                                    <fo:inline>
                                                                        <xsl:value-of
                                                                                select="../PHS398_TrainingBudget_2_0:SAMUEI"/>
                                                                    </fo:inline>

                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell number-columns-spanned="2" padding="1px"
                                                                           display-align="center">
                                                                <fo:block>
                                                                    <fo:inline>
                                                                        <xsl:text>Budget Type:</xsl:text>
                                                                    </fo:inline>

                                                                    <xsl:for-each
                                                                            select="../PHS398_TrainingBudget_2_0:BudgetType">
                                                                        <fo:inline>
                                                                            <xsl:text>&#160;&#160; </xsl:text>
                                                                        </fo:inline>
                                                                        <xsl:choose>
                                                                            <xsl:when test="string(.)='Project'">
                                                                                <fo:inline font-family="ZapfDingbats"
                                                                                           font-size="9px">
                                                                                    &#x25cf;
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline font-family="ZapfDingbats"
                                                                                           font-size="9px">
                                                                                    &#x274d;
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                        <fo:inline>
                                                                            <xsl:text> Project&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                                        </fo:inline>
                                                                        <xsl:choose>
                                                                            <xsl:when
                                                                                    test="string(.)='Subaward/Consortium'">
                                                                                <fo:inline font-family="ZapfDingbats"
                                                                                           font-size="9px">
                                                                                    &#x25cf;
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline font-family="ZapfDingbats"
                                                                                           font-size="9px">
                                                                                    &#x274d;
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                        <fo:inline>
                                                                            <xsl:text> Subaward/Consortium</xsl:text>
                                                                        </fo:inline>
                                                                    </xsl:for-each>

                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                        <fo:table-row margin="0">
                                                            <fo:table-cell number-columns-spanned="3" padding="1px"
                                                                           display-align="center">
                                                                <fo:block>
                                                                    <fo:inline font-family="arialuni" font-size="9px">
                                                                        <xsl:text>Organization Name:</xsl:text>
                                                                    </fo:inline>

                                                                    <xsl:for-each
                                                                            select="../PHS398_TrainingBudget_2_0:OrganizationName">
                                                                        <fo:inline>
                                                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                                        </fo:inline>
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when
                                                                                    test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of
                                                                                            select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of
                                                                                            select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>

                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                        <fo:table-row margin="0">
                                                            <fo:table-cell padding="1px" display-align="before">
                                                                <fo:block>
                                                                    <fo:inline>
                                                                        <xsl:text>Start Date:</xsl:text>
                                                                    </fo:inline>
                                                                    <xsl:for-each
                                                                            select="PHS398_TrainingBudget_2_0:PeriodStartDate">
                                                                        <fo:inline>
                                                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                                        </fo:inline>
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when
                                                                                    test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:call-template
                                                                                            name="formatDate">
                                                                                        <xsl:with-param name="value"
                                                                                                        select="$value-of-template"/>
                                                                                    </xsl:call-template>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:call-template
                                                                                            name="formatDate">
                                                                                        <xsl:with-param name="value"
                                                                                                        select="$value-of-template"/>
                                                                                    </xsl:call-template>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding="1px" display-align="before">
                                                                <fo:block>
                                                                    <fo:inline>
                                                                        <xsl:text>End Date:</xsl:text>
                                                                    </fo:inline>
                                                                    <xsl:for-each
                                                                            select="PHS398_TrainingBudget_2_0:PeriodEndDate">
                                                                        <fo:inline>
                                                                            <xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
                                                                        </fo:inline>
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when
                                                                                    test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:call-template
                                                                                            name="formatDate">
                                                                                        <xsl:with-param name="value"
                                                                                                        select="$value-of-template"/>
                                                                                    </xsl:call-template>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:call-template
                                                                                            name="formatDate">
                                                                                        <xsl:with-param name="value"
                                                                                                        select="$value-of-template"/>
                                                                                    </xsl:call-template>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding="1px" display-align="center">
                                                                <fo:block/>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </fo:table-body>
                                                </fo:table>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row margin="0">
                                        <fo:table-cell padding="1px" display-align="center">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row margin="0">
                                        <fo:table-cell padding="1px" display-align="center">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:table line-height="11px" table-layout="fixed" width="100%"
                                                          border="solid 1pt black" border-spacing="0pt">
                                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                                    <fo:table-body start-indent="0pt">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 1pt gray" padding="1px"
                                                                           display-align="center">
                                                                <fo:block>
                                                                    <fo:inline-container>
                                                                        <fo:block>
                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                        </fo:block>
                                                                    </fo:inline-container>
                                                                    <fo:table font-family="arialuni" font-size="9px"
                                                                              line-height="11px" table-layout="fixed"
                                                                              width="100%" border-spacing="0pt">
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-column
                                                                                column-width="proportional-column-width(1)"/>
                                                                        <fo:table-body start-indent="0pt">
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="6"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold"
                                                                                                   font-size="10px">
                                                                                            <xsl:text>A. Stipends, Tuition/Fees</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:block padding-top="1px">
                                                                                            <xsl:text>Number of Trainees</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Full</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Time</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Short</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Term</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block text-align="right">
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Stipends</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Requested ($)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block text-align="right">
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Tuition/Fees</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Requested ($)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:UndergraduateNumFullTime">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block
                                                                                                                                text-align="center">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:UndergraduateNumShortTerm">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block
                                                                                                                                text-align="center">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline
                                                                                                text-decoration="underline">
                                                                                            <xsl:text>Undergraduate:</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:UndergraduateStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:UndergraduateTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="5"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Number Per Stipend Level:</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>First-Year/Soph.</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:UndergraduateNumFirstYearSophomoreStipends">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block
                                                                                                                                text-align="right">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Junior/Senior</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:UndergraduateNumJuniorSeniorStipends">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block
                                                                                                                                text-align="right">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocSingleDegreeNumFullTime">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block
                                                                                                                                text-align="center">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocSingleDegreeNumShortTerm">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block
                                                                                                                                text-align="center">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block
                                                                                            text-decoration="underline">
                                                                                        <fo:inline>
                                                                                            <xsl:text>Predoctoral:</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Single Degree</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocSingleDegreeStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocSingleDegreeTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocDualDegreeNumFullTime">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocDualDegreeNumShortTerm">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Dual Degree</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocDualDegreeStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocDualDegreeTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocTotalNumFullTime">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocTotalNumShortTerm">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Total Predoctoral</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocTotalStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block
                                                                                                    text-align="right">
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PredocTotalTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline
                                                                                                text-decoration="underline">
                                                                                            <xsl:text>Postdoctoral:</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="5"
                                                                                        padding="1px"
                                                                                        text-align="center"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Number Per Stipend Level:</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>0</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>1</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>2</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>3</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>4</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>5</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>6</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="center"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>7</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeFullTime">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeShortTerm">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>Non-degree Seeking
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel0">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel1">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel2">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel3">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel4">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel5">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel6">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel7">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNonDegreeStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNonDegreeTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeFullTime">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeShortTerm">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Degree</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Seeking</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel0">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel1">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel2">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel3">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel4">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel5">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel6">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel7">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocDegreeStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocDegreeTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalFullTime">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalShortTerm">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Total</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Postdoctoral</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel0">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel1">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block
                                                                                                                                text-align="center">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline
                                                                                                                                text-align="center">
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel2">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel3">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel4">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel5">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel6">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel7">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:PostdocTotalTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:OtherNumFullTime">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="center">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:OtherNumShortTerm">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="3"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline
                                                                                                text-decoration="underline">
                                                                                            <xsl:text>Other:</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:OtherStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:OtherTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="2"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block text-align="right">
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Totals</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TotalStipendsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TotalTuitionAndFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="7"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Total Stipends + Tuition/Fees Requested</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center"
                                                                                        border-top="solid 1pt black">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right"
                                                                                                                font-weight="bold">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TotalStipendsAndTuitionFeesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="21"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:block text-align="center">
                                                                                            <fo:leader
                                                                                                    leader-pattern="rule"
                                                                                                    rule-thickness="0.5pt"
                                                                                                    leader-length="100%"/>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold"
                                                                                                   font-size="10px">
                                                                                            <xsl:text>B. Other Direct Costs</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block font-weight="bold">
                                                                                        <fo:inline>
                                                                                            <xsl:text>Funds Requested ($)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="7"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Trainee Travel</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TraineeTravelRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="6"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Training Related Expenses</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TrainingRelatedExpensesRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="8"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Total Direct Costs from R&amp;R Budget Form (if applicable)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:ResearchDirectCostsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="7"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Consortium Training Costs (if applicable)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:ConsortiumTrainingCostsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="6"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold"
                                                                                                   text-align="right">
                                                                                            <xsl:text>Total Other Direct Costs Requested</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center"
                                                                                        border-top="solid 1pt black">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right"
                                                                                                                font-weight="bold">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TotalOtherDirectCostsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="21"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:block text-align="center">
                                                                                            <fo:leader
                                                                                                    leader-pattern="rule"
                                                                                                    rule-thickness="0.5pt"
                                                                                                    leader-length="100%"/>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="7"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>C. Total Direct Costs Requested (A + B)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right"
                                                                                                                font-weight="bold">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TotalDirectCostsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="21"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:block text-align="center">
                                                                                            <fo:leader
                                                                                                    leader-pattern="rule"
                                                                                                    rule-thickness="0.5pt"
                                                                                                    leader-length="100%"/>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="before">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>D. Indirect (F&amp;A) Costs</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline text-align="center">
                                                                                            <xsl:text>Indirect (F&amp;A) Type</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Indirect (F&amp;A)</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Rate (%)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Indirect (F&amp;A)</xsl:text>
                                                                                        </fo:inline>
                                                                                        <fo:block/>
                                                                                        <fo:inline>
                                                                                            <xsl:text>Base ($)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block font-weight="bold"
                                                                                              text-align="right">
                                                                                        Funds Requested ($)
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="right"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>1.</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="10"
                                                                                        number-rows-spanned="2"
                                                                                        padding="1px"
                                                                                        display-align="before">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                font-family="arialuni">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostType1">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="2"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostRate1">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostBase1">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostFundsRequested1">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               text-align="right"
                                                                                               display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline>
                                                                                            <xsl:text>2.</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="10"
                                                                                        number-rows-spanned="2"
                                                                                        padding="1px"
                                                                                        display-align="before">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                font-family="arialuni">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostType2">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="2"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostRate2">
                                                                                                                <xsl:variable
                                                                                                                        name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when
                                                                                                                            test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of
                                                                                                                                    select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostBase2">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:IndirectCostFundsRequested2">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="6"
                                                                                        padding="1px" text-align="right"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>Total Indirect (F&amp;A) Costs Requested</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center"
                                                                                        border-top="solid 1pt black">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right"
                                                                                                                font-weight="bold">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TotalIndirectCostsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="21"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:block text-align="right">
                                                                                            <fo:leader
                                                                                                    leader-pattern="rule"
                                                                                                    rule-thickness="0.5pt"
                                                                                                    leader-length="100%"/>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="9"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>E. Total Direct and Indirect (F&amp;A) Costs Requested (C + D)</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell padding="1px"
                                                                                               display-align="center">
                                                                                    <fo:block/>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="4"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                text-align="right"
                                                                                                                font-weight="bold">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <xsl:for-each
                                                                                                                    select="PHS398_TrainingBudget_2_0:TotalDirectAndIndirectCostsRequested">
                                                                                                                <fo:inline>
                                                                                                                    <xsl:value-of
                                                                                                                            select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:for-each>
                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="21"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:block text-align="right">
                                                                                            <fo:leader
                                                                                                    leader-pattern="rule"
                                                                                                    rule-thickness="0.5pt"
                                                                                                    leader-length="100%"/>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                            <fo:table-row>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="5"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:text>F. Budget Justification</xsl:text>
                                                                                        </fo:inline>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell
                                                                                        number-columns-spanned="16"
                                                                                        padding="1px"
                                                                                        display-align="center">
                                                                                    <fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:table line-height="11px"
                                                                                                  table-layout="fixed"
                                                                                                  width="100%"
                                                                                                  border="solid 1pt white"
                                                                                                  border-spacing="0pt">
                                                                                            <fo:table-column
                                                                                                    column-width="proportional-column-width(1)"/>
                                                                                            <fo:table-body
                                                                                                    start-indent="0pt">
                                                                                                <fo:table-row>
                                                                                                    <fo:table-cell
                                                                                                            border="solid 1pt white"
                                                                                                            padding="1px"
                                                                                                            display-align="center">
                                                                                                        <fo:block
                                                                                                                font-family="arialuni">
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                                            </fo:inline>

                                                                                                            <xsl:for-each
                                                                                                                    select="../PHS398_TrainingBudget_2_0:BudgetJustification">
                                                                                                                <xsl:for-each
                                                                                                                        select="att:FileName">
                                                                                                                    <xsl:variable
                                                                                                                            name="value-of-template">
                                                                                                                        <xsl:apply-templates/>
                                                                                                                    </xsl:variable>
                                                                                                                    <xsl:choose>
                                                                                                                        <xsl:when
                                                                                                                                test="contains(string($value-of-template),'&#x2029;')">
                                                                                                                            <fo:block>
                                                                                                                                <xsl:copy-of
                                                                                                                                        select="$value-of-template"/>
                                                                                                                            </fo:block>
                                                                                                                        </xsl:when>
                                                                                                                        <xsl:otherwise>
                                                                                                                            <fo:inline>
                                                                                                                                <xsl:copy-of
                                                                                                                                        select="$value-of-template"/>
                                                                                                                            </fo:inline>
                                                                                                                        </xsl:otherwise>
                                                                                                                    </xsl:choose>
                                                                                                                </xsl:for-each>
                                                                                                            </xsl:for-each>

                                                                                                        </fo:block>
                                                                                                    </fo:table-cell>
                                                                                                </fo:table-row>
                                                                                            </fo:table-body>
                                                                                        </fo:table>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                            </fo:table-row>
                                                                        </fo:table-body>
                                                                    </fo:table>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </fo:table-body>
                                                </fo:table>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row margin="0">
                                        <fo:table-cell padding="1px" display-align="center">
                                            <fo:block>
                                                <fo:inline font-family="arialuni" font-size="9px">
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:table line-height="11px" table-layout="fixed" width="100%"
                                                          border-spacing="0pt">
                                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                                    <fo:table-body margin="0" padding="0" start-indent="0pt">
                                                        <fo:table-row margin="0">
                                                            <fo:table-cell number-columns-spanned="2" padding="1px"
                                                                           display-align="center">
                                                                <fo:block/>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </fo:table-body>
                                                </fo:table>
                                                <fo:block break-after="page">
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>


                                </fo:table-body>
                            </fo:table>
                        </xsl:for-each>

                        <fo:inline-container>
                            <fo:block>
                                <xsl:text>&#x2029;</xsl:text>
                            </fo:block>
                        </fo:inline-container>
                        <fo:table font-family="arialuni" font-size="9px" margin="0" padding="0" table-layout="fixed"
                                  width="100%" border-spacing="0pt">
                            <fo:table-column column-width="proportional-column-width(1)"/>
                            <fo:table-body start-indent="0pt">
                                <fo:table-row>
                                    <fo:table-cell padding="1px" text-align="center" display-align="center">
                                        <fo:block>
                                            <fo:block/>
                                            <fo:block/>
                                            <fo:inline font-size="12px" font-weight="bold">
                                                <xsl:text>PHS 398 TRAINING BUDGET, Cumulative Budget</xsl:text>
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding="1px" display-align="center">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding="1px" display-align="center">
                                        <fo:block>
                                            <fo:inline-container>
                                                <fo:block>
                                                    <xsl:text>&#x2029;</xsl:text>
                                                </fo:block>
                                            </fo:inline-container>
                                            <fo:table margin="0" padding="0" table-layout="fixed" width="100%"
                                                      border="solid 1pt gray" border-spacing="0pt">
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-body start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt black" padding="1px"
                                                                       display-align="center">
                                                            <fo:block>
                                                                <fo:inline-container>
                                                                    <fo:block>
                                                                        <xsl:text>&#x2029;</xsl:text>
                                                                    </fo:block>
                                                                </fo:inline-container>
                                                                <fo:table padding-left="3pt" table-layout="fixed"
                                                                          width="100%" border-spacing="0pt">
                                                                    <fo:table-column column-width="5%"/>
                                                                    <fo:table-column column-width="10%"/>
                                                                    <fo:table-column column-width="35%"/>
                                                                    <fo:table-column column-width="25%"/>
                                                                    <fo:table-column column-width="25%"/>
                                                                    <fo:table-body start-indent="0pt">
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="4"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold"
                                                                                               font-size="10px">
                                                                                        <xsl:text>A. Stipends, Tuition/Fees</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           text-align="right"
                                                                                           display-align="center">
                                                                                <fo:block font-weight="bold">
                                                                                    <fo:inline>
                                                                                        <xsl:text>Stipends</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:block/>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Requested ($)</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           text-align="right"
                                                                                           display-align="center">
                                                                                <fo:block font-weight="bold">
                                                                                    <fo:inline>
                                                                                        <xsl:text>Tuition/Fees</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:block/>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Requested ($)</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block text-decoration="underline">
                                                                                    <fo:inline>
                                                                                        <xsl:text>Undergraduate:</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block text-align="right">
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>
                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeUndergraduateStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>
                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>
                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeUndergraduateTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>
                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block text-decoration="underline">
                                                                                    <fo:inline>
                                                                                        <xsl:text>Predoctoral:</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Single Degree</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>
                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePredocSingleDegreeStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>
                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePredocSingleDegreeTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Dual Degree</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePredocDualDegreeStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePredocDualDegreeTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>Total Predoctoral</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePredocTotalStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePredocTotalTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block text-decoration="underline">
                                                                                    <fo:inline>
                                                                                        <xsl:text>Postdoctoral:</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Non-Degree Seeking</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePostdocNonDegreeStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePostdocNonDegreeTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Degree Seeking</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePostdocDegreeStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePostdocDegreeTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px" height="15"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px" height="15"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px" height="15"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>Total Postdoctoral</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px" height="15"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePostdocTotalStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px" height="15"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativePostdocTotalTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block text-decoration="underline">
                                                                                    <fo:inline>
                                                                                        <xsl:text>Other:</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeOtherStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeOtherTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           text-align="right"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>Totals&#160;&#160;&#160; </xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTotalStipendsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTuitionAndFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell number-columns-spanned="2"
                                                                                           padding="1px"
                                                                                           text-align="right"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>Total Stipends + Tuition/Fees Requested&#160;&#160;&#160; </xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center"
                                                                                           border-top="solid 1pt black">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right"
                                                                                                            font-weight="bold">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTotalStipendsAndTuitionFeesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="5"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:block text-align="center">
                                                                                        <fo:leader leader-pattern="rule"
                                                                                                   rule-thickness="0.5pt"
                                                                                                   leader-length="100%"/>
                                                                                    </fo:block>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="3"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>B. Other Direct Costs</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           text-align="right"
                                                                                           display-align="center">
                                                                                <fo:block font-weight="bold">Funds
                                                                                    Requested ($)
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell number-columns-spanned="3"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Trainee Travel</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTraineeTravelRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell number-columns-spanned="3"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Training Related Expenses</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTrainingRelatedExpensesRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell number-columns-spanned="3"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Total Direct Costs from R&amp;R Budget Form (if applicable)</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeResearchDirectCostsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell number-columns-spanned="3"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline>
                                                                                        <xsl:text>Consortium Training Costs (if applicable)</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeConsortiumTrainingCostsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell number-columns-spanned="3"
                                                                                           padding="1px"
                                                                                           text-align="right"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>Total Other Direct Costs Requested&#160;&#160;&#160; </xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center"
                                                                                           border-top="solid 1pt black">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right"
                                                                                                            font-weight="bold">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTotalOtherDirectCostsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="5"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:block text-align="center">
                                                                                        <fo:leader leader-pattern="rule"
                                                                                                   rule-thickness="0.5pt"
                                                                                                   leader-length="100%"/>
                                                                                    </fo:block>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="4"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>C. Total Direct Costs Requested (A + B)</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right"
                                                                                                            font-weight="bold">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTotalDirectCostsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="5"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:block text-align="center">
                                                                                        <fo:leader leader-pattern="rule"
                                                                                                   rule-thickness="0.5pt"
                                                                                                   leader-length="100%"/>
                                                                                    </fo:block>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="3"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>D. Total Indirect (F&amp;A) Costs Requested</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block/>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="1px"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            text-align="right"
                                                                                                            font-weight="bold">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTotalIndirectCostsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="5"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:block text-align="center">
                                                                                        <fo:leader leader-pattern="rule"
                                                                                                   rule-thickness="0.5pt"
                                                                                                   leader-length="100%"/>
                                                                                    </fo:block>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                        <fo:table-row>
                                                                            <fo:table-cell number-columns-spanned="4"
                                                                                           padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold">
                                                                                        <xsl:text>E. Total Direct and Indirect (F&amp;A) Costs Requested (C + D)</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                            <fo:table-cell padding="1px"
                                                                                           display-align="center">
                                                                                <fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed"
                                                                                              width="100%"
                                                                                              border="solid 1pt white"
                                                                                              border-spacing="0pt">
                                                                                        <fo:table-column
                                                                                                column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body
                                                                                                start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell
                                                                                                        border="solid 1pt white"
                                                                                                        padding="2pt"
                                                                                                        display-align="center">
                                                                                                    <fo:block
                                                                                                            font-weight="bold"
                                                                                                            text-align="right">
                                                                                                        <fo:inline>
                                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                                        </fo:inline>

                                                                                                        <xsl:for-each
                                                                                                                select="PHS398_TrainingBudget_2_0:CumulativeTotalDirectAndIndirectCostsRequested">
                                                                                                            <fo:inline>
                                                                                                                <xsl:value-of
                                                                                                                        select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:for-each>

                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                        </fo:table-body>
                                                                                    </fo:table>
                                                                                </fo:block>
                                                                            </fo:table-cell>
                                                                        </fo:table-row>
                                                                    </fo:table-body>
                                                                </fo:table>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="double-backslash">
        <xsl:param name="text"/>
        <xsl:param name="text-length"/>
        <xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
        <xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
        <xsl:choose>
            <xsl:when test="$text-after-bs-length = 0">
                <xsl:choose>
                    <xsl:when test="substring($text, $text-length) = '\'">
                        <xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$text"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
                <xsl:call-template name="double-backslash">
                    <xsl:with-param name="text" select="$text-after-bs"/>
                    <xsl:with-param name="text-length" select="$text-after-bs-length"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="formatDate">
        <xsl:param name="value"/>
        <xsl:value-of select="format-number(substring($value,6,2), '00')"/>
        <xsl:text>-</xsl:text>
        <xsl:value-of select="format-number(substring($value,9,2), '00')"/>
        <xsl:text>-</xsl:text>
        <xsl:value-of select="format-number(substring($value,1,4), '0000')"/>
    </xsl:template>
</xsl:stylesheet>
