/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate;

import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.kuali.coeus.s2sgen.api.core.S2SException;

import java.util.List;
import java.util.Set;

/**
 * 
 * This interface defines the service that is used to create instances of opportunity form generator classes.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
public interface S2SFormGeneratorRetrievalService {

    /**
     *
     * This method is used to create and return a form generator instance. Based on the namespace provided as parameter, it
     * instantiates the respective generator class and returns it.
     *
     * @param namespace the namespace for the generator
     * @return S2SFormGenerator form generator instances corresponding to the name space.
     */
    <T extends XmlObject> S2SFormGenerator<T> getS2SGenerator(String namespace) throws S2SException;

    /**
     * 
     * This method is used to create and return a form generator instance. Based on the namespace provided as parameter, it
     * instantiates the respective generator class and returns it.
     *
     * @param proposalNumber a proposal number which is used to first find if a user attached form exists matching the namespace.
     * @param namespace the namespace for the generator
     * @return S2SFormGenerator form generator instances corresponding to the name space.
     */
    <T extends XmlObject> S2SFormGenerator<T> getS2SGenerator(String namespace, String proposalNumber) throws S2SException;

    /**
     *
     * This method is used to create and return form generators instances. Based on the namespaces provided as parameter, it
     * instantiates the respective generator class and returns it.  The generators in the list are ordered by the generators sort index.
     *
     * @param proposalNumber a proposal number which is used to first find if user attached forms exist matching the namespaces.
     * @param namespaces a set of namespaces
     * @return S2SFormGenerator form generator instances corresponding to the name space.
     */
    <T extends XmlObject> List<S2SFormGenerator<T>> getS2SGenerators(Set<String> namespaces, String proposalNumber) throws S2SException;

    /**
     *
     * This method is used to create and return form generators instances excluding DynamicForm types.
     * @return S2SFormGenerator form generator instances corresponding to the name space.
     */
    <T extends XmlObject> List<S2SFormGenerator<T>> getS2SGenerators() throws S2SException;

    /**
     * This method is to get the namespace prefixes for some individual forms like, Subaward Budget and PHS398_ResearchTrainingProgramPlan
     */
    XmlOptions getXmlOptionsPrefixes();

}
