/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;


import gov.grants.apply.forms.attachmentForm12V12.AttachmentForm12Document;
import gov.grants.apply.forms.attachmentForm12V12.AttachmentForm12Document.AttachmentForm12;
import gov.grants.apply.forms.attachmentForm12V12.AttachmentForm12Document.AttachmentForm12.*;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

@FormGenerator("Attachments_1_2V1_2Generator")
public class Attachments_1_2V1_2Generator extends S2SBaseFormGenerator<AttachmentForm12Document> implements S2SFormGeneratorPdfFillable<AttachmentForm12Document> {

    private static final String NARRATIVECODE_ATTACHMENTS = "61";

    @Value("http://apply.grants.gov/forms/AttachmentForm_1_2-V1.2")
    private String namespace;

    @Value("Attachments_1_2V1_2")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/Attachments-V1.2.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/AttachmentForm_1_2-V1.2.pdf")
    private Resource pdfForm;

    @Value("240")
    private int sortIndex;

    private AttachmentForm12Document getAttachment() {

        AttachmentForm12Document attachmentsDocument = AttachmentForm12Document.Factory.newInstance();
        AttachmentForm12 attachments = AttachmentForm12.Factory.newInstance();
        attachments.setFormVersion(FormVersion.v1_2.getVersion());
        ATT1 att1 = ATT1.Factory.newInstance();
        ATT2 att2 = ATT2.Factory.newInstance();
        ATT3 att3 = ATT3.Factory.newInstance();
        ATT4 att4 = ATT4.Factory.newInstance();
        ATT5 att5 = ATT5.Factory.newInstance();
        ATT6 att6 = ATT6.Factory.newInstance();
        ATT7 att7 = ATT7.Factory.newInstance();
        ATT8 att8 = ATT8.Factory.newInstance();
        ATT9 att9 = ATT9.Factory.newInstance();
        ATT10 att10 = ATT10.Factory.newInstance();
        ATT11 att11 = ATT11.Factory.newInstance();
        ATT12 att12 = ATT12.Factory.newInstance();
        ATT13 att13 = ATT13.Factory.newInstance();
        ATT14 att14 = ATT14.Factory.newInstance();
        ATT15 att15 = ATT15.Factory.newInstance();
        int countAttachments = 0;
        for (NarrativeContract narrative : pdDoc.getDevelopmentProposal().getNarratives().stream()
                .sorted(Comparator.comparing(NarrativeContract::getModuleSequenceNumber)).toList()) {
            if (narrative.getNarrativeType() != null && NARRATIVECODE_ATTACHMENTS.equals(narrative.getNarrativeType().getCode())) {
                final AttachedFileDataType attachedFileDataType = addAttachedFileType(narrative);
                if (attachedFileDataType != null) {
                    countAttachments++;
                    switch (countAttachments) {
                        case 1 -> {
                            att1.setATT1File(attachedFileDataType);
                            attachments.setATT1(att1);
                        }
                        case 2 -> {
                            att2.setATT2File(attachedFileDataType);
                            attachments.setATT2(att2);
                        }
                        case 3 -> {
                            att3.setATT3File(attachedFileDataType);
                            attachments.setATT3(att3);
                        }
                        case 4 -> {
                            att4.setATT4File(attachedFileDataType);
                            attachments.setATT4(att4);
                        }
                        case 5 -> {
                            att5.setATT5File(attachedFileDataType);
                            attachments.setATT5(att5);
                        }
                        case 6 -> {
                            att6.setATT6File(attachedFileDataType);
                            attachments.setATT6(att6);
                        }
                        case 7 -> {
                            att7.setATT7File(attachedFileDataType);
                            attachments.setATT7(att7);
                        }
                        case 8 -> {
                            att8.setATT8File(attachedFileDataType);
                            attachments.setATT8(att8);
                        }
                        case 9 -> {
                            att9.setATT9File(attachedFileDataType);
                            attachments.setATT9(att9);
                        }
                        case 10 -> {
                            att10.setATT10File(attachedFileDataType);
                            attachments.setATT10(att10);
                        }
                        case 11 -> {
                            att11.setATT11File(attachedFileDataType);
                            attachments.setATT11(att11);
                        }
                        case 12 -> {
                            att12.setATT12File(attachedFileDataType);
                            attachments.setATT12(att12);
                        }
                        case 13 -> {
                            att13.setATT13File(attachedFileDataType);
                            attachments.setATT13(att13);
                        }
                        case 14 -> {
                            att14.setATT14File(attachedFileDataType);
                            attachments.setATT14(att14);
                        }
                        case 15 -> {
                            att15.setATT15File(attachedFileDataType);
                            attachments.setATT15(att15);
                        }
                    }
                }
            }
        }
        attachmentsDocument.setAttachmentForm12(attachments);
        return attachmentsDocument;
    }

    @Override
    public AttachmentForm12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {

        this.pdDoc = proposalDevelopmentDocument;
        return getAttachment();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(AttachmentForm12Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getAttachmentForm12().getATT1() != null && form.getAttachmentForm12().getATT1().getATT1File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT1().getATT1File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile1", a);
            } else if (form.getAttachmentForm12().getATT2() != null && form.getAttachmentForm12().getATT2().getATT2File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT2().getATT2File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile2", a);
            } else if (form.getAttachmentForm12().getATT3() != null && form.getAttachmentForm12().getATT3().getATT3File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT3().getATT3File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile3", a);
            } else if (form.getAttachmentForm12().getATT4() != null && form.getAttachmentForm12().getATT4().getATT4File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT4().getATT4File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile4", a);
            } else if (form.getAttachmentForm12().getATT5() != null && form.getAttachmentForm12().getATT5().getATT5File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT5().getATT5File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile5", a);
            } else if (form.getAttachmentForm12().getATT6() != null && form.getAttachmentForm12().getATT6().getATT6File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT6().getATT6File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile6", a);
            } else if (form.getAttachmentForm12().getATT7() != null && form.getAttachmentForm12().getATT7().getATT7File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT7().getATT7File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile7", a);
            } else if (form.getAttachmentForm12().getATT8() != null && form.getAttachmentForm12().getATT8().getATT8File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT8().getATT8File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile8", a);
            } else if (form.getAttachmentForm12().getATT9() != null && form.getAttachmentForm12().getATT9().getATT9File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT9().getATT9File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile9", a);
            } else if (form.getAttachmentForm12().getATT10() != null && form.getAttachmentForm12().getATT10().getATT10File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT10().getATT10File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile10", a);
            } else if (form.getAttachmentForm12().getATT11() != null && form.getAttachmentForm12().getATT11().getATT11File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT11().getATT11File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile11", a);
            } else if (form.getAttachmentForm12().getATT12() != null && form.getAttachmentForm12().getATT12().getATT12File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT12().getATT12File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile12", a);
            } else if (form.getAttachmentForm12().getATT13() != null && form.getAttachmentForm12().getATT13().getATT13File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT13().getATT13File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile13", a);
            } else if (form.getAttachmentForm12().getATT14() != null && form.getAttachmentForm12().getATT14().getATT14File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT14().getATT14File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile14", a);
            } else if (form.getAttachmentForm12().getATT15() != null && form.getAttachmentForm12().getATT15().getATT15File() != null && a.getContentId().equals(form.getAttachmentForm12().getATT15().getATT15File().getFileLocation().getHref())) {
                return entry("AttachmentForm_1_2_P1.optionalFile0", a);
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<AttachmentForm12Document> factory() {
        return AttachmentForm12Document.Factory;
    }
}
