/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrMPBudget20V20.RRMPBudget20Document;
import gov.grants.apply.forms.rrMPBudget20V20.RRMPBudget20Document.RRMPBudget20;
import gov.grants.apply.forms.rrMPSubawardBudget20V20.RRMPSubawardBudget20Document;
import gov.grants.apply.forms.rrMPSubawardBudget20V20.RRMPSubawardBudget20Document.RRMPSubawardBudget20;
import gov.grants.apply.forms.rrMPSubawardBudget20V20.RRMPSubawardBudget20Document.RRMPSubawardBudget20.BudgetAttachments;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@FormGenerator("RRMPSubAwardBudgetV2_0Generator")
public class RRMPSubAwardBudgetV2_0Generator extends S2SAdobeFormAttachmentBaseGenerator<RRMPSubawardBudget20Document> implements S2SFormGeneratorPdfFillable<RRMPSubawardBudget20Document> {

    private static final String RR_MP_BUDGET2_0_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_MP_Budget_2_0-V2.0";
    private static final String RR_MP_BUDGET2_0_LOCAL_NAME = "RR_MP_Budget_2_0";

    @Value("http://apply.grants.gov/forms/RR_MP_SubawardBudget_2_0-V2.0")
    private String namespace;

    @Value("RR_MP_SubawardBudget_2_0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_MP_SubawardBudget-V2.0.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_MP_SubawardBudget_2_0-V2.0.pdf")
    private Resource pdfForm;

    @Value("177")
    private int sortIndex;

    private RRMPSubawardBudget20Document getRRSubawardBudgetDocument() throws S2SException {

        RRMPSubawardBudget20Document rrMpSubawardBudgetDocument = RRMPSubawardBudget20Document.Factory.newInstance();
        RRMPSubawardBudget20 rrMPSubawardBudget = RRMPSubawardBudget20.Factory.newInstance();
        BudgetAttachments budgetAttachments = BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = getBudgetSubAwards(pdDoc, RR_MP_BUDGET2_0_NAMESPACE_URI, false);
        List<RRMPBudget20> budgetList = new ArrayList<>();
        rrMPSubawardBudget.setFormVersion(FormVersion.v2_0.getVersion());

        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            final RRMPBudget20Document rrMPBudgetDocument = getRRMPBudget20(budgetSubAwards);
            if (rrMPBudgetDocument != null) {
                final RRMPBudget20 rrMPBudget = rrMPBudgetDocument.getRRMPBudget20();

                switch (attCount) {
                    case 1:
                        rrMPSubawardBudget.setATT1(prepareAttName(budgetSubAwards));
                        budgetList.add(0, rrMPBudget);
                        break;
                    case 2:
                        rrMPSubawardBudget.setATT2(prepareAttName(budgetSubAwards));
                        budgetList.add(1, rrMPBudget);
                        break;
                    case 3:
                        rrMPSubawardBudget.setATT3(prepareAttName(budgetSubAwards));
                        budgetList.add(2, rrMPBudget);
                        break;
                    case 4:
                        rrMPSubawardBudget.setATT4(prepareAttName(budgetSubAwards));
                        budgetList.add(3, rrMPBudget);
                        break;
                    case 5:
                        rrMPSubawardBudget.setATT5(prepareAttName(budgetSubAwards));
                        budgetList.add(4, rrMPBudget);
                        break;
                    case 6:
                        rrMPSubawardBudget.setATT6(prepareAttName(budgetSubAwards));
                        budgetList.add(5, rrMPBudget);
                        break;
                    case 7:
                        rrMPSubawardBudget.setATT7(prepareAttName(budgetSubAwards));
                        budgetList.add(6, rrMPBudget);
                        break;
                    case 8:
                        rrMPSubawardBudget.setATT8(prepareAttName(budgetSubAwards));
                        budgetList.add(7, rrMPBudget);
                        break;
                    case 9:
                        rrMPSubawardBudget.setATT9(prepareAttName(budgetSubAwards));
                        budgetList.add(8, rrMPBudget);
                        break;
                    case 10:
                        rrMPSubawardBudget.setATT10(prepareAttName(budgetSubAwards));
                        budgetList.add(9, rrMPBudget);
                        break;
                    case 11:
                        rrMPSubawardBudget.setATT11(prepareAttName(budgetSubAwards));
                        budgetList.add(10, rrMPBudget);
                        break;
                    case 12:
                        rrMPSubawardBudget.setATT12(prepareAttName(budgetSubAwards));
                        budgetList.add(11, rrMPBudget);
                        break;
                    case 13:
                        rrMPSubawardBudget.setATT13(prepareAttName(budgetSubAwards));
                        budgetList.add(12, rrMPBudget);
                        break;
                    case 14:
                        rrMPSubawardBudget.setATT14(prepareAttName(budgetSubAwards));
                        budgetList.add(13, rrMPBudget);
                        break;
                    case 15:
                        rrMPSubawardBudget.setATT15(prepareAttName(budgetSubAwards));
                        budgetList.add(14, rrMPBudget);
                        break;
                    case 16:
                        rrMPSubawardBudget.setATT16(prepareAttName(budgetSubAwards));
                        budgetList.add(15, rrMPBudget);
                        break;
                    case 17:
                        rrMPSubawardBudget.setATT17(prepareAttName(budgetSubAwards));
                        budgetList.add(16, rrMPBudget);
                        break;
                    case 18:
                        rrMPSubawardBudget.setATT18(prepareAttName(budgetSubAwards));
                        budgetList.add(17, rrMPBudget);
                        break;
                    case 19:
                        rrMPSubawardBudget.setATT19(prepareAttName(budgetSubAwards));
                        budgetList.add(18, rrMPBudget);
                        break;
                    case 20:
                        rrMPSubawardBudget.setATT20(prepareAttName(budgetSubAwards));
                        budgetList.add(19, rrMPBudget);
                        break;
                    case 21:
                        rrMPSubawardBudget.setATT21(prepareAttName(budgetSubAwards));
                        budgetList.add(20, rrMPBudget);
                        break;
                    case 22:
                        rrMPSubawardBudget.setATT22(prepareAttName(budgetSubAwards));
                        budgetList.add(21, rrMPBudget);
                        break;
                    case 23:
                        rrMPSubawardBudget.setATT23(prepareAttName(budgetSubAwards));
                        budgetList.add(22, rrMPBudget);
                        break;
                    case 24:
                        rrMPSubawardBudget.setATT24(prepareAttName(budgetSubAwards));
                        budgetList.add(23, rrMPBudget);
                        break;
                    case 25:
                        rrMPSubawardBudget.setATT25(prepareAttName(budgetSubAwards));
                        budgetList.add(24, rrMPBudget);
                        break;
                    case 26:
                        rrMPSubawardBudget.setATT26(prepareAttName(budgetSubAwards));
                        budgetList.add(25, rrMPBudget);
                        break;
                    case 27:
                        rrMPSubawardBudget.setATT27(prepareAttName(budgetSubAwards));
                        budgetList.add(26, rrMPBudget);
                        break;
                    case 28:
                        rrMPSubawardBudget.setATT28(prepareAttName(budgetSubAwards));
                        budgetList.add(27, rrMPBudget);
                        break;
                    case 29:
                        rrMPSubawardBudget.setATT29(prepareAttName(budgetSubAwards));
                        budgetList.add(28, rrMPBudget);
                        break;
                    case 30:
                        rrMPSubawardBudget.setATT30(prepareAttName(budgetSubAwards));
                        budgetList.add(29, rrMPBudget);
                        break;
                }
                addSubAwdAttachments(budgetSubAwards);
                attCount++;
            }

        }
        budgetAttachments.setRRMPBudget20Array(budgetList.toArray(new RRMPBudget20[0]));
        rrMPSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrMpSubawardBudgetDocument.setRRMPSubawardBudget20(rrMPSubawardBudget);
        return rrMpSubawardBudgetDocument;
    }

    private RRMPBudget20Document getRRMPBudget20(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        final RRMPBudget20Document rrBudget;
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = stringToDom(subAwdXML);

        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_MP_BUDGET2_0_NAMESPACE_URI, RR_MP_BUDGET2_0_LOCAL_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }


        byte[] subAwdNodeBytes = docToBytes(nodeToDom(subAwdNode));

        try {
            rrBudget = RRMPBudget20Document.Factory.parse(new ByteArrayInputStream(subAwdNodeBytes));
        } catch (XmlException | IOException e) {
            throw new RuntimeException(e);
        }

        return rrBudget;
    }

    @Override
    public RRMPSubawardBudget20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        pdDoc = proposalDevelopmentDocument;
        return getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(RRMPSubawardBudget20Document form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRMPSubawardBudget20Document> factory() {
        return RRMPSubawardBudget20Document.Factory;
    }
}
