/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage18V18.NSFCoverPage18Document;
import gov.grants.apply.forms.nsfCoverPage18V18.NSFCoverPage18Document.NSFCoverPage18;
import gov.grants.apply.forms.nsfCoverPage18V18.NSFCoverPage18Document.NSFCoverPage18.OtherInfo;
import gov.grants.apply.forms.nsfCoverPage18V18.NSFCoverPage18Document.NSFCoverPage18.PIInfo;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

@FormGenerator("NSFCoverPageV1_8Generator")
public class NSFCoverPageV1_8Generator extends NSFCoverPageBaseGenerator<NSFCoverPage18Document> implements S2SFormGeneratorPdfFillable<NSFCoverPage18Document> {

    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    private static final int GOALI = -1;
    private static final int RAISE = -2;

    @Value("http://apply.grants.gov/forms/NSF_CoverPage_1_8-V1.8")
    private String namespace;

    @Value("NSF_CoverPage_1_8")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.8.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_1_8-V1.8.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    @Autowired
    @Qualifier("departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;

    private NSFCoverPage18Document getNSFCoverPage18() {
        NSFCoverPage18Document nsfCoverPage18Document = NSFCoverPage18Document.Factory.newInstance();
        NSFCoverPage18 nsfCoverPage18 = NSFCoverPage18.Factory.newInstance();
        nsfCoverPage18.setFormVersion(FormVersion.v1_8.getVersion());
        setFundingOpportunityNumber(nsfCoverPage18);

        if (pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage18.setDueDate(pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage18.setNSFUnitConsideration(getNSFUnitConsideration());
        setOtherInfo(nsfCoverPage18);
        setNsfId(nsfCoverPage18);
        AttachmentGroupMin1Max100DataType attachmentGroup = AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage18.setSingleCopyDocuments(attachmentGroup);
        }
        final AttachedFileDataType dataManagementPlan = getAttachedNarrativeFile(DATA_MANAGEMENT_PLAN);
        if (dataManagementPlan != null) {
            nsfCoverPage18.setDataManagementPlan(dataManagementPlan);
        }

        final AttachedFileDataType mentoringPlan = getAttachedNarrativeFile(MENTORING_PLAN);
        if (mentoringPlan != null) {
            nsfCoverPage18.setMentoringPlan(mentoringPlan);
        }

        final AttachedFileDataType goali = getAttachedNarrativeFile(GOALI);
        if (goali != null) {
            nsfCoverPage18.setGOALILetter(goali);
        }

        final AttachedFileDataType raise = getAttachedNarrativeFile(RAISE);
        if (raise != null) {
            nsfCoverPage18.setRAISEEmails(raise);
        }
        nsfCoverPage18Document.setNSFCoverPage18(nsfCoverPage18);
        return nsfCoverPage18Document;
    }

    private void setNsfId(NSFCoverPage18 nsfCoverPage18) {
        DepartmentalPersonDto person = departmentalPersonService.getDepartmentalPerson(pdDoc);
        nsfCoverPage18.setNSFID(person.getNsfId());
    }

    protected void setFundingMechanism(NSFCoverPage18Document.NSFCoverPage18 nsfCoverPage18, String answer) {
        NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.Enum fundingMechanism;
        if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CONFERENCE.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CONFERENCE;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAPID.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAPID;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EAGER.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EAGER;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EQUIPMENT.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EQUIPMENT;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAISE.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAISE;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FELLOWSHIP.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FELLOWSHIP;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.IDEAS_LAB.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.IDEAS_LAB;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.GOALI.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.GOALI;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FASED.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FASED;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.TRAVEL.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.TRAVEL;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE;
        } else if (StringUtils.equalsIgnoreCase(answer, NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RESEARCH.toString())) {
            fundingMechanism = NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RESEARCH;
        }
        else {
            fundingMechanism = null;
        }
        nsfCoverPage18.setFundingMechanism(fundingMechanism);
    }

    private void setFundingOpportunityNumber(NSFCoverPage18 nsfCoverPage18) {
        nsfCoverPage18.setFundingOpportunityNumber(StringUtils.substring(pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), 0, PROGRAM_ANNOUNCEMENT_NUMBER_MAX_LENGTH));
    }

    private void setOtherInfo(NSFCoverPage18 nsfCoverPage18) {
        // Default funding mechanism to research to avoid triggering NSFID validation
        nsfCoverPage18.setFundingMechanism(NSFCoverPage18.FundingMechanism.RESEARCH);

        OtherInfo otherInfo = OtherInfo.Factory.newInstance();
        PIInfo pInfo = PIInfo.Factory.newInstance();
        final List<? extends AnswerContract> questionnaireAnswers = getPropDevQuestionAnswerService().getQuestionnaireAnswers(pdDoc.getDevelopmentProposal().getProposalNumber(), getNamespace(), getFormName());
        int unansweredQuestions = questionnaireAnswers.size();

        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer != null) {
                switch (questionId) {
                    case QUESTION_CURRENT_PI:
                        pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    case QUESTION_BEGIN_INVESTIGATOR:
                        otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    case QUESTION_ACCOMPLISHMENT_RENEWAL:
                        otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    case FUNDING_MECHANISM_QUESTION:
                        setFundingMechanism(nsfCoverPage18, answer);
                        unansweredQuestions--;
                        break;
                    case LOBBYING_ACTIVITIES_QUESTION:
                        otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    default:
                        break;
                }
            }
        }
        // Null OtherInfo signifies an incomplete questionnaire and should fire an audit error to that effect
        nsfCoverPage18.setOtherInfo(unansweredQuestions == 0 ? otherInfo : null);
        nsfCoverPage18.setPIInfo(pInfo);
    }

    @Override
    public NSFCoverPage18Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return getNSFCoverPage18();
    }

    protected NSFCoverPage18Document.NSFCoverPage18.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage18Document.NSFCoverPage18.NSFUnitConsideration nsfConsideration = NSFCoverPage18Document.NSFCoverPage18.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(NSFCoverPage18Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getNSFCoverPage18().getSingleCopyDocuments() != null && form.getNSFCoverPage18().getSingleCopyDocuments().getAttachedFileList() != null) {
                final List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage18().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); i++) {
                    final AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (a.getContentId().equals(attachedFile.getFileLocation().getHref())){
                        return entry("NSF_CoverPage_1_8_P1.optionalFile1_" + i, a);
                    }
                }
            }

            final AttachedFileDataType dataManagementPlanAttachedFile = form.getNSFCoverPage18().getDataManagementPlan();
            if (dataManagementPlanAttachedFile != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_8_P1.optionalFile2", a);
            }

            final AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage18().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_8_P1.optionalFile3", a);
            }

            final AttachedFileDataType goaliLetterAttachedFile = form.getNSFCoverPage18().getGOALILetter();
            if (goaliLetterAttachedFile != null && a.getContentId().equals(goaliLetterAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_8_P1.optionalFile4", a);
            }

            final AttachedFileDataType raiseAttachedFile = form.getNSFCoverPage18().getRAISEEmails();
            if (raiseAttachedFile != null && a.getContentId().equals(raiseAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_8_P1.optionalFile5", a);
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage18Document> factory() {
        return NSFCoverPage18Document.Factory;
    }
}
