/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfSuggestedReviewersV11.NSFSuggestedReviewersDocument;
import gov.grants.apply.forms.nsfSuggestedReviewersV11.NSFSuggestedReviewersDocument.NSFSuggestedReviewers;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.Collections;
import java.util.List;


/**
 * 
 * This class is used to generate XML Document object for grants.gov NSFSuggestedReviewersV1.1. This form is generated using XMLBean
 * API's generated by compiling NSFSuggestedReviewersV1.1 schema.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
@FormGenerator("NSFSuggestedReviewersV1_1Generator")
public class NSFSuggestedReviewersV1_1Generator extends NSFSuggestedReviewersBaseGenerator<NSFSuggestedReviewersDocument> {

    @Value("http://apply.grants.gov/forms/NSF_SuggestedReviewers-V1.1")
    private String namespace;

    @Value("NSF_SuggestedReviewers-V1.1")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_SuggestedReviewers-V1.1.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_SuggestedReviewers-V1.1.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    /**
     * 
     * This method returns NSFSuggestedReviewersDocument object based on proposal development document which contains the
     * NSFSuggestedReviewersDocument informations SuggestedReviewers and inclusion of Reviewer for a particular proposal
     * 
     * @return nsfReviewersDocument {@link XmlObject} of type NSFSuggestedReviewersDocument.
     */
    private NSFSuggestedReviewersDocument getNSFSuggestedReviewers() {

        NSFSuggestedReviewersDocument nsfReviewersDocument = NSFSuggestedReviewersDocument.Factory.newInstance();
        NSFSuggestedReviewers nsfSuggestedReviewers = NSFSuggestedReviewers.Factory.newInstance();
        nsfSuggestedReviewers.setFormVersion(FormVersion.v1_1.getVersion());
        String suggestedRev = getAbstractText(SUGGESTED_REVIEWERS);
        if (suggestedRev != null && !suggestedRev.equals("")) {
            nsfSuggestedReviewers.setSuggestedReviewers(suggestedRev);
        }
        String doNotInclude = getAbstractText(REVIEWERS_NOT_TO_INCLUDE);
        if (doNotInclude != null && !doNotInclude.equals("")) {
            nsfSuggestedReviewers.setReviewersNotToInclude(doNotInclude);
        }
        nsfReviewersDocument.setNSFSuggestedReviewers(nsfSuggestedReviewers);
        return nsfReviewersDocument;
    }

    /**
     * This method creates {@link XmlObject} of type {@link NSFSuggestedReviewersDocument} by populating data from the given
     * {@link ProposalDevelopmentDocumentContract}
     * 
     * @param proposalDevelopmentDocument for which the {@link XmlObject} needs to be created
     * @return {@link XmlObject} which is generated using the given {@link ProposalDevelopmentDocumentContract}
     */
    @Override
    public NSFSuggestedReviewersDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return getNSFSuggestedReviewers();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(NSFSuggestedReviewersDocument form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<NSFSuggestedReviewersDocument> factory() {
        return NSFSuggestedReviewersDocument.Factory;
    }
}
