/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;

import java.util.Comparator;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * Used to order <code>{@link ProposalPersonContract}</code> instances by the role.
 */
public class ProposalPersonComparator implements Comparator<ProposalPersonContract> {
    private static final Logger LOG = LogManager.getLogger(ProposalPersonComparator.class);


    /**
     * compare one <code>{@link ProposalPersonContract}</code> instance to another. Sort by the role of the
     *  <code>{@link ProposalPersonContract}</code>
     *
     * @return int
     */
    @Override
    public int compare(ProposalPersonContract person1, ProposalPersonContract person2) {
        int retval = 0;
               
        if (person1.isInvestigator() || person2.isInvestigator()) {
            if (person1.isPrincipalInvestigator() 
                    || person2.isPrincipalInvestigator()) {
               if (person1.isPrincipalInvestigator()) {
                   retval--;
               }
               
               if (person2.isPrincipalInvestigator()) {
                   retval++;
               }
            }
        }
        
        if (retval == 0) {
            retval = massageOrdinalNumber(person1).compareTo(massageOrdinalNumber(person2));
        }
        
        if (retval == 0) {
            if (isNotBlank(person1.getFullName())) {
                retval = person1.getLastName().compareTo(person2.getLastName());
            }
            else if (isNotBlank(person2.getLastName())) {
                retval--; 
            }
        }
        
        LOG.info("retval = " + retval);

        return retval;
    }

    private Integer massageOrdinalNumber(ProposalPersonContract person) {
        return person.getOrdinalPosition() != null ? person.getOrdinalPosition() : -1;
    }
    
}
