/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrFedNonFedBudget12V12.RRFedNonFedBudget12Document;
import gov.grants.apply.forms.rrFedNonFedBudget12V12.RRFedNonFedBudget12Document.RRFedNonFedBudget12;
import gov.grants.apply.forms.rrFedNonFedSubawardBudget13V13.RRFedNonFedSubawardBudget13Document;
import gov.grants.apply.forms.rrFedNonFedSubawardBudget13V13.RRFedNonFedSubawardBudget13Document.RRFedNonFedSubawardBudget13;
import gov.grants.apply.forms.rrFedNonFedSubawardBudget13V13.RRFedNonFedSubawardBudget13Document.RRFedNonFedSubawardBudget13.BudgetAttachments;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@FormGenerator("RRFedNonFedSubAwardBudget_1_3_V1_3Generator")
public class RRFedNonFedSubAwardBudget_1_3_V1_3Generator extends S2SAdobeFormAttachmentBaseGenerator<RRFedNonFedSubawardBudget13Document> implements S2SFormGeneratorPdfFillable<RRFedNonFedSubawardBudget13Document> {

    @Value("http://apply.grants.gov/forms/RR_FedNonFed_SubawardBudget_1_3-V1.3")
    private String namespace;

    @Value("RRFedNonFedSubAwardBudget_1_3_V1_3")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_FedNonFedSubawardBudget13-V1.3.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_FedNonFed_SubawardBudget_1_3-V1.3.pdf")
    private Resource pdfForm;

    @Value("172")
    private int sortIndex;

    private static final String RR_FED_NON_FED_BUDGET_12_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_FedNonFedBudget_1_2-V1.2";
    private static final String LOCAL_FED_NON_FED_NAME = "RR_FedNonFedBudget_1_2";


    private RRFedNonFedSubawardBudget13Document getRRFedNonFedSubawardBudgetDocument() throws S2SException {
        RRFedNonFedSubawardBudget13 rrSubawardBudget = RRFedNonFedSubawardBudget13.Factory.newInstance();
        rrSubawardBudget.setFormVersion(FormVersion.v1_3.getVersion());

        List<BudgetSubAwardsContract> budgetSubAwardsList = getBudgetSubAwards(pdDoc, RR_FED_NON_FED_BUDGET_12_NAMESPACE_URI,false);
        RRFedNonFedBudget12[] budgetList = new RRFedNonFedBudget12[budgetSubAwardsList.size()];

        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRFedNonFedBudget12 rrBudget = getRRFedNonFedBudget(budgetSubAwards).getRRFedNonFedBudget12();
            switch (attCount) {
                case 1:
                    rrSubawardBudget.setATT1(prepareAttName(budgetSubAwards));
                    budgetList[0] = rrBudget;
                    break;
                case 2:
                    rrSubawardBudget.setATT2(prepareAttName(budgetSubAwards));
                    budgetList[1] = rrBudget;
                    break;
                case 3:
                    rrSubawardBudget.setATT3(prepareAttName(budgetSubAwards));
                    budgetList[2] = rrBudget;
                    break;
                case 4:
                    rrSubawardBudget.setATT4(prepareAttName(budgetSubAwards));
                    budgetList[3] = rrBudget;
                    break;
                case 5:
                    rrSubawardBudget.setATT5(prepareAttName(budgetSubAwards));
                    budgetList[4] = rrBudget;
                    break;
                case 6:
                    rrSubawardBudget.setATT6(prepareAttName(budgetSubAwards));
                    budgetList[5] = rrBudget;
                    break;
                case 7:
                    rrSubawardBudget.setATT7(prepareAttName(budgetSubAwards));
                    budgetList[6] = rrBudget;
                    break;
                case 8:
                    rrSubawardBudget.setATT8(prepareAttName(budgetSubAwards));
                    budgetList[7] = rrBudget;
                    break;
                case 9:
                    rrSubawardBudget.setATT9(prepareAttName(budgetSubAwards));
                    budgetList[8] = rrBudget;
                    break;
                case 10:
                    rrSubawardBudget.setATT10(prepareAttName(budgetSubAwards));
                    budgetList[9] = rrBudget;
                    break;
            }
            addSubAwdAttachments(budgetSubAwards);
            attCount++;
            
        }
        BudgetAttachments budgetAttachments = BudgetAttachments.Factory.newInstance();
        budgetAttachments.setRRFedNonFedBudget12Array(budgetList);
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        RRFedNonFedSubawardBudget13Document rrSubawardBudgetDocument = RRFedNonFedSubawardBudget13Document.Factory.newInstance();
        rrSubawardBudgetDocument.setRRFedNonFedSubawardBudget13(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRFedNonFedBudget12Document getRRFedNonFedBudget(BudgetSubAwardsContract budgetSubAwards) throws S2SException  {
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = stringToDom(subAwdXML);
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_FED_NON_FED_BUDGET_12_NAMESPACE_URI, LOCAL_FED_NON_FED_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null){
            if(subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }

        try {
            byte[] subAwdNodeBytes = docToBytes(nodeToDom(subAwdNode));
            return RRFedNonFedBudget12Document.Factory.parse(new ByteArrayInputStream(subAwdNodeBytes));
        } catch (XmlException|IOException e) {
            throw new RuntimeException(e);
        }

    }

    @Override
    public RRFedNonFedSubawardBudget13Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        pdDoc=proposalDevelopmentDocument;
        return getRRFedNonFedSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(RRFedNonFedSubawardBudget13Document form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRFedNonFedSubawardBudget13Document> factory() {
        return RRFedNonFedSubawardBudget13Document.Factory;
    }
}
