<!--
  #%L
  %%
  Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:NSF_CoverPage_2_3="http://apply.grants.gov/forms/NSF_CoverPage_2_3-V2.3"
xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" 
xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" 
xmlns:glob="http://apply.grants.gov/system/Global-V1.0" 
xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" 
xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.4in" margin-right="0.4in">
				<fo:region-body margin-top="0.9in" margin-bottom="0.6in"/>
				<fo:region-before extent=".5in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="NSF_CoverPage_2_3:NSF_CoverPage_2_3">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block>&#160;</fo:block>
					<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(20)"/>
						<fo:table-column column-width="proportional-column-width(60)"/>
						<fo:table-column column-width="proportional-column-width(20)"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="center">
										<fo:inline font-size="18pt"> National Science Foundation</fo:inline>
									</fo:block>
									<fo:block text-align="center">
										<fo:inline font-size="18pt"> Grant Application Cover Page</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell hyphenate="true" language="en" line-height="9pt" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="right" border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="8px" font-weight="100">OMB Number: 3145-0058</fo:inline>
									</fo:block>
									<fo:block>
										<fo:inline font-size="8px" font-weight="100">Expiration Date: 10/31/2025</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-weight="bold" font-size="8pt">
						<fo:block font-weight="100">Please complete the following NSF forms in conjunction with the relevant Research and Related forms.</fo:block>
						<fo:table border-style="solid" border-color="black" space-before.optimum="10pt" space-after.optimum="2pt" border-width="1pt" width="100%" table-layout="fixed">
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-style="solid" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(60)"/>
												<fo:table-column column-width="proportional-column-width(40)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
															<fo:block >1. Funding Opportunity Number</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Funding Opportunity Number:&#160;
																<fo:inline font-weight="100">
																	<xsl:value-of select="NSF_CoverPage_2_3:FundingOpportunityNumber"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt">
															<fo:block>Opportunity closing date:
																<fo:inline font-weight="100">
																	<xsl:for-each select="NSF_CoverPage_2_3:DueDate">
																		<xsl:value-of select="format-number(substring(.,6,2), '00')"/>
																		<xsl:text>-</xsl:text>
																		<xsl:value-of select="format-number(substring(.,9,2), '00')"/>
																		<xsl:text>-</xsl:text>
																		<xsl:value-of select="format-number(substring(.,1,4), '0000')"/>
																	</xsl:for-each>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt" border-style="solid" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table space-before.optimum="1pt" space-after.optimum="2pt" width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(35)"/>
												<fo:table-column column-width="proportional-column-width(65)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
															<fo:block>2. NSF Unit Consideration</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
															<fo:block font-weight="100">Go to	<fo:basic-link external-destination="url('https://www.fastlane.nsf.gov/pgmannounce.jsp')" color="blue" text-decoration="underline">https://www.fastlane.nsf.gov/pgmannounce.jsp</fo:basic-link>
																and follow the instructions to find the Division and Program information for this funding opportunity.
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Division Code:
																<fo:inline font-weight="100">
																	<xsl:value-of select="NSF_CoverPage_2_3:NSFUnitConsideration/NSF_CoverPage_2_3:DivisionCode"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block>Division Name:
																<fo:inline font-weight="100">
																	<xsl:value-of select="NSF_CoverPage_2_3:NSFUnitConsideration/NSF_CoverPage_2_3:DivisionName"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Program Code:
																<fo:inline font-weight="100">
																	<xsl:value-of select="NSF_CoverPage_2_3:NSFUnitConsideration/NSF_CoverPage_2_3:ProgramCode"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block>Program Name:
																<fo:inline font-weight="100">
																	<xsl:value-of select="NSF_CoverPage_2_3:NSFUnitConsideration/NSF_CoverPage_2_3:ProgramName"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-style="solid" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table space-before.optimum="1pt" space-after.optimum="2pt" width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
														<fo:block>3. Principal Investigator (PI) Information</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block font-weight="100">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:PIInfo/NSF_CoverPage_2_3:isCurrentPI !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			<fo:leader leader-length="7pt" leader-pattern="rule"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															Check here if you are currently serving (or have previously served) as a PI, co-PI or Program Director (PD) on any Federally funded project.</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-style="solid" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table space-before.optimum="1pt" space-after.optimum="2pt" space-start.optimum="5pt" width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(4)"/>
												<fo:table-column column-width="proportional-column-width(46)"/>
												<fo:table-column column-width="proportional-column-width(4)"/>
												<fo:table-column column-width="proportional-column-width(46)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="4">
															<fo:block>4. Other Information</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="4">
															<fo:block font-weight="100">Check Appropriate Box (es) if this proposal includes any of the items listed below.</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:isBeginInvestigator !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Beginning Investigator (Proposal &amp; Award Policies &amp; Procedures
																Guide (PAPPG II.E.2))</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:isDisclosureLobbyingActivities !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Disclosure of Lobbying Activities (PAPPG II.D.1.d)</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:isAccomplishmentRenewal !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Accomplishment-Based Renewal (PAPPG Chapter V.B)																		</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:isFundingInternationalBranch !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Funding of an International Branch Campus of a U.S. IHE
																(PAPPG Chapter I.E.1)
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:isFundingForeignOrganization !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Funding of a Foreign Organization or Foreign Individual
																(PAPPG I.E.2.c)
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:isPotentialLifeSciences !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Potential Life Sciences Dual Use Research of Concern (PAPPG
																II.E.6 &amp; XI.B.5)
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:isOffSiteResearch !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Off-Campus or Off-Site Research (PAPPG II.D.1.d (viii) &amp; II.E.9)</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt">
															<fo:block font-weight="100" text-align="right">
																<xsl:choose>
																	<xsl:when test="NSF_CoverPage_2_3:OtherInfo/NSF_CoverPage_2_3:potentialImpacts !='N: No'">
																		<fo:inline text-decoration="underline" font-family="ZapfDingbats" font-size="8pt" padding-start="1.5pt" padding-end="1.5pt">&#x2714;</fo:inline>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline text-decoration="underline" color="black">
																			&#160;&#160;&#160;
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="1pt" padding-after="1pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">Potential Impacts on Tribal Nations</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
										<fo:block>
											<fo:table space-before.optimum="1pt" space-after.optimum="2pt" width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(30)"/>
												<fo:table-column column-width="proportional-column-width(70)"/>
												<fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
                                                            <fo:block font-weight="100">Attach PDF files only for any attachments below.</fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
															<fo:block>
																5. Additional Single-Copy Documents
                                                            </fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
															<fo:block>Mime Type:</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block>File Name:</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<xsl:for-each select="NSF_CoverPage_2_3:Single-CopyDocuments/att:AttachedFile">
														<fo:table-row>
															<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
																<fo:block font-weight="100" hyphenate="true" language="en">
																	<xsl:value-of select="att:MimeType"/>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
																<fo:block font-weight="100" hyphenate="true" language="en">
																	<xsl:value-of select="att:FileName"/>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
                                                            <fo:block>
                                                                6. Data Management and Sharing Plan
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block>Mime Type:</fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block>File Name:</fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:Data-Management-Plan/att:MimeType"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:Data-Management-Plan/att:FileName"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
                                                            <fo:block>
                                                                7. Mentoring Plan
                                                            </fo:block>
                                                        </fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100">
																The Mentoring Plan, required for proposals that request funding to support postdoctoral researchers, and Graduate students
																(PAPPG Chapter II.D.2.i)
															</fo:block>
														</fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block>Mime Type:</fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block>File Name:</fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:Mentoring-Plan/att:MimeType"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:Mentoring-Plan/att:FileName"/>
                                                                </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
                                                            <fo:block>
                                                                8. GOALI - Industrial PI Confirmation Letter
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block>Mime Type:</fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block>File Name:</fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:GOALILetter/att:MimeType"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:GOALILetter/att:FileName"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
                                                            <fo:block>
                                                                9. RAPID, EAGER or RAISE - Program Officer Concurrence Email
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block>Mime Type:</fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block>File Name:</fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:RAISEEmail/att:MimeType"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block font-weight="100" hyphenate="true" language="en">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:RAISEEmail/att:FileName"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt" number-columns-spanned="2">
															<fo:block>
																10. Potential Impacts on Tribal Nations
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
															<fo:block>Mime Type:</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block>File Name:</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
															<fo:block font-weight="100" hyphenate="true" language="en">
																<xsl:value-of select="NSF_CoverPage_2_3:PotentialImpacts1/att:MimeType"/>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100" hyphenate="true" language="en">
																<xsl:value-of select="NSF_CoverPage_2_3:PotentialImpacts1/att:FileName"/>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
															<fo:block>Mime Type:</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block>File Name:</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="15pt">
															<fo:block font-weight="100" hyphenate="true" language="en">
																<xsl:value-of select="NSF_CoverPage_2_3:PotentialImpacts2/att:MimeType"/>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
															<fo:block font-weight="100" hyphenate="true" language="en">
																<xsl:value-of select="NSF_CoverPage_2_3:PotentialImpacts2/att:FileName"/>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

                                <fo:table-row>
                                    <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-style="solid" border-color="black" border-width="1pt">
                                        <fo:block>
                                            <fo:table space-before.optimum="1pt" space-after.optimum="2pt" width="100%" table-layout="fixed">
                                                <fo:table-column column-width="proportional-column-width(30)"/>
                                                <fo:table-column column-width="proportional-column-width(70)"/>
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
                                                            <fo:block>11. Type of Proposal</fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="1pt">
                                                            <fo:block font-weight="100">
                                                                <xsl:value-of select="NSF_CoverPage_2_3:FundingMechanism"/>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

                                <fo:table-row>
                                    <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-style="solid" border-color="black" border-width="1pt">
                                        <fo:block>
                                            <fo:table space-before.optimum="1pt" space-after.optimum="2pt" width="100%" table-layout="fixed">
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-body>
                                                    <fo:table-row>
                                                        <fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
                                                            <fo:block>12. Authorized Representative (AOR)</fo:block>
                                                            <fo:block font-weight="100" space-before.optimum="7pt">Provide the NSF ID associated with the AOR for this application:</fo:block>
                                                            <fo:block space-before.optimum="7pt">NSF ID:&#160;
                                                                <fo:inline font-weight="100"><xsl:value-of select="NSF_CoverPage_2_3:NSFID"/></fo:inline>
															</fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-body>
                                            </fo:table>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>

							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
