/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.BlanketApproveEngine;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class BlanketApproveAction
extends ActionTakenEvent {
    private static final Logger LOG = LogManager.getLogger(BlanketApproveAction.class);
    private Set<String> nodeNames;

    public BlanketApproveAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        this(rh, principal, DEFAULT_ANNOTATION, (Set<String>)null);
    }

    public BlanketApproveAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation, Integer routeLevel) {
        this(rh, principal, annotation, BlanketApproveAction.convertRouteLevel(rh.getDocumentType(), routeLevel));
    }

    public BlanketApproveAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation, String nodeName) {
        this(rh, principal, annotation, Collections.singleton(nodeName));
    }

    public BlanketApproveAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation, Set<String> nodeNames) {
        super("B", rh, principal, annotation, true, false);
        this.nodeNames = nodeNames == null ? new HashSet() : nodeNames;
    }

    private static Set<String> convertRouteLevel(DocumentType documentType, Integer routeLevel) {
        HashSet<String> nodeNames = new HashSet<String>();
        if (routeLevel == null) {
            return nodeNames;
        }
        RouteNode node = CompatUtils.getNodeForLevel(documentType, routeLevel);
        if (node == null) {
            throw new WorkflowRuntimeException("Could not locate a valid node for the given route level: " + routeLevel);
        }
        nodeNames.add(node.getRouteNodeName());
        return nodeNames;
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        String nodeName;
        if (this.nodeNames != null && !this.nodeNames.isEmpty() && !StringUtils.isEmpty((String)(nodeName = this.isGivenNodeListValid()))) {
            return "Document already at or beyond route node " + nodeName;
        }
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be approved";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "C");
        if (!this.isActionCompatibleRequest(filteredActionRequests)) {
            return "No request for the user is compatible with the BlanketApprove Action";
        }
        if (!KEWServiceLocator.getDocumentTypePermissionService().canBlanketApprove(this.getPrincipal().getPrincipalId(), this.getRouteHeader())) {
            return "User is not authorized to BlanketApprove document";
        }
        return "";
    }

    private String isGivenNodeListValid() {
        Iterator<String> iterator = this.nodeNames.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            if (nodeName == null) {
                iterator.remove();
                continue;
            }
            if (this.getRouteNodeService().isNodeInPath(this.getRouteHeader(), nodeName)) continue;
            return nodeName;
        }
        return "";
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "C");
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        LOG.debug("Checking to see if the action is legal");
        LOG.debug("Blanket approving document : " + this.annotation);
        if (this.getRouteHeader().isStateInitiated() || this.getRouteHeader().isStateSaved()) {
            this.markDocumentEnroute(this.getRouteHeader());
            this.getRouteHeader().setRoutedByUserWorkflowId(this.getPrincipal().getPrincipalId());
        }
        LOG.debug("Record the blanket approval action");
        Recipient delegator = this.findDelegatorForActionRequests(actionRequests);
        ActionTakenValue actionTaken = this.saveActionTaken(delegator);
        LOG.debug("Deactivate pending action requests for user");
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
        DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
        this.setRouteHeader(routeHeaderValue);
        this.queueDeferredWork(actionTaken);
    }

    protected void queueDeferredWork(ActionTakenValue actionTaken) {
        try {
            boolean shouldIndex = this.getRouteHeader().getDocumentType().hasSearchableAttributes() && RouteContext.getCurrentRouteContext().isSearchIndexingRequestedForContext();
            String applicationId = this.routeHeader.getDocumentType().getApplicationId();
            DocumentOrchestrationQueue blanketApprove = KewApiServiceLocator.getDocumentOrchestrationQueue((String)applicationId);
            org.kuali.rice.kew.api.document.OrchestrationConfig orchestrationConfig = org.kuali.rice.kew.api.document.OrchestrationConfig.create((String)actionTaken.getActionTakenId(), this.nodeNames);
            DocumentProcessingOptions options = DocumentProcessingOptions.create((boolean)true, (boolean)shouldIndex);
            blanketApprove.orchestrateDocument(this.routeHeader.getDocumentId(), this.getPrincipal().getPrincipalId(), orchestrationConfig, options);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public void performDeferredBlanketApproveWork(ActionTakenValue actionTaken, DocumentProcessingOptions processingOptions) throws Exception {
        if (this.getRouteHeader().isInException()) {
            LOG.debug("Moving document back to Enroute from Exception");
            this.markDocumentEnroute(this.getRouteHeader());
        }
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.BLANKET_APPROVAL, this.nodeNames, actionTaken, processingOptions.isSendNotifications(), processingOptions.isRunPostProcessor(), processingOptions.isDeactivateAcknowledgements(), processingOptions.isDeactivateFYIs());
        BlanketApproveEngine blanketApproveEngine = (BlanketApproveEngine)KEWServiceLocator.getWorkflowEngineFactory().newEngine(config);
        blanketApproveEngine.process(this.getRouteHeader().getDocumentId());
        this.queueDocumentProcessing();
    }

    protected void markDocumentEnroute(DocumentRouteHeaderValue routeHeader) throws InvalidActionTakenException {
        String oldStatus = routeHeader.getDocRouteStatus();
        routeHeader.markDocumentEnroute();
        String newStatus = routeHeader.getDocRouteStatus();
        this.notifyStatusChange(newStatus, oldStatus);
        DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(routeHeader);
        this.setRouteHeader(routeHeaderValue);
    }

    private RouteNodeService getRouteNodeService() {
        return KEWServiceLocator.getRouteNodeService();
    }
}

