/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.collections.LineBuilderContext;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.layout.CollectionLayoutUtils;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.layout.collections.TableRow;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

public class TableRowBuilder
implements Serializable {
    private static final long serialVersionUID = 5098939594340088940L;
    private CollectionGroup collectionGroup;
    private TableLayoutManager tableLayoutManager;
    private LineBuilderContext lineBuilderContext;

    public TableRowBuilder() {
    }

    public TableRowBuilder(CollectionGroup collectionGroup, LineBuilderContext lineBuilderContext) {
        this.collectionGroup = collectionGroup;
        if (collectionGroup != null) {
            this.tableLayoutManager = (TableLayoutManager)collectionGroup.getLayoutManager();
        }
        this.lineBuilderContext = lineBuilderContext;
    }

    public TableRow buildRow() {
        boolean hasGrouping;
        ColumnCollector columnCollector = new ColumnCollector(this.tableLayoutManager.getActionColumnIndex());
        if (this.tableLayoutManager.isRenderSequenceField()) {
            this.addSequenceColumn(columnCollector);
        }
        if (this.collectionGroup.isIncludeLineSelectionField()) {
            this.addLineSelectColumn(columnCollector);
        }
        boolean bl = hasGrouping = this.tableLayoutManager.getGroupingPropertyNames() != null || StringUtils.isNotBlank((String)this.tableLayoutManager.getGroupingTitle());
        if (hasGrouping) {
            this.addGroupingColumn(columnCollector);
        }
        for (Field lineField : this.lineBuilderContext.getLineFields()) {
            boolean hasRoleAttribute;
            Map<String, String> fieldDataAttributes = lineField.getDataAttributes();
            boolean bl2 = hasRoleAttribute = fieldDataAttributes != null && fieldDataAttributes.containsKey("role");
            if (hasRoleAttribute && "RowGrouping".equals(fieldDataAttributes.get("role"))) continue;
            columnCollector.addColumn(lineField);
        }
        columnCollector.finishRow();
        return new TableRow(columnCollector.getColumns());
    }

    protected void addSequenceColumn(ColumnCollector columnCollector) {
        Field sequenceField;
        if (this.lineBuilderContext.isAddLine()) {
            sequenceField = ComponentFactory.getMessageField();
            Message sequenceMessage = ComponentUtils.copy(this.collectionGroup.getAddLineLabel(), this.lineBuilderContext.getIdSuffix());
            ((MessageField)sequenceField).setMessage(sequenceMessage);
        } else {
            sequenceField = ComponentUtils.copy(this.tableLayoutManager.getSequenceFieldPrototype(), this.lineBuilderContext.getIdSuffix());
            sequenceField.addDataAttribute("vignore", "yes");
            if (this.tableLayoutManager.isGenerateAutoSequence() && sequenceField instanceof MessageField) {
                ((MessageField)sequenceField).setMessageText(Integer.toString(this.lineBuilderContext.getLineIndex() + 1));
            }
            if (sequenceField instanceof DataBinding) {
                ((DataBinding)((Object)sequenceField)).getBindingInfo().setBindByNamePrefix(this.lineBuilderContext.getBindingPath());
            }
        }
        ContextUtils.updateContextForLine(sequenceField, this.collectionGroup, this.lineBuilderContext.getCurrentLine(), this.lineBuilderContext.getLineIndex(), this.lineBuilderContext.getIdSuffix());
        columnCollector.addColumn(sequenceField);
    }

    protected void addLineSelectColumn(ColumnCollector columnCollector) {
        Field selectField = ComponentUtils.copy(this.tableLayoutManager.getSelectFieldPrototype(), this.lineBuilderContext.getIdSuffix());
        CollectionLayoutUtils.prepareSelectFieldForLine(selectField, this.collectionGroup, this.lineBuilderContext.getBindingPath(), this.lineBuilderContext.getCurrentLine());
        ContextUtils.updateContextForLine(selectField, this.collectionGroup, this.lineBuilderContext.getCurrentLine(), this.lineBuilderContext.getLineIndex(), this.lineBuilderContext.getIdSuffix());
        columnCollector.addColumn(selectField);
    }

    protected void addGroupingColumn(ColumnCollector columnCollector) {
        if (this.lineBuilderContext.isAddLine()) {
            SpaceField spaceField = ComponentFactory.getSpaceField();
            columnCollector.addColumn(spaceField);
            return;
        }
        MessageField groupingMessageField = ComponentFactory.getColGroupingField();
        StringBuilder groupingTitle = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.tableLayoutManager.getGroupingTitle())) {
            groupingTitle.append(this.tableLayoutManager.getGroupingTitle());
        } else if (this.tableLayoutManager.getGroupingPropertyNames() != null) {
            for (String propertyName : this.tableLayoutManager.getGroupingPropertyNames()) {
                Object propertyValue = ObjectPropertyUtils.getPropertyValue(this.lineBuilderContext.getCurrentLine(), propertyName);
                if (propertyValue == null) {
                    propertyValue = "Null";
                }
                if (groupingTitle.length() != 0) {
                    groupingTitle.append(", ");
                }
                groupingTitle.append(propertyValue);
            }
        }
        groupingMessageField.setMessageText(groupingTitle.toString());
        groupingMessageField.addDataAttribute("role", "RowGrouping");
        columnCollector.addColumn(groupingMessageField);
    }

    public class ColumnCollector
    implements Serializable {
        private static final long serialVersionUID = 7129699106011942622L;
        private int actionColumnIndex;
        private int currentIndex = 0;
        private List<Field> columns;

        public ColumnCollector(int actionColumnIndex) {
            this.actionColumnIndex = actionColumnIndex;
            this.columns = new ArrayList<Field>();
        }

        public void addColumn(Field column) {
            if (this.isRenderActions() && this.actionColumnIndex == this.currentIndex + 1) {
                FieldGroup actionColumn = this.buildActionColumn();
                this.columns.add(actionColumn);
                ++this.currentIndex;
            }
            this.columns.add(column);
            ++this.currentIndex;
        }

        public void finishRow() {
            if (this.isRenderActions() && this.actionColumnIndex == this.currentIndex + 1 || this.actionColumnIndex == -1) {
                FieldGroup actionColumn = this.buildActionColumn();
                this.columns.add(actionColumn);
            }
        }

        protected FieldGroup buildActionColumn() {
            FieldGroup lineActionsField = ComponentUtils.copy(TableRowBuilder.this.tableLayoutManager.getActionFieldPrototype(), TableRowBuilder.this.lineBuilderContext.getIdSuffix());
            ContextUtils.updateContextForLine(lineActionsField, TableRowBuilder.this.collectionGroup, TableRowBuilder.this.lineBuilderContext.getCurrentLine(), TableRowBuilder.this.lineBuilderContext.getLineIndex(), TableRowBuilder.this.lineBuilderContext.getIdSuffix());
            lineActionsField.setItems(TableRowBuilder.this.lineBuilderContext.getLineActions());
            if (lineActionsField.getWrapperCssClasses() != null && !lineActionsField.getWrapperCssClasses().contains("uif-collection-column-action")) {
                lineActionsField.getWrapperCssClasses().add("uif-collection-column-action");
            } else {
                lineActionsField.setWrapperCssClasses(Arrays.asList("uif-collection-column-action"));
            }
            return lineActionsField;
        }

        public boolean isRenderActions() {
            return TableRowBuilder.this.collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(TableRowBuilder.this.collectionGroup.getReadOnly());
        }

        public List<Field> getColumns() {
            return this.columns;
        }
    }
}

