/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.util.BrokerHelper;

public class Identity
implements Serializable {
    private static final long serialVersionUID = 3182285550574178710L;
    private static final int IS_TRANSIENT = 3;
    private static final int IS_PERMANENT = 17;
    private static final int iConstant = 37;
    private Class m_objectsTopLevelClass;
    private Class m_objectsRealClass = null;
    private Object[] m_pkValues;
    private final int isTransient;
    private transient String m_stringRepresentation = null;
    private transient Integer m_hashCode;

    protected Identity() {
        this.isTransient = 3;
    }

    public Identity(Class clazz, Class clazz2, Object[] objectArray, boolean bl) {
        this.m_objectsTopLevelClass = clazz2;
        this.m_objectsRealClass = clazz;
        this.m_pkValues = objectArray;
        this.isTransient = bl ? 3 : 17;
        this.checkForPrimaryKeys(null);
    }

    public Identity(Class clazz, Class clazz2, Object[] objectArray) {
        this.m_objectsTopLevelClass = clazz2;
        this.m_objectsRealClass = clazz;
        this.m_pkValues = objectArray;
        this.isTransient = 17;
        this.checkForPrimaryKeys(null);
    }

    public Identity(Object object, PersistenceBroker persistenceBroker) {
        this.isTransient = 17;
        this.init(object, persistenceBroker, null);
    }

    public Identity(Object object, PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor) {
        this.isTransient = 17;
        this.init(object, persistenceBroker, classDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Object object, PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor) {
        if (object == null) {
            throw new OJBRuntimeException("Can't create Identity for 'null'-object");
        }
        try {
            IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
            Object object2 = object;
            synchronized (object2) {
                if (indirectionHandler != null) {
                    Identity identity = indirectionHandler.getIdentity();
                    this.m_objectsTopLevelClass = identity.m_objectsTopLevelClass;
                    this.m_objectsRealClass = identity.m_objectsRealClass;
                    this.m_pkValues = identity.m_pkValues;
                } else {
                    if (classDescriptor == null) {
                        classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
                    }
                    this.m_objectsTopLevelClass = persistenceBroker.getTopLevelClass(object.getClass());
                    this.m_objectsRealClass = object.getClass();
                    BrokerHelper brokerHelper = persistenceBroker.serviceBrokerHelper();
                    ValueContainer[] valueContainerArray = brokerHelper.getValuesForObject(classDescriptor.getPkFields(), object, false, true);
                    if (valueContainerArray == null || valueContainerArray.length == 0) {
                        throw this.createException("Can't extract PK value fields", object, null);
                    }
                    this.m_pkValues = brokerHelper.extractValueArray(valueContainerArray);
                }
            }
            this.checkForPrimaryKeys(object);
        }
        catch (ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            throw classNotPersistenceCapableException;
        }
        catch (Exception exception) {
            throw this.createException("Can not init Identity for given object.", object, exception);
        }
    }

    public static Identity fromByteArray(byte[] byArray) throws PersistenceBrokerException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            Identity identity = (Identity)objectInputStream.readObject();
            objectInputStream.close();
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return identity;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
    }

    public boolean isTransient() {
        return this.isTransient == 3;
    }

    public Class getObjectsTopLevelClass() {
        return this.m_objectsTopLevelClass;
    }

    public Class getObjectsRealClass() {
        return this.m_objectsRealClass;
    }

    public void setObjectsRealClass(Class clazz) {
        this.m_objectsRealClass = clazz;
    }

    public byte[] serialize() throws PersistenceBrokerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
    }

    public String toString() {
        if (this.m_stringRepresentation == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_objectsTopLevelClass.getName());
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                stringBuffer.append(i == 0 ? "{" : ",");
                stringBuffer.append(this.m_pkValues[i]);
            }
            stringBuffer.append("}");
            if (this.isTransient == 3) {
                stringBuffer.append("-transient");
            }
            this.m_stringRepresentation = stringBuffer.toString();
        }
        return this.m_stringRepresentation;
    }

    protected void checkForPrimaryKeys(Object object) throws ClassNotPersistenceCapableException {
        if (this.m_pkValues == null || this.m_pkValues.length == 0) {
            throw this.createException("OJB needs at least one primary key attribute for class: ", object, null);
        }
    }

    public Object[] getPrimaryKeyValues() {
        return this.m_pkValues;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            boolean bl2 = bl = this.m_objectsTopLevelClass.equals(identity.m_objectsTopLevelClass) && this.isTransient == identity.isTransient;
            if (bl) {
                Object[] objectArray = identity.m_pkValues;
                boolean bl3 = bl = this.m_pkValues.length == objectArray.length;
                if (bl) {
                    for (int i = 0; bl && i < this.m_pkValues.length; ++i) {
                        boolean bl4 = this.m_pkValues[i] == null ? objectArray[i] == null : (bl = this.m_pkValues[i].equals(objectArray[i]));
                        if (bl || !(this.m_pkValues[i] instanceof byte[]) || !(objectArray[i] instanceof byte[])) continue;
                        bl = Arrays.equals((byte[])this.m_pkValues[i], (byte[])objectArray[i]);
                    }
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        if (this.m_hashCode == null) {
            int n = this.isTransient;
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                Object object = this.m_pkValues[i];
                n = object instanceof byte[] ? n * 37 + ((byte[])object).length : n * 37 + (object != null ? object.hashCode() : 0);
            }
            n = n * 37 + this.m_objectsTopLevelClass.hashCode();
            this.m_hashCode = new Integer(n);
        }
        return this.m_hashCode;
    }

    private ClassNotPersistenceCapableException createException(String string, Object object, Exception exception) {
        String string2 = SystemUtils.LINE_SEPARATOR;
        if (string == null) {
            string = "Unexpected error:";
        }
        if (exception != null) {
            return new ClassNotPersistenceCapableException(string + string2 + "objectTopLevelClass=" + (this.m_objectsTopLevelClass != null ? this.m_objectsTopLevelClass.getName() : null) + string2 + "objectRealClass=" + (this.m_objectsRealClass != null ? this.m_objectsRealClass.getName() : null) + string2 + "pkValues=" + (this.m_pkValues != null ? ArrayUtils.toString((Object)this.m_pkValues) : null) + (object != null ? string2 + "object to identify: " + object : ""), exception);
        }
        return new ClassNotPersistenceCapableException(string + string2 + "objectTopLevelClass=" + (this.m_objectsTopLevelClass != null ? this.m_objectsTopLevelClass.getName() : null) + string2 + "objectRealClass=" + (this.m_objectsRealClass != null ? this.m_objectsRealClass.getName() : null) + string2 + "pkValues=" + (this.m_pkValues != null ? ArrayUtils.toString((Object)this.m_pkValues) : null) + string2 + "object to identify: " + object);
    }
}

