/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardBudgeCostTotalAuditRule
implements DocumentAuditRule {
    public static final String AWARD_BUDGET_TOTAL_COST_ERROR_KEY = "awardBudgetTotalCostAuditErrors";

    public boolean processRunAuditBusinessRules(Document document) {
        AwardBudgetExt budget = ((AwardBudgetDocument)document).getBudget();
        boolean valid = true;
        String[] params = new String[]{"Budget Overview Cost Total"};
        if (!budget.getTotalCost().equals((Object)budget.getTotalCostLimit())) {
            this.getAuditErrors().add(new AuditError("document.budget.totalCost", "error.budget.total.cost", "parameters.BudgetPeriodsTotals", params));
            valid = false;
        }
        return valid;
    }

    private List<AuditError> getAuditErrors() {
        return this.getAuditProblems("Error");
    }

    private List<AuditError> getAuditProblems(String problemType) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(AWARD_BUDGET_TOTAL_COST_ERROR_KEY)) {
            GlobalVariables.getAuditErrorMap().put(AWARD_BUDGET_TOTAL_COST_ERROR_KEY, new AuditCluster("Budget Period And Totals Information", auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(AWARD_BUDGET_TOTAL_COST_ERROR_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }
}

