/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRemoteServiceConnectionException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.framework.group.GroupTypeService;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.remoting.RemoteAccessException;

public class KimTypeLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger(KimTypeLookupableHelperServiceImpl.class);
    private static final long serialVersionUID = 1L;

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        List searchResults = super.getSearchResultsHelper(fieldValues, unbounded);
        ArrayList<KimTypeBo> filteredSearchResults = new ArrayList<KimTypeBo>();
        DocumentTypeService dts = KEWServiceLocator.getDocumentTypeService();
        DocumentType st = dts.findByDocumentId(fieldValues.get("docNum"));
        String docName = "";
        if (st != null) {
            docName = st.getName();
        }
        if ("IMRD".equals(fieldValues.get("docFormKey"))) {
            for (KimTypeBo kimTypeBo : searchResults) {
                if (!KimTypeLookupableHelperServiceImpl.hasRoleTypeService(KimTypeBo.to((KimTypeBo)kimTypeBo))) continue;
                filteredSearchResults.add(kimTypeBo);
            }
            return filteredSearchResults;
        }
        if ("IdentityManagementGroupDocument".equals(docName)) {
            for (KimTypeBo kimTypeBo : searchResults) {
                if (!KimTypeLookupableHelperServiceImpl.hasGroupTypeService(KimTypeBo.to((KimTypeBo)kimTypeBo))) continue;
                filteredSearchResults.add(kimTypeBo);
            }
            return filteredSearchResults;
        }
        return searchResults;
    }

    protected String getReturnHref(Properties parameters, LookupForm lookupForm, List returnKeys) {
        KimType kimType = KimApiServiceLocator.getKimTypeInfoService().getKimType(parameters.getProperty("id"));
        String href = "";
        boolean showReturnHref = true;
        boolean refreshMe = false;
        String docTypeName = "";
        String docTypeAction = "";
        if ("IMRD".equals(lookupForm.getFormKey())) {
            docTypeName = "IdentityManagementRoleDocument";
            docTypeAction = "identityManagementRoleDocument.do";
            showReturnHref = kimType != null && (StringUtils.isBlank((String)kimType.getServiceName()) || KimFrameworkServiceLocator.getKimTypeService((KimType)kimType) instanceof RoleTypeService);
        } else {
            docTypeName = "IdentityManagementGroupDocument";
            docTypeAction = "identityManagementGroupDocument.do";
            refreshMe = true;
        }
        if (showReturnHref) {
            if (!refreshMe) {
                parameters.put("methodToCall", "docHandler");
                parameters.put("command", "initiate");
                parameters.put("docTypeName", docTypeName);
                if (StringUtils.isNotBlank((String)this.getReturnLocation())) {
                    parameters.put("returnLocation", this.getReturnLocation());
                }
            }
            href = UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + docTypeAction), (Properties)parameters);
        }
        return href;
    }

    public static boolean hasRoleTypeService(KimType kimType) {
        return kimType != null && kimType.getServiceName() == null || KimFrameworkServiceLocator.getKimTypeService((KimType)kimType) instanceof RoleTypeService;
    }

    public static boolean hasRoleTypeService(KimType kimType, KimTypeService kimTypeService) {
        return kimType != null && kimType.getServiceName() == null || kimTypeService instanceof RoleTypeService;
    }

    public static boolean hasGroupTypeService(KimType kimType) {
        return kimType != null && kimType.getServiceName() == null || KimFrameworkServiceLocator.getKimTypeService((KimType)kimType) instanceof GroupTypeService;
    }

    public static boolean hasDerivedRoleTypeService(KimType kimType) {
        boolean hasDerivedRoleTypeService = false;
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
        try {
            if (KimTypeLookupableHelperServiceImpl.hasRoleTypeService(kimType, kimTypeService)) {
                hasDerivedRoleTypeService = kimType.getServiceName() != null && ((RoleTypeService)kimTypeService).isDerivedRoleType();
            }
        }
        catch (RiceRemoteServiceConnectionException ex) {
            LOG.warn("Not able to retrieve KimTypeService from remote system for KIM Type: " + kimType.getName(), (Throwable)ex);
        }
        catch (RemoteAccessException rae) {
            LOG.warn("Not able to retrieve KimTypeService from remote system for KIM Type: " + kimType.getName(), (Throwable)rae);
        }
        catch (WebServiceException e) {
            LOG.warn("Not able to retrieve KimTypeService from remote system for KIM Type: " + kimType.getName(), (Throwable)e);
        }
        return hasDerivedRoleTypeService;
    }
}

