/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.s3.api;

import co.kuali.coeus.s3.api.S3FileService;
import co.kuali.coeus.s3.impl.S3FileServiceimpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3FileServiceFactoryBean
implements FactoryBean<S3FileService>,
InitializingBean {
    private String bucketName;
    private boolean replicationBucket = false;
    private String region;
    private String accessKey;
    private String secretKey;
    private boolean encryptionEnabled = false;
    private String encryptionKey;
    private String confidentialDataTagName;
    private boolean confidentialData = true;
    private boolean singleton = true;

    public S3FileService getObject() {
        boolean awsCredsProvided = this.accessKey != null && !this.accessKey.trim().isEmpty() && this.secretKey != null && !this.secretKey.trim().isEmpty();
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().region(Region.of((String)this.getRegion()));
        S3Client s3 = (S3Client)(awsCredsProvided ? (S3ClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey))) : builder).build();
        S3FileServiceimpl s3FileService = new S3FileServiceimpl();
        s3FileService.setAmazonS3(s3);
        s3FileService.setBucketName(this.bucketName);
        if (this.replicationBucket) {
            s3FileService.setReplicationBucketName(this.toReplicationBucket(this.bucketName));
        }
        s3FileService.setEncryptionEnabled(this.encryptionEnabled);
        s3FileService.setEncryptionKey(this.encryptionKey);
        s3FileService.setConfidentialDataTagName(this.confidentialDataTagName);
        s3FileService.setConfidentialData(this.confidentialData);
        return s3FileService;
    }

    public Class<?> getObjectType() {
        return S3FileService.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isReplicationBucket() {
        return this.replicationBucket;
    }

    public void setReplicationBucket(boolean replicationBucket) {
        this.replicationBucket = replicationBucket;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public void setEncryptionEnabled(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getConfidentialDataTagName() {
        return this.confidentialDataTagName;
    }

    public void setConfidentialDataTagName(String confidentialDataTagName) {
        this.confidentialDataTagName = confidentialDataTagName;
    }

    public boolean isConfidentialData() {
        return this.confidentialData;
    }

    public void setConfidentialData(boolean confidentialData) {
        this.confidentialData = confidentialData;
    }

    private String toReplicationBucket(String bucketName) {
        return bucketName + "-r";
    }

    public void afterPropertiesSet() {
        if (StringUtils.isBlank((CharSequence)this.bucketName)) {
            throw new IllegalStateException("bucket name is blank");
        }
        if (Region.of((String)this.region) == null) {
            throw new IllegalStateException("Invalid region " + this.region);
        }
    }
}

