/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.core.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.core.groups.GroupsPushService;
import org.kuali.coeus.common.framework.core.groups.GroupsPushStatus;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.coeus.sys.framework.auth.AuthUser;
import org.kuali.coeus.sys.framework.auth.CategoryDto;
import org.kuali.coeus.sys.framework.auth.CoreGroupsService;
import org.kuali.coeus.sys.framework.auth.GroupDto;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="groupsPushService")
public class GroupsPushServiceImpl
implements GroupsPushService {
    private static final String ACTIVE_FIELD_DESCRIPTION = "Active";
    private static final String UNIT_NUMBER_FIELD_DESCRIPTION = "Unit Number";
    private static final String CHECKBOX_FIELD_TYPE = "checkbox";
    private static final String TEXT_FIELD_TYPE = "text";
    private static final Logger LOG = LogManager.getLogger(GroupsPushServiceImpl.class);
    private static final String ROLE_IDS_TO_PUSH_TO_GROUPS = "Role_Ids_To_Push_To_Groups";
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="coreGroupsService")
    private CoreGroupsService coreGroupsService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService RoleService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public GroupsPushStatus pushAllGroups() {
        GroupsPushStatus status = new GroupsPushStatus();
        List categories = this.getAllCategories().sorted(Comparator.comparing(CategoryDto::getId)).collect(Collectors.toCollection(ArrayList::new));
        List<GroupDto> groups = this.getAllGroups().toList();
        List<UnitAdministratorType> unitAdminTypes = this.getUnitAdministratorTypes();
        Unit topUnit = this.unitService.getTopUnit();
        this.syncGroups(Collections.singletonList(topUnit), null, 1, null, categories, groups, unitAdminTypes, new ArrayList<Integer>(), status);
        return status;
    }

    protected List<UnitAdministratorType> getUnitAdministratorTypes() {
        return this.dataObjectService.findAll(UnitAdministratorType.class).getResults();
    }

    protected void syncGroups(List<Unit> units, GroupDto parentGroup, Integer level, CategoryDto parentCategory, List<CategoryDto> categories, List<GroupDto> groups, List<UnitAdministratorType> unitAdminTypes, List<Integer> levelsSynced, GroupsPushStatus status) {
        CategoryDto category;
        Optional<CategoryDto> currentCategory = this.findChildCategory(parentCategory, categories);
        if (currentCategory.isEmpty() || !levelsSynced.contains(level)) {
            category = this.syncCategory(currentCategory, parentCategory, level, unitAdminTypes, status);
            if (currentCategory.isEmpty()) {
                categories.add(category);
            }
            levelsSynced.add(level);
        } else {
            category = currentCategory.get();
        }
        status.setNumberOfUnits(status.getNumberOfUnits() + units.size());
        Set unitAdminRoleIds = unitAdminTypes.stream().map(UnitAdministratorType::getDescription).map(this::createRoleIdFromAdminTypeDescription).collect(Collectors.toSet());
        units.forEach(unit -> {
            GroupDto group = groups.stream().filter(g -> StringUtils.equals((CharSequence)unit.getUnitNumber(), (CharSequence)this.getField((GroupDto)g, "UNIT_NUMBER").getValue())).findFirst().orElse(new GroupDto());
            if (group.getId() == null) {
                status.setGroupsAdded(status.getGroupsAdded() + 1);
                group.setCategoryId(category.getId());
                group.setName(unit.getUnitName());
                if (parentGroup != null) {
                    group.setParentId(parentGroup.getId());
                }
                group.getFields().add(new GroupDto.GroupFields("UNIT_NUMBER", unit.getUnitNumber()));
                group.getFields().add(new GroupDto.GroupFields("ACTIVE", Boolean.toString(unit.isActive())));
                this.addRoleMembers(group, (Unit)unit);
                this.addUnitAdmins(group, (Unit)unit);
                group = this.addGroup(group);
            } else {
                status.setGroupsUpdated(status.getGroupsUpdated() + 1);
                group.setCategoryId(category.getId());
                group.setName(unit.getUnitName());
                if (parentGroup != null) {
                    group.setParentId(parentGroup.getId());
                }
                this.getField(group, "ACTIVE").setValue(Boolean.toString(unit.isActive()));
                this.addRoleMembers(group, (Unit)unit);
                this.clearUnitAdmins(group, unitAdminRoleIds);
                this.addUnitAdmins(group, (Unit)unit);
                this.updateGroup(group);
            }
            List<Unit> childUnits = this.unitService.getSubUnits(unit.getUnitNumber());
            if (childUnits != null && childUnits.size() > 0) {
                this.syncGroups(childUnits, group, level + 1, category, categories, groups, unitAdminTypes, levelsSynced, status);
            }
        });
    }

    protected void clearUnitAdmins(GroupDto group, Set<String> unitAdminRoleIds) {
        List<GroupDto.Role> filteredRoles = group.getRoles().stream().filter(role -> !unitAdminRoleIds.contains(role.getId())).toList();
        group.setRoles(filteredRoles);
    }

    protected void addUnitAdmins(GroupDto group, Unit unit) {
        Map unitAdmins = this.unitService.retrieveUnitAdministratorsByUnitNumber(unit.getUnitNumber()).stream().collect(Collectors.groupingBy(a -> a.getUnitAdministratorType().getDescription(), HashMap::new, Collectors.mapping(UnitAdministrator::getPersonId, Collectors.toSet())));
        this.addRolesToGroup(unitAdmins, group);
    }

    protected void addRolesToGroup(Map<String, Set<String>> membersMap, GroupDto group) {
        Map updatedRoles = membersMap.entrySet().stream().map(entry -> new GroupDto.Role(this.createRoleIdFromAdminTypeDescription((String)entry.getKey()), ((Set)entry.getValue()).stream().map(this::getCoreUserId).filter(Objects::nonNull).toList())).collect(Collectors.toMap(GroupDto.Role::getId, Function.identity()));
        group.setRoles(Stream.concat(group.getRoles().stream().filter(r -> !updatedRoles.containsKey(r.getId())), updatedRoles.values().stream()).toList());
    }

    protected String getRoleDescription(String roleId) {
        Role role = this.getRoleService().getRole(roleId);
        return role.getDescription();
    }

    protected Set<String> getRoleMembers(String roleId, Unit unit) {
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put("unitNumber", unit.getUnitNumber());
        return this.getRoleService().getRoleMembers(List.of(roleId), qualifications).stream().filter(roleMembership -> ((String)roleMembership.getQualifier().get("unitNumber")).equals(unit.getUnitNumber())).map(RoleMembership::getMemberId).collect(Collectors.toSet());
    }

    protected void addRoleMembers(GroupDto group, Unit unit) {
        List<Role> roles = this.getRolesToPush();
        if (roles.isEmpty()) {
            return;
        }
        HashMap<String, Set<String>> roleMembers = new HashMap<String, Set<String>>();
        for (Role role : roles) {
            roleMembers.put(role.getDescription(), this.getRoleMembers(role.getId(), unit));
        }
        this.addRolesToGroup(roleMembers, group);
    }

    protected String getCoreUserId(String schoolId) {
        String uri = UriComponentsBuilder.fromHttpUrl((String)this.getUsersApiUrl()).queryParam("schoolId", new Object[]{schoolId}).build().encode().toString();
        ResponseEntity result = this.restOperations.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), (ParameterizedTypeReference)new ParameterizedTypeReference<List<AuthUser>>(this){}, new Object[0]);
        if (result.getBody() != null && !((List)result.getBody()).isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("GET " + uri + " returning " + String.valueOf(((List)result.getBody()).get(0)));
            }
            return ((AuthUser)((List)result.getBody()).get(0)).getId();
        }
        return null;
    }

    private GroupDto.GroupFields getField(GroupDto group, String fieldId) {
        return group.getFields().stream().filter(f -> StringUtils.equals((CharSequence)f.getId(), (CharSequence)fieldId)).findFirst().orElse(new GroupDto.GroupFields());
    }

    protected CategoryDto syncCategory(Optional<CategoryDto> existingCategory, CategoryDto parentCategory, int level, List<UnitAdministratorType> unitAdminTypes, GroupsPushStatus status) {
        CategoryDto updatedCategory = existingCategory.orElse(null);
        if (updatedCategory == null) {
            status.setCategoriesAdded(status.getCategoriesAdded() + 1);
            updatedCategory = new CategoryDto();
            if (parentCategory != null) {
                updatedCategory.setParentId(parentCategory.getId());
            }
            updatedCategory.setName("Level " + level);
            updatedCategory.getFieldSchemas().add(new CategoryDto.FieldSchemaDto("UNIT_NUMBER", TEXT_FIELD_TYPE, UNIT_NUMBER_FIELD_DESCRIPTION));
            updatedCategory.getFieldSchemas().add(new CategoryDto.FieldSchemaDto("ACTIVE", CHECKBOX_FIELD_TYPE, ACTIVE_FIELD_DESCRIPTION));
            this.updateCategoryRoles(updatedCategory, unitAdminTypes);
            return this.addCategory(updatedCategory);
        }
        status.setCategoriesUpdated(status.getCategoriesUpdated() + 1);
        if (parentCategory != null) {
            updatedCategory.setParentId(parentCategory.getId());
        }
        this.updateCategoryRoles(updatedCategory, unitAdminTypes);
        this.updateCategory(updatedCategory);
        return updatedCategory;
    }

    protected List<Role> getRolesToPush() {
        Collection roleIds = this.getParameterService().getParameterValuesAsString("KC-SYS", "All", ROLE_IDS_TO_PUSH_TO_GROUPS);
        return roleIds.stream().map(roleId -> this.getRoleService().getRole(roleId)).filter(role -> "10000".equals(role.getKimTypeId()) || "10001".equals(role.getKimTypeId())).toList();
    }

    protected void updateCategoryRoles(CategoryDto category, List<UnitAdministratorType> unitAdminTypes) {
        ArrayList<String> categoryRoles = new ArrayList<String>();
        categoryRoles.addAll(this.getRolesToPush().stream().map(Role::getDescription).toList());
        categoryRoles.addAll(unitAdminTypes.stream().map(UnitAdministratorType::getDescription).toList());
        categoryRoles.stream().distinct().forEach(name -> {
            String id = this.createRoleIdFromAdminTypeDescription((String)name);
            Optional<CategoryDto.RoleSchemaDto> roleSchema = category.getRoleSchemas().stream().filter(rs -> StringUtils.equals((CharSequence)rs.getId(), (CharSequence)id)).findFirst();
            if (roleSchema.isEmpty()) {
                category.getRoleSchemas().add(new CategoryDto.RoleSchemaDto(id, (String)name));
            }
        });
    }

    private String createRoleIdFromAdminTypeDescription(String name) {
        return name.toUpperCase().replaceAll("\\s+|\\.", "_");
    }

    protected Optional<CategoryDto> findChildCategory(CategoryDto parentCategory, List<CategoryDto> categories) {
        String parentId;
        String string = parentId = parentCategory == null ? null : parentCategory.getId();
        if (parentId == null) {
            return categories.stream().filter(c -> StringUtils.isBlank((CharSequence)c.getParentId()) || StringUtils.equals((CharSequence)c.getParentId(), (CharSequence)c.getId())).findFirst();
        }
        return categories.stream().filter(c -> StringUtils.equals((CharSequence)c.getParentId(), (CharSequence)parentId)).findFirst();
    }

    protected Stream<CategoryDto> getAllCategories() {
        return this.coreGroupsService.getAllCategories();
    }

    protected Stream<GroupDto> getAllGroups() {
        return this.coreGroupsService.getAllGroups();
    }

    protected CategoryDto addCategory(CategoryDto category) {
        ResponseEntity result = this.restOperations.exchange(this.coreGroupsService.getCategoriesApiUrl(), HttpMethod.POST, new HttpEntity((Object)category, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), CategoryDto.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.CREATED) {
            throw new RestClientException(result.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("POST " + this.coreGroupsService.getCategoriesApiUrl() + " returned " + String.valueOf(result.getBody()));
        }
        return (CategoryDto)result.getBody();
    }

    protected void updateCategory(CategoryDto category) {
        String uri = this.coreGroupsService.getCategoriesApiUrl() + category.getId();
        ResponseEntity result = this.restOperations.exchange(uri, HttpMethod.PUT, new HttpEntity((Object)category, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (LOG.isInfoEnabled()) {
            LOG.info("PUT " + uri + " returned status of " + String.valueOf(result.getStatusCode()) + " and body text of " + (String)result.getBody());
        }
        if (result.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException(Objects.requireNonNullElse((String)result.getBody(), "Response body is null"));
        }
    }

    protected GroupDto addGroup(GroupDto group) {
        String uri = this.coreGroupsService.getGroupsApiUrl();
        ResponseEntity result = this.restOperations.exchange(this.coreGroupsService.getGroupsApiUrl(), HttpMethod.POST, new HttpEntity((Object)group, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), GroupDto.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.CREATED) {
            throw new RestClientException(result.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("POST " + uri + " returned " + String.valueOf(result.getBody()));
        }
        return (GroupDto)result.getBody();
    }

    protected void updateGroup(GroupDto group) {
        String uri = this.coreGroupsService.getGroupsApiUrl() + group.getId();
        ResponseEntity result = this.restOperations.exchange(uri, HttpMethod.PUT, new HttpEntity((Object)group, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (LOG.isInfoEnabled()) {
            LOG.info("PUT " + uri + " returned status of " + String.valueOf(result.getStatusCode()) + " and body text of " + (String)result.getBody());
        }
        if (result.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException(Objects.requireNonNullElse((String)result.getBody(), "Response body is null"));
        }
    }

    protected String getUsersApiUrl() {
        return this.configurationService.getPropertyValueAsString("auth.users.url") + "/";
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public CoreGroupsService getCoreGroupsService() {
        return this.coreGroupsService;
    }

    public void setCoreGroupsService(CoreGroupsService coreGroupsService) {
        this.coreGroupsService = coreGroupsService;
    }

    public RoleService getRoleService() {
        return this.RoleService;
    }

    public void setRoleService(RoleService roleService) {
        this.RoleService = roleService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

