/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.io.File;
import java.util.Collection;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.ProgressListener;
import net.sourceforge.schemaspy.model.Table;

public class ConsoleProgressListener
implements ProgressListener {
    private final boolean render;
    private long startedAt;
    private long startedGatheringAt;
    private long startedConnectingAt;
    private long startedGraphingSummariesAt;
    private long startedGraphingDetailsAt;
    private long finishedAt;

    public ConsoleProgressListener(boolean bl) {
        this.render = bl;
        this.startedAt = System.currentTimeMillis();
    }

    @Override
    public long startedGatheringDetails() {
        this.startedGatheringAt = System.currentTimeMillis();
        long l = this.startedAt - this.startedGatheringAt;
        if (this.render) {
            System.out.print("Gathering schema details...");
        }
        return l;
    }

    @Override
    public void gatheringDetailsProgressed(Table table) {
        if (this.render) {
            System.out.print('.');
        }
    }

    @Override
    public long startedConnectingTables() {
        this.startedConnectingAt = System.currentTimeMillis();
        long l = this.startedConnectingAt - this.startedGatheringAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + l / 1000L + "sec)");
            System.out.print("Connecting relationships...");
        }
        return l;
    }

    @Override
    public void connectingTablesProgressed(Table table) {
        if (this.render) {
            System.out.print('.');
        }
    }

    @Override
    public long startedGraphingSummaries() {
        this.startedGraphingSummariesAt = System.currentTimeMillis();
        long l = this.startedGraphingSummariesAt - this.startedConnectingAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + l / 1000L + "sec)");
            System.out.print("Writing/graphing summary");
            System.out.print('.');
        }
        return l;
    }

    @Override
    public void graphingSummaryProgressed() {
        if (this.render) {
            System.out.print('.');
        }
    }

    @Override
    public long startedGraphingDetails() {
        this.startedGraphingDetailsAt = System.currentTimeMillis();
        long l = this.startedGraphingDetailsAt - this.startedGraphingSummariesAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + l / 1000L + "sec)");
            System.out.print("Writing/diagramming details");
        }
        return l;
    }

    @Override
    public void graphingDetailsProgressed(Table table) {
        if (this.render) {
            System.out.print('.');
        }
    }

    @Override
    public long finishedGatheringDetails() {
        this.finishedAt = System.currentTimeMillis();
        long l = this.finishedAt - this.startedGraphingDetailsAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + l / 1000L + "sec)");
        }
        return l;
    }

    @Override
    public long finished(Collection<Table> collection, Config config) {
        this.finishedAt = System.currentTimeMillis();
        long l = this.finishedAt - this.startedAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("Wrote relationship details of " + collection.size() + " tables/views to directory '" + String.valueOf(config.getOutputDir()) + "' in " + l / 1000L + " seconds.");
            System.out.println("View the results by opening " + String.valueOf(new File(config.getOutputDir(), "index.html")));
        }
        return l;
    }

    @Override
    public String recoverableExceptionEncountered(String string, Exception exception, String string2) {
        System.out.println();
        System.out.flush();
        String string3 = string + ": " + String.valueOf(exception);
        if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        return string3;
    }
}

