/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.org.kuali.rice.krad.uif.container;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.container.ActiveCollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.CollectionGroupBuilder;
import org.kuali.rice.krad.uif.container.CollectionGroupSecurity;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.QuickFinder;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTags(value={@BeanTag(name="collectionGroup", parent="Uif-CollectionGroupBase"), @BeanTag(name="stacked", parent="Uif-StackedCollectionGroup"), @BeanTag(name="stackedSection", parent="Uif-StackedCollectionSection"), @BeanTag(name="stackedSubSection", parent="Uif-StackedCollectionSubSection"), @BeanTag(name="stackedSubCollection-withinSection", parent="Uif-StackedSubCollection-WithinSection"), @BeanTag(name="stackedSubCollection-withinSubSection", parent="Uif-StackedSubCollection-WithinSubSection"), @BeanTag(name="disclosureStackedSection", parent="Uif-Disclosure-StackedCollectionSection"), @BeanTag(name="disclosureStackedSubSection", parent="Uif-Disclosure-StackedCollectionSubSection"), @BeanTag(name="disclosureStackedSubCollection-withinSection", parent="Uif-Disclosure-StackedSubCollection-WithinSection"), @BeanTag(name="disclosureStackedSubCollection-withinSubSection", parent="Uif-Disclosure-StackedSubCollection-WithinSubSection"), @BeanTag(name="table", parent="Uif-TableCollectionGroup"), @BeanTag(name="tableSection", parent="Uif-TableCollectionSection"), @BeanTag(name="tableSubSection", parent="Uif-TableCollectionSubSection"), @BeanTag(name="tableSubCollection-withinSection", parent="Uif-TableSubCollection-WithinSection"), @BeanTag(name="tableSubCollection-withinSubSection", parent="Uif-TableSubCollection-WithinSubSection"), @BeanTag(name="disclosureTableSection", parent="Uif-Disclosure-TableCollectionSection"), @BeanTag(name="disclosureTableSubSection", parent="Uif-Disclosure-TableCollectionSubSection"), @BeanTag(name="disclosureTableSubCollection-withinSection", parent="Uif-Disclosure-TableSubCollection-WithinSection"), @BeanTag(name="disclosureTableSubCollection-withinSubSection", parent="Uif-Disclosure-TableSubCollection-WithinSubSection"), @BeanTag(name="listCollection", parent="Uif-ListCollectionGroup"), @BeanTag(name="listCollectionSection", parent="Uif-ListCollectionSection"), @BeanTag(name="listCollectionSubSection", parent="Uif-ListCollectionSubSection"), @BeanTag(name="maintenanceStackedSection", parent="Uif-MaintenanceStackedCollectionSection"), @BeanTag(name="maintenanceStackedSubCollection-withinSection", parent="Uif-MaintenanceStackedSubCollection-WithinSection"), @BeanTag(name="maintenanceTableSection", parent="Uif-MaintenanceTableCollectionSection"), @BeanTag(name="maintenanceTableSubCollection-withinSection", parent="Uif-MaintenanceTableSubCollection-WithinSection")})
public class KcCollectionGroupBase
extends GroupBase
implements CollectionGroup {
    private static final long serialVersionUID = -6496712566071542452L;
    private Class<?> collectionObjectClass;
    private String propertyName;
    private BindingInfo bindingInfo;
    private boolean renderAddLine = true;
    private String addLinePropertyName;
    private BindingInfo addLineBindingInfo;
    private Message addLineLabel;
    private List<? extends Component> addLineItems;
    private List<? extends Component> addLineActions;
    @KeepExpression
    private String addLineEnterKeyAction;
    @KeepExpression
    private String lineEnterKeyAction;
    private boolean renderLineActions = true;
    private List<? extends Component> lineActions;
    private boolean includeLineSelectionField;
    private String lineSelectPropertyName;
    private QuickFinder collectionLookup;
    private boolean renderInactiveToggleButton = true;
    @ClientSideState(variableName="inactive")
    private boolean showInactiveLines;
    private CollectionFilter activeCollectionFilter;
    private List<CollectionFilter> filters = Collections.emptyList();
    private List<String> duplicateLinePropertyNames = Collections.emptyList();
    private List<BindingInfo> unauthorizedLineBindingInfos;
    @DelayedCopy
    private List<CollectionGroup> subCollections;
    private CollectionGroupBuilder collectionGroupBuilder;
    private int displayCollectionSize = -1;
    private boolean highlightNewItems = true;
    private boolean highlightAddItem = true;
    private String newItemsCssClass;
    private String addItemCssClass;
    private boolean renderAddBlankLineButton;
    private Action addBlankLineAction;
    private String addLinePlacement = "TOP";
    private boolean renderSaveLineActions;
    private boolean editWithDialog;
    private boolean customEditLineDialog;
    private DialogGroup editLineDialogPrototype;
    private Action editWithDialogActionPrototype;
    private Action editInDialogSaveActionPrototype;
    private List<DialogGroup> lineDialogs;
    private boolean addWithDialog;
    private Action addWithDialogAction;
    private DialogGroup addLineDialog;
    private boolean generatedAddDialog;
    private boolean useServerPaging = false;
    private int pageSize;
    private int displayStart = -1;
    private int displayLength = -1;
    private int filteredCollectionSize = -1;
    private int totalCollectionSize = -1;
    private List<String> totalColumns;

    public KcCollectionGroupBase() {
        this.lineActions = Collections.emptyList();
        this.addLineItems = Collections.emptyList();
        this.addLineActions = Collections.emptyList();
        this.subCollections = Collections.emptyList();
        this.lineDialogs = Collections.emptyList();
    }

    public void performInitialization(Object model) {
        View view = ViewLifecycle.getView();
        this.setFieldBindingObjectPath(this.getBindingInfo().getBindingObjectPath());
        super.performInitialization(model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
        if (this.addLineBindingInfo != null && StringUtils.isNotBlank((CharSequence)this.addLinePropertyName)) {
            this.addLineBindingInfo.setDefaults(view, this.getPropertyName());
            this.addLineBindingInfo.setBindingName(this.addLinePropertyName);
            if (StringUtils.isNotBlank((CharSequence)this.getFieldBindByNamePrefix())) {
                this.addLineBindingInfo.setBindByNamePrefix(this.getFieldBindByNamePrefix());
            }
        }
        if (this.addLineItems == null || this.addLineItems.isEmpty()) {
            this.addLineItems = this.getItems();
        }
        if (this.addWithDialog) {
            if (this.addLineDialog == null) {
                this.addLineDialog = (DialogGroup)ComponentFactory.getNewComponentInstance((String)"Uif-AddLineDialog");
                this.generatedAddDialog = true;
            }
            ((CollectionLayoutManager)this.getLayoutManager()).setAddLineGroup((Group)this.addLineDialog);
            if (!this.addLineDialog.getItems().isEmpty()) {
                this.addLineItems = this.addLineDialog.getItems();
            }
        }
        if (this.editWithDialog) {
            if (this.editLineDialogPrototype == null) {
                this.editLineDialogPrototype = (DialogGroup)ComponentUtils.copy((Component)ComponentFactory.getNewComponentInstance((String)"Uif-EditLineDialog"));
            } else if (this.editLineDialogPrototype.getItems() != null && !this.editLineDialogPrototype.getItems().isEmpty()) {
                this.customEditLineDialog = true;
            }
            if (this.editWithDialogActionPrototype == null) {
                this.editWithDialogActionPrototype = (Action)ComponentUtils.copy((Component)ComponentFactory.getNewComponentInstance((String)"Uif-EditLineInDialogAction"));
            }
            if (this.editInDialogSaveActionPrototype == null) {
                this.editInDialogSaveActionPrototype = (Action)ComponentUtils.copy((Component)((Action)ComponentFactory.getNewComponentInstance((String)"Uif-EditLineInDialogSaveAction")));
            }
        }
        if (this.activeCollectionFilter == null) {
            this.activeCollectionFilter = new ActiveCollectionFilter();
        }
        Object collectionPath = "";
        if (StringUtils.isNotBlank((CharSequence)this.getBindingInfo().getCollectionPath())) {
            collectionPath = (String)collectionPath + this.getBindingInfo().getCollectionPath() + ".";
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBindingInfo().getBindByNamePrefix()) && StringUtils.isNotBlank((CharSequence)this.getBindingInfo().getCollectionPath()) && this.getBindingInfo().getBindByNamePrefix().startsWith(this.getBindingInfo().getCollectionPath())) {
            collectionPath = this.getBindingInfo().getBindByNamePrefix() + ".";
        } else if (StringUtils.isNotBlank((CharSequence)this.getBindingInfo().getBindByNamePrefix())) {
            collectionPath = (String)collectionPath + this.getBindingInfo().getBindByNamePrefix() + ".";
        }
        collectionPath = (String)collectionPath + this.getBindingInfo().getBindingName();
        List collectionFields = ComponentUtils.getNestedNonCollectionComponents(this.getItems(), DataField.class);
        List addLineCollectionFields = ComponentUtils.getNestedNonCollectionComponents(this.addLineItems, DataField.class);
        if (addLineCollectionFields != null) {
            collectionFields.addAll(addLineCollectionFields);
        }
        for (DataField collectionField : collectionFields) {
            collectionField.getBindingInfo().setCollectionPath((String)collectionPath);
            if (!StringUtils.isBlank((CharSequence)collectionField.getDictionaryObjectEntry())) continue;
            collectionField.setDictionaryObjectEntry(this.collectionObjectClass.getName());
        }
        for (CollectionGroup collectionGroup : this.getSubCollections()) {
            collectionGroup.getBindingInfo().setCollectionPath((String)collectionPath);
        }
        if (!view.getObjectPathToConcreteClassMapping().containsKey(collectionPath)) {
            view.getObjectPathToConcreteClassMapping().put(collectionPath, this.getCollectionObjectClass());
        }
    }

    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        ViewModel viewModel = (ViewModel)model;
        View view = ViewLifecycle.getView();
        if (this.isUseServerPaging()) {
            Iterator displayLength;
            Object displayStart = ViewLifecycle.getViewPostMetadata().getComponentPostData(this.getId(), "displayStart");
            if (displayStart != null) {
                this.setDisplayStart((Integer)displayStart);
            }
            if ((displayLength = ViewLifecycle.getViewPostMetadata().getComponentPostData(this.getId(), "displayLength")) != null) {
                this.setDisplayLength((Integer)((Object)displayLength));
            }
        }
        if (viewModel.isCollectionPagingRequest() && StringUtils.equals((CharSequence)viewModel.getUpdateComponentId(), (CharSequence)this.getId())) {
            ((CollectionLayoutManager)this.getLayoutManager()).processPagingRequest(model, (CollectionGroup)this);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getId()) && viewModel.getViewPostMetadata() != null && viewModel.getViewPostMetadata().getAddedCollectionObjects().get(this.getId()) != null) {
            List newLines = (List)viewModel.getViewPostMetadata().getAddedCollectionObjects().get(this.getId());
            if (newLines.isEmpty()) {
                this.initializeNewCollectionLine(view, model, this, true);
            }
            for (Object newLine : newLines) {
                ViewLifecycle.getHelper().applyDefaultValuesForCollectionLine((CollectionGroup)this, newLine);
            }
        }
        if (this.renderAddBlankLineButton) {
            if (this.addBlankLineAction == null) {
                this.addBlankLineAction = (Action)ComponentFactory.getNewComponentInstance((String)"Uif-AddBlankLineAction");
            }
            if (this.addLinePlacement.equals(UifConstants.Position.BOTTOM.name())) {
                this.addBlankLineAction.setOnClickScript("writeCurrentPageToSession(this, 'last');");
            } else {
                this.addBlankLineAction.setOnClickScript("writeCurrentPageToSession(this, 'first');");
            }
        } else if (this.addWithDialog) {
            this.setupAddLineDialog();
        }
        this.pushCollectionGroupToReference();
        ArrayList<Component> allComponents = new ArrayList<Component>(this.getItems());
        allComponents.addAll(this.getAddLineItems());
        ArrayList<Component> allActionComponents = new ArrayList<Component>(this.getLineActions());
        allActionComponents.addAll(this.getAddLineActions());
        this.setupLineActionValidationScripts(allComponents, allActionComponents);
        if (this.isRender()) {
            this.getCollectionGroupBuilder().build(view, model, (CollectionGroup)this);
        }
    }

    protected void setupLineActionValidationScripts(List<Component> components, List<Component> actionComponents) {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (Component component : components) {
            if (!(component instanceof InputField)) continue;
            inputFields.add((InputField)component);
        }
        String script = this.buildInputFieldValidationActionScript(inputFields, null);
        for (Component actionComponent : actionComponents) {
            if (!(actionComponent instanceof Action)) continue;
            Action action = (Action)actionComponent;
            String onClickScript = action.getOnClickScript();
            if (StringUtils.isNotEmpty((CharSequence)onClickScript)) {
                script = ScriptUtils.appendScript((String)script, (String)onClickScript);
            }
            action.setOnClickScript(script);
        }
    }

    protected void setupAddLineDialog() {
        if (this.addWithDialogAction == null) {
            this.addWithDialogAction = (Action)ComponentFactory.getNewComponentInstance((String)"Uif-AddWithDialogAction");
        }
        if (this.generatedAddDialog && this.getAddLineDialog().getFooter() != null && this.getAddLineDialog().getFooter().getItems() != null) {
            for (Component item : this.getAddLineDialog().getFooter().getItems()) {
                if (!(item instanceof Action)) continue;
                ((Action)item).setRefreshId(this.getId());
                ((Action)item).addActionParameter("selectedCollectionPath", this.getBindingInfo().getBindingPath());
                ((Action)item).addActionParameter("selectedCollectionId", this.getId());
                ((Action)item).getActionParameters().remove("selectedLineIndex");
                ((Action)item).getActionParameters().remove("lineIndex");
            }
        }
        String sessionPage = "first";
        if (this.addLinePlacement.equals(UifConstants.Position.BOTTOM.name())) {
            sessionPage = "last";
        }
        Object dialogId = this.addLineDialog.getId();
        if (StringUtils.isNotBlank((CharSequence)this.getContainerIdSuffix())) {
            dialogId = (String)dialogId + this.getContainerIdSuffix();
        }
        String additionalData = "{ 'actionParameters[selectedCollectionPath]' : '" + this.propertyName + "', 'actionParameters[selectedLineIndex]' : '0', 'actionParameters[dialogId]' : '" + (String)dialogId + "' }";
        Object actionScript = "writeCurrentPageToSession(this, '" + sessionPage + "');";
        actionScript = ScriptUtils.appendScript((String)this.addWithDialogAction.getActionScript(), (String)actionScript);
        String showDialogScript = "showDialog('" + (String)dialogId + "', " + additionalData + ");";
        actionScript = ScriptUtils.appendScript((String)actionScript, (String)showDialogScript);
        this.addWithDialogAction.setActionScript((String)actionScript);
    }

    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        this.addCollectionPostMetadata();
        if (this.addWithDialog && this.addLineDialog != null && this.addLineDialog.getFooter() != null) {
            ArrayList<CallSite> fieldsToSend = new ArrayList<CallSite>();
            fieldsToSend.add((CallSite)((Object)("#" + this.addLineDialog.getId())));
            for (Component cmpnt : this.addLineDialog.getFooter().getItems()) {
                if (!(cmpnt instanceof Action)) continue;
                ((Action)cmpnt).setFieldsToSend(fieldsToSend);
                if (!this.generatedAddDialog || ((Action)cmpnt).getMethodToCall() == null || !((Action)cmpnt).getMethodToCall().equals("addLine")) continue;
                String preSubmitScript = "var valid=validate(jQuery('#" + this.addLineDialog.getId() + "'));";
                preSubmitScript = preSubmitScript + "return valid;";
                ((Action)cmpnt).setPreSubmitCall(preSubmitScript);
            }
        }
    }

    protected void addCollectionPostMetadata() {
        boolean hasBindingPath;
        if (this.getCollectionLookup() != null) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "collectionLookup.fieldConversions", (Object)this.getCollectionLookup().getFieldConversions());
        }
        ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "collectionObjectClass", this.getCollectionObjectClass());
        ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "bindingInfo", (Object)this.getBindingInfo());
        ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "addLineBindingInfo", (Object)this.getAddLineBindingInfo());
        ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "addLinePlacement", (Object)this.getAddLinePlacement());
        if (this.getHeader() != null) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "collectionLabel", (Object)this.getCollectionLabel());
        }
        if (this.getDuplicateLinePropertyNames() != null) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "duplicateLinePropertyNames", this.getDuplicateLinePropertyNames());
            ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "duplicateLineLabelString", (Object)this.getDuplicateLineLabelString(this.getDuplicateLinePropertyNames()));
        }
        boolean bl = hasBindingPath = this.getBindingInfo() != null && this.getBindingInfo().getBindingPath() != null;
        if (hasBindingPath) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "bindingPath", (Object)this.getBindingInfo().getBindingPath());
        }
        ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "displayStart", (Object)this.getDisplayStart());
        ViewLifecycle.getViewPostMetadata().addComponentPostData((Component)this, "displayLength", (Object)this.getDisplayLength());
    }

    public void pushCollectionGroupToReference() {
        Collection components = ViewLifecycleUtils.getElementsForLifecycle((LifecycleElement)this).values();
        ContextUtils.pushObjectToContextDeep(components, (String)"collectionGroup", (Object)((Object)this));
        List actions = ViewLifecycleUtils.getElementsOfTypeDeep(components, Action.class);
        for (Action action : actions) {
            action.addActionParameter("selectedCollectionPath", this.getBindingInfo().getBindingPath());
            action.addActionParameter("selectedCollectionId", this.getId());
        }
    }

    protected String getCollectionLabel() {
        String collectionLabel = this.getHeaderText();
        if (StringUtils.isBlank((CharSequence)collectionLabel)) {
            String propertyName = this.getPropertyName();
            collectionLabel = KRADServiceLocatorWeb.getUifDefaultingService().deriveHumanFriendlyNameFromPropertyName(propertyName);
        }
        return collectionLabel;
    }

    protected String getDuplicateLineLabelString(List<String> duplicateLinePropertyNames) {
        ArrayList<String> duplicateLineLabels = new ArrayList<String>();
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (Component component : this.getAddLineItems()) {
            if (component instanceof DataField) {
                fields.add((DataField)component);
                continue;
            }
            if (!(component instanceof FieldGroup)) continue;
            Group group = ((FieldGroup)component).getGroup();
            List nestedAddLineItems = ViewLifecycleUtils.getElementsOfTypeDeep((LifecycleElement)group, DataField.class);
            fields.addAll(nestedAddLineItems);
        }
        for (DataField dataField : fields) {
            if (!duplicateLinePropertyNames.contains(dataField.getPropertyName())) continue;
            String label = dataField.getLabel();
            String shortLabel = dataField.getShortLabel();
            duplicateLineLabels.add(StringUtils.isNotBlank((CharSequence)label) ? label : shortLabel);
        }
        return StringUtils.join(duplicateLineLabels, (String)", ");
    }

    public void initializeNewCollectionLine(View view, Object model, CollectionGroup collectionGroup, boolean clearExistingLine) {
        this.getCollectionGroupBuilder().initializeNewCollectionLine(view, model, collectionGroup, clearExistingLine);
    }

    public boolean isProcessRemoteFieldHolders() {
        return false;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getItems() {
        return super.getItems();
    }

    @BeanTagAttribute
    public Class<?> getCollectionObjectClass() {
        return this.collectionObjectClass;
    }

    public void setCollectionObjectClass(Class<?> collectionObjectClass) {
        this.collectionObjectClass = collectionObjectClass;
    }

    @BeanTagAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @BeanTagAttribute
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getLineActions() {
        return this.lineActions;
    }

    public void setLineActions(List<? extends Component> lineActions) {
        this.lineActions = lineActions;
    }

    @BeanTagAttribute
    public String getAddLineEnterKeyAction() {
        return this.addLineEnterKeyAction;
    }

    public void setAddLineEnterKeyAction(String addLineEnterKeyAction) {
        this.addLineEnterKeyAction = addLineEnterKeyAction;
    }

    @BeanTagAttribute
    public String getLineEnterKeyAction() {
        return this.lineEnterKeyAction;
    }

    public void setLineEnterKeyAction(String lineEnterKeyAction) {
        this.lineEnterKeyAction = lineEnterKeyAction;
    }

    @BeanTagAttribute
    public boolean isRenderLineActions() {
        return this.renderLineActions;
    }

    public void setRenderLineActions(boolean renderLineActions) {
        this.renderLineActions = renderLineActions;
    }

    @BeanTagAttribute
    public boolean isRenderAddLine() {
        if (this.useServerPaging && this.renderAddLine) {
            return this.displayStart == 0;
        }
        return this.renderAddLine;
    }

    public void setRenderAddLine(boolean renderAddLine) {
        this.renderAddLine = renderAddLine;
    }

    @BeanTagAttribute
    public String getAddLabel() {
        if (this.getAddLineLabel() != null) {
            return this.getAddLineLabel().getMessageText();
        }
        return null;
    }

    public void setAddLabel(String addLabelText) {
        if (this.getAddLineLabel() != null) {
            this.getAddLineLabel().setMessageText(addLabelText);
        }
    }

    @BeanTagAttribute
    public Message getAddLineLabel() {
        return this.addLineLabel;
    }

    public void setAddLineLabel(Message addLineLabel) {
        this.addLineLabel = addLineLabel;
    }

    @BeanTagAttribute
    public String getAddLinePropertyName() {
        return this.addLinePropertyName;
    }

    public void setAddLinePropertyName(String addLinePropertyName) {
        this.addLinePropertyName = addLinePropertyName;
    }

    @BeanTagAttribute
    public BindingInfo getAddLineBindingInfo() {
        return this.addLineBindingInfo;
    }

    public void setAddLineBindingInfo(BindingInfo addLineBindingInfo) {
        this.addLineBindingInfo = addLineBindingInfo;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getAddLineItems() {
        return this.addLineItems;
    }

    public void setAddLineItems(List<? extends Component> addLineItems) {
        this.addLineItems = addLineItems;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<? extends Component> getAddLineActions() {
        return this.addLineActions;
    }

    public void setAddLineActions(List<? extends Component> addLineActions) {
        this.addLineActions = addLineActions;
    }

    @BeanTagAttribute
    public boolean isIncludeLineSelectionField() {
        return this.includeLineSelectionField;
    }

    public void setIncludeLineSelectionField(boolean includeLineSelectionField) {
        this.includeLineSelectionField = includeLineSelectionField;
    }

    @BeanTagAttribute
    public String getLineSelectPropertyName() {
        return this.lineSelectPropertyName;
    }

    public void setLineSelectPropertyName(String lineSelectPropertyName) {
        this.lineSelectPropertyName = lineSelectPropertyName;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.BYTYPE)
    public QuickFinder getCollectionLookup() {
        return this.collectionLookup;
    }

    public void setCollectionLookup(QuickFinder collectionLookup) {
        this.collectionLookup = collectionLookup;
    }

    @BeanTagAttribute
    public boolean isShowInactiveLines() {
        return this.showInactiveLines;
    }

    public void setShowInactiveLines(boolean showInactiveLines) {
        this.showInactiveLines = showInactiveLines;
    }

    @BeanTagAttribute
    public CollectionFilter getActiveCollectionFilter() {
        return this.activeCollectionFilter;
    }

    public void setActiveCollectionFilter(CollectionFilter activeCollectionFilter) {
        this.activeCollectionFilter = activeCollectionFilter;
    }

    @BeanTagAttribute
    public List<CollectionFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<CollectionFilter> filters) {
        this.filters = filters;
    }

    @BeanTagAttribute
    public List<String> getDuplicateLinePropertyNames() {
        return this.duplicateLinePropertyNames;
    }

    public void setDuplicateLinePropertyNames(List<String> duplicateLinePropertyNames) {
        this.duplicateLinePropertyNames = duplicateLinePropertyNames;
    }

    public List<BindingInfo> getUnauthorizedLineBindingInfos() {
        return this.unauthorizedLineBindingInfos;
    }

    public void setUnauthorizedLineBindingInfos(List<BindingInfo> unauthorizedLineBindingInfos) {
        this.unauthorizedLineBindingInfos = unauthorizedLineBindingInfos;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public List<CollectionGroup> getSubCollections() {
        return this.subCollections;
    }

    public void setSubCollections(List<CollectionGroup> subCollections) {
        this.subCollections = subCollections;
    }

    public CollectionGroupSecurity getCollectionGroupSecurity() {
        return (CollectionGroupSecurity)super.getComponentSecurity();
    }

    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof CollectionGroupSecurity)) {
            throw new RiceRuntimeException("Component security for CollectionGroup should be instance of CollectionGroupSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    protected void initializeComponentSecurity() {
        if (this.getComponentSecurity() == null) {
            this.setComponentSecurity((ComponentSecurity)KRADUtils.createNewObjectFromClass(CollectionGroupSecurity.class));
        }
    }

    @BeanTagAttribute
    public boolean isEditLineAuthz() {
        this.initializeComponentSecurity();
        return this.getCollectionGroupSecurity().isEditLineAuthz();
    }

    public void setEditLineAuthz(boolean editLineAuthz) {
        this.initializeComponentSecurity();
        this.getCollectionGroupSecurity().setEditLineAuthz(editLineAuthz);
    }

    @BeanTagAttribute
    public boolean isViewLineAuthz() {
        this.initializeComponentSecurity();
        return this.getCollectionGroupSecurity().isViewLineAuthz();
    }

    public void setViewLineAuthz(boolean viewLineAuthz) {
        this.initializeComponentSecurity();
        this.getCollectionGroupSecurity().setViewLineAuthz(viewLineAuthz);
    }

    @BeanTagAttribute
    public CollectionGroupBuilder getCollectionGroupBuilder() {
        if (this.collectionGroupBuilder == null) {
            this.collectionGroupBuilder = new CollectionGroupBuilder();
        }
        return this.collectionGroupBuilder;
    }

    public void setCollectionGroupBuilder(CollectionGroupBuilder collectionGroupBuilder) {
        this.collectionGroupBuilder = collectionGroupBuilder;
    }

    @BeanTagAttribute
    public boolean isRenderInactiveToggleButton() {
        return this.renderInactiveToggleButton;
    }

    public void setRenderInactiveToggleButton(boolean renderInactiveToggleButton) {
        this.renderInactiveToggleButton = renderInactiveToggleButton;
    }

    @BeanTagAttribute
    public int getDisplayCollectionSize() {
        return this.displayCollectionSize;
    }

    public void setDisplayCollectionSize(int displayCollectionSize) {
        this.displayCollectionSize = displayCollectionSize;
    }

    @BeanTagAttribute
    public boolean isHighlightNewItems() {
        return this.highlightNewItems;
    }

    public void setHighlightNewItems(boolean highlightNewItems) {
        this.highlightNewItems = highlightNewItems;
    }

    @BeanTagAttribute
    public String getNewItemsCssClass() {
        return this.newItemsCssClass;
    }

    public void setNewItemsCssClass(String newItemsCssClass) {
        this.newItemsCssClass = newItemsCssClass;
    }

    @BeanTagAttribute
    public String getAddItemCssClass() {
        return this.addItemCssClass;
    }

    public void setAddItemCssClass(String addItemCssClass) {
        this.addItemCssClass = addItemCssClass;
    }

    @BeanTagAttribute
    public boolean isHighlightAddItem() {
        return this.highlightAddItem;
    }

    public void setHighlightAddItem(boolean highlightAddItem) {
        this.highlightAddItem = highlightAddItem;
    }

    @BeanTagAttribute
    public boolean isRenderAddBlankLineButton() {
        return this.renderAddBlankLineButton;
    }

    public void setRenderAddBlankLineButton(boolean renderAddBlankLineButton) {
        this.renderAddBlankLineButton = renderAddBlankLineButton;
    }

    @BeanTagAttribute
    public Action getAddBlankLineAction() {
        return this.addBlankLineAction;
    }

    public void setAddBlankLineAction(Action addBlankLineAction) {
        this.addBlankLineAction = addBlankLineAction;
    }

    @BeanTagAttribute
    public String getAddLinePlacement() {
        return this.addLinePlacement;
    }

    public void setAddLinePlacement(String addLinePlacement) {
        this.addLinePlacement = addLinePlacement;
    }

    @BeanTagAttribute
    public boolean isRenderSaveLineActions() {
        return this.renderSaveLineActions;
    }

    public void setRenderSaveLineActions(boolean renderSaveLineActions) {
        this.renderSaveLineActions = renderSaveLineActions;
    }

    @BeanTagAttribute
    public boolean isAddWithDialog() {
        return this.addWithDialog;
    }

    public void setAddWithDialog(boolean addWithDialog) {
        this.addWithDialog = addWithDialog;
    }

    @BeanTagAttribute
    public Action getAddWithDialogAction() {
        return this.addWithDialogAction;
    }

    public void setAddWithDialogAction(Action addWithDialogAction) {
        this.addWithDialogAction = addWithDialogAction;
    }

    @BeanTagAttribute
    public DialogGroup getAddLineDialog() {
        return this.addLineDialog;
    }

    public void setAddLineDialog(DialogGroup addLineDialog) {
        this.addLineDialog = addLineDialog;
    }

    @BeanTagAttribute
    public boolean isUseServerPaging() {
        return this.useServerPaging;
    }

    public void setUseServerPaging(boolean useServerPaging) {
        this.useServerPaging = useServerPaging;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getDisplayStart() {
        return this.displayStart;
    }

    public void setDisplayStart(int displayStart) {
        this.displayStart = displayStart;
    }

    public int getDisplayLength() {
        return this.displayLength;
    }

    public void setDisplayLength(int displayLength) {
        this.displayLength = displayLength;
    }

    public int getFilteredCollectionSize() {
        return this.filteredCollectionSize;
    }

    public void setFilteredCollectionSize(int filteredCollectionSize) {
        this.filteredCollectionSize = filteredCollectionSize;
    }

    public int getTotalCollectionSize() {
        return this.totalCollectionSize;
    }

    public void setTotalCollectionSize(int totalCollectionSize) {
        this.totalCollectionSize = totalCollectionSize;
    }

    @BeanTagAttribute
    protected List<String> getTotalColumns() {
        return this.totalColumns;
    }

    protected void setTotalColumns(List<String> totalColumns) {
        this.totalColumns = totalColumns;
    }

    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean((Component)this);
        if (this.getCollectionObjectClass() == null && Validator.checkExpressions((Component)this, (String)"collectionObjectClass")) {
            String[] currentValues = new String[]{"collectionObjectClass = " + String.valueOf(this.getCollectionObjectClass())};
            tracer.createWarning("CollectionObjectClass is not set (disregard if part of an abstract)", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @BeanTagAttribute
    public boolean isEditWithDialog() {
        return this.editWithDialog;
    }

    public void setEditWithDialog(boolean editWithDialog) {
        this.editWithDialog = editWithDialog;
    }

    @BeanTagAttribute
    public boolean isCustomEditLineDialog() {
        return this.customEditLineDialog;
    }

    public void setCustomEditLineDialog(boolean customEditLineDialog) {
        this.customEditLineDialog = customEditLineDialog;
    }

    @BeanTagAttribute
    public DialogGroup getEditLineDialogPrototype() {
        return this.editLineDialogPrototype;
    }

    public void setEditLineDialogPrototype(DialogGroup editLineDialogPrototype) {
        this.editLineDialogPrototype = editLineDialogPrototype;
    }

    @BeanTagAttribute
    public Action getEditWithDialogActionPrototype() {
        return this.editWithDialogActionPrototype;
    }

    public void setEditWithDialogActionPrototype(Action editWithDialogActionPrototype) {
        this.editWithDialogActionPrototype = editWithDialogActionPrototype;
    }

    @BeanTagAttribute
    public Action getEditInDialogSaveActionPrototype() {
        return this.editInDialogSaveActionPrototype;
    }

    public void setEditInDialogSaveActionPrototype(Action editInDialogSaveActionPrototype) {
        this.editInDialogSaveActionPrototype = editInDialogSaveActionPrototype;
    }

    public List<DialogGroup> getLineDialogs() {
        return this.lineDialogs;
    }

    public void setLineDialogs(List<DialogGroup> dialogGroups) {
        this.lineDialogs = dialogGroups;
    }
}

