/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.events;

import org.ehcache.Cache;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.EventType;

public final class CacheEvents {
    private CacheEvents() {
    }

    public static <K, V> CacheEvent<K, V> expiry(K expiredKey, V expiredValue, Cache<K, V> source) {
        return new ExpiryEvent<K, V>(expiredKey, expiredValue, source);
    }

    public static <K, V> CacheEvent<K, V> eviction(K evictedKey, V evictedValue, Cache<K, V> source) {
        return new EvictionEvent<K, V>(evictedKey, evictedValue, source);
    }

    public static <K, V> CacheEvent<K, V> creation(K newKey, V newValue, Cache<K, V> source) {
        return new CreationEvent<K, V>(newKey, newValue, source);
    }

    public static <K, V> CacheEvent<K, V> removal(K removedKey, V removedValue, Cache<K, V> source) {
        return new RemovalEvent<K, V>(removedKey, removedValue, source);
    }

    public static <K, V> CacheEvent<K, V> update(K key, V oldValue, V newValue, Cache<K, V> source) {
        return new UpdateEvent<K, V>(key, oldValue, newValue, source);
    }

    private static final class UpdateEvent<K, V>
    extends BaseCacheEvent<K, V> {
        final V oldValue;
        final V newValue;

        UpdateEvent(K key, V oldValue, V newValue, Cache<K, V> src) {
            super(key, src);
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public EventType getType() {
            return EventType.UPDATED;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public V getOldValue() {
            return this.oldValue;
        }
    }

    private static final class RemovalEvent<K, V>
    extends BaseCacheEvent<K, V> {
        final V removedValue;

        RemovalEvent(K removedKey, V removedValue, Cache<K, V> src) {
            super(removedKey, src);
            this.removedValue = removedValue;
        }

        public EventType getType() {
            return EventType.REMOVED;
        }

        public V getNewValue() {
            return null;
        }

        public V getOldValue() {
            return this.removedValue;
        }
    }

    private static final class CreationEvent<K, V>
    extends BaseCacheEvent<K, V> {
        final V newValue;

        CreationEvent(K newKey, V newValue, Cache<K, V> src) {
            super(newKey, src);
            this.newValue = newValue;
        }

        public EventType getType() {
            return EventType.CREATED;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public V getOldValue() {
            return null;
        }
    }

    private static final class EvictionEvent<K, V>
    extends BaseCacheEvent<K, V> {
        final V evictedValue;

        EvictionEvent(K evictedKey, V evictedValue, Cache<K, V> src) {
            super(evictedKey, src);
            this.evictedValue = evictedValue;
        }

        public EventType getType() {
            return EventType.EVICTED;
        }

        public V getNewValue() {
            return null;
        }

        public V getOldValue() {
            return this.evictedValue;
        }
    }

    private static final class ExpiryEvent<K, V>
    extends BaseCacheEvent<K, V> {
        final V expiredValue;

        ExpiryEvent(K expiredKey, V expiredValue, Cache<K, V> src) {
            super(expiredKey, src);
            this.expiredValue = expiredValue;
        }

        public EventType getType() {
            return EventType.EXPIRED;
        }

        public V getNewValue() {
            return null;
        }

        public V getOldValue() {
            return this.expiredValue;
        }
    }

    private static abstract class BaseCacheEvent<K, V>
    implements CacheEvent<K, V> {
        final K key;
        final Cache<K, V> src;

        protected BaseCacheEvent(K key, Cache<K, V> from) {
            this.key = key;
            this.src = from;
        }

        public K getKey() {
            return this.key;
        }

        @Deprecated
        public Cache<K, V> getSource() {
            return this.src;
        }

        public String toString() {
            return this.getType() + " on " + this.src + " key,oldValue,newValue='" + this.getKey() + "','" + this.getOldValue() + "','" + this.getNewValue() + "'";
        }
    }
}

