/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleService;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kew.rule.RoleAttribute;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExpressionResult;
import org.kuali.rice.kew.rule.RuleSelector;
import org.kuali.rice.kew.rule.TemplateRuleSelector;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.RoleRecipient;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kew.util.ResponsibleParty;
import org.kuali.rice.kew.util.Utilities;

public class FlexRM {
    private static final Logger LOG = LogManager.getLogger(FlexRM.class);
    public static final String DEFAULT_RULE_SELECTOR = "Template";
    private static final String RULE_SELECTOR_PACKAGE = "org.kuali.rice.kew.rule";
    private static final String RULE_SELECTOR_SUFFIX = "RuleSelector";
    private final Timestamp effectiveDate;
    private int selectedRules;

    public FlexRM() {
        this.effectiveDate = null;
    }

    public FlexRM(Timestamp effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    protected RuleSelector loadRuleSelector(RouteNode routeNodeDef, RouteNodeInstance nodeInstance) {
        RuleSelector ruleSelector;
        Class<?> ruleSelectorClass;
        NodeState ns = null;
        if (nodeInstance != null) {
            ns = nodeInstance.getNodeState("__RULE_SELECTOR__");
        }
        String ruleSelectorName = null;
        if (ns != null) {
            ruleSelectorName = ns.getValue();
        } else {
            Map<String, String> nodeCfgParams = Utilities.getKeyValueCollectionAsMap(routeNodeDef.getConfigParams());
            ruleSelectorName = nodeCfgParams.get("ruleSelector");
        }
        if (ruleSelectorName == null) {
            ruleSelectorName = DEFAULT_RULE_SELECTOR;
        }
        ruleSelectorName = StringUtils.capitalize((String)ruleSelectorName);
        String className = "org.kuali.rice.kew.rule." + ruleSelectorName + RULE_SELECTOR_SUFFIX;
        try {
            ruleSelectorClass = ClassLoaderUtils.getDefaultClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Rule selector implementation '" + className + "' not found", cnfe);
        }
        if (!RuleSelector.class.isAssignableFrom(ruleSelectorClass)) {
            throw new IllegalStateException("Specified class '" + String.valueOf(ruleSelectorClass) + "' does not implement RuleSelector interface");
        }
        try {
            ruleSelector = (RuleSelector)ruleSelectorClass.newInstance();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error instantiating rule selector implementation '" + String.valueOf(ruleSelectorClass) + "'", e);
        }
        return ruleSelector;
    }

    public List<ActionRequestValue> getActionRequests(DocumentRouteHeaderValue routeHeader, RouteNodeInstance nodeInstance, String ruleTemplateName) {
        return this.getActionRequests(routeHeader, nodeInstance.getRouteNode(), nodeInstance, ruleTemplateName);
    }

    public List<ActionRequestValue> getActionRequests(DocumentRouteHeaderValue routeHeader, RouteNode routeNodeDef, RouteNodeInstance nodeInstance, String ruleTemplateName) {
        RouteContext context = RouteContext.getCurrentRouteContext();
        if (context.getDocument() == null) {
            context.setDocument(routeHeader);
        }
        if (context.getNodeInstance() == null) {
            context.setNodeInstance(nodeInstance);
        }
        LOG.debug("Making action requests for document " + routeHeader.getDocumentId());
        RuleSelector ruleSelector = this.loadRuleSelector(routeNodeDef, nodeInstance);
        List<Rule> rules = ruleSelector.selectRules(context, routeHeader, nodeInstance, ruleTemplateName, this.effectiveDate);
        if (ruleSelector instanceof TemplateRuleSelector) {
            this.selectedRules += ((TemplateRuleSelector)ruleSelector).getNumberOfSelectedRules();
        }
        PerformanceLogger performanceLogger = new PerformanceLogger();
        ActionRequestFactory arFactory = new ActionRequestFactory(routeHeader, context.getNodeInstance());
        ArrayList<ActionRequestValue> actionRequests = new ArrayList();
        if (rules != null) {
            LOG.info("Total number of rules selected by RuleSelector for documentType=" + routeHeader.getDocumentType().getName() + " and ruleTemplate=" + ruleTemplateName + ": " + rules.size());
            for (Rule rule : rules) {
                RuleExpressionResult result = rule.evaluate(rule, context);
                if (!result.isSuccess() || result.getResponsibilities() == null) continue;
                org.kuali.rice.kew.api.rule.Rule ruleDef = Rule.Builder.create((RuleContract)rule.getDefinition()).build();
                this.makeActionRequests(arFactory, result.getResponsibilities(), context, ruleDef, routeHeader, null, null);
            }
        }
        actionRequests = new ArrayList<ActionRequestValue>(arFactory.getRequestGraphs());
        performanceLogger.log("Time to make action request for template " + ruleTemplateName);
        return actionRequests;
    }

    public ResponsibleParty resolveResponsibilityId(String responsibilityId) {
        return null;
    }

    public void makeActionRequests(ActionRequestFactory arFactory, List<RuleResponsibility> responsibilities, RouteContext context, org.kuali.rice.kew.api.rule.Rule rule, DocumentRouteHeaderValue routeHeader, ActionRequestValue parentRequest, RuleDelegation ruleDelegation) {
        for (RuleResponsibility responsibility : responsibilities) {
            if (responsibility.isUsingRole()) {
                this.makeRoleActionRequests(arFactory, context, rule, responsibility, routeHeader, parentRequest, ruleDelegation);
                continue;
            }
            this.makeActionRequest(arFactory, context, rule, routeHeader, responsibility, parentRequest, ruleDelegation);
        }
    }

    private void buildDelegationGraph(ActionRequestFactory arFactory, RouteContext context, org.kuali.rice.kew.api.rule.Rule delegationRule, DocumentRouteHeaderValue routeHeaderValue, ActionRequestValue parentRequest, RuleDelegation ruleDelegation) {
        context.setActionRequest(parentRequest);
        RuleBaseValues delRuleBo = KEWServiceLocator.getRuleService().getRuleByName(delegationRule.getName());
        if (delegationRule.isActive()) {
            for (RuleResponsibility delegationResp : delegationRule.getRuleResponsibilities()) {
                if (delegationResp.isUsingRole()) {
                    this.makeRoleActionRequests(arFactory, context, delegationRule, delegationResp, routeHeaderValue, parentRequest, ruleDelegation);
                    continue;
                }
                if (!delRuleBo.isMatch(context.getDocumentContent())) continue;
                this.makeActionRequest(arFactory, context, delegationRule, routeHeaderValue, delegationResp, parentRequest, ruleDelegation);
            }
        }
    }

    private void makeRoleActionRequests(ActionRequestFactory arFactory, RouteContext context, org.kuali.rice.kew.api.rule.Rule rule, RuleResponsibility resp, DocumentRouteHeaderValue routeHeader, ActionRequestValue parentRequest, RuleDelegation ruleDelegation) {
        String roleName = resp.getResolvedRoleName();
        RoleAttribute roleAttribute = null;
        if (resp.isUsingRole() && (roleAttribute = (RoleAttribute)GlobalResourceLoader.getResourceLoader().getObject(new ObjectDefinition(resp.getRoleAttributeName()))) instanceof XmlConfiguredAttribute) {
            ExtensionDefinition roleAttributeDefinition = null;
            for (RuleTemplateAttribute ruleTemplateAttribute : rule.getRuleTemplate().getRuleTemplateAttributes()) {
                if (!resp.getRoleAttributeName().equals(ruleTemplateAttribute.getRuleAttribute().getResourceDescriptor())) continue;
                roleAttributeDefinition = ruleTemplateAttribute.getRuleAttribute();
                break;
            }
            ((XmlConfiguredAttribute)((Object)roleAttribute)).setExtensionDefinition(roleAttributeDefinition);
        }
        ArrayList<String> qualifiedRoleNames = new ArrayList<String>();
        if (parentRequest != null && parentRequest.getQualifiedRoleName() != null) {
            qualifiedRoleNames.add(parentRequest.getQualifiedRoleName());
        } else {
            qualifiedRoleNames.addAll(roleAttribute.getQualifiedRoleNames(roleName, context.getDocumentContent()));
        }
        for (String qualifiedRoleName : qualifiedRoleNames) {
            if (parentRequest == null && this.isDuplicateActionRequestDetected(routeHeader, context.getNodeInstance(), resp, qualifiedRoleName)) continue;
            ResolvedQualifiedRole resolvedRole = roleAttribute.resolveQualifiedRole(context, roleName, qualifiedRoleName);
            RoleRecipient recipient = new RoleRecipient(roleName, qualifiedRoleName, resolvedRole);
            if (parentRequest == null) {
                ActionRequestValue roleRequest = arFactory.addRoleRequest(recipient, resp.getActionRequestedCd(), resp.getApprovePolicy(), resp.getPriority(), resp.getResponsibilityId(), rule.isForceAction(), rule.getDescription(), rule.getId());
                List ruleDelegations = this.getRuleService().getRuleDelegationsByResponsibiltityId(resp.getResponsibilityId());
                if (ruleDelegations == null || ruleDelegations.isEmpty()) continue;
                for (ActionRequestValue request : roleRequest.getChildrenRequests()) {
                    for (RuleDelegation childRuleDelegation : ruleDelegations) {
                        this.buildDelegationGraph(arFactory, context, childRuleDelegation.getDelegationRule(), routeHeader, request, childRuleDelegation);
                    }
                }
                continue;
            }
            arFactory.addDelegationRoleRequest(parentRequest, resp.getApprovePolicy(), recipient, resp.getResponsibilityId(), rule.isForceAction(), ruleDelegation.getDelegationType(), rule.getDescription(), rule.getId());
        }
    }

    private void makeActionRequest(ActionRequestFactory arFactory, RouteContext context, org.kuali.rice.kew.api.rule.Rule rule, DocumentRouteHeaderValue routeHeader, RuleResponsibility resp, ActionRequestValue parentRequest, RuleDelegation ruleDelegation) {
        Recipient recipient;
        if (parentRequest == null && this.isDuplicateActionRequestDetected(routeHeader, context.getNodeInstance(), resp, null)) {
            return;
        }
        if (resp.isUsingPrincipal()) {
            recipient = new KimPrincipalRecipient(resp.getPrincipalId());
        } else if (resp.isUsingGroup()) {
            recipient = new KimGroupRecipient(resp.getGroupId());
        } else {
            throw new RiceRuntimeException("Illegal rule responsibility type encountered");
        }
        if (parentRequest == null) {
            ActionRequestValue actionRequest = arFactory.addRootActionRequest(resp.getActionRequestedCd(), resp.getPriority(), recipient, rule.getDescription(), resp.getResponsibilityId(), rule.isForceAction(), resp.getApprovePolicy(), rule.getId());
            List ruleDelegations = this.getRuleService().getRuleDelegationsByResponsibiltityId(resp.getResponsibilityId());
            if (ruleDelegations != null && !ruleDelegations.isEmpty()) {
                for (RuleDelegation childRuleDelegation : ruleDelegations) {
                    this.buildDelegationGraph(arFactory, context, childRuleDelegation.getDelegationRule(), routeHeader, actionRequest, childRuleDelegation);
                }
            }
        } else {
            arFactory.addDelegationRequest(parentRequest, recipient, resp.getResponsibilityId(), rule.isForceAction(), ruleDelegation.getDelegationType(), rule.getDescription(), rule.getId());
        }
    }

    private boolean isDuplicateActionRequestDetected(DocumentRouteHeaderValue routeHeader, RouteNodeInstance nodeInstance, RuleResponsibility resp, String qualifiedRoleName) {
        List<ActionRequestValue> requests = this.getActionRequestService().findByStatusAndDocId(ActionRequestStatus.DONE.getCode(), routeHeader.getDocumentId());
        for (ActionRequestValue request : requests) {
            if ((nodeInstance == null || request.getNodeInstance() == null || !request.getNodeInstance().getRouteNodeInstanceId().equals(nodeInstance.getRouteNodeInstanceId())) && !request.getRouteLevel().equals(routeHeader.getDocRouteLevel()) || !request.getResponsibilityId().equals(resp.getResponsibilityId()) || !ObjectUtils.equals((Object)request.getQualifiedRoleName(), (Object)qualifiedRoleName)) continue;
            return true;
        }
        return false;
    }

    public RuleService getRuleService() {
        return KewApiServiceLocator.getRuleService();
    }

    private ActionRequestService getActionRequestService() {
        return KEWServiceLocator.getActionRequestService();
    }

    public int getNumberOfMatchingRules() {
        return this.selectedRules;
    }
}

