/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByMtoNCriteria;
import org.apache.ojb.broker.query.ReportQueryByMtoNCriteria;

public class MtoNCollectionPrefetcher
extends CollectionPrefetcher {
    public MtoNCollectionPrefetcher(PersistenceBrokerImpl persistenceBrokerImpl, ObjectReferenceDescriptor objectReferenceDescriptor) {
        super(persistenceBrokerImpl, objectReferenceDescriptor);
    }

    @Override
    public void prefetchRelationship(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        Query[] queryArray = this.buildPrefetchQueries(collection, arrayList);
        Query[] queryArray2 = this.buildMtoNImplementorQueries(collection, arrayList);
        for (int i = 0; i < queryArray.length; ++i) {
            Object object;
            Iterator iterator = this.getBroker().getIteratorByQuery(queryArray[i]);
            while (iterator.hasNext()) {
                object = iterator.next();
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
            object = this.getBroker().getReportQueryIteratorByQuery(queryArray2[i]);
            while (object.hasNext()) {
                arrayList2.add(object.next());
            }
        }
        this.associateBatched(collection, arrayList, arrayList2);
    }

    @Override
    protected Query buildPrefetchQuery(Collection collection) {
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        String[] stringArray = this.getFksToThisClass();
        String[] stringArray2 = this.getFksToItemClass();
        FieldDescriptor[] fieldDescriptorArray = this.getItemClassDescriptor().getPkFields();
        Criteria criteria = this.buildPrefetchCriteria(collection, stringArray, stringArray2, fieldDescriptorArray);
        return new QueryByMtoNCriteria(collectionDescriptor.getItemClass(), collectionDescriptor.getIndirectionTable(), criteria, false);
    }

    protected Query buildMtoNImplementorQuery(Collection collection) {
        int n;
        String[] stringArray = this.getFksToThisClass();
        String[] stringArray2 = this.getFksToItemClass();
        FieldDescriptor[] fieldDescriptorArray = this.getOwnerClassDescriptor().getPkFields();
        FieldDescriptor[] fieldDescriptorArray2 = this.getItemClassDescriptor().getPkFields();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int[] nArray = new int[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        Criteria criteria = this.buildPrefetchCriteria(collection, stringArray, stringArray2, fieldDescriptorArray2);
        for (n = 0; n < fieldDescriptorArray.length; ++n) {
            nArray[n] = fieldDescriptorArray[n].getJdbcType().getType();
        }
        for (n = 0; n < fieldDescriptorArray2.length; ++n) {
            nArray[fieldDescriptorArray.length + n] = fieldDescriptorArray2[n].getJdbcType().getType();
        }
        ReportQueryByMtoNCriteria reportQueryByMtoNCriteria = new ReportQueryByMtoNCriteria(this.getItemClassDescriptor().getClassOfObject(), stringArray3, criteria, false);
        reportQueryByMtoNCriteria.setIndirectionTable(this.getCollectionDescriptor().getIndirectionTable());
        reportQueryByMtoNCriteria.setJdbcTypes(nArray);
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        if (!collectionDescriptor.getOrderBy().isEmpty()) {
            Iterator iterator = collectionDescriptor.getOrderBy().iterator();
            while (iterator.hasNext()) {
                reportQueryByMtoNCriteria.addOrderBy((FieldHelper)iterator.next());
            }
        }
        return reportQueryByMtoNCriteria;
    }

    private String[] getFksToThisClass() {
        String string = this.getCollectionDescriptor().getIndirectionTable();
        String[] stringArray = this.getCollectionDescriptor().getFksToThisClass();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = string + "." + stringArray[i];
        }
        return stringArray2;
    }

    private String[] getFksToItemClass() {
        String string = this.getCollectionDescriptor().getIndirectionTable();
        String[] stringArray = this.getCollectionDescriptor().getFksToItemClass();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = string + "." + stringArray[i];
        }
        return stringArray2;
    }

    protected Query[] buildMtoNImplementorQueries(Collection collection, Collection collection2) {
        ClassDescriptor classDescriptor = this.getOwnerClassDescriptor();
        PersistenceBrokerImpl persistenceBrokerImpl = this.getBroker();
        ArrayList<Query> arrayList = new ArrayList<Query>(collection.size());
        HashSet<Identity> hashSet = new HashSet<Identity>(collection.size());
        for (Object e : collection) {
            Identity identity = persistenceBrokerImpl.serviceIdentity().buildIdentity(classDescriptor, e);
            hashSet.add(identity);
            if (hashSet.size() != this.pkLimit) continue;
            arrayList.add(this.buildMtoNImplementorQuery(hashSet));
            hashSet.clear();
        }
        if (hashSet.size() > 0) {
            arrayList.add(this.buildMtoNImplementorQuery(hashSet));
        }
        return arrayList.toArray(new Query[arrayList.size()]);
    }

    private Criteria buildPrefetchCriteria(Collection collection, String[] stringArray, String[] stringArray2, FieldDescriptor[] fieldDescriptorArray) {
        if (stringArray.length == 1 && stringArray2.length == 1) {
            return this.buildPrefetchCriteriaSingleKey(collection, stringArray[0], stringArray2[0], fieldDescriptorArray[0]);
        }
        return this.buildPrefetchCriteriaMultipleKeys(collection, stringArray, stringArray2, fieldDescriptorArray);
    }

    private Criteria buildPrefetchCriteriaSingleKey(Collection collection, String string, String string2, FieldDescriptor fieldDescriptor) {
        Criteria criteria = new Criteria();
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (Identity identity : collection) {
            arrayList.add(identity.getPrimaryKeyValues()[0]);
        }
        switch (arrayList.size()) {
            case 0: {
                break;
            }
            case 1: {
                criteria.addEqualTo(string, arrayList.get(0));
                break;
            }
            default: {
                criteria.addIn(string, arrayList);
            }
        }
        criteria.addEqualToField(fieldDescriptor.getAttributeName(), string2);
        return criteria;
    }

    private Criteria buildPrefetchCriteriaMultipleKeys(Collection collection, String[] stringArray, String[] stringArray2, FieldDescriptor[] fieldDescriptorArray) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = new Criteria();
        Iterator iterator = collection.iterator();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            criteria.addEqualToField(fieldDescriptorArray[i].getAttributeName(), stringArray2[i]);
        }
        while (iterator.hasNext()) {
            Criteria criteria3 = new Criteria();
            Identity identity = (Identity)iterator.next();
            Object[] objectArray = identity.getPrimaryKeyValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    criteria3.addIsNull(stringArray[i]);
                    continue;
                }
                criteria3.addEqualTo(stringArray[i], objectArray[i]);
            }
            criteria2.addOrCriteria(criteria3);
        }
        criteria.addAndCriteria(criteria2);
        return criteria;
    }

    private FieldConversion[] getPkFieldConversion(ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        FieldConversion[] fieldConversionArray = new FieldConversion[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            fieldConversionArray[i] = fieldDescriptorArray[i].getFieldConversion();
        }
        return fieldConversionArray;
    }

    private Object[] convert(FieldConversion[] fieldConversionArray, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = fieldConversionArray[i].sqlToJava(objectArray[i]);
        }
        return objectArray2;
    }

    protected void associateBatched(Collection collection, Collection collection2, Collection collection3) {
        Object object;
        Collection<Object> collection4;
        Identity identity;
        Object[] objectArray;
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        PersistentField persistentField = collectionDescriptor.getPersistentField();
        PersistenceBrokerImpl persistenceBrokerImpl = this.getBroker();
        Class clazz = persistenceBrokerImpl.getTopLevelClass(this.getOwnerClassDescriptor().getClassOfObject());
        Class clazz2 = persistenceBrokerImpl.getTopLevelClass(this.getItemClassDescriptor().getClassOfObject());
        Class clazz3 = collectionDescriptor.getCollectionClass();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        FieldConversion[] fieldConversionArray = this.getPkFieldConversion(this.getOwnerClassDescriptor());
        FieldConversion[] fieldConversionArray2 = this.getPkFieldConversion(this.getItemClassDescriptor());
        for (Object e : collection) {
            objectArray = persistenceBrokerImpl.serviceIdentity().buildIdentity(e);
            hashMap2.put(objectArray, new ArrayList());
        }
        for (Object e : collection2) {
            objectArray = persistenceBrokerImpl.serviceIdentity().buildIdentity(e);
            hashMap.put(objectArray, e);
        }
        int n = this.getOwnerClassDescriptor().getPkFields().length;
        int n2 = this.getItemClassDescriptor().getPkFields().length;
        objectArray = new Object[n];
        Object[] objectArray2 = new Object[n2];
        for (Object object2 : collection3) {
            System.arraycopy(object2, 0, objectArray, 0, n);
            System.arraycopy(object2, n, objectArray2, 0, n2);
            objectArray = this.convert(fieldConversionArray, objectArray);
            objectArray2 = this.convert(fieldConversionArray2, objectArray2);
            Object object3 = persistenceBrokerImpl.serviceIdentity().buildIdentity(null, clazz, objectArray);
            identity = persistenceBrokerImpl.serviceIdentity().buildIdentity(null, clazz2, objectArray2);
            collection4 = (Collection)hashMap2.get(object3);
            object = hashMap.get(identity);
            collection4.add(object);
        }
        for (Object object3 : collection) {
            Object object4;
            Object object2;
            identity = persistenceBrokerImpl.serviceIdentity().buildIdentity(object3);
            collection4 = (List)hashMap2.get(identity);
            if (clazz3 == null && persistentField.getType().isArray()) {
                int n3 = collection4.size();
                object4 = persistentField.getType().getComponentType();
                object2 = Array.newInstance(object4, n3);
                for (int i = 0; i < n3; ++i) {
                    Array.set(object2, i, collection4.get(i));
                }
            } else {
                object = this.createCollection(collectionDescriptor, clazz3);
                object4 = collection4.iterator();
                while (object4.hasNext()) {
                    object.ojbAdd(object4.next());
                }
                object2 = object;
            }
            if ((object = persistentField.get(object3)) instanceof CollectionProxyDefaultImpl && object2 instanceof Collection) {
                ((CollectionProxyDefaultImpl)object).setData((Collection)object2);
                continue;
            }
            persistentField.set(object3, object2);
        }
    }
}

