/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectAuthorizer;
import org.kuali.rice.krad.util.KRADUtils;

public class DataObjectAuthorizerBase
implements DataObjectAuthorizer,
Serializable {
    private static final long serialVersionUID = 3987953326458974964L;

    @Override
    public final boolean isAuthorized(Object dataObject, String namespaceCode, String permissionName, String principalId) {
        return DataObjectAuthorizerBase.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, new HashMap<String, String>(this.getRoleQualification(dataObject, principalId)));
    }

    @Override
    public final boolean isAuthorizedByTemplate(Object dataObject, String namespaceCode, String permissionTemplateName, String principalId) {
        return DataObjectAuthorizerBase.getPermissionService().isAuthorizedByTemplate(principalId, namespaceCode, permissionTemplateName, new HashMap<String, String>(this.getPermissionDetailValues(dataObject)), new HashMap<String, String>(this.getRoleQualification(dataObject, principalId)));
    }

    @Override
    public final boolean isAuthorized(Object dataObject, String namespaceCode, String permissionName, String principalId, Map<String, String> collectionOrFieldLevelPermissionDetails, Map<String, String> collectionOrFieldLevelRoleQualification) {
        HashMap<String, String> roleQualifiers;
        if (collectionOrFieldLevelRoleQualification != null) {
            roleQualifiers = new HashMap<String, String>(this.getRoleQualification(dataObject, principalId));
            roleQualifiers.putAll(collectionOrFieldLevelRoleQualification);
        } else {
            roleQualifiers = new HashMap<String, String>(this.getRoleQualification(dataObject, principalId));
        }
        if (collectionOrFieldLevelPermissionDetails != null) {
            HashMap<String, String> permissionDetails = new HashMap<String, String>(this.getPermissionDetailValues(dataObject));
            permissionDetails.putAll(collectionOrFieldLevelPermissionDetails);
        } else {
            HashMap<String, String> permissionDetails = new HashMap<String, String>(this.getPermissionDetailValues(dataObject));
        }
        return DataObjectAuthorizerBase.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, roleQualifiers);
    }

    @Override
    public final boolean isAuthorizedByTemplate(Object dataObject, String namespaceCode, String permissionTemplateName, String principalId, Map<String, String> collectionOrFieldLevelPermissionDetails, Map<String, String> collectionOrFieldLevelRoleQualification) {
        HashMap<String, String> roleQualifiers = new HashMap<String, String>(this.getRoleQualification(dataObject, principalId));
        HashMap<String, String> permissionDetails = new HashMap<String, String>(this.getPermissionDetailValues(dataObject));
        if (collectionOrFieldLevelRoleQualification != null) {
            roleQualifiers.putAll(collectionOrFieldLevelRoleQualification);
        }
        if (collectionOrFieldLevelPermissionDetails != null) {
            permissionDetails.putAll(collectionOrFieldLevelPermissionDetails);
        }
        return DataObjectAuthorizerBase.getPermissionService().isAuthorizedByTemplate(principalId, namespaceCode, permissionTemplateName, permissionDetails, roleQualifiers);
    }

    protected void addRoleQualification(Object primaryDataObjectOrDocument, Map<String, String> attributes) {
        this.addStandardAttributes(primaryDataObjectOrDocument, attributes);
    }

    protected void addPermissionDetails(Object primaryDataObjectOrDocument, Map<String, String> attributes) {
        this.addStandardAttributes(primaryDataObjectOrDocument, attributes);
    }

    private void addStandardAttributes(Object primaryDataObjectOrDocument, Map<String, String> attributes) {
        attributes.putAll(KRADUtils.getNamespaceAndComponentSimpleName(primaryDataObjectOrDocument.getClass()));
    }

    protected final boolean permissionExistsByTemplate(Object dataObject, String namespaceCode, String permissionTemplateName) {
        return DataObjectAuthorizerBase.getPermissionService().isPermissionDefinedByTemplate(namespaceCode, permissionTemplateName, new HashMap<String, String>(this.getPermissionDetailValues(dataObject)));
    }

    protected final boolean permissionExistsByTemplate(String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) {
        return DataObjectAuthorizerBase.getPermissionService().isPermissionDefinedByTemplate(namespaceCode, permissionTemplateName, new HashMap<String, String>(permissionDetails));
    }

    protected final boolean permissionExistsByTemplate(Object dataObject, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) {
        HashMap<String, String> combinedPermissionDetails = new HashMap<String, String>(this.getPermissionDetailValues(dataObject));
        combinedPermissionDetails.putAll(permissionDetails);
        return DataObjectAuthorizerBase.getPermissionService().isPermissionDefinedByTemplate(namespaceCode, permissionTemplateName, combinedPermissionDetails);
    }

    protected final Map<String, String> getRoleQualification(Object primaryDataObjectOrDocument, String principalId) {
        HashMap<String, String> roleQualification = new HashMap<String, String>();
        this.addRoleQualification(primaryDataObjectOrDocument, roleQualification);
        roleQualification.put("principalId", principalId);
        return roleQualification;
    }

    protected final Map<String, String> getPermissionDetailValues(Object primaryDataObjectOrDocument) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        this.addPermissionDetails(primaryDataObjectOrDocument, permissionDetails);
        return permissionDetails;
    }

    protected static PermissionService getPermissionService() {
        return KimApiServiceLocator.getPermissionService();
    }

    protected static PersonService getPersonService() {
        return KimApiServiceLocator.getPersonService();
    }
}

