/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.util.Link;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.bind.ChangeTracking;
import org.kuali.rice.krad.web.bind.UifBeanPropertyBindingResult;
import org.kuali.rice.krad.web.bind.UifBindingErrorProcessor;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.web.bind.ServletRequestDataBinder;

public class UifServletRequestDataBinder
extends ServletRequestDataBinder {
    protected static final Logger LOG = LogManager.getLogger(UifServletRequestDataBinder.class);
    private UifBeanPropertyBindingResult bindingResult;
    private ConversionService conversionService;
    private DataObjectService dataObjectService;
    private boolean changeTracking = false;
    private boolean autoLinking = true;

    public UifServletRequestDataBinder(Object target) {
        super(target);
        this.changeTracking = UifServletRequestDataBinder.determineChangeTracking(target);
        this.setBindingErrorProcessor((BindingErrorProcessor)new UifBindingErrorProcessor());
    }

    public UifServletRequestDataBinder(Object target, String name) {
        super(target, name);
        this.changeTracking = UifServletRequestDataBinder.determineChangeTracking(target);
        this.setBindingErrorProcessor((BindingErrorProcessor)new UifBindingErrorProcessor());
    }

    private static boolean determineChangeTracking(Object target) {
        ChangeTracking changeTracking = (ChangeTracking)AnnotationUtils.findAnnotation(target.getClass(), ChangeTracking.class);
        return changeTracking != null && changeTracking.enabled();
    }

    public void initBeanPropertyAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initBeanPropertyAccess before other configuration methods");
        this.bindingResult = new UifBeanPropertyBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths(), this.getAutoGrowCollectionLimit());
        this.bindingResult.setChangeTracking(this.changeTracking);
        if (this.conversionService != null) {
            this.bindingResult.initConversion(this.conversionService);
        }
        if (this.dataObjectService == null) {
            this.dataObjectService = KradDataServiceLocator.getDataObjectService();
        }
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        if (this.bindingResult == null) {
            this.initBeanPropertyAccess();
        }
        return this.bindingResult;
    }

    public void initDirectFieldAccess() {
        LOG.error("Direct Field access is not allowed in UifServletRequestDataBinder.");
        throw new RuntimeException("Direct Field access is not allowed in Kuali");
    }

    private void _bind(ServletRequest request) {
        super.bind(request);
    }

    public void bind(ServletRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request Parameters from getParameterMap:");
            for (String key : request.getParameterMap().keySet()) {
                LOG.debug("\t" + key + "=>" + Arrays.toString((Object[])request.getParameterMap().get(key)));
            }
            LOG.debug("Request Parameters from getParameter:");
            for (String name : Collections.list(request.getParameterNames())) {
                LOG.debug("\t" + name + "=>" + request.getParameter(name));
            }
        }
        UifFormBase form = (UifFormBase)this.getTarget();
        request.setAttribute("requestForm", (Object)form);
        form.preBind((HttpServletRequest)request);
        this._bind(request);
        request.setAttribute("rice.krad.uif.propertyEditorRegistry", (Object)this.bindingResult.getPropertyEditorRegistry());
        this.executeAutomaticLinking(request, form);
        if (!form.isUpdateNoneRequest()) {
            String viewId = (String)request.getAttribute("viewId");
            if (StringUtils.isBlank((String)viewId)) {
                viewId = request.getParameter("viewId");
            }
            View view = null;
            if (StringUtils.isNotBlank((String)viewId)) {
                view = this.getViewService().getViewById(viewId);
            }
            if (view == null) {
                view = this.getViewByType(request, form);
            }
            if (view == null && (view = this.getViewFromPreviousModel(form)) != null) {
                LOG.warn("Obtained viewId from cached form, this may not be safe!");
            }
            if (view != null) {
                form.setViewId(view.getId());
            } else {
                form.setViewId(null);
            }
            form.setView(view);
        }
        form.postBind((HttpServletRequest)request);
    }

    protected void executeAutomaticLinking(ServletRequest request, UifFormBase form) {
        if (!this.changeTracking) {
            LOG.info("Skip automatic linking because change tracking not enabled for this form.");
            return;
        }
        if (!this.autoLinking) {
            LOG.info("Skip automatic linking because it has been disabled for this form");
            return;
        }
        Set<String> autoLinkingPaths = this.determineRootAutoLinkingPaths(form.getClass(), null, new HashSet());
        List<AutoLinkTarget> targets = this.extractAutoLinkTargets(autoLinkingPaths);
        for (AutoLinkTarget target : targets) {
            if (!this.dataObjectService.supports(target.getTarget().getClass())) {
                LOG.warn("Encountered an auto linking target that is not a valid data object: " + String.valueOf(target.getTarget().getClass()));
                continue;
            }
            DataObjectWrapper wrapped = this.dataObjectService.wrap(target.getTarget());
            wrapped.linkChanges(target.getModifiedPropertyPaths());
        }
    }

    protected Set<String> determineRootAutoLinkingPaths(Class<?> rootObjectType, String path, Set<Class<?>> scanned) {
        HashSet<String> autoLinkingPaths = new HashSet<String>();
        if (scanned.contains(rootObjectType)) {
            return autoLinkingPaths;
        }
        scanned.add(rootObjectType);
        Link autoLink = (Link)AnnotationUtils.findAnnotation(rootObjectType, Link.class);
        if (autoLink != null && autoLink.cascade()) {
            autoLinkingPaths.addAll(this.assembleAutoLinkingPaths(path, autoLink));
        } else if (autoLink == null) {
            Field[] fields;
            for (Field field : fields = FieldUtils.getAllFields(rootObjectType)) {
                autoLink = field.getAnnotation(Link.class);
                if (autoLink != null) {
                    if (!autoLink.cascade()) continue;
                    String fieldPath = this.appendToPath(path, field.getName());
                    autoLinkingPaths.addAll(this.assembleAutoLinkingPaths(fieldPath, autoLink));
                    continue;
                }
                autoLinkingPaths.addAll(this.determineRootAutoLinkingPaths(field.getType(), this.appendToPath(path, field.getName()), scanned));
            }
        }
        return autoLinkingPaths;
    }

    protected Set<String> assembleAutoLinkingPaths(String path, Link autoLink) {
        HashSet<String> autoLinkingPaths = new HashSet<String>();
        if (ArrayUtils.isEmpty((Object[])autoLink.path())) {
            autoLinkingPaths.add(path);
        } else {
            for (String autoLinkingPath : autoLink.path()) {
                autoLinkingPaths.add(this.appendToPath(path, autoLinkingPath));
            }
        }
        return autoLinkingPaths;
    }

    protected List<AutoLinkTarget> extractAutoLinkTargets(Set<String> autoLinkingPaths) {
        ArrayList<AutoLinkTarget> targets = new ArrayList<AutoLinkTarget>();
        for (String autoLinkingPath : autoLinkingPaths) {
            Object targetObject = this.getInternalBindingResult().getPropertyAccessor().getPropertyValue(autoLinkingPath);
            if (targetObject == null) continue;
            if (targetObject instanceof Map) {
                targets.addAll(this.extractAutoLinkMapTargets(autoLinkingPath, (Map)targetObject));
                continue;
            }
            if (targetObject instanceof List) {
                targets.addAll(this.extractAutoLinkListTargets(autoLinkingPath, (List)targetObject));
                continue;
            }
            HashSet<String> modifiedAutoLinkingPaths = new HashSet<String>();
            Set<String> modifiedPaths = ((UifBeanPropertyBindingResult)this.getInternalBindingResult()).getModifiedPaths();
            for (String modifiedPath : modifiedPaths) {
                if (!modifiedPath.startsWith(autoLinkingPath)) continue;
                modifiedAutoLinkingPaths.add(modifiedPath.substring(autoLinkingPath.length() + 1));
            }
            targets.add(new AutoLinkTarget(targetObject, modifiedAutoLinkingPaths));
        }
        return targets;
    }

    protected List<AutoLinkTarget> extractAutoLinkMapTargets(String autoLinkingPath, Map<?, ?> targetMap) {
        ArrayList<AutoLinkTarget> targets = new ArrayList<AutoLinkTarget>();
        Set<String> modifiedPaths = ((UifBeanPropertyBindingResult)this.getInternalBindingResult()).getModifiedPaths();
        for (Map.Entry<?, ?> targetMapEntry : targetMap.entrySet()) {
            HashSet<String> modifiedAutoLinkingPaths = new HashSet<String>();
            for (String modifiedPath : modifiedPaths) {
                String targetPathMatch;
                if (!modifiedPath.startsWith(targetPathMatch = autoLinkingPath + "['" + String.valueOf(targetMapEntry.getKey()) + "']")) continue;
                modifiedAutoLinkingPaths.add(modifiedPath.substring(targetPathMatch.length() + 1));
            }
            if (modifiedAutoLinkingPaths.isEmpty()) continue;
            targets.add(new AutoLinkTarget(targetMapEntry.getValue(), modifiedAutoLinkingPaths));
        }
        return targets;
    }

    protected List<AutoLinkTarget> extractAutoLinkListTargets(String autoLinkingPath, List<?> targetList) {
        ArrayList<AutoLinkTarget> targets = new ArrayList<AutoLinkTarget>();
        Set<String> modifiedPaths = ((UifBeanPropertyBindingResult)this.getInternalBindingResult()).getModifiedPaths();
        for (int i = 0; i < targetList.size(); ++i) {
            HashSet<String> modifiedAutoLinkingPaths = new HashSet<String>();
            for (String modifiedPath : modifiedPaths) {
                String targetPathMatch;
                if (!modifiedPath.startsWith(targetPathMatch = autoLinkingPath + "[" + i + "]")) continue;
                modifiedAutoLinkingPaths.add(modifiedPath.substring(targetPathMatch.length() + 1));
            }
            if (modifiedAutoLinkingPaths.isEmpty()) continue;
            targets.add(new AutoLinkTarget(targetList.get(i), modifiedAutoLinkingPaths));
        }
        return targets;
    }

    private String appendToPath(String path, String pathElement) {
        if (StringUtils.isEmpty((String)path)) {
            return pathElement;
        }
        if (StringUtils.isEmpty((String)pathElement)) {
            return path;
        }
        return path + "." + pathElement;
    }

    protected View getViewByType(ServletRequest request, UifFormBase form) {
        UifConstants.ViewType viewType;
        View view = null;
        String viewTypeName = request.getParameter("viewTypeName");
        UifConstants.ViewType viewType2 = viewType = StringUtils.isBlank((String)viewTypeName) ? form.getViewTypeName() : UifConstants.ViewType.valueOf(viewTypeName);
        if (viewType != null) {
            Map<String, String> parameterMap = KRADUtils.translateRequestParameterMap(request.getParameterMap());
            view = this.getViewService().getViewByType(viewType, parameterMap);
        }
        return view;
    }

    protected View getViewFromPreviousModel(UifFormBase form) {
        if (form.getViewId() != null) {
            return this.getViewService().getViewById(form.getViewId());
        }
        return null;
    }

    public boolean isChangeTracking() {
        return this.changeTracking;
    }

    public boolean isAutoLinking() {
        return this.autoLinking;
    }

    public void setAutoLinking(boolean autoLinking) {
        this.autoLinking = autoLinking;
    }

    public ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    private static final class AutoLinkTarget {
        private final Object target;
        private final Set<String> modifiedPropertyPaths;

        AutoLinkTarget(Object target, Set<String> modifiedPropertyPaths) {
            this.target = target;
            this.modifiedPropertyPaths = modifiedPropertyPaths;
        }

        Object getTarget() {
            return this.target;
        }

        Set<String> getModifiedPropertyPaths() {
            return Collections.unmodifiableSet(this.modifiedPropertyPaths);
        }
    }
}

