/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.layout.collections.TableExporter;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/export"})
public class UifExportController
extends UifControllerBase {
    private static final Logger LOG = LogManager.getLogger(UifExportController.class);
    @Autowired
    protected HttpServletRequest request;

    @Override
    protected UifFormBase createInitialForm() {
        String formKey = this.request.getParameter("formKey");
        if (StringUtils.isBlank((String)formKey)) {
            throw new RuntimeException("Unable to create export form due to misssing form key parameter");
        }
        UifFormBase sessionForm = GlobalVariables.getUifFormManager().getSessionForm(formKey);
        if (sessionForm != null) {
            try {
                return (UifFormBase)sessionForm.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create export form instance from session form", e);
            }
        }
        return null;
    }

    @MethodAccessible
    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableCsvRetrieval"}, produces={"text/csv"})
    @ResponseBody
    public String tableCsvRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("processing csv table data request");
        return this.retrieveTableData(form, request, response);
    }

    @MethodAccessible
    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableXlsRetrieval"}, produces={"application/vnd.ms-excel"})
    @ResponseBody
    public String tableXlsRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("processing xls table data request");
        return this.retrieveTableData(form, request, response);
    }

    @MethodAccessible
    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableXmlRetrieval"}, produces={"application/xml"})
    @ResponseBody
    public String tableXmlRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("processing xml table data request");
        return this.retrieveTableData(form, request, response);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=inquiryXmlRetrieval"}, produces={"application/xml"})
    @ResponseBody
    public ModelAndView inquiryXmlRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        Object dataObject = inquiryForm.getDataObject();
        if (dataObject != null) {
            this.applyCustomExport(Collections.singletonList(dataObject), inquiryForm.getDataObjectClassName(), "xml", response);
        }
        return null;
    }

    protected String retrieveTableData(@ModelAttribute(value="KualiForm") UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("processing table data request");
        CollectionGroup collectionGroup = (CollectionGroup)ViewLifecycle.performComponentLifecycle(form.getView(), form, request, form.getViewPostMetadata(), form.getUpdateComponentId());
        List modelCollection = (List)ObjectPropertyUtils.getPropertyValue(form, collectionGroup.getBindingInfo().getBindingPath());
        Class<?> dataObjectClass = collectionGroup.getCollectionObjectClass();
        String formatType = this.getValidatedFormatType(request.getParameter("formatType"));
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATENONE.getKey());
        if (this.applyCustomExport(modelCollection, dataObjectClass.getName(), formatType, response)) {
            return null;
        }
        return TableExporter.buildExportTableData(collectionGroup, form, formatType);
    }

    protected boolean canApplyCustomExport(DataObjectEntry dataObjectEntry) {
        if (dataObjectEntry == null) {
            return false;
        }
        return dataObjectEntry.getExporterClass() != null;
    }

    protected boolean applyCustomExport(List<Object> dataObjectCollection, String dataObjectClassName, String formatType, HttpServletResponse response) {
        String contentType = this.getContentType(formatType);
        this.setAttachmentResponseHeader(response, "export." + formatType, contentType);
        DataObjectEntry dataObjectEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDataObjectEntry(dataObjectClassName);
        if (CollectionUtils.isEmpty(dataObjectCollection)) {
            return false;
        }
        if (!this.canApplyCustomExport(dataObjectEntry)) {
            return false;
        }
        try {
            Exporter exporter = dataObjectEntry.getExporterClass().newInstance();
            if (exporter.getSupportedFormats(dataObjectEntry.getDataObjectClass()).contains(formatType)) {
                exporter.export(dataObjectEntry.getDataObjectClass(), dataObjectCollection, formatType, (OutputStream)response.getOutputStream());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot invoked custom exporter class", e);
        }
        return false;
    }

    protected void setAttachmentResponseHeader(HttpServletResponse response, String filename, String contentType) {
        response.setContentType(contentType);
        response.setHeader("Content-disposition", "attachment; filename=\"" + filename + "\"");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
    }

    protected String getValidatedFormatType(String formatType) {
        if ("xls".equals(formatType) || "xml".equals(formatType)) {
            return formatType;
        }
        return "csv";
    }

    protected String getContentType(String formatType) {
        if ("xls".equals(formatType)) {
            return "application/vnd.ms-excel";
        }
        if ("xml".equals(formatType)) {
            return "application/xml";
        }
        return "text/csv";
    }
}

