/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.CheckedIntFunction;

public final class SourceIntervalsSource
extends IntervalsSource {
    private final IntervalsSource in;
    private final Query approximation;
    private final Function<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> valueFetcherProvider;
    private final Analyzer indexAnalyzer;

    public SourceIntervalsSource(IntervalsSource in, Query approximation, Function<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> valueFetcherProvider, Analyzer indexAnalyzer) {
        this.in = Objects.requireNonNull(in);
        this.approximation = Objects.requireNonNull(approximation);
        this.valueFetcherProvider = Objects.requireNonNull(valueFetcherProvider);
        this.indexAnalyzer = Objects.requireNonNull(indexAnalyzer);
    }

    public IntervalsSource getIntervalsSource() {
        return this.in;
    }

    private LeafReaderContext createSingleDocLeafReaderContext(String field, List<Object> values) {
        MemoryIndex index = new MemoryIndex();
        for (Object value : values) {
            if (value == null) continue;
            index.addField(field, value.toString(), this.indexAnalyzer);
        }
        index.freeze();
        return (LeafReaderContext)index.createSearcher().getIndexReader().leaves().get(0);
    }

    public IntervalIterator intervals(final String field, LeafReaderContext ctx) throws IOException {
        IndexSearcher searcher = new IndexSearcher((IndexReader)ctx.reader());
        Weight weight = searcher.createWeight(searcher.rewrite(this.approximation), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer scorer = weight.scorer(ctx.reader().getContext());
        if (scorer == null) {
            return null;
        }
        final DocIdSetIterator approximation = scorer.iterator();
        final CheckedIntFunction<List<Object>, IOException> valueFetcher = this.valueFetcherProvider.apply(ctx);
        return new IntervalIterator(){
            private IntervalIterator in;

            public int docID() {
                return approximation.docID();
            }

            public long cost() {
                return approximation.cost();
            }

            public int nextDoc() throws IOException {
                return this.doNext(approximation.nextDoc());
            }

            public int advance(int target) throws IOException {
                return this.doNext(approximation.advance(target));
            }

            private int doNext(int doc) throws IOException {
                while (doc != Integer.MAX_VALUE && !this.setIterator(doc)) {
                    doc = approximation.nextDoc();
                }
                return doc;
            }

            private boolean setIterator(int doc) throws IOException {
                boolean isSet;
                List values = (List)valueFetcher.apply(doc);
                LeafReaderContext singleDocContext = SourceIntervalsSource.this.createSingleDocLeafReaderContext(field, values);
                this.in = SourceIntervalsSource.this.in.intervals(field, singleDocContext);
                boolean bl = isSet = this.in != null && this.in.nextDoc() != Integer.MAX_VALUE;
                assert (!isSet || this.in.docID() == 0);
                return isSet;
            }

            public int start() {
                return this.in.start();
            }

            public int end() {
                return this.in.end();
            }

            public int gaps() {
                return this.in.gaps();
            }

            public int nextInterval() throws IOException {
                return this.in.nextInterval();
            }

            public float matchCost() {
                return 10000.0f;
            }
        };
    }

    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        CheckedIntFunction<List<Object>, IOException> valueFetcher = this.valueFetcherProvider.apply(ctx);
        List values = (List)valueFetcher.apply(doc);
        LeafReaderContext singleDocContext = this.createSingleDocLeafReaderContext(field, values);
        return this.in.matches(field, singleDocContext, 0);
    }

    public void visit(String field, QueryVisitor visitor) {
        this.in.visit(field, visitor);
    }

    public int minExtent() {
        return this.in.minExtent();
    }

    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    public int hashCode() {
        return Objects.hash(this.in, this.indexAnalyzer);
    }

    public boolean equals(Object other) {
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        SourceIntervalsSource that = (SourceIntervalsSource)((Object)other);
        return this.in.equals((Object)that.in) && this.indexAnalyzer.equals(that.indexAnalyzer);
    }

    public String toString() {
        return this.in.toString();
    }
}

