/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jdbc.sql;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.search.SearchOperator;

public final class SQLUtils {
    private static final Logger LOG = LogManager.getLogger(SQLUtils.class);
    private static final String DATE_REGEX_SMALL_TWO_DIGIT_YEAR = "^\\d{1,2}/\\d{1,2}/\\d{2}$|^\\d{1,2}-\\d{1,2}-\\d{2}$";
    private static final String DATE_REGEX_SMALL_TWO_DIGIT_YEAR_SPLIT = "(\\d{1,2})[/,-](\\d{1,2})[/,-](\\d{2})";
    private static final String DATE_REGEX_SMALL_FOUR_DIGIT_YEAR = "^\\d{1,2}/\\d{1,2}/\\d{4}$|^\\d{1,2}-\\d{1,2}-\\d{4}$";
    private static final String DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_SPLIT = "(\\d{1,2})[/,-](\\d{1,2})[/,-](\\d{4})";
    private static final String DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_FIRST = "^\\d{4}/\\d{1,2}/\\d{1,2}$|^\\d{4}-\\d{1,2}-\\d{1,2}$";
    private static final String DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_FIRST_SPLIT = "(\\d{4})[/,-](\\d{1,2})[/,-](\\d{1,2})";
    private static final String DATE_REGEX_WHOLENUM_SMALL = "^\\d{6}$";
    private static final String DATE_REGEX_WHOLENUM_SMALL_SPLIT = "(\\d{2})(\\d{2})(\\d{2})";
    private static final String DATE_REGEX_WHOLENUM_LARGE = "^\\d{8}$";
    private static final String DATE_REGEX_WHOLENUM_LARGE_SPLIT = "(\\d{2})(\\d{2})(\\d{4})";
    private static final String TIME_REGEX = "([0-1][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])";
    private static final Collection<String> DOCUMENT_SEARCH_DATE_VALIDATION_REGEX_EXPRESSIONS = Collections.unmodifiableCollection(Arrays.asList("^\\d{1,2}/\\d{1,2}/\\d{4}$|^\\d{1,2}-\\d{1,2}-\\d{4}$", "^\\d{4}/\\d{1,2}/\\d{1,2}$|^\\d{4}-\\d{1,2}-\\d{1,2}$"));
    private static final Map<String, String> REGEX_EXPRESSION_MAP_TO_REGEX_SPLIT_EXPRESSION;

    private SQLUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String getSqlFormattedDate(String date) {
        DateComponent dc = SQLUtils.formatDateToDateComponent(date, REGEX_EXPRESSION_MAP_TO_REGEX_SPLIT_EXPRESSION.keySet());
        if (dc == null) {
            return null;
        }
        return dc.getYear() + "/" + dc.getMonth() + "/" + dc.getDate();
    }

    public static Timestamp convertStringDateToTimestamp(String dateWithoutTime) {
        DateComponent formattedDate;
        Pattern p = Pattern.compile(TIME_REGEX);
        Matcher util = p.matcher(dateWithoutTime);
        if (util.find()) {
            dateWithoutTime = StringUtils.substringBeforeLast((String)dateWithoutTime, (String)" ");
        }
        if ((formattedDate = SQLUtils.formatDateToDateComponent(dateWithoutTime, REGEX_EXPRESSION_MAP_TO_REGEX_SPLIT_EXPRESSION.keySet())) == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(2, Integer.valueOf(formattedDate.getMonth()) - 1);
        c.set(5, Integer.valueOf(formattedDate.getDate()));
        c.set(1, Integer.valueOf(formattedDate.getYear()));
        return SQLUtils.convertCalendar(c);
    }

    public static String getEntryFormattedDate(String date) {
        DateComponent dc;
        Pattern p = Pattern.compile(TIME_REGEX);
        Matcher util = p.matcher(date);
        if (util.find()) {
            date = StringUtils.substringBeforeLast((String)date, (String)" ");
        }
        if ((dc = SQLUtils.formatDateToDateComponent(date, DOCUMENT_SEARCH_DATE_VALIDATION_REGEX_EXPRESSIONS)) == null) {
            return null;
        }
        return dc.getMonth() + "/" + dc.getDate() + "/" + dc.getYear();
    }

    private static DateComponent formatDateToDateComponent(String date, Collection<String> regularExpressionList) {
        StringBuffer yearBuf;
        String matchingRegexExpression = null;
        for (String string : regularExpressionList) {
            Pattern p;
            String matchRegex = string;
            if (!REGEX_EXPRESSION_MAP_TO_REGEX_SPLIT_EXPRESSION.containsKey(matchRegex)) {
                String errorMsg = "";
                LOG.error("formatDateToDateComponent(String,List) " + errorMsg);
            }
            if (!(p = Pattern.compile(matchRegex)).matcher(date).matches()) continue;
            matchingRegexExpression = matchRegex;
            break;
        }
        if (matchingRegexExpression == null) {
            String errorMsg = "formatDate(String,List) Date string given '" + date + "' is not valid according to Workflow defaults.  Returning null value.";
            if (StringUtils.isNotBlank((String)date)) {
                LOG.warn(errorMsg);
            } else {
                LOG.debug(errorMsg);
            }
            return null;
        }
        String regexSplitExpression = REGEX_EXPRESSION_MAP_TO_REGEX_SPLIT_EXPRESSION.get(matchingRegexExpression);
        Pattern p = Pattern.compile(regexSplitExpression);
        Matcher util = p.matcher(date);
        util.matches();
        if (regexSplitExpression.equals(DATE_REGEX_SMALL_TWO_DIGIT_YEAR_SPLIT)) {
            yearBuf = new StringBuffer();
            StringBuffer monthBuf = new StringBuffer();
            StringBuffer dateBuf = new StringBuffer();
            Integer year = Integer.valueOf(util.group(3));
            if (year <= 50) {
                yearBuf.append("20").append(util.group(3));
            } else if (util.group(3).length() < 3) {
                yearBuf.append("19").append(util.group(3));
            } else {
                yearBuf.append(util.group(3));
            }
            if (util.group(1).length() < 2) {
                monthBuf.append("0").append(util.group(1));
            } else {
                monthBuf.append(util.group(1));
            }
            if (util.group(2).length() < 2) {
                dateBuf.append("0").append(util.group(2));
            } else {
                dateBuf.append(util.group(2));
            }
            return new DateComponent(yearBuf.toString(), monthBuf.toString(), dateBuf.toString());
        }
        if (regexSplitExpression.equals(DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_SPLIT)) {
            yearBuf = new StringBuffer(util.group(3));
            StringBuffer monthBuf = new StringBuffer();
            StringBuffer dateBuf = new StringBuffer();
            if (util.group(1).length() < 2) {
                monthBuf.append("0").append(util.group(1));
            } else {
                monthBuf.append(util.group(1));
            }
            if (util.group(2).length() < 2) {
                dateBuf.append("0").append(util.group(2));
            } else {
                dateBuf.append(util.group(2));
            }
            return new DateComponent(yearBuf.toString(), monthBuf.toString(), dateBuf.toString());
        }
        if (regexSplitExpression.equals(DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_FIRST_SPLIT)) {
            yearBuf = new StringBuffer(util.group(1));
            StringBuffer monthBuf = new StringBuffer();
            StringBuffer dateBuf = new StringBuffer();
            if (util.group(2).length() < 2) {
                monthBuf.append("0").append(util.group(2));
            } else {
                monthBuf.append(util.group(2));
            }
            if (util.group(3).length() < 2) {
                dateBuf.append("0").append(util.group(3));
            } else {
                dateBuf.append(util.group(3));
            }
            return new DateComponent(yearBuf.toString(), monthBuf.toString(), dateBuf.toString());
        }
        if (regexSplitExpression.equals(DATE_REGEX_WHOLENUM_LARGE_SPLIT)) {
            return new DateComponent(util.group(3), util.group(1), util.group(2));
        }
        if (regexSplitExpression.equals(DATE_REGEX_WHOLENUM_SMALL_SPLIT)) {
            yearBuf = new StringBuffer();
            Integer year = Integer.valueOf(util.group(3));
            if (year < 50) {
                yearBuf.append("20");
            } else {
                yearBuf.append("19");
            }
            yearBuf.append(util.group(3));
            return new DateComponent(yearBuf.toString(), util.group(1), util.group(2));
        }
        LOG.warn("formatDate(String,List) Date string given '" + date + "' is not valid according to Workflow defaults.  Returning null value.");
        return null;
    }

    public static Calendar convertTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        return calendar;
    }

    public static Timestamp convertCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static String cleanDate(String string) {
        for (SearchOperator op : SearchOperator.RANGE_CHARACTERS) {
            string = StringUtils.replace((String)string, (String)op.op(), (String)"");
        }
        return string;
    }

    public static String cleanNumericOfValidOperators(String string) {
        for (SearchOperator op : SearchOperator.RANGE_CHARACTERS) {
            string = StringUtils.replace((String)string, (String)op.op(), (String)"");
        }
        string = StringUtils.replace((String)string, (String)SearchOperator.OR.op(), (String)"");
        string = StringUtils.replace((String)string, (String)SearchOperator.AND.op(), (String)"");
        string = StringUtils.replace((String)string, (String)SearchOperator.NOT.op(), (String)"");
        return string;
    }

    public static String cleanString(String string) {
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            string = StringUtils.replace((String)string, (String)op.op(), (String)"");
        }
        return string;
    }

    public static List<String> getCleanedSearchableValues(String valueEntered, String propertyDataType) {
        ArrayList<String> lRet = null;
        List<String> lTemp = SQLUtils.getSearchableValues(valueEntered);
        if (lTemp != null && !lTemp.isEmpty()) {
            lRet = new ArrayList<String>();
            for (String val : lTemp) {
                if ("string".equals(propertyDataType)) {
                    lRet.add(SQLUtils.clean(val));
                    continue;
                }
                if ("float".equals(propertyDataType) || "long".equals(propertyDataType)) {
                    lRet.add(SQLUtils.cleanNumericOfValidOperators(val));
                    continue;
                }
                if ("datetime".equals(propertyDataType)) {
                    lRet.add(SQLUtils.cleanDate(val));
                    continue;
                }
                lRet.add(SQLUtils.clean(val));
            }
        }
        return lRet;
    }

    private static List<String> getSearchableValues(String valueEntered) {
        ArrayList<String> lRet = new ArrayList<String>();
        SQLUtils.getSearchableValueRecursive(valueEntered, lRet);
        return lRet;
    }

    private static void getSearchableValueRecursive(String valueEntered, List lRet) {
        if (valueEntered == null) {
            return;
        }
        valueEntered = valueEntered.trim();
        if (lRet == null) {
            throw new NullPointerException("The list passed in is by reference and should never be null.");
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.BETWEEN.op())) {
            List<String> l = Arrays.asList(valueEntered.split("\\.\\."));
            for (String value : l) {
                SQLUtils.getSearchableValueRecursive(value, lRet);
            }
            return;
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.OR.op())) {
            List<String> l = Arrays.asList(StringUtils.split((String)valueEntered, (String)SearchOperator.OR.op()));
            for (String value : l) {
                SQLUtils.getSearchableValueRecursive(value, lRet);
            }
            return;
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.AND.op())) {
            List<String> l = Arrays.asList(StringUtils.split((String)valueEntered, (String)SearchOperator.AND.op()));
            for (String value : l) {
                SQLUtils.getSearchableValueRecursive(value, lRet);
            }
            return;
        }
        lRet.add(valueEntered);
    }

    private static String clean(String string) {
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            string = StringUtils.replace((String)string, (String)op.op(), (String)"");
        }
        return string;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DATE_REGEX_SMALL_TWO_DIGIT_YEAR, DATE_REGEX_SMALL_TWO_DIGIT_YEAR_SPLIT);
        map.put(DATE_REGEX_SMALL_FOUR_DIGIT_YEAR, DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_SPLIT);
        map.put(DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_FIRST, DATE_REGEX_SMALL_FOUR_DIGIT_YEAR_FIRST_SPLIT);
        map.put(DATE_REGEX_WHOLENUM_SMALL, DATE_REGEX_WHOLENUM_SMALL_SPLIT);
        map.put(DATE_REGEX_WHOLENUM_LARGE, DATE_REGEX_WHOLENUM_LARGE_SPLIT);
        REGEX_EXPRESSION_MAP_TO_REGEX_SPLIT_EXPRESSION = Collections.unmodifiableMap(map);
    }

    private static class DateComponent {
        protected String month;
        protected String date;
        protected String year;

        public DateComponent(String year, String month, String date) {
            this.month = month;
            this.date = date;
            this.year = year;
        }

        public String getDate() {
            return this.date;
        }

        public String getMonth() {
            return this.month;
        }

        public String getYear() {
            return this.year;
        }
    }
}

