/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.postalcode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.location.api.postalcode.PostalCode;
import org.kuali.rice.location.api.postalcode.PostalCodeContract;
import org.kuali.rice.location.api.postalcode.PostalCodeQueryResults;
import org.kuali.rice.location.api.postalcode.PostalCodeService;
import org.kuali.rice.location.impl.postalcode.PostalCodeBo;
import org.springframework.beans.factory.annotation.Required;

public class PostalCodeServiceImpl
implements PostalCodeService {
    private DataObjectService dataObjectService;

    public PostalCode getPostalCode(String countryCode, String code) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("countryCode", countryCode);
        map.put("code", code);
        return PostalCodeBo.to((PostalCodeBo)((Object)this.getDataObjectService().find(PostalCodeBo.class, (Object)new CompoundKey(map))));
    }

    public List<PostalCode> findAllPostalCodesInCountry(String countryCode) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("countryCode", countryCode);
        map.put("active", Boolean.TRUE);
        QueryResults postalCodeBoQueryResults = this.getDataObjectService().findMatching(PostalCodeBo.class, QueryByCriteria.Builder.andAttributes(map).build());
        if (postalCodeBoQueryResults == null) {
            return Collections.emptyList();
        }
        ArrayList<PostalCode> toReturn = new ArrayList<PostalCode>();
        for (PostalCodeBo bo : postalCodeBoQueryResults.getResults()) {
            if (bo == null || !bo.isActive()) continue;
            toReturn.add(PostalCodeBo.to(bo));
        }
        return Collections.unmodifiableList(toReturn);
    }

    public PostalCodeQueryResults findPostalCodes(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(PostalCodeBo.class, queryByCriteria);
        PostalCodeQueryResults.Builder builder = PostalCodeQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<PostalCode.Builder> ims = new ArrayList<PostalCode.Builder>();
        for (PostalCodeBo bo : results.getResults()) {
            ims.add(PostalCode.Builder.create((PostalCodeContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

