/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.SimpleValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedSimpleValue
extends ParsedSingleValueNumericMetricsAggregation
implements SimpleValue {
    private static final ObjectParser<ParsedSimpleValue, Void> PARSER = new ObjectParser(ParsedSimpleValue.class.getSimpleName(), true, ParsedSimpleValue::new);

    @Override
    public String getType() {
        return "simple_value";
    }

    public static ParsedSimpleValue fromXContent(XContentParser parser, String name) {
        ParsedSimpleValue simpleValue = (ParsedSimpleValue)PARSER.apply(parser, null);
        simpleValue.setName(name);
        return simpleValue;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isNaN(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    static {
        ParsedSimpleValue.declareSingleValueFields(PARSER, Double.NaN);
    }
}

